/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.rmi;

import com.zerog.ia.installer.actions.Subinstaller;
import com.zerog.ia.installer.installpanels.ProgressActionPanel;
import com.zerog.ia.installer.rmi.MessageReceiverRmi;
import com.zerog.ia.installer.util.VariableFacade;
import com.zerog.util.IAResourceBundle;
import com.zerog.util.ZGUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class RmiServer
extends UnicastRemoteObject
implements MessageReceiverRmi {
    private int ipPort;
    private Registry registry;
    private Object parent;

    public RmiServer(Object object) throws RemoteException {
        this.startServer();
        this.parent = object;
    }

    private void startServer() throws RemoteException {
        try {
            this.ipPort = this.getIpPort();
            this.registry = LocateRegistry.createRegistry(this.ipPort);
            this.registry.rebind("rmiServer", this);
            VariableFacade.getInstance().setVariable("IA_MergeModule_RMIServer_Port", Integer.toString(this.ipPort));
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new RemoteException("Can't get inet address");
        }
    }

    private int getIpPort() {
        int n = 20213;
        boolean bl = false;
        try {
            for (n = 20213; n < 30000 && !(bl = this.isPortAvaiable(n)); n += 2) {
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: getIpPort() : while get the avaiable ip port " + exception.getMessage());
        }
        return n;
    }

    private boolean isPortAvaiable(int n) {
        boolean bl = true;
        Object object = "";
        object = ZGUtil.MACOSX || ZGUtil.MACOS ? "." + Integer.toString(n) + " " : ":" + Integer.toString(n) + " ";
        try {
            String string = null;
            Process process = Runtime.getRuntime().exec("netstat -an");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                int n2 = string.indexOf((String)object);
                if (n2 <= 0) continue;
                bl = false;
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: isPortAvaiable() : while get the avaiable ip port " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    @Override
    public void receiveMessage(String string) throws RemoteException {
        if (Flexeraaq7.az()) {
            if (this.parent instanceof Subinstaller && ((Subinstaller)this.parent).shouldShowProgressDialog()) {
                Subinstaller.dialog.setProgressText(IAResourceBundle.getValue("InstallProgressUI.installingStr") + " " + string);
                Subinstaller.dialog.repaint();
            } else {
                ProgressActionPanel.mergeModuleProcessingLabel.setText(IAResourceBundle.getValue("InstallProgressUI.installingStr"));
                ProgressActionPanel.mergeModuleProcessingLabel.repaint();
                ProgressActionPanel.mergeModuleProcessedElementLabel.setText(string);
                ProgressActionPanel.mergeModuleProcessedElementLabel.repaint();
            }
        }
    }
}

