/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.designer.util;

import com.zerog.ia.designer.build.BuildTarget;
import com.zerog.ia.installer.jvmresolution.JVMFileParseExpection;
import com.zerog.ia.installer.jvmresolution.JVMResolutionFileSpec;
import com.zerog.ia.installer.jvmresolution.JVMResolutionSpecParserImpl;
import com.zerog.ia.installer.util.Preferences;
import com.zerog.ia.installer.util.ZGPathManager;
import com.zerog.util.ZGUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Vector;

public class DiscoverJavaVMSpecFileUtility {
    private static DiscoverJavaVMSpecFileUtility jvmsfu = null;
    public static final String SYSTEM_ENV_JVM_SPECS_PATHS_STR = "IA_JVM_SPECS_PATHS";
    private File jvmSpecsDir;
    private JVMResolutionFileSpec[] windowsSpecs = null;
    private JVMResolutionFileSpec[] windows64Specs = null;
    private JVMResolutionFileSpec[] linuxSpecs = null;
    private JVMResolutionFileSpec[] aixSpecs = null;
    private JVMResolutionFileSpec[] solarisSpecs = null;
    private JVMResolutionFileSpec[] hpuxSpecs = null;
    private JVMResolutionFileSpec[] unixWithVMSpecs = null;
    private JVMResolutionFileSpec[] genericUnixSpecs = null;
    private Vector loadedSpecs = new Vector();

    private DiscoverJavaVMSpecFileUtility() {
        this.jvmSpecsDir = this.setupJVMSpecDirectory();
        this.refreshJVMSpecs();
    }

    public void refreshJVMSpecs() {
        this.loadedSpecs = new Vector();
        this.windowsSpecs = this.setupSpecs(this.jvmSpecsDir, "windows");
        this.windows64Specs = this.setupSpecs(this.jvmSpecsDir, "windows64");
        this.linuxSpecs = this.setupSpecs(this.jvmSpecsDir, "linux");
        this.aixSpecs = this.setupSpecs(this.jvmSpecsDir, "aix");
        this.solarisSpecs = this.setupSpecs(this.jvmSpecsDir, "solaris");
        this.hpuxSpecs = this.setupSpecs(this.jvmSpecsDir, "hpux");
        this.unixWithVMSpecs = this.setupSpecs(this.jvmSpecsDir, "unix");
        this.genericUnixSpecs = this.setupSpecs(this.jvmSpecsDir, "generic-unix");
    }

    public static DiscoverJavaVMSpecFileUtility getInstance() {
        if (jvmsfu == null) {
            jvmsfu = new DiscoverJavaVMSpecFileUtility();
        }
        return jvmsfu;
    }

    private JVMResolutionFileSpec[] setupSpecs(File file, String string) {
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if (Flexeraajj.ae(20L)) {
            Preferences preferences = Preferences.getPreferences();
            String string2 = preferences.getStringProperty("designer.resource.paths.jvmspecs", "");
            arrayList = DiscoverJavaVMSpecFileUtility.getPathsFromProperty(string2);
            String string3 = System.getProperty("lax.nl.env.IA_JVM_SPECS_PATHS", "");
            arrayList2 = DiscoverJavaVMSpecFileUtility.getPathsFromProperty(string3);
        }
        return this.setupSpecs(file, arrayList, arrayList2, string);
    }

    public static ArrayList getPathsFromProperty(String string) {
        ZGPathManager zGPathManager = ZGPathManager.getInstance();
        String[] stringArray = ZGUtil.getStringArrayFromDelimitedString(string, ";");
        ArrayList<File> arrayList = new ArrayList<File>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file;
                String string2;
                String string3 = stringArray[i];
                if (string3 == null || string3.trim().length() <= 0 || (string2 = zGPathManager.getSubstitutedFilePath(string3)) == null || string2.trim().length() <= 0 || !(file = new File(string2)).exists() || !file.isDirectory()) continue;
                arrayList.add(file);
            }
        }
        return arrayList;
    }

    private JVMResolutionFileSpec[] setupSpecs(File file, ArrayList arrayList, ArrayList arrayList2, String string) {
        Object object;
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".jvm");
            }
        };
        ArrayList<File> arrayList3 = new ArrayList<File>();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList2 != null) {
            arrayList3.addAll(arrayList2);
        }
        if (file != null && file.exists()) {
            arrayList3.add(file);
        }
        ArrayList<JVMResolutionFileSpec> arrayList4 = new ArrayList<JVMResolutionFileSpec>();
        for (File jVMResolutionFileSpecArray2 : arrayList3) {
            if (jVMResolutionFileSpecArray2 != null && !jVMResolutionFileSpecArray2.exists() || !((File)(object = new File(jVMResolutionFileSpecArray2, string))).exists()) continue;
            File[] n = ((File)object).listFiles(filenameFilter);
            for (int i = 0; n != null && i < n.length; ++i) {
                JVMResolutionSpecParserImpl jVMResolutionSpecParserImpl = new JVMResolutionSpecParserImpl();
                try {
                    JVMResolutionFileSpec fileNotFoundException = jVMResolutionSpecParserImpl.parseJVMFile(n[i]);
                    if (this.loadedSpecs.contains(fileNotFoundException.getDescription())) {
                        System.err.println("!!! Duplicate JVM Spec Loaded -- description not unique!!!  -" + fileNotFoundException.getDescription());
                        continue;
                    }
                    arrayList4.add(fileNotFoundException);
                    continue;
                }
                catch (FileNotFoundException jVMFileParseExpection) {
                    jVMFileParseExpection.printStackTrace();
                    continue;
                }
                catch (JVMFileParseExpection jVMFileParseExpection) {
                    jVMFileParseExpection.printStackTrace();
                }
            }
        }
        JVMResolutionFileSpec[] jVMResolutionFileSpecArray = new JVMResolutionFileSpec[arrayList4.size()];
        object = arrayList4.iterator();
        int n = 0;
        while (object.hasNext()) {
            JVMResolutionFileSpec jVMResolutionFileSpec = (JVMResolutionFileSpec)object.next();
            jVMResolutionFileSpecArray[n++] = jVMResolutionFileSpec;
        }
        return jVMResolutionFileSpecArray;
    }

    private File setupJVMSpecDirectory() {
        File file = ZGUtil.getResourceDirectory();
        if (file != null && file.exists()) {
            File file2 = new File(file, "jvms");
            if (file2 != null && file2.exists() && file2.isDirectory()) {
                return file2;
            }
        }
        return null;
    }

    public JVMResolutionFileSpec[] getWindowsSpecs() {
        return this.windowsSpecs;
    }

    public JVMResolutionFileSpec[] getLinuxSpecs() {
        return this.linuxSpecs;
    }

    public JVMResolutionFileSpec[] getAixSpecs() {
        return this.aixSpecs;
    }

    public JVMResolutionFileSpec[] getSolarisSpecs() {
        return this.solarisSpecs;
    }

    public JVMResolutionFileSpec[] getHpuxSpecs() {
        return this.hpuxSpecs;
    }

    public JVMResolutionFileSpec[] getUnixWithVMSpecs() {
        return this.unixWithVMSpecs;
    }

    public JVMResolutionFileSpec[] getGenericUnixSpecs() {
        return this.genericUnixSpecs;
    }

    public Object[] getSpecsForThisPlatform(BuildTarget.BuildPlatform buildPlatform) {
        switch (buildPlatform.getId()) {
            case 1: {
                return this.linuxSpecs;
            }
            case 0: {
                return this.windowsSpecs;
            }
            case 9: {
                return this.windows64Specs;
            }
            case 3: {
                return this.aixSpecs;
            }
            case 4: {
                return this.solarisSpecs;
            }
            case 5: {
                return this.hpuxSpecs;
            }
            case 6: {
                return this.unixWithVMSpecs;
            }
            case 7: 
            case 8: {
                return this.genericUnixSpecs;
            }
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = "";
        return objectArray;
    }
}

