/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.api.pub.registry;

import com.zerog.ia.installer.actions.Version;
import com.zerog.ia.installer.util.service.RegexEvaluatorWrapper;
import com.zerog.interfaces.util.regex.RegExprSyntaxException;

public class SoftwareObjectSearchCriteria {
    public static final int COMPARISON_TYPE_AND = 1;
    public static final int COMPARISON_TYPE_OR = 2;
    private String name;
    private String uniqueID;
    private String location;
    private String version;
    private int comparisonType;

    public SoftwareObjectSearchCriteria() {
        this(1);
    }

    public SoftwareObjectSearchCriteria(int n) {
        this.comparisonType = n;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setUniqueID(String string) {
        this.uniqueID = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public String getVersion() {
        return this.version;
    }

    public int getComparisonType() {
        return this.comparisonType;
    }

    public boolean matches(String string, String string2, String string3, String string4) {
        if (this.comparisonType == 1) {
            return this.matchesName(string) && this.matchesUniqueID(string2) && this.matchesLocation(string3) && this.matchesVersion(string4);
        }
        return this.matchesName(string) || this.matchesUniqueID(string2) || this.matchesLocation(string3) || this.matchesVersion(string4);
    }

    private boolean matchesVersion(String string) {
        if (this.version == null) {
            return true;
        }
        if (this.version.endsWith("+") && string != null) {
            Version version = new Version();
            Version version2 = new Version();
            version.setVersionFromString(this.version.substring(0, this.version.length() - 1));
            version2.setVersionFromString(string);
            return version.isValid() && version2.isValid() && version2.compareTo(version) >= 0;
        }
        if (this.version.endsWith("-") && string != null) {
            Version version = new Version();
            Version version3 = new Version();
            version.setVersionFromString(this.version.substring(0, this.version.length() - 1));
            version3.setVersionFromString(string);
            return version.isValid() && version3.isValid() && version3.compareTo(version) <= 0;
        }
        Version version = new Version();
        Version version4 = new Version();
        version.setVersionFromString(this.version);
        version4.setVersionFromString(string);
        if (version.isValid() && version4.isValid()) {
            return version.compareTo(version4) == 0;
        }
        return string != null && this.matchesRegex(string, this.version);
    }

    private boolean matchesUniqueID(String string) {
        return this.uniqueID == null || string != null && this.matchesRegex(string.toUpperCase(), this.uniqueID.toUpperCase());
    }

    private boolean matchesName(String string) {
        return this.name == null || string != null && this.matchesRegex(string, this.name);
    }

    private boolean matchesLocation(String string) {
        return this.location == null || string != null && this.matchesRegex(string, this.location);
    }

    private boolean matchesRegex(String string, String string2) {
        if (string2.equals("")) {
            if (!string.equals("")) {
                return false;
            }
        }
        RegexEvaluatorWrapper regexEvaluatorWrapper = new RegexEvaluatorWrapper();
        try {
            return regexEvaluatorWrapper.matches(string, string2);
        }
        catch (RegExprSyntaxException regExprSyntaxException) {
            return false;
        }
    }
}

