/*
 * Decompiled with CFR 0.152.
 */
package com.apple.scripting;

import com.apple.scripting.MessageHeader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Manifest {
    static final String MANIFEST = "META-INF/MANIFEST.MF";
    private Vector entries = new Vector();
    static final boolean debug = false;

    static final void debug(String string) {
    }

    public Manifest() {
    }

    public Manifest(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public Manifest(InputStream inputStream) throws IOException {
        MessageHeader messageHeader;
        while (!(messageHeader = new MessageHeader(inputStream)).isEmpty()) {
            this.entries.addElement(messageHeader);
        }
    }

    public Manifest(String[] stringArray) throws IOException {
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.add("Manifest-Version", "1.0");
        this.addEntry(messageHeader);
        this.addFiles(null, stringArray);
    }

    public void addEntry(MessageHeader messageHeader) {
        this.entries.addElement(messageHeader);
    }

    public MessageHeader getEntry(String string) {
        Enumeration enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            MessageHeader messageHeader = (MessageHeader)enumeration.nextElement();
            String string2 = messageHeader.findValue("Name");
            if (string2 == null || !string2.equals(string)) continue;
            return messageHeader;
        }
        return null;
    }

    public MessageHeader entryAt(int n) {
        return (MessageHeader)this.entries.elementAt(n);
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public void addFiles(File file, String[] stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2 = file == null ? new File(stringArray[n]) : new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                this.addFiles(file2, file2.list());
            } else {
                this.addFile(file2);
            }
            ++n;
        }
    }

    public void addFile(File file) throws IOException {
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.add("Name", file.getPath());
        this.addEntry(messageHeader);
    }

    public void stream(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        MessageHeader messageHeader = (MessageHeader)this.entries.elementAt(0);
        if (messageHeader.findValue("Manifest-Version") == null) {
            throw new IOException("Manifest file requires Manifest-Version: 1.0 in 1st header");
        }
        messageHeader.print(printWriter);
        int n = 1;
        while (n < this.entries.size()) {
            MessageHeader messageHeader2 = (MessageHeader)this.entries.elementAt(n);
            messageHeader2.print(printWriter);
            ++n;
        }
    }

    public static boolean isManifestName(String string) {
        if (string.charAt(0) == '/') {
            string = string.substring(1, string.length());
        }
        return (string = string.toUpperCase()).equals(MANIFEST);
    }
}

