/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.CInfoPBRecStruct;
import com.apple.mrj.macos.generated.FileFilterInterface;
import com.apple.mrj.macos.generated.FileFilterYDInterface;
import com.apple.mrj.macos.generated.QuickdrawFunctions;
import com.apple.mrj.macos.toolbox.DataPointer;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.TranslateString;
import java.io.File;
import java.io.FilenameFilter;

public class StdFileToIOFilterAdapter
implements FileFilterInterface,
FileFilterYDInterface {
    FilenameFilter filter;
    FSSpec dirSpec;
    File dir;
    CInfoPBRec pb;
    int[] savedPort = new int[1];
    int lastDirID;
    short lastVRefNum;

    public StdFileToIOFilterAdapter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
        this.dir = new File(".");
        this.dirSpec = new FSSpec(0, 0);
        this.pb = new CInfoPBRec(0);
        this.lastDirID = 0;
        this.lastVRefNum = 0;
    }

    public boolean FileFilterYD(int n, int n2) {
        return this.FileFilter(n);
    }

    public boolean FileFilter(int n) {
        boolean bl = false;
        QuickdrawFunctions.GetPort(this.savedPort);
        this.pb.setPB(n);
        if ((this.pb.getIoFlAttrib() & 0x10) == 0) {
            DataPointer dataPointer = new DataPointer(this.pb.getIoNamePtr(), 256);
            String string = TranslateString.asString(dataPointer.getBytes(), (short)1, (short)(dataPointer.getLengthByte() + 1));
            if (this.pb.getIoVRefNum() != this.lastVRefNum || this.pb.getIoFlParID() != this.lastDirID) {
                this.lastVRefNum = this.pb.getIoVRefNum();
                this.lastDirID = this.pb.getIoFlParID();
                this.dirSpec.makeFSSpec(this.lastVRefNum, this.lastDirID);
                this.dir = this.dirSpec.toFile();
            }
            bl = this.filter.accept(this.dir, string) ^ true;
        }
        QuickdrawFunctions.SetPort(this.savedPort[0]);
        return bl;
    }

    class CInfoPBRec
    extends CInfoPBRecStruct {
        public CInfoPBRec(int n) {
            super(n);
        }

        public void setPB(int n) {
            this.pointer = n;
        }
    }
}

