/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.NavDialogOptionsStruct;
import com.apple.mrj.macos.generated.NavObjectFilterClosureUPP;
import com.apple.mrj.macos.generated.NavReplyRecordStruct;
import com.apple.mrj.macos.generated.NavigationFunctions;
import com.apple.mrj.macos.toolbox.AEDesc;
import com.apple.mrj.macos.toolbox.AEDescList;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.MacFileFilter;
import com.apple.mrj.macos.toolbox.MacToIoFilterAdapter;
import com.apple.mrj.macos.toolbox.NavToMacFilterAdapter;
import com.apple.mrj.macos.toolbox.NavTypeList;
import com.apple.mrj.macos.toolbox.TranslateString;
import java.io.File;
import java.io.FilenameFilter;

public class NavServices {
    static final int TEXT_FILETYPE = 0x54455854;
    static final int MRJ_FILECREATOR = 1784772193;

    public static boolean available() {
        boolean bl = false;
        try {
            bl = NavigationFunctions.NavServicesCanRun();
        }
        catch (Throwable throwable) {
            return false;
        }
        return bl;
    }

    public static FSSpec GetTextFile() {
        return NavServices.GetTextFile(null, null);
    }

    public static FSSpec GetTextFile(String string) {
        return NavServices.GetTextFile(string, null);
    }

    public static FSSpec GetTextFile(String string, FilenameFilter filenameFilter) {
        int[] nArray = new int[]{0x54455854};
        NavTypeList navTypeList = new NavTypeList(nArray);
        MacToIoFilterAdapter macToIoFilterAdapter = null;
        if (filenameFilter != null) {
            macToIoFilterAdapter = new MacToIoFilterAdapter(filenameFilter);
        }
        FSSpec fSSpec = NavServices.GetFile(string, navTypeList, macToIoFilterAdapter, null, null);
        navTypeList.dispose();
        return fSSpec;
    }

    public static FSSpec GetFile(String string, FilenameFilter filenameFilter) {
        MacToIoFilterAdapter macToIoFilterAdapter = null;
        if (filenameFilter != null) {
            macToIoFilterAdapter = new MacToIoFilterAdapter(filenameFilter);
        }
        return NavServices.GetFile(string, null, macToIoFilterAdapter, null, null);
    }

    public static FSSpec GetFile(String string, FilenameFilter filenameFilter, String string2, String string3) {
        MacToIoFilterAdapter macToIoFilterAdapter = null;
        if (filenameFilter != null) {
            macToIoFilterAdapter = new MacToIoFilterAdapter(filenameFilter);
        }
        return NavServices.GetFile(string, null, macToIoFilterAdapter, string2, string3);
    }

    public static FSSpec GetFile(String string, NavTypeList navTypeList, MacFileFilter macFileFilter, String string2, String string3) {
        FSSpec fSSpec = null;
        if (NavServices.available()) {
            Object object;
            Object object2;
            NavDialogOptionsStruct navDialogOptionsStruct = new NavDialogOptionsStruct();
            NavReplyRecordStruct navReplyRecordStruct = new NavReplyRecordStruct();
            NavObjectFilterClosureUPP navObjectFilterClosureUPP = null;
            AEDesc aEDesc = null;
            if (macFileFilter != null) {
                navObjectFilterClosureUPP = new NavObjectFilterClosureUPP(new NavToMacFilterAdapter(macFileFilter));
            }
            short s = NavigationFunctions.NavLoad();
            s = NavigationFunctions.NavGetDefaultDialogOptions(navDialogOptionsStruct);
            if (string != null) {
                object2 = new byte[256];
                object2[0] = (byte)string.length();
                TranslateString.toBytes(string.toCharArray(), (byte[])object2, 1);
                navDialogOptionsStruct.setMessage((byte[])object2);
            }
            if (string2 != null && string2.length() != 0 && ((File)(object2 = (Object)new File(string2))).isDirectory()) {
                if (!string2.endsWith(File.separator)) {
                    string2 = String.valueOf(string2) + File.separator;
                }
                if (string3 != null && string3.length() != 0) {
                    object = new FSSpec(String.valueOf(string2) + string3);
                    if (!((FSSpec)object).toFile().exists()) {
                        String[] stringArray = ((File)object2).list();
                        if (stringArray.length > 0 && ((FSSpec)(object = new FSSpec(String.valueOf(string2) + stringArray[0]))).toFile().isDirectory()) {
                            navDialogOptionsStruct.setDialogOptionFlags(navDialogOptionsStruct.getDialogOptionFlags() | 0x400);
                        }
                    } else if (((FSSpec)object).toFile().isDirectory()) {
                        navDialogOptionsStruct.setDialogOptionFlags(navDialogOptionsStruct.getDialogOptionFlags() | 0x400);
                    }
                } else {
                    object = new FSSpec(string2);
                }
                aEDesc = new AEDesc((FSSpec)object);
            }
            if ((s = NavigationFunctions.NavChooseFile(aEDesc, navReplyRecordStruct, navDialogOptionsStruct, null, null, navObjectFilterClosureUPP, navTypeList, 0)) == 0 && navReplyRecordStruct.getValidRecord()) {
                object2 = new AEDescList(navReplyRecordStruct.getSelection());
                object = ((AEDescList)object2).ToArray();
                fSSpec = object[0].ToFSSpec();
            }
            s = NavigationFunctions.NavDisposeReply(navReplyRecordStruct);
        }
        return fSSpec;
    }

    public static FSSpec GetFolder(String string, FilenameFilter filenameFilter) {
        MacToIoFilterAdapter macToIoFilterAdapter = null;
        if (filenameFilter != null) {
            macToIoFilterAdapter = new MacToIoFilterAdapter(filenameFilter);
        }
        return NavServices.GetFolder(string, macToIoFilterAdapter);
    }

    public static FSSpec GetFolder(String string, MacFileFilter macFileFilter) {
        FSSpec fSSpec = null;
        if (NavServices.available()) {
            Object object;
            NavDialogOptionsStruct navDialogOptionsStruct = new NavDialogOptionsStruct();
            NavReplyRecordStruct navReplyRecordStruct = new NavReplyRecordStruct();
            NavObjectFilterClosureUPP navObjectFilterClosureUPP = null;
            if (macFileFilter != null) {
                navObjectFilterClosureUPP = new NavObjectFilterClosureUPP(new NavToMacFilterAdapter(macFileFilter));
            }
            short s = NavigationFunctions.NavLoad();
            s = NavigationFunctions.NavGetDefaultDialogOptions(navDialogOptionsStruct);
            if (string != null) {
                object = new byte[256];
                object[0] = (byte)string.length();
                TranslateString.toBytes(string.toCharArray(), (byte[])object, 1);
                navDialogOptionsStruct.setMessage((byte[])object);
            }
            if ((s = NavigationFunctions.NavChooseFolder(null, navReplyRecordStruct, navDialogOptionsStruct, null, navObjectFilterClosureUPP, 0)) == 0 && navReplyRecordStruct.getValidRecord()) {
                object = new AEDescList(navReplyRecordStruct.getSelection());
                AEDesc[] aEDescArray = ((AEDescList)object).ToArray();
                fSSpec = aEDescArray[0].ToFSSpec();
            }
            s = NavigationFunctions.NavDisposeReply(navReplyRecordStruct);
        }
        return fSSpec;
    }

    public static FSSpec PutFile(String string, String string2, String string3) {
        FSSpec fSSpec = null;
        if (NavServices.available()) {
            Object object;
            NavDialogOptionsStruct navDialogOptionsStruct = new NavDialogOptionsStruct();
            NavReplyRecordStruct navReplyRecordStruct = new NavReplyRecordStruct();
            AEDesc aEDesc = null;
            short s = NavigationFunctions.NavLoad();
            s = NavigationFunctions.NavGetDefaultDialogOptions(navDialogOptionsStruct);
            if (string2 != null && string2.length() != 0 && ((File)(object = new File(string2))).isDirectory()) {
                if (!string2.endsWith(File.separator)) {
                    string2 = String.valueOf(string2) + File.separator;
                }
                aEDesc = new AEDesc(new FSSpec(string2));
            }
            if (string3 != null && string3.length() != 0) {
                object = new byte[256];
                object[0] = (byte)string3.length();
                TranslateString.toBytes(string3.toCharArray(), (byte[])object, 1);
                navDialogOptionsStruct.setSavedFileName((byte[])object);
            }
            navDialogOptionsStruct.setDialogOptionFlags(navDialogOptionsStruct.getDialogOptionFlags() | 1);
            if (string != null) {
                object = new byte[256];
                object[0] = (byte)string.length();
                TranslateString.toBytes(string.toCharArray(), (byte[])object, 1);
                navDialogOptionsStruct.setMessage((byte[])object);
            }
            if ((s = NavigationFunctions.NavPutFile(aEDesc, navReplyRecordStruct, navDialogOptionsStruct, null, 0x54455854, 1784772193, 0)) == 0 && navReplyRecordStruct.getValidRecord()) {
                object = new AEDescList(navReplyRecordStruct.getSelection());
                AEDesc[] aEDescArray = ((AEDescList)object).ToArray();
                fSSpec = aEDescArray[0].ToFSSpec();
            }
            s = NavigationFunctions.NavDisposeReply(navReplyRecordStruct);
        }
        return fSSpec;
    }
}

