/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.jdirect.PointerStruct;
import com.apple.mrj.macos.generated.CellStruct;
import com.apple.mrj.macos.generated.ListFunctions;
import com.apple.mrj.macos.generated.ListRecStruct;
import com.apple.mrj.macos.generated.ListSearchClosureUPP;
import com.apple.mrj.macos.generated.PointStruct;
import com.apple.mrj.macos.generated.RectStruct;
import com.apple.mrj.macos.toolbox.Cell;
import com.apple.mrj.macos.toolbox.ControlRef;
import com.apple.mrj.macos.toolbox.ListBounds;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Region;
import com.apple.mrj.macos.toolbox.TranslateString;
import com.apple.mrj.macos.toolbox.WindowRef;

public class ListHandle {
    ListRecStruct data;
    Object owner;
    public static final short kTextLDEF = 0;
    private ControlRef fVScroll;
    private ControlRef fHScroll;

    protected ListRecStruct getListRec() {
        return this.data;
    }

    protected int getHandleValue() {
        return this.data.getHandle();
    }

    public ListHandle(int n, Object object) {
        this.data = new ListRecStruct(n);
        this.owner = object;
    }

    public ListHandle(int n) {
        this(n, null);
    }

    public ListHandle() {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[rView '" + this.getRView() + ", DataBounds " + this.getDataBounds() + "]";
    }

    public ListHandle(Rect rect, ListBounds listBounds, Point point, short s, WindowRef windowRef, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(ListFunctions.LNew(rect.getRect(), listBounds.getListBounds(), point.getPoint(), s, windowRef.getWindowPointer(), bl, bl2, bl3, bl4));
    }

    public void dispose() {
        if (this.owner == null && this.getListRec() != null && this.getHandleValue() != 0) {
            ListFunctions.LDispose(this.getListRec());
        }
        this.data = null;
    }

    public void finalize() {
        if (this.data != null) {
            System.err.println("Warning!!! List not disposed properly!!!");
            this.data = null;
        }
    }

    public short addColumn(short s, short s2) {
        return ListFunctions.LAddColumn(s, s2, this.getListRec());
    }

    public short addRow(short s, short s2) {
        return ListFunctions.LAddRow(s, s2, this.getListRec());
    }

    public void delColumn(short s, short s2) {
        ListFunctions.LDelColumn(s, s2, this.getListRec());
    }

    public void delRow(short s, short s2) {
        ListFunctions.LDelRow(s, s2, this.getListRec());
    }

    public boolean getSelect(boolean bl, CellStruct cellStruct) {
        return ListFunctions.LGetSelect(bl, cellStruct, this.getListRec());
    }

    public boolean getSelect(boolean bl, Cell cell) {
        return this.getSelect(bl, cell.getCell());
    }

    public void setSelect(boolean bl, CellStruct cellStruct) {
        ListFunctions.LSetSelect(bl, cellStruct, this.getListRec());
    }

    public void setSelect(boolean bl, Cell cell) {
        this.setSelect(bl, cell.getCell());
    }

    public void setCell(byte[] byArray, short s, CellStruct cellStruct) {
        ListFunctions.LSetCell(byArray, s, cellStruct, this.getListRec());
    }

    public void setCell(byte[] byArray, short s, Cell cell) {
        this.setCell(byArray, s, cell.getCell());
    }

    public void setCell(PointerStruct pointerStruct, short s, CellStruct cellStruct) {
        ListFunctions.LSetCell(pointerStruct.getPointer(), s, cellStruct, this.getListRec());
    }

    public void setCell(PointerStruct pointerStruct, short s, Cell cell) {
        this.setCell(pointerStruct, s, cell.getCell());
    }

    public void setCell(String string, CellStruct cellStruct) {
        this.setCell((PointerStruct)TranslateString.asPtr(string), (short)string.length(), cellStruct);
    }

    public void setCell(String string, Cell cell) {
        this.setCell(string, cell.getCell());
    }

    public void addToCell(byte[] byArray, short s, CellStruct cellStruct) {
        ListFunctions.LAddToCell(byArray, s, cellStruct, this.getListRec());
    }

    public void addToCell(byte[] byArray, short s, Cell cell) {
        this.addToCell(byArray, s, cell.getCell());
    }

    public void addToCell(PointerStruct pointerStruct, short s, CellStruct cellStruct) {
        ListFunctions.LAddToCell(pointerStruct.getPointer(), s, cellStruct, this.getListRec());
    }

    public void addToCell(PointerStruct pointerStruct, short s, Cell cell) {
        this.addToCell(pointerStruct, s, cell.getCell());
    }

    public void clrCell(CellStruct cellStruct) {
        ListFunctions.LClrCell(cellStruct, this.getListRec());
    }

    public void clrCell(Cell cell) {
        this.clrCell(cell.getCell());
    }

    public void setUserHandle(int n) {
        this.getListRec().setUserHandle(n);
    }

    public short getCell(byte[] byArray, short s, CellStruct cellStruct) {
        short[] sArray = new short[]{s};
        ListFunctions.LGetCell(byArray, sArray, cellStruct, this.getListRec());
        return sArray[0];
    }

    public short getCell(byte[] byArray, short s, Cell cell) {
        return this.getCell(byArray, s, cell.getCell());
    }

    public short getCell(PointerStruct pointerStruct, short s, CellStruct cellStruct) {
        short[] sArray = new short[]{s};
        ListFunctions.LGetCell(pointerStruct.getPointer(), sArray, cellStruct, this.getListRec());
        return sArray[0];
    }

    public short getCell(PointerStruct pointerStruct, short s, Cell cell) {
        return this.getCell(pointerStruct, s, cell.getCell());
    }

    public boolean click(PointStruct pointStruct, short s) {
        return ListFunctions.LClick(pointStruct, s, this.getListRec());
    }

    public boolean click(Point point, short s) {
        return this.click(point.getPoint(), s);
    }

    public void activate(boolean bl) {
        ListFunctions.LActivate(bl, this.getListRec());
    }

    public void update(Region region) {
        ListFunctions.LUpdate(region.getRegion(), this.getListRec());
    }

    public void isHilited(boolean bl) {
        this.activate(bl);
    }

    public void setDrawingMode(boolean bl) {
        ListFunctions.LSetDrawingMode(bl, this.getListRec());
    }

    public void draw(CellStruct cellStruct) {
        ListFunctions.LDraw(cellStruct, this.getListRec());
    }

    public void draw(Cell cell) {
        this.draw(cell.getCell());
    }

    public void autoScroll() {
        ListFunctions.LAutoScroll(this.getListRec());
    }

    public void scroll(short s, short s2) {
        ListFunctions.LScroll(s, s2, this.getListRec());
    }

    public boolean search(byte[] byArray, short s, ListSearchClosureUPP listSearchClosureUPP, CellStruct cellStruct) {
        return ListFunctions.LSearch(byArray, s, listSearchClosureUPP, cellStruct, this.getListRec());
    }

    public boolean search(byte[] byArray, short s, ListSearchClosureUPP listSearchClosureUPP, Cell cell) {
        return this.search(byArray, s, listSearchClosureUPP, cell.getCell());
    }

    public boolean search(PointerStruct pointerStruct, short s, ListSearchClosureUPP listSearchClosureUPP, CellStruct cellStruct) {
        return ListFunctions.LSearch(pointerStruct.getPointer(), s, listSearchClosureUPP, cellStruct, this.getListRec());
    }

    public boolean search(PointerStruct pointerStruct, short s, ListSearchClosureUPP listSearchClosureUPP, Cell cell) {
        return this.search(pointerStruct, s, listSearchClosureUPP, cell.getCell());
    }

    public boolean search(String string, ListSearchClosureUPP listSearchClosureUPP, CellStruct cellStruct) {
        return this.search(TranslateString.asBytes(string), (short)string.length(), listSearchClosureUPP, cellStruct);
    }

    public boolean search(String string, ListSearchClosureUPP listSearchClosureUPP, Cell cell) {
        return this.search(string, listSearchClosureUPP, cell.getCell());
    }

    public void size(short s, short s2) {
        ListFunctions.LSize(s, s2, this.getListRec());
    }

    public void cellSize(Point point) {
        ListFunctions.LCellSize(point.getPoint(), this.getListRec());
    }

    public boolean nextCell(boolean bl, boolean bl2, CellStruct cellStruct) {
        return ListFunctions.LNextCell(bl, bl2, cellStruct, this.getListRec());
    }

    public boolean nextCell(boolean bl, boolean bl2, Cell cell) {
        return this.nextCell(bl, bl2, cell.getCell());
    }

    public void rect(RectStruct rectStruct, CellStruct cellStruct) {
        ListFunctions.LRect(rectStruct, cellStruct, this.getListRec());
    }

    public void rect(Rect rect, Cell cell) {
        this.rect(rect.getRect(), cell.getCell());
    }

    public void lastClick(CellStruct cellStruct) {
        ListFunctions.LLastClick(cellStruct, this.getListRec());
    }

    public void lastClick(Cell cell) {
        this.lastClick(cell.getCell());
    }

    public Cell lastClick() {
        Cell cell = new Cell();
        this.lastClick(cell);
        return cell;
    }

    public WindowRef getWindowRef() {
        return this.getPort();
    }

    public final boolean getLActive() {
        return this.getListRec().getLActive();
    }

    public final Rect getRView() {
        return new Rect(this.getListRec().getRView());
    }

    public final void setRView(Rect rect) {
        this.getListRec().setRView(rect.getRect());
    }

    public final WindowRef getPort() {
        return new WindowRef(this.getListRec().getPort());
    }

    public final void setPort(WindowRef windowRef) {
        this.getListRec().setPort(windowRef.getWindowPointer());
    }

    public final Point getIndent() {
        return new Point(this.getListRec().getIndent());
    }

    public final void setIndent(Point point) {
        this.getListRec().setIndent(point.getPoint());
    }

    public final Point getCellSize() {
        return new Point(this.getListRec().getCellSize());
    }

    public final void setCellSize(Point point) {
        this.getListRec().setCellSize(point.getPoint());
    }

    public Rect getVisible() {
        return new Rect(this.getListRec().getVisible());
    }

    public final void setVisible(ListBounds listBounds) {
        this.getListRec().setVisible(listBounds.getListBounds());
    }

    public final byte getSelFlags() {
        return this.getListRec().getSelFlags();
    }

    public final void setSelFlags(byte by) {
        this.getListRec().setSelFlags(by);
    }

    public final short getRowCount() {
        return this.getDataBounds().getHeight();
    }

    public final short getColumnCount() {
        return this.getDataBounds().getWidth();
    }

    public final Rect getDataBounds() {
        return new Rect(this.getListRec().getDataBounds());
    }

    public final void setVScroll(ControlRef controlRef) {
        this.fVScroll = controlRef;
        if (controlRef == null) {
            this.getListRec().setVScroll(0);
        } else {
            this.fVScroll.owner = this;
            this.getListRec().setVScroll(this.fVScroll.getHandleValue());
        }
    }

    public final void setHScroll(ControlRef controlRef) {
        this.fHScroll = controlRef;
        if (controlRef == null) {
            this.getListRec().setHScroll(0);
        } else {
            this.fHScroll.owner = this;
            this.getListRec().setHScroll(this.fHScroll.getHandleValue());
        }
    }

    public final ControlRef getVScroll() {
        if (this.fVScroll == null) {
            int n = this.getListRec().getVScroll();
            if (n == 0) {
                return null;
            }
            this.fVScroll = ControlRef.GetOwnedControlRef(n, this);
        }
        return this.fVScroll;
    }

    public final ControlRef getHScroll() {
        if (this.fHScroll == null) {
            int n = this.getListRec().getHScroll();
            if (n == 0) {
                return null;
            }
            this.fHScroll = ControlRef.GetOwnedControlRef(n, this);
        }
        return this.fHScroll;
    }
}

