/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.jdirect.Struct;
import com.apple.mrj.macos.generated.EventFunctions;
import com.apple.mrj.macos.generated.EventRecordStruct;
import com.apple.mrj.macos.generated.MacWindowFunctions;
import com.apple.mrj.macos.toolbox.EventManager;
import com.apple.mrj.macos.toolbox.OSType;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Ptr;
import com.apple.mrj.macos.toolbox.Region;
import com.apple.mrj.macos.toolbox.WindowRef;

public class EventRecord
implements EventManager {
    EventRecordStruct data;
    private static Ptr myTransData = null;
    private static int[] myState = new int[1];

    EventRecordStruct getEventRecord() {
        return this.data;
    }

    public EventRecord() {
        this.data = new EventRecordStruct();
    }

    public EventRecord(Struct struct) {
        this(struct, 0);
    }

    public EventRecord(Struct struct, int n) {
        this.data = new EventRecordStruct(struct, n);
    }

    public static boolean cmdKeyDown(int n) {
        return (n & 0x100) != 0;
    }

    public static boolean shiftKeyDown(int n) {
        return (n & 0x200) != 0;
    }

    public static boolean optionKeyDown(int n) {
        return (n & 0x800) != 0;
    }

    public static boolean controlKeyDown(int n) {
        return (n & 0x1000) != 0;
    }

    public static boolean activeFlag(int n) {
        return (n & 1) != 0;
    }

    public short getWhat() {
        return this.data.getWhat();
    }

    public int getMessage() {
        return this.data.getMessage();
    }

    public int getWhen() {
        return this.data.getWhen();
    }

    public Point getWhere() {
        return new Point(this.data.getWhere());
    }

    public OSType getEventID() {
        return new OSType(this.getWhere().getValue());
    }

    public short getModifiers() {
        return this.data.getModifiers();
    }

    void setWhat(short s) {
        this.data.setWhat(s);
    }

    void setMessage(int n) {
        this.data.setMessage(n);
    }

    void setWhen(int n) {
        this.data.setWhen(n);
    }

    void setWhere(Point point) {
        this.data.setWhere(point.getPoint());
    }

    void setModifiers(short s) {
        this.data.setModifiers(s);
    }

    public final char getCharCode() {
        return (char)(this.getMessage() & 0xFF);
    }

    public final char getKeyCode() {
        return (char)((this.getMessage() & 0xFF00) >> 8);
    }

    final void setCharCode(char c) {
        this.setMessage(c & this.getKeyCode() << 8);
    }

    final void setKeyCode(char c) {
        this.setMessage(c << 8 & this.getCharCode());
    }

    public boolean cmdKeyDown() {
        return EventRecord.cmdKeyDown(this.getModifiers());
    }

    public boolean shiftKeyDown() {
        return EventRecord.shiftKeyDown(this.getModifiers());
    }

    public boolean optionKeyDown() {
        return EventRecord.optionKeyDown(this.getModifiers());
    }

    public boolean controlKeyDown() {
        return EventRecord.controlKeyDown(this.getModifiers());
    }

    public boolean activeFlag() {
        return EventRecord.activeFlag(this.getModifiers());
    }

    public WindowRef getWindowMessage() {
        return new WindowRef(this.getMessage());
    }

    public int findWindow() {
        int[] nArray = new int[1];
        return this.findWindow(nArray);
    }

    public int findWindow(int[] nArray) {
        return MacWindowFunctions.FindWindow(this.data.getWhere(), nArray);
    }

    public final boolean waitNextEvent(short s, int n, Region region) {
        Object object = EventManager.lock;
        synchronized (object) {
            boolean bl = EventFunctions.WaitNextEvent(s, this.getEventRecord(), n, region != null ? region.getRegion() : null);
            Object var6_6 = null;
            return bl;
        }
    }

    public final boolean eventAvail(short s) {
        Object object = EventManager.lock;
        synchronized (object) {
            boolean bl = EventFunctions.EventAvail(s, this.getEventRecord());
            Object var4_4 = null;
            return bl;
        }
    }

    public final boolean eventAvail() {
        return EventFunctions.EventAvail((short)-1, this.getEventRecord());
    }

    public final boolean getNextEvent(short s) {
        Object object = EventManager.lock;
        synchronized (object) {
            boolean bl = EventFunctions.GetNextEvent(s, this.getEventRecord());
            Object var4_4 = null;
            return bl;
        }
    }

    public final boolean getNextEvent() {
        return EventFunctions.GetNextEvent((short)-1, this.getEventRecord());
    }

    public void flushEvents(short s, short s2) {
        EventFunctions.FlushEvents(s, s2);
    }

    public void systemClick(WindowRef windowRef) {
        EventFunctions.SystemClick(this.getEventRecord(), windowRef.getWindowPointer());
    }

    public static void systemTask() {
        EventFunctions.SystemTask();
    }

    public final boolean getOSEvent(short s) {
        return EventFunctions.GetOSEvent(s, this.getEventRecord());
    }

    public final boolean getOSEvent() {
        return EventFunctions.GetOSEvent((short)-1, this.getEventRecord());
    }

    public final boolean osEventAvail(short s) {
        return EventFunctions.OSEventAvail(s, this.getEventRecord());
    }

    public final boolean osEventAvail() {
        return EventFunctions.OSEventAvail((short)-1, this.getEventRecord());
    }

    public static void setEventMask(short s) {
        EventFunctions.SetEventMask(s);
    }

    public static int keyTranslate(Ptr ptr, short s) {
        if (ptr != myTransData) {
            myTransData = ptr;
            EventRecord.myState[0] = 0;
        }
        return EventFunctions.KeyTranslate(ptr.getPointer(), s, myState);
    }

    public static int getCaretTime() {
        return EventFunctions.GetCaretTime();
    }

    public static int getDblTime() {
        return EventFunctions.GetDblTime();
    }

    public static int tickCount() {
        return EventFunctions.TickCount();
    }
}

