/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.internal.jdirect.ArrayCopy;
import com.apple.mrj.macos.generated.AEDataModelFunctions;
import com.apple.mrj.macos.generated.AEDescListStruct;
import com.apple.mrj.macos.generated.AEDescStruct;
import com.apple.mrj.macos.generated.AEEventHandlerClosureUPP;
import com.apple.mrj.macos.generated.AEEventHandlerInterface;
import com.apple.mrj.macos.generated.AppleEventFunctions;
import com.apple.mrj.macos.generated.AppleEventStruct;
import com.apple.mrj.macos.generated.FSSpecStruct;
import com.apple.mrj.macos.toolbox.ApplicationEventListener;
import com.apple.mrj.macos.toolbox.ApplicationEventProxy;
import com.apple.mrj.macos.toolbox.FSSpec;
import java.io.File;
import java.util.Vector;

public class ApplicationEventProxy
implements AEEventHandlerInterface {
    private static final int ABOU = 0;
    private static final int OAPP = 1;
    private static final int ODOC = 2;
    private static final int PDOC = 3;
    private static final int QUIT = 4;
    private AEEventHandlerClosureUPP handler;
    private ApplicationEventListener listener;
    private static ApplicationEventProxy instance;

    private void checkError(short s) {
        if (s != 0) {
            throw new RuntimeException("macos error: " + s);
        }
    }

    private void processOne(AEDescStruct aEDescStruct, Vector vector) {
        AEDescStruct aEDescStruct2 = new AEDescStruct();
        this.checkError(AEDataModelFunctions.AECoerceDesc(aEDescStruct, 1718842144, aEDescStruct2));
        FSSpecStruct fSSpecStruct = new FSSpecStruct();
        ArrayCopy.copyHandleToArray(aEDescStruct2.getDataHandle(), 0, fSSpecStruct.getByteArray(), 0, 70);
        AEDataModelFunctions.AEDisposeDesc(aEDescStruct2);
        vector.addElement(new FSSpec(fSSpecStruct).toFile());
    }

    private void processList(AEDescListStruct aEDescListStruct, Vector vector) {
        AEDescListStruct aEDescListStruct2 = new AEDescListStruct();
        int[] nArray = new int[1];
        this.checkError(AEDataModelFunctions.AECountItems(aEDescListStruct, nArray));
        int n = nArray[0];
        int n2 = 1;
        while (n2 <= n) {
            this.checkError(AEDataModelFunctions.AEGetNthDesc(aEDescListStruct, n2, 0x2A2A2A2A, nArray, aEDescListStruct2));
            this.processItem(aEDescListStruct2, vector);
            AEDataModelFunctions.AEDisposeDesc(aEDescListStruct2);
            ++n2;
        }
    }

    private void processItem(AEDescListStruct aEDescListStruct, Vector vector) {
        if (aEDescListStruct.getDescriptorType() == 1818850164) {
            this.processList(aEDescListStruct, vector);
        } else {
            this.processOne(aEDescListStruct, vector);
        }
    }

    private File[] retrieveOdocFiles(int n) {
        AppleEventStruct appleEventStruct = new AppleEventStruct();
        ArrayCopy.copyPointerToArray(n, 0, appleEventStruct.getByteArray(), 0, 8);
        Vector vector = new Vector();
        AEDescListStruct aEDescListStruct = new AEDescListStruct();
        this.checkError(AEDataModelFunctions.AEGetParamDesc(appleEventStruct, 0x2D2D2D2D, 0x2A2A2A2A, aEDescListStruct));
        this.processItem(aEDescListStruct, vector);
        AEDataModelFunctions.AEDisposeDesc(aEDescListStruct);
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected short threadedHandler(int n, int n2, int n3) {
        short s = -1708;
        try {
            switch (n3) {
                case 0: {
                    this.listener.aboutApplication();
                    break;
                }
                case 1: {
                    this.listener.openApplication();
                    break;
                }
                case 2: {
                    this.listener.openDocuments(this.retrieveOdocFiles(n));
                    break;
                }
                case 3: {
                    this.listener.printDocuments(this.retrieveOdocFiles(n));
                    break;
                }
                case 4: {
                    this.listener.quitApplication();
                    break;
                }
            }
            s = 0;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                s = 0;
            }
            System.out.println("got an exception: " + throwable);
            throwable.printStackTrace(System.out);
        }
        return s;
    }

    public short AEEventHandler(int n, int n2, int n3) {
        AppleEventStruct appleEventStruct = new AppleEventStruct();
        ArrayCopy.copyPointerToArray(n, 0, appleEventStruct.getByteArray(), 0, 8);
        AppleEventStruct appleEventStruct2 = new AppleEventStruct();
        ArrayCopy.copyPointerToArray(n2, 0, appleEventStruct2.getByteArray(), 0, 8);
        this.checkError(AppleEventFunctions.AESuspendTheCurrentEvent(appleEventStruct));
        new Thread(new 1(appleEventStruct, n3, appleEventStruct2, this)).start();
        return 0;
    }

    private void installHandlers() {
        this.handler = new AEEventHandlerClosureUPP(this);
        this.checkError(AppleEventFunctions.AEInstallEventHandler(1634039412, 1094864725, this.handler, 0, false));
        this.checkError(AppleEventFunctions.AEInstallEventHandler(1634039412, 1868656752, this.handler, 1, false));
        this.checkError(AppleEventFunctions.AEInstallEventHandler(1634039412, 1868853091, this.handler, 2, false));
        this.checkError(AppleEventFunctions.AEInstallEventHandler(1634039412, 1885630307, this.handler, 3, false));
        this.checkError(AppleEventFunctions.AEInstallEventHandler(1634039412, 1903520116, this.handler, 4, false));
    }

    private ApplicationEventProxy(ApplicationEventListener applicationEventListener) {
        this.setListener(applicationEventListener);
        this.installHandlers();
        this.repostApplicationEvents();
    }

    private void setListener(ApplicationEventListener applicationEventListener) {
        this.listener = applicationEventListener;
    }

    public static void installListener(ApplicationEventListener applicationEventListener) {
        if (instance == null) {
            instance = new ApplicationEventProxy(applicationEventListener);
        } else {
            instance.setListener(applicationEventListener);
        }
    }

    protected native void repostApplicationEvents0();

    protected void repostApplicationEvents() {
        try {
            this.repostApplicationEvents0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ int val$refcon;
        private final /* synthetic */ AppleEventStruct val$reply;
        private final /* synthetic */ AppleEventStruct val$aevt;
        private final /* synthetic */ ApplicationEventProxy this$0;

        public void run() {
            AEEventHandlerClosureUPP aEEventHandlerClosureUPP = new AEEventHandlerClosureUPP(new 2(this.this$0));
            AppleEventStruct appleEventStruct = new AppleEventStruct();
            this.this$0.checkError(AppleEventFunctions.AEGetTheCurrentEvent(appleEventStruct));
            this.this$0.checkError(AppleEventFunctions.AEResumeTheCurrentEvent(this.val$aevt, this.val$reply, aEEventHandlerClosureUPP, this.val$refcon));
            this.this$0.checkError(AppleEventFunctions.AESetTheCurrentEvent(appleEventStruct));
        }

        /* synthetic */ 1(AppleEventStruct appleEventStruct, int n, AppleEventStruct appleEventStruct2, ApplicationEventProxy applicationEventProxy) {
            this.val$aevt = appleEventStruct;
            this.val$refcon = n;
            this.val$reply = appleEventStruct2;
            this.this$0 = applicationEventProxy;
        }
    }
}

