/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.CharsHandle;
import com.apple.MacOS.Handle;
import com.apple.MacOS.MemoryUtils;
import com.apple.MacOS.MethodClosure;
import com.apple.MacOS.Point;
import com.apple.MacOS.Rect;
import com.apple.MacOS.Region;
import com.apple.MacOS.RgnHandle;
import com.apple.MacOS.StScrpHandle;
import com.apple.MacOS.StringPtr;
import com.apple.MacOS.TEClickLoopUPP;
import com.apple.MacOS.TEStyleHandle;
import com.apple.MacOS.TextStyle;
import com.apple.MacOS.TextUtilities;
import com.apple.MacOS.ToolboxObject;
import com.apple.MacOS.TranslateString;
import com.apple.MacOS.UniversalProcPtr;
import com.apple.MacOS.WindowRef;
import com.apple.MacOS.WordBreakUPP;
import com.apple.memory.PInt;
import com.apple.memory.PShort;
import com.apple.memory.PointerObject;

public class TEHandle
extends Handle
implements ToolboxObject {
    private boolean visible = true;
    public static final short teJustLeft = 0;
    public static final short teJustCenter = 1;
    public static final short teJustRight = -1;
    public static final short teForceLeft = -2;
    public static final short teFlushDefault = 0;
    public static final short teCenter = 1;
    public static final short teFlushRight = -1;
    public static final short teFlushLeft = -2;
    public static final short fontBit = 0;
    public static final short faceBit = 1;
    public static final short sizeBit = 2;
    public static final short clrBit = 3;
    public static final short addSizeBit = 4;
    public static final short toggleBit = 5;
    public static final short toglBit = 5;
    public static final short doFont = 1;
    public static final short doFace = 2;
    public static final short doSize = 4;
    public static final short doColor = 8;
    public static final short doAll = 15;
    public static final short addSize = 16;
    public static final short doToggle = 32;
    public static final short EOLHook = 0;
    public static final short DRAWHook = 4;
    public static final short WIDTHHook = 8;
    public static final short HITTESTHook = 12;
    public static final short nWIDTHHook = 24;
    public static final short TextWidthHook = 28;
    public static final short intEOLHook = 0;
    public static final short intDrawHook = 1;
    public static final short intWidthHook = 2;
    public static final short intHitTestHook = 3;
    public static final short intNWidthHook = 6;
    public static final short intTextWidthHook = 7;
    public static final short teFAutoScroll = 0;
    public static final short teFAutoScr = 0;
    public static final short teFTextBuffering = 1;
    public static final short teFOutlineHilite = 2;
    public static final short teFInlineInput = 3;
    public static final short teFUseTextServices = 4;
    public static final short teBitClear = 0;
    public static final short teBitSet = 1;
    public static final short teBitTest = -1;
    public static final short teWordSelect = 4;
    public static final short teWordDrag = 8;
    public static final short teFromFind = 12;
    public static final short teFromRecal = 16;
    public static final short teFind = 0;
    public static final short teHighlight = 1;
    public static final short teDraw = -1;
    public static final short teCaret = -2;
    private static Object theTENewLock = new Object();

    public Rect getDestRect() {
        return MemoryUtils.RectAt(this, 0);
    }

    public void setDestRect(Rect rect) {
        rect.CopyValue(0, this);
    }

    public Rect getViewRect() {
        return MemoryUtils.RectAt(this, 8);
    }

    public void setViewRect(Rect rect) {
        rect.CopyValue(8, this);
    }

    public Rect getSelRect() {
        return MemoryUtils.RectAt(this, 16);
    }

    public short getLineHeight() {
        return this.getShortAt(24);
    }

    public short getFontAscent() {
        return this.getShortAt(26);
    }

    public short getSelStart() {
        return this.getShortAt(32);
    }

    public short getSelEnd() {
        return this.getShortAt(34);
    }

    public short getTELength() {
        return this.getShortAt(60);
    }

    public short getTXSize() {
        return this.getShortAt(80);
    }

    public WindowRef getWindowRef() {
        return new WindowRef(this.getIntAt(82));
    }

    public short getNLines() {
        return this.getShortAt(94);
    }

    public boolean HitTest(Point point) {
        return this.getViewRect().Contains(point);
    }

    public PointerObject getLineStarts() {
        return this.PointerAt(96, this.getNLines() * 2);
    }

    public native void TEInit();

    private static int SafeNew(Rect rect, Rect rect2, boolean bl, WindowRef windowRef) {
        int n;
        Object object = theTENewLock;
        synchronized (object) {
            windowRef.SetPort();
            n = bl ? TEHandle.TEStyleNew(rect, rect2) : TEHandle.TENew(rect, rect2);
        }
        return n;
    }

    private static int SafeNew(Rect rect, boolean bl, WindowRef windowRef) {
        Rect rect2 = new Rect(rect);
        rect2.Inset((short)4, (short)-1);
        return TEHandle.SafeNew(rect2, rect, bl, windowRef);
    }

    public TEHandle(Rect rect, Rect rect2, boolean bl, WindowRef windowRef) {
        super(TEHandle.SafeNew(rect, rect2, bl, windowRef));
    }

    public TEHandle(Rect rect, boolean bl, WindowRef windowRef) {
        super(TEHandle.SafeNew(rect, bl, windowRef));
    }

    protected TEHandle(int n) {
        super(n);
    }

    protected int AllocateHandle(int n, boolean bl) {
        return 0;
    }

    protected void FreeHandle(int n) {
        TEHandle.TEDispose(n);
    }

    public void Activate() {
        TEHandle.TEActivate(this.getHandle());
    }

    public void Deactivate() {
        TEHandle.TEDeactivate(this.getHandle());
    }

    public void Key(short s) {
        TEHandle.TEKey(s, this.getHandle());
    }

    public void SetText(byte[] byArray, int n) {
        TEHandle.TESetText(byArray, n, this.getHandle());
    }

    public void SetText(String string) {
        this.SetText(TranslateString.asBytes(string), string.length());
    }

    public CharsHandle GetText() {
        return new CharsHandle(TEHandle.TEGetText(this.getHandle()), this);
    }

    public String GetTextAsString() {
        CharsHandle charsHandle = this.GetText();
        return new String(charsHandle.getBytes(), 0, 0, (int)this.getTELength());
    }

    public void SetStyleHandle(TEStyleHandle tEStyleHandle) {
        TEHandle.TESetStyleHandle(tEStyleHandle.getHandle(), this.getHandle());
    }

    public TEStyleHandle GetStyleHandle() {
        return new TEStyleHandle(TEHandle.TEGetStyleHandle(this.getHandle()), this);
    }

    public void Idle() {
        TEHandle.TEIdle(this.getHandle());
    }

    public void Click(Point point, boolean bl) {
        TEHandle.TEClick(point.toInt(), bl, this.getHandle());
    }

    public void SetSelect(int n, int n2) {
        TEHandle.TESetSelect(n, n2, this.getHandle());
    }

    public void SetAlignment(short s) {
        TEHandle.TESetAlignment(s, this.getHandle());
    }

    public void Update(Rect rect) {
        TEHandle.TEUpdate(rect, this.getHandle());
    }

    public void Update(Region region) {
        this.Update(region.Bounds());
    }

    public void Draw() {
        this.Update(this.getViewRect());
    }

    public static void TextBox(StringPtr stringPtr, int n, Rect rect, short s) {
        TEHandle.TextBox(stringPtr.getBytes(), n, rect, s);
    }

    public static void TextBox(byte[] byArray, int n, Rect rect, short s) {
        TEHandle.TETextBox(byArray, n, rect, s);
    }

    public void CalText() {
        TEHandle.TECalText(this.getHandle());
    }

    public int GetHeight(int n, int n2) {
        return TEHandle.TEGetHeight(n, n2, this.getHandle());
    }

    public void Scroll(short s, short s2) {
        TEHandle.TEScroll(s, s2, this.getHandle());
    }

    public void PinScroll(short s, short s2) {
        TEHandle.TEPinScroll(s, s2, this.getHandle());
    }

    public void AutoView(boolean bl) {
        TEHandle.TEAutoView(bl, this.getHandle());
    }

    public void SelView() {
        TEHandle.TESelView(this.getHandle());
    }

    public void Delete() {
        TEHandle.TEDelete(this.getHandle());
    }

    public void Insert(byte[] byArray, int n) {
        TEHandle.TEInsert(byArray, n, this.getHandle());
    }

    public void Insert(String string) {
        this.Insert(TranslateString.asBytes(string), string.length());
    }

    public void Cut() {
        TEHandle.TECut(this.getHandle());
    }

    public void Copy() {
        TEHandle.TECopy(this.getHandle());
    }

    public void Paste() {
        TEHandle.TEPaste(this.getHandle());
    }

    public void StylePaste() {
        TEHandle.TEStylePaste(this.getHandle());
    }

    public static short ToScrap() {
        return TEHandle.TEToScrap();
    }

    public static short FromScrap() {
        return TEHandle.TEFromScrap();
    }

    public static Handle ScrapHandle() {
        return new Handle(TEHandle.TEScrapHandle(), null);
    }

    public static int GetScrapLength() {
        return TEHandle.TEGetScrapLength();
    }

    public static void SetScrapLength(int n) {
        TEHandle.TESetScrapLength(n);
    }

    public void SetStyle(short s, TextStyle textStyle, boolean bl) {
        TEHandle.TESetStyle(s, textStyle, bl, this.getHandle());
    }

    public void ReplaceStyle(short s, TextStyle textStyle, TextStyle textStyle2, boolean bl) {
        TEHandle.TEReplaceStyle(s, textStyle, textStyle2, bl, this.getHandle());
    }

    public boolean ContinuousStyle(PShort pShort, TextStyle textStyle) {
        return TEHandle.TEContinuousStyle(pShort, textStyle, this.getHandle());
    }

    public void StyleInsert(byte[] byArray, int n, StScrpHandle stScrpHandle) {
        TEHandle.TEStyleInsert(byArray, n, stScrpHandle.getHandle(), this.getHandle());
    }

    public StScrpHandle GetStyleScrapHandle() {
        return new StScrpHandle(TEHandle.TEGetStyleScrapHandle(this.getHandle()), this);
    }

    public void UseStyleScrap(int n, int n2, StScrpHandle stScrpHandle, boolean bl) {
        TEHandle.TEUseStyleScrap(n, n2, stScrpHandle.getHandle(), bl, this.getHandle());
    }

    public int NumStyles(int n, int n2) {
        return TEHandle.TENumStyles(n, n2, this.getHandle());
    }

    public short GetOffset(Point point) {
        return TEHandle.TEGetOffset(point.toInt(), this.getHandle());
    }

    public Point GetPoint(short s) {
        return new Point(TEHandle.TEGetPoint(s, this.getHandle()));
    }

    public short FeatureFlag(short s, short s2) {
        return TEHandle.TEFeatureFlag(s, s2, this.getHandle());
    }

    public int CustomHook(short s, MethodClosure methodClosure) {
        PInt pInt = new PInt(UniversalProcPtr.getUPP(methodClosure));
        TEHandle.TECustomHook(s, pInt, this.getHandle());
        return pInt.getValue();
    }

    public void SetWordBreak(WordBreakUPP wordBreakUPP) {
        TEHandle.TESetWordBreak(wordBreakUPP, this.getHandle());
    }

    public void SetClickLoop(TEClickLoopUPP tEClickLoopUPP) {
        TEHandle.TESetClickLoop(tEClickLoopUPP, this.getHandle());
    }

    public Point GetOrigin() {
        return this.getViewRect().topLeft();
    }

    public Rect GetBounds() {
        return this.getViewRect();
    }

    public void SetBounds(Rect rect) {
        Rect rect2 = this.getViewRect();
        Rect rect3 = this.getDestRect();
        this.getWindowRef().Inval(rect2);
        rect3.Offset((short)(rect.getLeft() - rect2.getLeft()), (short)(rect.getTop() - rect2.getTop()));
        rect3.setBottom(rect3.getBottom() + (rect.Height() - rect2.Height()));
        rect3.setRight(rect3.getRight() + (rect.Width() - rect2.Width()));
        rect2.Set(rect);
        this.setViewRect(rect2);
        this.setDestRect(rect3);
        this.CalText();
        this.getWindowRef().Valid(rect2);
        this.Draw();
    }

    public void Move(short s, short s2) {
        Rect rect = this.getViewRect();
        Rect rect2 = this.getDestRect();
        this.getWindowRef().Inval(rect);
        rect.Erase();
        rect.Offset(s, s2);
        rect2.Offset(s, s2);
        this.getWindowRef().Valid(rect);
        this.Draw();
    }

    public void Size(short s, short s2) {
        Rect rect = this.getViewRect();
        Rect rect2 = this.getDestRect();
        this.getWindowRef().Inval(rect);
        if (s != 0) {
            rect.setRight(rect.getRight() + s);
            rect2.setRight(rect2.getRight() + s);
        }
        if (s2 != 0) {
            rect.setBottom(rect.getRight() + s2);
            rect2.setBottom(rect2.getRight() + s2);
        }
        this.CalText();
        this.getWindowRef().Valid(rect);
        this.Draw();
    }

    public int CalcMaxWidth() {
        CharsHandle charsHandle = this.GetText();
        int n = this.getNLines();
        PointerObject pointerObject = this.getLineStarts();
        short s = 0;
        charsHandle.Lock();
        PointerObject pointerObject2 = charsHandle.PointerAt(0, charsHandle.getSize());
        int n2 = 0;
        while (n2 < n) {
            short s2;
            short s3 = pointerObject.getShortAt(n2);
            short s4 = TextUtilities.TextWidth(pointerObject2, s3, (short)((s2 = n2 < n ? pointerObject.getShortAt(n2 + 1) : this.getTELength()) - s3));
            if (s4 > s) {
                s = s4;
            }
            ++n2;
        }
        charsHandle.Unlock();
        return s + 10;
    }

    public void IsVisible(boolean bl) {
        if (!bl && this.visible) {
            this.getViewRect().Erase();
        }
        if (bl && !this.visible) {
            this.Draw();
        }
        this.visible = bl;
    }

    public void IsHilited(boolean bl) {
        if (bl) {
            this.Activate();
        } else {
            this.Deactivate();
        }
    }

    private static native int TEScrapHandle();

    private static native int TEGetScrapLength();

    private static native int TENew(Rect var0, Rect var1);

    private static native void TEDispose(int var0);

    private static native void TESetText(byte[] var0, int var1, int var2);

    private static native int TEGetText(int var0);

    private static native void TEIdle(int var0);

    private static native void TESetSelect(int var0, int var1, int var2);

    private static native void TEActivate(int var0);

    private static native void TEDeactivate(int var0);

    private static native void TEKey(short var0, int var1);

    private static native void TECut(int var0);

    private static native void TECopy(int var0);

    private static native void TEPaste(int var0);

    private static native void TEDelete(int var0);

    private static native void TEInsert(byte[] var0, int var1, int var2);

    private static native void TESetAlignment(short var0, int var1);

    private static native void TEUpdate(Rect var0, int var1);

    private static native void TETextBox(byte[] var0, int var1, Rect var2, short var3);

    private static native void TEScroll(short var0, short var1, int var2);

    private static native void TESelView(int var0);

    private static native void TEPinScroll(short var0, short var1, int var2);

    private static native void TEAutoView(boolean var0, int var1);

    private static native void TECalText(int var0);

    private static native short TEGetOffset(int var0, int var1);

    private static native int TEGetPoint(short var0, int var1);

    private static native void TEClick(int var0, boolean var1, int var2);

    private static native int TEStyleNew(Rect var0, Rect var1);

    private static native void TESetStyleHandle(int var0, int var1);

    private static native int TEGetStyleHandle(int var0);

    private static native void TEGetStyle(short var0, TextStyle var1, short var2, PShort var3, int var4);

    private static native void TEStylePaste(int var0);

    private static native void TESetStyle(short var0, TextStyle var1, boolean var2, int var3);

    private static native void TEReplaceStyle(short var0, TextStyle var1, TextStyle var2, boolean var3, int var4);

    private static native int TEGetStyleScrapHandle(int var0);

    private static native void TEStyleInsert(byte[] var0, int var1, int var2, int var3);

    private static native int TEGetHeight(int var0, int var1, int var2);

    private static native boolean TEContinuousStyle(PShort var0, TextStyle var1, int var2);

    private static native void TEUseStyleScrap(int var0, int var1, int var2, boolean var3, int var4);

    private static native void TECustomHook(short var0, PInt var1, int var2);

    private static native int TENumStyles(int var0, int var1, int var2);

    private static native short TEFeatureFlag(short var0, short var1, int var2);

    private static native short TEGetHiliteRgn(RgnHandle var0, int var1);

    private static native void TESetScrapLength(int var0);

    private static native short TEFromScrap();

    private static native short TEToScrap();

    private static native void TESetClickLoop(TEClickLoopUPP var0, int var1);

    private static native void TESetWordBreak(WordBreakUPP var0, int var1);
}

