/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSError;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.ProcessInfoRec;
import com.apple.memory.StructObject;

public class ProcessSerialNumber
extends StructObject {
    long psn;
    public static final long kNoProcess = 0L;
    public static final long kSystemProcess = 1L;
    public static final long kCurrentProcess = 2L;
    public static final int modeDeskAccessory = 131072;
    public static final int modeMultiLaunch = 65536;
    public static final int modeNeedSuspendResume = 16384;
    public static final int modeCanBackground = 4096;
    public static final int modeDoesActivateOnFGSwitch = 2048;
    public static final int modeOnlyBackground = 1024;
    public static final int modeGetFrontClicks = 512;
    public static final int modeGetAppDiedMsg = 256;
    public static final int mode32BitCompatible = 128;
    public static final int modeHighLevelEventAware = 64;
    public static final int modeLocalAndRemoteHLEvents = 32;
    public static final int modeStationeryAware = 16;
    public static final int modeUseTextEditServices = 8;
    public static final int modeDisplayManagerAware = 4;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public ProcessSerialNumber(long l) {
        this.psn = l;
    }

    public ProcessSerialNumber() {
        this(2L);
    }

    public boolean isValidProcess() {
        return this.psn != 0L;
    }

    public void getNextProcess() throws MacOSError {
        MacOSError.CheckResult(ProcessSerialNumber.GetNextProcess(this));
    }

    public void getProcessInformation(ProcessInfoRec processInfoRec) throws MacOSError {
        MacOSError.CheckResult(ProcessSerialNumber.GetProcessInformation(this, processInfoRec));
    }

    public ProcessInfoRec getProcessInformation() throws MacOSError {
        ProcessInfoRec processInfoRec = new ProcessInfoRec();
        this.getProcessInformation(processInfoRec);
        return processInfoRec;
    }

    public String toString() {
        return this.getProcessInformation().getName();
    }

    public int getProcessType() {
        return this.getProcessInformation().processType;
    }

    public int getProcessCreator() {
        return this.getProcessInformation().processSignature;
    }

    public int getProcessMode() {
        return this.getProcessInformation().processMode;
    }

    public int getProcessSize() {
        return this.getProcessInformation().processSize;
    }

    public int getProcessFreeMem() {
        return this.getProcessInformation().processFreeMem;
    }

    public ProcessSerialNumber getLauncher() {
        return new ProcessSerialNumber(this.getProcessInformation().processLauncher);
    }

    public static ProcessSerialNumber findProcess(int n) {
        ProcessSerialNumber processSerialNumber = new ProcessSerialNumber(0L);
        do {
            ProcessSerialNumber.GetNextProcess(processSerialNumber);
            if (processSerialNumber.getProcessCreator() != n) continue;
            return processSerialNumber;
        } while (processSerialNumber.psn != 0L);
        return null;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[8];
        long l = this.psn;
        int n = 0;
        while (n < 8) {
            byArray[7 - n] = (byte)(l & 0xFFL);
            l >>= 8;
            ++n;
        }
        return byArray;
    }

    private static native short GetNextProcess(ProcessSerialNumber var0);

    private static native short GetProcessInformation(ProcessSerialNumber var0, ProcessInfoRec var1);
}

