/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.Handle;
import com.apple.MacOS.Pattern;
import com.apple.MacOS.PenState;
import com.apple.MacOS.Point;
import com.apple.MacOS.Shape;
import java.awt.Polygon;

public class PolyHandle
extends Handle
implements Shape {
    Point origin;
    private static Object thePolyLock = new Object();

    public PolyHandle() {
    }

    public PolyHandle(Polygon polygon) {
        this(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public PolyHandle(int[] nArray, int[] nArray2, int n) {
        this();
        Object object = thePolyLock;
        synchronized (object) {
            this.origin = new Point((short)nArray[0], (short)nArray2[0]);
            this.handle = PolyHandle.OpenPoly();
            PolyHandle.DrawPolyline(nArray, nArray2, n);
            PolyHandle.ClosePoly();
        }
    }

    public PolyHandle(Point[] pointArray, int n) {
        this();
        Object object = thePolyLock;
        synchronized (object) {
            this.origin = new Point(pointArray[0]);
            this.handle = PolyHandle.OpenPoly();
            this.DrawPolyline(pointArray, n);
            PolyHandle.ClosePoly();
        }
    }

    public static void DrawPolyline(int[] nArray, int[] nArray2, int n) {
        Object object = thePolyLock;
        synchronized (object) {
            PenState.MoveTo((short)nArray[0], (short)nArray2[0]);
            int n2 = 1;
            while (n2 < n) {
                PenState.LineTo((short)nArray[n2], (short)nArray2[n2]);
                ++n2;
            }
        }
    }

    public void DrawPolyline(Point[] pointArray, int n) {
        Object object = thePolyLock;
        synchronized (object) {
            PenState.MoveTo(pointArray[0].getH(), pointArray[0].getV());
            int n2 = 1;
            while (n2 < n) {
                PenState.LineTo(pointArray[n2].getH(), pointArray[n2].getV());
                ++n2;
            }
        }
    }

    public short getLeft() {
        return this.origin.h;
    }

    public short getTop() {
        return this.origin.v;
    }

    public void MoveTo(short s, short s2) {
        this.Offset((short)(s - this.getLeft()), (short)(s2 - this.getTop()));
        this.origin.Set(s, s2);
    }

    public void Offset(short s, short s2) {
        PolyHandle.OffsetPoly(this.handle, s, s2);
        this.origin.Offset(s, s2);
    }

    public boolean Contains(Point point) {
        return false;
    }

    public void Frame() {
        PolyHandle.FramePoly(this.handle);
    }

    public void Paint() {
        PolyHandle.PaintPoly(this.handle);
    }

    public void Fill(Pattern pattern) {
        PolyHandle.FillPoly(this.handle, pattern);
    }

    public void Erase() {
        PolyHandle.ErasePoly(this.handle);
    }

    public void Invert() {
        PolyHandle.InvertPoly(this.handle);
    }

    private static native int OpenPoly();

    private static native void ClosePoly();

    private static native void OffsetPoly(int var0, short var1, short var2);

    private static native void KillPoly(int var0);

    private static native void FramePoly(int var0);

    private static native void PaintPoly(int var0);

    private static native void FillPoly(int var0, Pattern var1);

    private static native void ErasePoly(int var0);

    private static native void InvertPoly(int var0);
}

