/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.FSSpec;
import com.apple.MacOS.MacOSError;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.Point;
import com.apple.memory.ByteObject;

public class FInfo
extends ByteObject {
    public static final int sizeOfFInfo = 16;
    FSSpec itsSpec;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    private FInfo() {
        super(16);
    }

    public FInfo(FSSpec fSSpec) {
        this();
        this.itsSpec = fSSpec;
        this.readFromSpec();
    }

    public int getType() {
        return this.getIntAt(0);
    }

    public int getCreator() {
        return this.getIntAt(4);
    }

    public short getFlags() {
        return this.getShortAt(8);
    }

    public Point getLocation() {
        return new Point(this.getIntAt(10));
    }

    public short getFolder() {
        return this.getShortAt(14);
    }

    public void setType(int n) {
        this.setIntAt(0, n);
    }

    public void setCreator(int n) {
        this.setIntAt(4, n);
    }

    public void setFlags(short s) {
        this.setShortAt(8, s);
    }

    public void setLocation(Point point) {
        this.setIntAt(10, point.toInt());
    }

    public void setFolder(short s) {
        this.setShortAt(14, s);
    }

    public void setFInfo() {
        this.writeToSpec();
    }

    private void readFromSpec() {
        MacOSError.CheckResult(FInfo.FSpGetFInfo(this.itsSpec.getBytes(), this.getBytes()));
    }

    private void writeToSpec() {
        MacOSError.CheckResult(FInfo.FSpSetFInfo(this.itsSpec.getBytes(), this.getBytes()));
    }

    private static native short FSpGetFInfo(byte[] var0, byte[] var1);

    private static native short FSpSetFInfo(byte[] var0, byte[] var1);
}

