/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.util;

import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.firestore.FirestoreDocumentReference;
import coldfusion.cloud.gcp.firestore.exception.GCPFirestoreException;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentReferenceImpl;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentSnapshot;
import coldfusion.cloud.gcp.firestore.impl.FirestoreQuerySnapshot;
import coldfusion.runtime.Array;
import coldfusion.runtime.OleDateTime;
import coldfusion.util.RB;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Strings;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class FirestoreUtils {
    public static boolean isNullOrEmpty(String value) {
        return Strings.isNullOrEmpty((String)value);
    }

    public static Precondition getPrecondition(OleDateTime timestamp) {
        if (Objects.isNull(timestamp)) {
            throw new ValidationException(RB.getString(FirestoreUtils.class, (String)"TIMESTAMP_NULL"));
        }
        return Precondition.updatedAt((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)(timestamp.getTime() / 1000L), (int)timestamp.getNanos()));
    }

    public static FieldPath stringToFieldPath(String path) {
        if (FirestoreUtils.isNullOrEmpty(path)) {
            throw new ValidationException(RB.getString(FirestoreUtils.class, (String)"FIELD_PATH_NULL"));
        }
        String[] splitPath = path.split("\\.");
        return FieldPath.of((String[])splitPath);
    }

    public static FieldMask getFieldMask(Array mask) {
        if (Objects.nonNull(mask)) {
            FieldPath[] fieldsPaths = new FieldPath[mask.size()];
            for (int i = 0; i < mask.size(); ++i) {
                fieldsPaths[i] = FirestoreUtils.stringToFieldPath((String)mask.get(i));
            }
            return FieldMask.of((FieldPath[])fieldsPaths);
        }
        throw new ValidationException(RB.getString(FirestoreUtils.class, (String)"RESULTS_FILTER_NULL"));
    }

    public static OleDateTime getPrecisedDate(Timestamp timestamp) {
        long seconds = timestamp.getSeconds();
        int nanos = timestamp.getNanos();
        return new OleDateTime(seconds, nanos);
    }

    public static Function<List<WriteResult>, List<OleDateTime>> getWriteResultListConverter() {
        return writeResults -> writeResults.stream().map(FirestoreUtils.getWriteResultConverter()).collect(Collectors.toList());
    }

    public static Function<WriteResult, OleDateTime> getWriteResultConverter() {
        return writeResult -> FirestoreUtils.getPrecisedDate(writeResult.getUpdateTime());
    }

    public static Function<DocumentReference, FirestoreDocumentReference> getDocumentReferenceCaster() {
        return FirestoreDocumentReferenceImpl::new;
    }

    public static Function<DocumentSnapshot, FirestoreDocumentSnapshot> getDocumentSnapshotStruct() {
        return FirestoreDocumentSnapshot::new;
    }

    public static Function<QuerySnapshot, FirestoreQuerySnapshot> getQuerySnapshotStruct() {
        return FirestoreQuerySnapshot::new;
    }

    public static Function<List<DocumentSnapshot>, List<FirestoreDocumentSnapshot>> documentSnapshotList() {
        return result -> result.stream().map(FirestoreDocumentSnapshot::new).collect(Collectors.toList());
    }

    public static RuntimeException HandleFirestoreException(String message, Throwable throwable) {
        if (throwable instanceof FirestoreException) {
            return new GCPFirestoreException(message, throwable);
        }
        if (throwable instanceof StatusRuntimeException) {
            return new GCPFirestoreException(message, throwable);
        }
        if (throwable instanceof RuntimeException) {
            return new GCPFirestoreException(message, throwable);
        }
        return new RuntimeException(message, throwable);
    }

    public static void validateDocumentData(Map<?, ?> data, String funcName) {
        if (Objects.isNull(data)) {
            throw new ValidationException(RB.getString(FirestoreUtils.class, (String)"DOCUMENT_STRUCT_DATA_NULL", (Object)funcName));
        }
    }
}

