/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.retry;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.ApiCallAttemptTimeoutException;
import software.amazon.awssdk.core.exception.RetryableException;

@SdkInternalApi
public final class SdkDefaultRetrySetting {
    public static final int RETRY_THROTTLING_COST = 5;
    public static final int THROTTLED_RETRIES = 100;
    public static final Duration BASE_DELAY = Duration.ofMillis(100L);
    public static final Duration THROTTLED_BASE_DELAY = Duration.ofMillis(500L);
    public static final Duration MAX_BACKOFF = Duration.ofMillis(20000L);
    public static final Integer DEFAULT_MAX_RETRIES = 3;
    public static final Set<Integer> RETRYABLE_STATUS_CODES;
    public static final Set<Class<? extends Exception>> RETRYABLE_EXCEPTIONS;

    private SdkDefaultRetrySetting() {
    }

    static {
        HashSet<Integer> retryableStatusCodes = new HashSet<Integer>();
        retryableStatusCodes.add(500);
        retryableStatusCodes.add(502);
        retryableStatusCodes.add(503);
        retryableStatusCodes.add(504);
        RETRYABLE_STATUS_CODES = Collections.unmodifiableSet(retryableStatusCodes);
        HashSet<Class<ApiCallAttemptTimeoutException>> retryableExceptions = new HashSet<Class<ApiCallAttemptTimeoutException>>();
        retryableExceptions.add(RetryableException.class);
        retryableExceptions.add(IOException.class);
        retryableExceptions.add(ApiCallAttemptTimeoutException.class);
        RETRYABLE_EXCEPTIONS = Collections.unmodifiableSet(retryableExceptions);
    }
}

