/*
 * Decompiled with CFR 0.152.
 */
package com.zingchart.nh;

import com.zingchart.nh.Context2d;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Canvas {
    private static final long serialVersionUID = 538270592527335641L;
    private int width;
    private int height;
    private BufferedImage image;
    private Graphics2D graphics;
    private Context2d context;

    public Context2d getContext(String s) {
        this.context = new Context2d();
        this.context.setCanvas(this);
        if (this.image == null) {
            this.image = new BufferedImage(this.width, this.height, 2);
            this.graphics = this.image.createGraphics();
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return this.context;
    }

    public void saveAs(String s) {
        try {
            this.graphics.dispose();
            if (s != "" && !s.isEmpty() && !s.equals("")) {
                File file = new File(s);
                ImageIO.write((RenderedImage)this.image, "png", file);
            }
        }
        catch (IOException e) {
            System.out.println("IOException");
        }
    }

    public Canvas(int pwidth, int pheight) {
        this.width = pwidth;
        this.height = pheight;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String getClassName() {
        return "Canvas";
    }
}

