/*
 * Decompiled with CFR 0.152.
 */
package com.zingchart;

import com.zingchart.Context2d;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;

public class TextStyle {
    public String fontFamily = "SansSerif";
    public String fontStyle = "plain";
    public String fontVariant = "none";
    public String fontWeight = "regular";
    public String fontSize = "12pt";
    public String textDecoration = "none";
    public String verticalAlign = "middle";
    public String textTransform = "none";
    public String textAlign = "left";
    private Context2d context;
    private Font font;

    public TextStyle(Context2d pcontext) {
        this.context = pcontext;
    }

    public Font getFont() {
        String unit = this.fontSize.substring(this.fontSize.length() - 2, this.fontSize.length());
        float size = Float.parseFloat(this.fontSize.replace(unit, ""));
        int style = 0;
        if ("bold".equals(this.fontWeight)) {
            style |= 1;
        }
        if ("italic".equals(this.fontVariant)) {
            style |= 2;
        }
        double metric = 10.0;
        metric = "px".equals(unit) ? 0.26 * (double)size : ("in".equals(unit) ? 25.4 * (double)size : ("cm".equals(unit) ? 10.0 * (double)size : ("pt".equals(unit) ? 25.4 * (double)size / 72.0 : ("pc".equals(unit) ? 25.4 * (double)size / 6.0 : ("mm".equals(unit) ? (double)size : 101.6 * (double)size / 72.0)))));
        int resolution = 96;
        if (!GraphicsEnvironment.isHeadless()) {
            resolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        this.font = new Font(this.fontFamily, style, (int)(metric * (double)resolution / 25.4));
        return this.font;
    }

    public FontMetrics getMetrics() {
        FontMetrics metrics = this.context.getCanvas().getGraphics().getFontMetrics(this.getFont());
        return metrics;
    }
}

