/*
 * Decompiled with CFR 0.152.
 */
package ice.net.pac;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class PacScripter {
    private Function function;
    private URL pacLocation;
    private Scriptable scope;

    PacScripter(URL pacLocation) throws IllegalArgumentException, IOException, JavaScriptException {
        this.loadScript("implementation", new InputStreamReader(this.getClass().getResourceAsStream("impl.js")));
        this.setPacLocation(pacLocation);
    }

    public static boolean dnsDomainIs(String host, String domain) {
        return host.endsWith(domain);
    }

    public static int dnsDomainLevels(String host) {
        if (host == null) {
            return 0;
        }
        int _count = 0;
        int _index = 0;
        int _length = host.length();
        while ((_index = host.indexOf(46, _index)) != -1) {
            ++_count;
            if (++_index != _length) continue;
            break;
        }
        return _count;
    }

    public static boolean isInNet(String host, String pattern, String mask) {
        if (host == null || pattern == null || mask == null) {
            return false;
        }
        int patternInt = PacScripter.ipStringToInt(pattern);
        int maskInt = PacScripter.ipStringToInt(mask);
        if (patternInt == 0 || maskInt == 0) {
            return false;
        }
        int hostInt = 0;
        try {
            hostInt = InetAddress.getByName(host).hashCode();
        }
        catch (UnknownHostException e) {
            return false;
        }
        return (maskInt & patternInt) == (maskInt & hostInt);
    }

    public static boolean localHostOrDomainIs(String host, String hostdom) {
        if (host.equalsIgnoreCase(hostdom)) {
            return true;
        }
        if (PacScripter.dnsDomainLevels(host) > 0) {
            return false;
        }
        return hostdom.startsWith(host);
    }

    public static boolean weekdayRange(String wd1, String wd2, String gmt) {
        GregorianCalendar _gregorianCalendar = null;
        _gregorianCalendar = "GMT".equals(gmt) ? new GregorianCalendar(Locale.UK) : new GregorianCalendar();
        int _today = _gregorianCalendar.get(7);
        int _weekday1 = PacScripter.convertWeekday(wd1);
        int _weekday2 = PacScripter.convertWeekday(wd2);
        if (_weekday1 == _today) {
            return true;
        }
        if (_weekday2 == -1 || _weekday2 == _weekday1) {
            return false;
        }
        if (_weekday1 < _weekday2) {
            return _today >= _weekday1 && _today <= _weekday2;
        }
        return _today >= _weekday2 || _today >= _weekday1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String findProxyForUrl(String url, String host) throws JavaScriptException {
        Context _context = Context.enter();
        try {
            String string = ScriptRuntime.toString((Object)this.function.call(_context, this.scope, this.scope, new Object[]{url, host}));
            return string;
        }
        finally {
            Context.exit();
        }
    }

    String findProxyForUrl(URL url) throws JavaScriptException {
        return this.findProxyForUrl(url.toExternalForm(), url.getHost());
    }

    URL getPacLocation() {
        return this.pacLocation;
    }

    void setPacLocation(URL pacLocation) throws IllegalArgumentException, IOException, JavaScriptException {
        if (pacLocation == null) {
            throw new IllegalArgumentException("pacLocation is null");
        }
        if (this.pacLocation == null || !pacLocation.equals(this.pacLocation)) {
            this.pacLocation = pacLocation;
            this.updatePac();
        }
    }

    private static int convertWeekday(String weekday) {
        if ("SUN".equalsIgnoreCase(weekday)) {
            return 1;
        }
        if ("MON".equalsIgnoreCase(weekday)) {
            return 2;
        }
        if ("TUE".equalsIgnoreCase(weekday)) {
            return 3;
        }
        if ("WED".equalsIgnoreCase(weekday)) {
            return 4;
        }
        if ("THU".equalsIgnoreCase(weekday)) {
            return 5;
        }
        if ("FRI".equalsIgnoreCase(weekday)) {
            return 6;
        }
        if ("SAT".equalsIgnoreCase(weekday)) {
            return 7;
        }
        return -1;
    }

    private static int ipStringToInt(String host) {
        int IP = 0;
        int hitDots = 0;
        char[] data = host.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            if (c < '0' || c > '9') {
                return 0;
            }
            int b = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return 0;
                }
                b = b * 10 + c - 48;
                if (++i >= data.length) break;
                c = data[i];
            }
            if (b > 255) {
                return 0;
            }
            IP = (IP << 8) + b;
            ++hitDots;
        }
        if (hitDots != 4 || host.endsWith(".")) {
            return 0;
        }
        return IP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadScript(String name, Reader reader) throws IOException, JavaScriptException {
        Context _context = Context.enter();
        try {
            this.scope = _context.initStandardObjects(null);
            _context.evaluateReader(this.scope, reader, name, 1, null);
        }
        finally {
            Context.exit();
        }
    }

    private void updatePac() throws IOException, JavaScriptException {
        this.loadScript("PAC", new InputStreamReader(this.pacLocation.openStream()));
        this.function = (Function)ScriptableObject.getProperty((Scriptable)this.scope, (String)"FindProxyForURL");
        if (this.function.equals(Scriptable.NOT_FOUND)) {
            // empty if block
        }
    }
}

