/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.CacheManager;
import ice.net.CachedInputStream;
import ice.net.ChunkDecoderInputStream;
import ice.net.Connection;
import ice.net.ConnectionManager;
import ice.net.HttpParser;
import ice.net.HttpRequest;
import ice.net.HttpResponse;
import ice.net.HttpSession;
import ice.net.HttpURLConnection;
import ice.net.SimpleSocket;
import ice.util.Defs;
import ice.util.ICEException;
import ice.util.memory.MemoryManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.ProtocolException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

class PersistentConnection
extends InputStream
implements Connection {
    private int localTimeout = -1;
    private boolean forceTimeout = false;
    boolean reuseable = true;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean opened = true;
    private byte[] buf = null;
    private int pos = 0;
    private int numRead = 0;
    private int startTokenPos = 0;
    private int mode = 0;
    private boolean skipCRLFs = false;
    private HttpURLConnection curCon;
    private CachedInputStream curStream;
    private boolean chunked;
    private int startindex;
    private int lastreadindex;
    private Object allocSync = new Object();
    private byte[] brokenStatuslineBuffer = null;
    private byte[] brokenHeaderLineBuffer = null;
    private boolean continueMode = false;
    private int posStore = -1;
    int contentLength = -1;
    boolean active = true;
    int bodyBytesRead = 0;
    byte[] theBuffer = null;
    int lastData = 0;
    byte[] numberBuffer = new byte[10];
    int bodyStartsAt;
    long lastTimestamp = System.currentTimeMillis();
    private ChunkDecoderInputStream decoder = null;
    private Vector referenceVector = null;
    private int lastChunkLength = 0;
    private boolean zipMode = false;
    private GZIPInputStream gzip = null;
    Thread ownerThread = null;
    String lasturl = null;
    private CacheManager cacheManager;
    private ConnectionManager connectionManager;
    private SimpleSocket simpleSocket;
    private HttpSession httpSession;

    PersistentConnection(SimpleSocket simpleSocket, CacheManager cacheManager, ConnectionManager connectionManager, MemoryManager memoryManager) throws IOException {
        int _readBufferSize;
        this.simpleSocket = simpleSocket;
        if (this.simpleSocket != null) {
            this.inputStream = this.simpleSocket.getInputStream();
            this.outputStream = this.simpleSocket.getOutputStream();
        }
        this.cacheManager = cacheManager;
        this.connectionManager = connectionManager;
        if (!(memoryManager != null ? memoryManager : MemoryManager.getInstance()).canAllocate(_readBufferSize = this.connectionManager.getReadBufferSize())) {
            throw new ICEException(2, 1, 2);
        }
        this.buf = new byte[_readBufferSize];
        this.ownerThread = Thread.currentThread();
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
            Debug.trace((String)("new connection:\r\n" + this));
        }
    }

    PersistentConnection(CacheManager cacheManager, SimpleSocket simpleSocket, HttpSession httpSession) throws IOException {
        this(simpleSocket, cacheManager, httpSession.connectionMgr, httpSession.memoryManager);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public boolean awaitingSocketCreation() {
        return this.simpleSocket == null;
    }

    public void setSocket(SimpleSocket simpleSocket) throws IOException {
        this.simpleSocket = simpleSocket;
        this.inputStream = this.simpleSocket.getInputStream();
        this.outputStream = this.simpleSocket.getOutputStream();
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
            Debug.trace((String)("connection set:\r\n" + this));
        }
    }

    void reInit() {
        try {
            this.readRemains();
        }
        catch (IOException exception) {
            Debug.ex((Throwable)exception);
        }
        this.ownerThread = Thread.currentThread();
        this.lastTimestamp = System.currentTimeMillis();
        this.mode = 0;
        this.pos = 0;
        this.startTokenPos = 0;
        this.numRead = 0;
        this.localTimeout = -1;
        this.curStream = null;
        this.active = true;
        this.opened = true;
        this.chunked = false;
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
            Debug.trace((String)("connection re-inited:\r\n" + this));
        }
    }

    void clear() {
    }

    boolean hasTimedOut() {
        if (this.forceTimeout) {
            return true;
        }
        float secIdle = (System.currentTimeMillis() - this.lastTimestamp) / 1000L;
        if (this.localTimeout != -1) {
            return secIdle > (float)this.localTimeout;
        }
        return secIdle > (float)this.connectionManager.getPersistentConnectionTimeout();
    }

    boolean isActive() {
        return this.active;
    }

    public void close() throws IOException {
        if (this.ownerThread != Thread.currentThread()) {
            return;
        }
        this.lasturl = this.curCon.getURL().toString();
        this.local_close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void local_close() {
        Object object = this.allocSync;
        synchronized (object) {
            if (this.contentLength > 0 && this.bodyBytesRead < this.contentLength || this.chunked && this.lastChunkLength != 0 || !this.reuseable) {
                this.forceTimeout = true;
            }
            this.active = false;
        }
        if (this.forceTimeout) {
            try {
                this.simpleSocket.close();
            }
            catch (IOException iOException) {}
        } else {
            this.buf = new byte[this.connectionManager.getReadBufferSize()];
        }
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
            Debug.trace((String)("connection closed:\r\n" + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = this.allocSync;
        synchronized (object) {
            if (this.active) {
                this.readRemains();
                this.active = false;
            }
        }
        this.opened = false;
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
            Debug.trace((String)("connection disconnected:\r\n" + this));
        }
    }

    private void readRemains() throws ICEException, IOException {
        block4: {
            int _numberOfBytes;
            block3: {
                int bytesread = -1;
                if (!this.chunked) break block3;
                if (this.lastChunkLength == 0) break block4;
                byte[] tmpBuffer = new byte[2048];
                bytesread = this.decoder.read(tmpBuffer, 0, tmpBuffer.length);
                while (bytesread > 0) {
                    bytesread = this.decoder.read(tmpBuffer, 0, tmpBuffer.length);
                }
                break block4;
            }
            if (this.contentLength != -1 && this.bodyBytesRead == this.contentLength) {
                return;
            }
            byte[] _bytes = new byte[this.connectionManager.getReadBufferSize()];
            int _bytesRead = this.bodyBytesRead;
            while ((_numberOfBytes = this.inputStream.read(_bytes, 0, _bytes.length)) != -1 && (this.contentLength <= 0 || (_bytesRead += _numberOfBytes) != this.contentLength)) {
            }
        }
    }

    public int read() {
        return -1;
    }

    public int read(byte[] readBuffer, int offset, int readLength) throws IOException {
        if (this.zipMode) {
            int byteCount = this.gzip.read(readBuffer, offset, readLength);
            if (byteCount != -1) {
                this.bodyBytesRead += byteCount;
                if (this.contentLength > 0 && this.bodyBytesRead == this.contentLength) {
                    this.curStream.markDone();
                    this.local_close();
                }
                return byteCount;
            }
            this.curStream.markDone();
            this.local_close();
            return -1;
        }
        this.lastTimestamp = System.currentTimeMillis();
        if (this.contentLength != -1 && this.bodyBytesRead == this.contentLength) {
            return -1;
        }
        if (!this.chunked) {
            int byteCount = this.inputStream.read(readBuffer, offset, readLength);
            if (byteCount != -1) {
                this.bodyBytesRead += byteCount;
                if (this.contentLength > 0 && this.bodyBytesRead == this.contentLength) {
                    this.curStream.markDone();
                    this.local_close();
                }
                return byteCount;
            }
            return -1;
        }
        int bytesread = this.decoder.read(readBuffer, offset, readLength);
        if (bytesread > 0) {
            return bytesread;
        }
        this.lastChunkLength = 0;
        this.curStream.markDone();
        this.local_close();
        return -1;
    }

    public InputStream getInputStream(HttpURLConnection con) throws IOException {
        CachedInputStream _tempInputStream;
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
            Debug.trace((String)("connection used:\r\n" + this));
        }
        this.lastTimestamp = System.currentTimeMillis();
        this.curCon = con;
        if (this.curStream != null) {
            return this.curStream;
        }
        con.prepareRequest();
        con.sendRequest();
        int brokenCounter = 0;
        while (this.mode != 2) {
            if (this.pos == this.buf.length) {
                System.arraycopy(this.buf, this.startTokenPos, this.buf, 0, this.pos - this.startTokenPos);
                this.pos = this.buf.length - this.startTokenPos;
                this.startTokenPos = 0;
                this.numRead = this.pos;
            }
            int n = 0;
            try {
                if (this.opened && (n = this.inputStream.read(this.buf, this.numRead, this.buf.length - this.numRead)) == -1 && con.getRetry()) {
                    ++brokenCounter;
                    this.simpleSocket = con.createSimpleSocket(this.simpleSocket.getInetAddress(), this.simpleSocket.getPort());
                    this.inputStream = this.simpleSocket.getInputStream();
                    this.outputStream = this.simpleSocket.getOutputStream();
                    con.prepareRequest();
                    con.sendRequest();
                    n = this.inputStream.read(this.buf, this.numRead, this.buf.length - this.numRead);
                }
            }
            catch (IOException exception) {
                n = -1;
            }
            if (n <= 0) {
                return null;
            }
            this.numRead += n;
            while (this.pos < this.numRead && this.mode != 2) {
                if (this.skipCRLFs) {
                    if (this.buf[this.pos] == 13) {
                        ++this.pos;
                    }
                    if (this.pos < this.numRead && this.buf[this.pos] == 10) {
                        ++this.pos;
                    }
                    if (this.pos >= this.numRead) continue;
                    this.skipCRLFs = false;
                    continue;
                }
                if (this.mode == 0) {
                    try {
                        this.parseStatusLine();
                    }
                    catch (ProtocolException e) {}
                    continue;
                }
                if (this.mode != 1) continue;
                try {
                    this.parseHeaderLine();
                }
                catch (ProtocolException e) {
                    if (this.brokenStatuslineBuffer == null) continue;
                    boolean mer = true;
                    while (mer) {
                        for (int i = 0; i < this.brokenStatuslineBuffer.length; ++i) {
                            if (this.brokenStatuslineBuffer[i] != 72) continue;
                            this.pos += i;
                            try {
                                this.parseStatusLine();
                                continue;
                            }
                            catch (ProtocolException pe) {
                                mer = false;
                            }
                        }
                        this.brokenStatuslineBuffer = new byte[512];
                        n = this.inputStream.read(this.brokenStatuslineBuffer, 0, 512);
                        if (n >= 0) continue;
                        mer = false;
                    }
                    HttpResponse _response = this.curCon.getResponse();
                    _response.putHeader("Cache-Control", "no-cache");
                    if (_response.containsHeader("Content-Type")) {
                        _response.removeHeaders("Content-Type");
                    }
                    _response.putHeader("Content-Type", "text/html");
                    this.curStream = HttpURLConnection.getGlobalConnectionManager().createInputStream(con, this.cacheManager, (Connection)this, this.buf, 0, this.numRead);
                    return this.curStream;
                }
            }
            if (brokenCounter <= 3) continue;
            HttpResponse _response = this.curCon.getResponse();
            _response.putHeader("Cache-Control", "no-cache");
            if (_response.containsHeader("Content-Type")) {
                _response.removeHeaders("Content-Type");
            }
            _response.putHeader("Content-Type", "text/html");
            this.curStream = HttpURLConnection.getGlobalConnectionManager().createInputStream(con, this.cacheManager, (Connection)this, this.buf, 0, this.numRead);
            return this.curStream;
        }
        this.contentLength = this.getContentLength();
        this.bodyBytesRead = this.numRead - this.bodyStartsAt;
        this.chunked = "chunked".equalsIgnoreCase(con.getHeaderField("Transfer-Encoding"));
        this.zipMode = "gzip".equalsIgnoreCase(con.getHeaderField("Content-Encoding"));
        this.determinePersistency(con.getResponse());
        if (!this.chunked) {
            if (this.zipMode) {
                if (this.contentLength != -1 && this.numRead - this.pos >= this.contentLength) {
                    this.embedData(this.readZIPFully(new GZIPInputStream(new ByteArrayInputStream(this.buf, this.pos, this.numRead - this.pos))));
                } else {
                    InputStream _inputStream = this.contentLength != -1 ? new ByteArrayInputStream(this.readNBytes(this.inputStream, this.contentLength - (this.numRead - this.pos))) : this.inputStream;
                    if (this.numRead > this.pos) {
                        this.embedData(this.readZIPFully(new GZIPInputStream(new SequenceInputStream(new ByteArrayInputStream(this.buf, this.pos, this.numRead - this.pos), _inputStream))));
                    } else {
                        byte[] _header = new byte[2];
                        _inputStream.read(_header, 0, _header.length);
                        this.embedData(this.readZIPFully(new GZIPInputStream(new SequenceInputStream(new ByteArrayInputStream(_header), _inputStream))));
                    }
                }
                this.zipMode = false;
            }
            _tempInputStream = this.curStream = HttpURLConnection.getGlobalConnectionManager().createInputStream(con, this.cacheManager, (Connection)this, this.buf, this.pos, this.numRead - this.pos);
            if (this.contentLength > 0 && this.bodyBytesRead == this.contentLength) {
                this.curStream.markDone();
                this.local_close();
            }
        } else {
            this.startindex = this.pos;
            this.lastreadindex = this.numRead;
            if (this.referenceVector == null) {
                this.referenceVector = new Vector(1);
            } else {
                this.referenceVector.removeAllElements();
            }
            this.referenceVector.addElement(this.buf);
            this.decoder = new ChunkDecoderInputStream(this.referenceVector, this.startindex, this.lastreadindex - this.startindex, this.inputStream);
            byte[] _buffer = new byte[1000];
            this.lastChunkLength = this.decoder.read(_buffer, 0, _buffer.length);
            if (this.zipMode) {
                byte[] _newBuffer;
                int _numberOfBytes;
                int _totalNumberOfBytes;
                int _readBufferSize = this.connectionManager.getReadBufferSize();
                if (this.lastChunkLength != -1) {
                    byte[] _newBuffer2 = new byte[this.lastChunkLength > _readBufferSize ? this.lastChunkLength : _readBufferSize];
                    System.arraycopy(_buffer, 0, _newBuffer2, 0, this.lastChunkLength);
                    _buffer = _newBuffer2;
                } else {
                    _buffer = new byte[_readBufferSize];
                }
                int n = _totalNumberOfBytes = this.lastChunkLength != -1 ? this.lastChunkLength : 0;
                while ((_numberOfBytes = this.decoder.read(_buffer, _totalNumberOfBytes, _buffer.length - _totalNumberOfBytes)) != -1) {
                    if (_numberOfBytes <= 0 || (_totalNumberOfBytes += _numberOfBytes) != _buffer.length) continue;
                    _newBuffer = new byte[_buffer.length * 2];
                    System.arraycopy(_buffer, 0, _newBuffer, 0, _buffer.length);
                    _buffer = _newBuffer;
                }
                if (_totalNumberOfBytes < _buffer.length) {
                    _newBuffer = new byte[_totalNumberOfBytes];
                    System.arraycopy(_buffer, 0, _newBuffer, 0, _totalNumberOfBytes);
                    _buffer = _newBuffer;
                }
                this.embedData(this.readZIPFully(new GZIPInputStream(new ByteArrayInputStream(_buffer))));
                this.zipMode = false;
                this.chunked = false;
                CachedInputStream _inputStream = this.curStream = HttpURLConnection.getGlobalConnectionManager().createInputStream(con, this.cacheManager, (Connection)this, this.buf, this.pos, this.numRead - this.pos);
                if (this.contentLength > 0 && this.bodyBytesRead == this.contentLength) {
                    this.curStream.markDone();
                    this.local_close();
                }
                return _inputStream;
            }
            _tempInputStream = this.curStream = HttpURLConnection.getGlobalConnectionManager().createInputStream(con, this.cacheManager, (Connection)this, _buffer, 0, this.lastChunkLength != -1 ? this.lastChunkLength : 0);
        }
        return _tempInputStream;
    }

    private int getContentLength() {
        int i = -1;
        String hval = this.curCon.getHeaderField("Content-Length");
        try {
            i = Integer.parseInt(hval);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    private void determinePersistency(HttpResponse httpResponse) {
        if (this.forceTimeout) {
            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : force timeout received"));
            }
            return;
        }
        HttpRequest _httpRequest = this.curCon.getRequest();
        boolean _foundConnectionKeepAliveInRequest = false;
        String[] _connectionValuesInRequest = _httpRequest.getFieldValues("Connection");
        for (int i = 0; i < _connectionValuesInRequest.length; ++i) {
            if (!_foundConnectionKeepAliveInRequest && _connectionValuesInRequest[i].equalsIgnoreCase("keep-alive")) {
                _foundConnectionKeepAliveInRequest = true;
                continue;
            }
            if (!_connectionValuesInRequest[i].equalsIgnoreCase("close")) continue;
            this.forceTimeout = true;
            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : \"Connection: close\" in request"));
            }
            return;
        }
        boolean _foundConnectionKeepAliveInResponse = false;
        String[] _connectionValuesInResponse = httpResponse.getFieldValues("Connection");
        for (int i = 0; i < _connectionValuesInResponse.length; ++i) {
            if (!_foundConnectionKeepAliveInResponse && _connectionValuesInResponse[i].equalsIgnoreCase("keep-alive")) {
                _foundConnectionKeepAliveInResponse = true;
                continue;
            }
            if (!_connectionValuesInResponse[i].equalsIgnoreCase("close")) continue;
            this.forceTimeout = true;
            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : \"Connection: close\" in response"));
            }
            return;
        }
        boolean _foundProxyConnectionKeepAliveInRequest = false;
        boolean _foundProxyConnectionKeepAliveInResponse = false;
        boolean _usingProxy = this.curCon.usingProxy();
        if (!_usingProxy) {
            if (_httpRequest.getHttpVersion().equalsIgnoreCase("HTTP/1.0")) {
                if (!_foundConnectionKeepAliveInRequest) {
                    this.forceTimeout = true;
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                        Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : " + "no \"Connection: keep-alive\" in request"));
                    }
                    return;
                }
                if (!_foundConnectionKeepAliveInResponse) {
                    this.forceTimeout = true;
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                        Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : " + "no \"Connection: keep-alive\" in response"));
                    }
                    return;
                }
            } else if (httpResponse.getHttpVersion().equalsIgnoreCase("HTTP/1.0") && !_foundConnectionKeepAliveInResponse) {
                this.forceTimeout = true;
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                    Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : " + "no \"Connection: keep-alive\" in response"));
                }
                return;
            }
        } else {
            String[] _proxyConnectionValuesInRequest = _httpRequest.getFieldValues("Proxy-Connection");
            for (int i = 0; i < _proxyConnectionValuesInRequest.length; ++i) {
                if (!_foundProxyConnectionKeepAliveInRequest && _proxyConnectionValuesInRequest[i].equalsIgnoreCase("keep-alive")) {
                    _foundProxyConnectionKeepAliveInRequest = true;
                    continue;
                }
                if (!_proxyConnectionValuesInRequest[i].equalsIgnoreCase("close")) continue;
                this.forceTimeout = true;
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                    Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : " + "\"Proxy-Connection: close\" in request"));
                }
                return;
            }
            String[] _proxyConnectionValuesInResponse = httpResponse.getFieldValues("Proxy-Connection");
            for (int i = 0; i < _proxyConnectionValuesInResponse.length; ++i) {
                if (!_foundProxyConnectionKeepAliveInResponse && _proxyConnectionValuesInResponse[i].equalsIgnoreCase("keep-alive")) {
                    _foundProxyConnectionKeepAliveInResponse = true;
                    continue;
                }
                if (!_proxyConnectionValuesInResponse[i].equalsIgnoreCase("close")) continue;
                this.forceTimeout = true;
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                    Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : " + "\"Proxy-Connection: close\" in response"));
                }
                return;
            }
            if (_httpRequest.getHttpVersion().equalsIgnoreCase("HTTP/1.0")) {
                if (!_foundConnectionKeepAliveInRequest && !_foundProxyConnectionKeepAliveInRequest) {
                    this.forceTimeout = true;
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                        Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : " + "no \"Connection: keep-alive\" or " + "\"Proxy-Connection: keep-alive\" in request"));
                    }
                    return;
                }
                if (!_foundConnectionKeepAliveInResponse && !_foundProxyConnectionKeepAliveInResponse) {
                    this.forceTimeout = true;
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                        Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : " + "no \"Connection: keep-alive\" or " + "\"Proxy-Connection: keep-alive\" in response"));
                    }
                    return;
                }
            } else if (httpResponse.getHttpVersion().equalsIgnoreCase("HTTP/1.0") && !_foundConnectionKeepAliveInResponse && !_foundProxyConnectionKeepAliveInResponse) {
                this.forceTimeout = true;
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                    Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : " + "no \"Connection: keep-alive\" or " + "\"Proxy-Connection: keep-alive\" in response"));
                }
                return;
            }
        }
        if (this.contentLength == -1 && !this.chunked) {
            this.forceTimeout = true;
            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : false\r\n" + "    Reason : " + "no Content-Length and no chunked transfer encoding"));
            }
            return;
        }
        if (_foundConnectionKeepAliveInResponse || _usingProxy && _foundProxyConnectionKeepAliveInResponse) {
            String[] _keepAliveValuesInResponse = httpResponse.getFieldValues("Keep-Alive");
            for (int i = 0; i < _keepAliveValuesInResponse.length; ++i) {
                int _beginIndex = _keepAliveValuesInResponse[0].indexOf("timeout");
                if (_beginIndex == -1 || !Character.isDigit(_keepAliveValuesInResponse[0].charAt(_beginIndex += "timeout".length() + 1))) continue;
                int _endIndex = _beginIndex;
                int _length = _keepAliveValuesInResponse[0].length();
                while (_endIndex + 1 < _length && Character.isDigit(_keepAliveValuesInResponse[0].charAt(_endIndex + 1))) {
                    ++_endIndex;
                }
                try {
                    this.localTimeout = Integer.parseInt(_keepAliveValuesInResponse[0].substring(_beginIndex, _endIndex + 1));
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                        Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : true\r\n" + "    Reason : " + "timeout=" + this.localTimeout));
                    }
                    return;
                }
                catch (NumberFormatException exception) {
                    Debug.ex((Throwable)exception);
                }
            }
        }
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
            Debug.trace((String)("Persistency determination for:\r\n" + this + "\r\n" + "    Result : true"));
        }
    }

    private void parseStatusLine() throws ProtocolException {
        while (this.pos < this.numRead && this.buf[this.pos] != 10 && this.buf[this.pos] != 13) {
            ++this.pos;
        }
        if (this.pos < this.numRead) {
            try {
                HttpResponse _httpResponse = HttpParser.parseStatusLine(new String(this.buf, this.startTokenPos, this.pos - this.startTokenPos));
                this.curCon.setResponse(_httpResponse);
                this.continueMode = _httpResponse.getStatusCode() == 100;
            }
            catch (ProtocolException exception) {
                this.brokenStatuslineBuffer = new byte[this.pos];
                System.arraycopy(this.buf, 0, this.brokenStatuslineBuffer, 0, this.pos);
                this.startTokenPos = this.pos;
                this.skipCRLFs = true;
                this.mode = 1;
                throw exception;
            }
            this.startTokenPos = this.pos;
            this.skipCRLFs = true;
            this.mode = 1;
        }
    }

    private void parseHeaderLine() throws ProtocolException {
        boolean lineEnded = false;
        if (this.continueMode) {
            this.posStore = this.pos;
        }
        while (this.pos < this.numRead) {
            byte c = this.buf[this.pos];
            if (lineEnded) {
                if (c == 32 || c == 9) {
                    lineEnded = false;
                } else {
                    if (c == 13) {
                        this.pos += 2;
                        this.mode = 2;
                        if (this.continueMode) {
                            this.mode = 0;
                            this.continueMode = false;
                        }
                        this.bodyStartsAt = this.pos;
                        break;
                    }
                    if (c == 10) {
                        ++this.pos;
                        this.mode = 2;
                        if (this.continueMode) {
                            this.mode = 0;
                            this.continueMode = false;
                        }
                        this.bodyStartsAt = this.pos;
                        break;
                    }
                    --this.pos;
                    break;
                }
            }
            if (c == 10) {
                lineEnded = true;
            }
            ++this.pos;
            if (this.pos != this.numRead) continue;
            if (this.pos == this.buf.length) {
                System.arraycopy(this.buf, this.startTokenPos, this.buf, 0, this.pos - this.startTokenPos);
                this.pos = this.buf.length - this.startTokenPos;
                this.startTokenPos = 0;
                this.numRead = this.pos;
            }
            int byteCount = -1;
            try {
                byteCount = this.inputStream.read(this.buf, this.numRead, this.buf.length - this.numRead);
            }
            catch (IOException exception) {
                // empty catch block
            }
            if (byteCount <= 0) continue;
            this.numRead += byteCount;
        }
        if (this.continueMode && this.pos == this.posStore + 1) {
            ++this.pos;
            this.mode = 0;
            this.continueMode = false;
        }
        if (this.pos <= this.numRead) {
            boolean parsedOk = this.curCon.parseHeaderLine(new String(this.buf, this.startTokenPos, this.pos - this.startTokenPos));
            if (!parsedOk) {
                this.brokenHeaderLineBuffer = new byte[this.pos - this.startTokenPos];
                System.arraycopy(this.buf, this.startTokenPos, this.brokenHeaderLineBuffer, 0, this.pos - this.startTokenPos);
                this.startTokenPos = this.pos;
                this.skipCRLFs = this.mode != 2;
                throw new ProtocolException("Header line parse failed.");
            }
            this.startTokenPos = this.pos;
            this.skipCRLFs = this.mode != 2;
        }
    }

    private byte[] readZIPFully(GZIPInputStream gzipInputStream) {
        byte[] _newBuffer;
        byte[] _buffer = new byte[this.connectionManager.getReadBufferSize()];
        int _totalNumberOfBytes = 0;
        int _zeroCount = 0;
        try {
            int _numberOfBytes;
            while ((_numberOfBytes = gzipInputStream.read(_buffer, _totalNumberOfBytes, _buffer.length - _totalNumberOfBytes)) != -1 && _zeroCount != 2) {
                if (_numberOfBytes == 0) {
                    ++_zeroCount;
                    continue;
                }
                if ((_totalNumberOfBytes += _numberOfBytes) != _buffer.length) continue;
                _newBuffer = new byte[_buffer.length * 2];
                System.arraycopy(_buffer, 0, _newBuffer, 0, _buffer.length);
                _buffer = _newBuffer;
            }
        }
        catch (IOException exception) {
            // empty catch block
        }
        if (_totalNumberOfBytes < _buffer.length) {
            _newBuffer = new byte[_totalNumberOfBytes];
            System.arraycopy(_buffer, 0, _newBuffer, 0, _totalNumberOfBytes);
            _buffer = _newBuffer;
        }
        return _buffer;
    }

    private void embedData(byte[] data) {
        this.buf = data;
        this.contentLength = data.length;
        this.bodyBytesRead = data.length;
        this.pos = 0;
        this.numRead = data.length;
    }

    private byte[] readNBytes(InputStream inStream, int bytesToRead) {
        byte[] readBuffer = new byte[bytesToRead];
        int bytesRead = 0;
        int totalRead = 0;
        int zeroCount = 0;
        while (bytesRead >= 0 && totalRead < bytesToRead && zeroCount < 2) {
            if (readBuffer.length - bytesRead == 0) {
                byte[] tmp = new byte[readBuffer.length * 2];
                System.arraycopy(readBuffer, 0, tmp, 0, readBuffer.length);
                readBuffer = tmp;
            }
            try {
                int bytesLeft = bytesToRead - totalRead;
                bytesRead = inStream.read(readBuffer, totalRead, bytesLeft);
            }
            catch (Throwable t) {
                Debug.trace((String)("ice.net.PersistentConnection: " + t));
            }
            if (bytesRead > 0) {
                totalRead += bytesRead;
                continue;
            }
            if (bytesRead != 0) continue;
            ++zeroCount;
        }
        byte[] tmp = new byte[totalRead];
        System.arraycopy(readBuffer, 0, tmp, 0, totalRead);
        return tmp;
    }

    public String toString() {
        return super.toString() + " [\r\n" + "    IP-address      : " + (this.simpleSocket != null ? this.simpleSocket.getInetAddress() : null) + "\r\n" + "    port            : " + (this.simpleSocket != null ? this.simpleSocket.getPort() : -1) + "\r\n" + "    - opened        : " + this.opened + "\r\n" + "    - active        : " + this.active + "\r\n" + "    - force timeout : " + this.forceTimeout + "\r\n" + "]";
    }
}

