/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.Authentication;
import ice.net.AuthenticationManager;
import ice.net.CacheCallback;
import ice.net.CacheManager;
import ice.net.CachedObject;
import ice.net.ClientSocket;
import ice.net.Connection;
import ice.net.ConnectionManager;
import ice.net.ConnectionRoute;
import ice.net.Cookie;
import ice.net.CookieManager;
import ice.net.Direct;
import ice.net.ForbiddenException;
import ice.net.HttpMessage;
import ice.net.HttpParser;
import ice.net.HttpRequest;
import ice.net.HttpResponse;
import ice.net.HttpSession;
import ice.net.HttpURLConnectionCallback;
import ice.net.HttpURLConnectionSettings;
import ice.net.Indirect;
import ice.net.PersistentConnection;
import ice.net.SimpleSocket;
import ice.net.URLNotFoundException;
import ice.net.pac.ConnectionRouteNotFoundException;
import ice.net.pac.PacManager;
import ice.net.proxy.Proxy;
import ice.net.proxy.ProxyManager;
import ice.net.proxy.ProxyResolver;
import ice.util.Defs;
import ice.util.Emulation;
import ice.util.Math;
import ice.util.alg.HashArray;
import ice.util.memory.MemoryManager;
import ice.util.net.CookieSet;
import ice.util.net.HeaderMap;
import ice.util.security.BoxedCode;
import ice.util.security.ProxyException;
import ice.util.security.SecurityKit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class HttpURLConnection
extends java.net.HttpURLConnection
implements CacheCallback,
CookieSet {
    private static final String IMMEDIATE_REFRESH_THRESHOLD_KEY = "ice.net.immediateRefreshThreshold";
    private static final int IMMEDIATE_REFRESH_THRESHOLD_DEFAULT = 0;
    private static int immediateRefreshThreshold = Defs.sysPropertyInt((String)"ice.net.immediateRefreshThreshold", (int)0);
    protected String host;
    protected int port;
    protected boolean wasPosted = false;
    private ByteArrayOutputStream cachedOutput;
    private HttpURLConnectionCallback httpUrlConnectionCallback;
    private boolean returnedError;
    private Connection conn;
    private Vector fallbackURLs = null;
    private boolean multipleURLS = false;
    private boolean pendingProxyAuth = false;
    private CachedObject cachedObject;
    private IOException pendingException = null;
    private int localRetry = 0;
    protected static HttpURLConnectionSettings FALLBACK_HTTP_URL_CONNECTION_SETTINGS = new HttpURLConnectionSettings();
    public static final String VERSION = "v1_6_4";
    public static final String PRODUCT_NAME = "ICEhttp/v1_6_4";
    static final DateFormat RFC_1123_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("en", "US"));
    private static final int RETRY_UNDEFINED = 0;
    private static final int RETRY_TRUE = 1;
    private static final int RETRY_FALSE = 2;
    protected AuthenticationManager authenticationManager;
    protected CacheManager cacheManager;
    protected ConnectionManager connectionManager;
    protected CookieManager cookieManager;
    protected MemoryManager memoryManager;
    protected ProxyResolver proxyResolver;
    boolean requestCancelled = false;
    boolean responseCancelled = false;
    private Vector acceptLanguageList;
    private ConnectionRoute connectionRoute;
    private HttpRequest httpRequest;
    private HeaderMap requestHeaderMap;
    private HttpResponse httpResponse;
    private String httpVersion;
    private boolean redirectsEnabled;
    private boolean retryBrokenConnections;
    private HttpSession httpSession;

    public HttpURLConnection(URL url) {
        this(url, FALLBACK_HTTP_URL_CONNECTION_SETTINGS);
    }

    public HttpURLConnection(URL url, HttpURLConnectionSettings httpUrlConnectionSettings) {
        super(url);
        this.httpVersion = httpUrlConnectionSettings.getHttpVersion();
        this.requestHeaderMap = (HeaderMap)httpUrlConnectionSettings.getRequestHeaders().clone();
        this.requestHeaderMap.putHeader("User-Agent", Emulation.getEmulatedUserAgent());
        this.acceptLanguageList = httpUrlConnectionSettings.getAcceptLanguageList();
        this.setInstanceAuthenticationManager(httpUrlConnectionSettings.getAuthenticationManager());
        this.setInstanceCacheManager(httpUrlConnectionSettings.getCacheManager());
        this.setInstanceConnectionManager(httpUrlConnectionSettings.getConnectionManager());
        this.setInstanceCookieManager(httpUrlConnectionSettings.getCookieManager());
        this.setInstanceMemoryManager(httpUrlConnectionSettings.getMemoryManager());
        this.setInstanceProxyResolver(httpUrlConnectionSettings.getProxyResolver());
        if (this.proxyResolver != null) {
            try {
                this.connectionRoute = this.proxyResolver.findProxyForUrl(this.url);
            }
            catch (Exception exception) {
                Debug.ex((Throwable)exception);
            }
        }
        if (this.connectionRoute instanceof Direct) {
            this.host = this.connectionRoute.getRequestedUrl().getHost();
            this.port = this.connectionRoute.getRequestedUrl().getPort() < 0 ? this.getDefaultPort() : this.connectionRoute.getRequestedUrl().getPort();
        } else if (this.connectionRoute instanceof Indirect) {
            this.host = ((Indirect)this.connectionRoute).getHost();
            this.port = ((Indirect)this.connectionRoute).getPort();
        } else {
            this.host = this.url.getHost();
            this.port = this.url.getPort() >= 0 ? this.url.getPort() : this.getDefaultPort();
        }
        this.redirectsEnabled = httpUrlConnectionSettings.areRedirectsEnabled();
        this.retryBrokenConnections = httpUrlConnectionSettings.shouldRetryBrokenConnections();
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.request", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
            Debug.trace((String)("Request for URL " + this.url));
        }
        this.fixAddress(this.url);
    }

    public HttpURLConnection(URL url, HttpSession httpSession) {
        super(url);
        this.httpVersion = httpSession.HTTPVersion == httpSession.VERSION_1_0 ? "HTTP/1.0" : "HTTP/1.1";
        this.requestHeaderMap = new HeaderMap();
        this.requestHeaderMap.putHeader("User-Agent", Emulation.getEmulatedUserAgent());
        HashArray.Entry[] _entries = httpSession.defaultRequestProperties.getEntries();
        for (int i = 0; i < _entries.length; ++i) {
            this.requestHeaderMap.putHeader((String)_entries[i].key(), (String)_entries[i].value);
        }
        HttpURLConnection.updateAcceptLanguage(this.requestHeaderMap, httpSession.acceptLanguageList);
        this.acceptLanguageList = httpSession.acceptLanguageList;
        this.httpSession = httpSession;
        this.setInstanceAuthenticationManager(this.httpSession.authManager);
        this.setInstanceCacheManager(this.httpSession.cacheMgr);
        this.setInstanceConnectionManager(this.httpSession.connectionMgr);
        this.setInstanceCookieManager(this.httpSession.cookieMgr);
        this.setInstanceMemoryManager(this.httpSession.memoryManager);
        this.setInstanceProxyResolver(this.httpSession.proxyResolver);
        if (this.proxyResolver != null) {
            try {
                this.connectionRoute = this.proxyResolver.findProxyForUrl(this.url);
            }
            catch (Exception exception) {
                Debug.trace((String)exception.toString());
                Debug.ex((Throwable)exception);
            }
        }
        if (this.connectionRoute instanceof Direct) {
            this.host = this.connectionRoute.getRequestedUrl().getHost();
            this.port = this.connectionRoute.getRequestedUrl().getPort() < 0 ? this.getDefaultPort() : this.connectionRoute.getRequestedUrl().getPort();
        } else if (this.connectionRoute instanceof Indirect) {
            this.host = ((Indirect)this.connectionRoute).getHost();
            this.port = ((Indirect)this.connectionRoute).getPort();
        } else {
            this.host = this.url.getHost();
            this.port = this.url.getPort() >= 0 ? this.url.getPort() : this.getDefaultPort();
        }
        this.localRetry = this.httpSession.RETRY_UNDEFINED;
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.request", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
            Debug.trace((String)("Request for URL " + this.url));
        }
        this.fixAddress(this.url);
    }

    public void addRequestProperty(String fieldName, Date fieldValue) {
        this.addRequestProperty(fieldName, this.httpSession == null ? RFC_1123_DATE_FORMAT.format(fieldValue) : this.httpSession.RFC1123Date.format(fieldValue));
    }

    public void addRequestProperty(String fieldName, String fieldValue) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is null");
        }
        this.requestHeaderMap.putHeader(fieldName, fieldValue);
    }

    public boolean areRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    public Vector getAcceptLanguageList() {
        return this.acceptLanguageList;
    }

    public static AuthenticationManager getAuthenticationManager() {
        return HttpURLConnection.getGlobalAuthenticationManager();
    }

    public static CacheManager getCacheManager() {
        return HttpURLConnection.getGlobalCacheManager();
    }

    public static ConnectionManager getConnectionManager() {
        return HttpURLConnection.getGlobalConnectionManager();
    }

    public String getContentType() {
        String[] _fieldValues;
        if (this.httpResponse == null) {
            try {
                this.getInputStream();
            }
            catch (IOException exception) {
                this.pendingException = exception;
                return null;
            }
        }
        return (_fieldValues = this.httpResponse.getFieldValues("Content-Type")).length > 0 ? _fieldValues[0] : null;
    }

    public static CookieManager getCookieManager() {
        return HttpURLConnection.getGlobalCookieManager();
    }

    public static String getDefaultRequestProperty(String fieldName) {
        String[] _fieldValues = FALLBACK_HTTP_URL_CONNECTION_SETTINGS.getRequestHeaders().getFieldValues(fieldName);
        return _fieldValues.length > 0 ? _fieldValues[0] : null;
    }

    public static boolean getFollowRedirects() {
        return FALLBACK_HTTP_URL_CONNECTION_SETTINGS.areRedirectsEnabled();
    }

    public static AuthenticationManager getGlobalAuthenticationManager() {
        return FALLBACK_HTTP_URL_CONNECTION_SETTINGS.getAuthenticationManager();
    }

    public static CacheManager getGlobalCacheManager() {
        return FALLBACK_HTTP_URL_CONNECTION_SETTINGS.getCacheManager();
    }

    public static ConnectionManager getGlobalConnectionManager() {
        return FALLBACK_HTTP_URL_CONNECTION_SETTINGS.getConnectionManager();
    }

    public static CookieManager getGlobalCookieManager() {
        return FALLBACK_HTTP_URL_CONNECTION_SETTINGS.getCookieManager();
    }

    public static MemoryManager getGlobalMemoryManager() {
        return FALLBACK_HTTP_URL_CONNECTION_SETTINGS.getMemoryManager();
    }

    public static ProxyManager getGlobalProxyManager() {
        ProxyResolver _proxyResolver = HttpURLConnection.getGlobalProxyResolver();
        if (_proxyResolver instanceof ProxyManager) {
            return (ProxyManager)_proxyResolver;
        }
        return null;
    }

    public static ProxyResolver getGlobalProxyResolver() {
        return FALLBACK_HTTP_URL_CONNECTION_SETTINGS.getProxyResolver();
    }

    public int getHeaderCount() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException exception) {
                Debug.ex((Throwable)exception);
            }
        }
        if (this.httpResponse != null) {
            return this.httpResponse.getHeaderCount() + 1;
        }
        return 0;
    }

    public String getHeaderField(int index) {
        if (this.httpResponse == null) {
            try {
                this.getInputStream();
            }
            catch (IOException exception) {
                Debug.ex((Throwable)exception);
            }
        }
        String _headerField = null;
        if (this.httpResponse != null) {
            _headerField = index == 0 ? this.httpResponse.getStatusLine() : this.httpResponse.getFieldValue(index - 1);
        }
        return _headerField;
    }

    public String getHeaderField(String fieldName) {
        if (this.httpResponse == null) {
            try {
                this.getInputStream();
            }
            catch (IOException exception) {
                Debug.ex((Throwable)exception);
            }
        }
        if (this.httpResponse != null) {
            String[] _fieldValues = this.httpResponse.getFieldValues(fieldName);
            return _fieldValues.length > 0 ? _fieldValues[0] : null;
        }
        return null;
    }

    public String getHeaderFieldKey(int index) {
        if (this.httpResponse == null) {
            try {
                this.getInputStream();
            }
            catch (IOException exception) {
                Debug.ex((Throwable)exception);
            }
        }
        String _headerFieldKey = null;
        if (this.httpResponse != null) {
            _headerFieldKey = index == 0 ? "statusline" : this.httpResponse.getFieldName(index - 1);
        }
        return _headerFieldKey;
    }

    public HttpURLConnectionCallback getHttpURLConnectionCallback() {
        return this.httpUrlConnectionCallback;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public AuthenticationManager getInstanceAuthenticationManager() {
        return this.authenticationManager;
    }

    public CacheManager getInstanceCacheManager() {
        return this.cacheManager;
    }

    public ConnectionManager getInstanceConnectionManager() {
        return this.connectionManager;
    }

    public CookieManager getInstanceCookieManager() {
        return this.cookieManager;
    }

    public MemoryManager getInstanceMemoryManager() {
        return this.memoryManager;
    }

    public ProxyManager getInstanceProxyManager() {
        if (this.proxyResolver instanceof ProxyManager) {
            return (ProxyManager)this.proxyResolver;
        }
        return null;
    }

    public ProxyResolver getInstanceProxyResolver() {
        return this.proxyResolver;
    }

    public static ProxyManager getProxyManager() {
        return HttpURLConnection.getGlobalProxyManager();
    }

    public HttpRequest getRequest() {
        if (this.httpRequest != null) {
            return (HttpRequest)this.httpRequest.clone();
        }
        return null;
    }

    public String getRequestProperty(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        String[] _fieldValues = this.requestHeaderMap.getFieldValues(fieldName);
        return _fieldValues.length > 0 ? _fieldValues[0] : null;
    }

    public HttpResponse getResponse() {
        return this.httpResponse;
    }

    public boolean parseHeaderLine(String header) {
        try {
            if (this.httpResponse == null) {
                this.httpResponse = new HttpResponse("HTTP/1.0", 200, "OK");
            }
            HttpParser.parseHeader(header, this.httpResponse);
            return true;
        }
        catch (ProtocolException exception) {
            Debug.trace((String)("Invalid header: " + header));
            return false;
        }
    }

    public static void removeCookieManager() {
        HttpURLConnection.setGlobalCookieManager(null);
    }

    public void removeRequestProperties(String fieldName) {
        this.requestHeaderMap.removeHeaders(fieldName);
    }

    public static void setAuthenticationManager(AuthenticationManager authenticationManager) {
        HttpURLConnection.setGlobalAuthenticationManager(authenticationManager);
    }

    public static void setCacheManager(CacheManager cacheManager) {
        HttpURLConnection.setGlobalCacheManager(cacheManager);
    }

    public static void setConnectionManager(ConnectionManager connectionManager) throws IllegalArgumentException {
        HttpURLConnection.setGlobalConnectionManager(connectionManager);
    }

    public static void setCookieManager(CookieManager cookieManager) {
        HttpURLConnection.setGlobalCookieManager(cookieManager);
    }

    public static void setDefaultRequestProperty(String key, String value) {
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.getRequestHeaders().putHeader(key, value);
    }

    public static void setFollowRedirects(boolean followRedirects) {
        SecurityManager _securityManager = System.getSecurityManager();
        if (_securityManager != null) {
            _securityManager.checkSetFactory();
        }
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setRedirectsEnabled(followRedirects);
    }

    public static void setGlobalAuthenticationManager(AuthenticationManager authenticationManager) {
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setAuthenticationManager(authenticationManager);
    }

    public static void setGlobalCacheManager(CacheManager cacheManager) {
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setCacheManager(cacheManager);
    }

    public static void setGlobalConnectionManager(ConnectionManager connectionManager) throws IllegalArgumentException {
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setConnectionManager(connectionManager);
    }

    public static void setGlobalCookieManager(CookieManager cookieManager) {
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setCookieManager(cookieManager);
    }

    public static void setGlobalMemoryManager(MemoryManager memoryManager) {
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setMemoryManager(memoryManager);
    }

    public static void setGlobalProxyManager(ProxyManager proxyManager) {
        HttpURLConnection.setGlobalProxyResolver(proxyManager);
    }

    public static void setGlobalProxyResolver(ProxyResolver proxyResolver) {
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setProxyResolver(proxyResolver);
    }

    public void setHttpURLConnectionCallback(HttpURLConnectionCallback httpUrlConnectionCallback) {
        this.httpUrlConnectionCallback = httpUrlConnectionCallback;
    }

    public void setIfModifiedSince(long ifmodifiedsince) throws IllegalAccessError {
        if (this.connected) {
            throw new IllegalAccessError("already connected");
        }
        this.ifModifiedSince = ifmodifiedsince;
        this.requestHeaderMap.putHeader("If-Modified-Since", this.httpSession == null ? RFC_1123_DATE_FORMAT.format(new Date(this.ifModifiedSince)) : this.httpSession.RFC1123Date.format(new Date(this.ifModifiedSince)));
    }

    public void setInstanceAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setInstanceCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setInstanceConnectionManager(ConnectionManager connectionManager) throws IllegalArgumentException {
        if (connectionManager == null) {
            throw new IllegalArgumentException("connectionManager is null");
        }
        this.connectionManager = connectionManager;
    }

    public void setInstanceCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.redirectsEnabled = followRedirects;
    }

    public void setInstanceMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public void setInstanceProxyManager(ProxyManager proxyManager) {
        this.setInstanceProxyResolver(proxyManager);
    }

    public void setInstanceProxyResolver(ProxyResolver proxyResolver) {
        this.proxyResolver = proxyResolver;
    }

    public static void setProxyManager(ProxyManager proxyManager) {
        HttpURLConnection.setGlobalProxyManager(proxyManager);
    }

    public void setRequestProperty(String fieldName, Date fieldValue) throws IllegalAccessError {
        this.setRequestProperty(fieldName, this.httpSession == null ? RFC_1123_DATE_FORMAT.format(fieldValue) : this.httpSession.RFC1123Date.format(fieldValue));
    }

    public void setRequestProperty(String fieldName, String fieldValue) throws IllegalAccessError {
        if (this.connected) {
            throw new IllegalAccessError("already connected");
        }
        this.requestHeaderMap.putHeader(fieldName, fieldValue, true);
    }

    public boolean shouldRetryBrokenConnections() {
        return this.retryBrokenConnections;
    }

    public static void unload() {
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setAuthenticationManager(null);
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setCacheManager(null);
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setConnectionManager(null);
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setCookieManager(null);
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setMemoryManager(null);
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS.setProxyResolver(null);
    }

    void parseStatusLine(String statusLine) throws ProtocolException {
        this.httpResponse = HttpParser.parseStatusLine(statusLine);
    }

    void setResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        this.responseCode = this.httpResponse.getStatusCode();
        if (this.responseCode >= 400) {
            this.returnedError = true;
        }
        this.responseMessage = this.httpResponse.getReasonPhrase();
    }

    static void updateAcceptLanguage(HeaderMap requestHeaders, Vector acceptLanguageList) {
        int _size;
        if (requestHeaders.containsFieldName("Accept-Language")) {
            requestHeaders.removeHeaders("Accept-Language");
        }
        if (acceptLanguageList != null && (_size = acceptLanguageList.size()) > 0) {
            StringBuffer _acceptLanguage = new StringBuffer();
            if (_size == 1) {
                Locale _locale = (Locale)acceptLanguageList.elementAt(0);
                _acceptLanguage.append(_locale.getLanguage());
                String _country = _locale.getCountry();
                if (_country.length() != 0) {
                    _acceptLanguage.append("-" + _country);
                }
            } else {
                double _quality = 1.0;
                double _interval = _quality / (double)_size;
                for (int i = 0; i < _size; ++i) {
                    double _roundedQuality;
                    if (i > 0) {
                        _acceptLanguage.append(",");
                    }
                    Locale _locale = (Locale)acceptLanguageList.elementAt(i);
                    _acceptLanguage.append(_locale.getLanguage());
                    String _country = _locale.getCountry();
                    if (_country.length() != 0) {
                        _acceptLanguage.append("-" + _country);
                    }
                    if ((_roundedQuality = Math.round((double)_quality, (int)1)) != 1.0) {
                        _acceptLanguage.append(";q=" + _roundedQuality);
                    }
                    _quality -= _interval;
                }
            }
            requestHeaders.putHeader("Accept-Language", _acceptLanguage.toString());
        }
    }

    public void setRetry(boolean doRetry) {
        if (doRetry) {
            int n;
            if (this.httpSession == null) {
                n = 1;
            } else {
                this.httpSession.getClass();
                n = 1;
            }
            this.localRetry = n;
        } else {
            this.localRetry = this.httpSession == null ? 2 : this.httpSession.RETRY_FALSE;
        }
    }

    public boolean getRetry() {
        boolean bl;
        if (this.httpSession == null) {
            bl = this.localRetry == 0 ? this.retryBrokenConnections : this.localRetry == 1;
        } else if (this.localRetry == this.httpSession.RETRY_UNDEFINED) {
            bl = this.httpSession.retryBrokenConnections;
        } else {
            this.httpSession.getClass();
            bl = this.localRetry == 1;
        }
        return bl;
    }

    public boolean usingProxy() {
        return this.connectionRoute instanceof Proxy;
    }

    public void setProxy(Proxy proxy) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.connectionRoute = proxy;
        if (this.connectionRoute == null) {
            this.host = this.url.getHost();
            this.port = this.url.getPort() < 0 ? this.getDefaultPort() : this.url.getPort();
        } else {
            this.host = ((Proxy)this.connectionRoute).getHost();
            this.port = ((Proxy)this.connectionRoute).getPort();
        }
    }

    public Proxy getProxy() {
        if (this.usingProxy()) {
            return (Proxy)this.connectionRoute;
        }
        return null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void fixAddress(URL u) {
        String theAddress = u.toString();
        if (theAddress.indexOf("/./") != -1) {
            int index = theAddress.indexOf("/./");
            String firstPart = theAddress.substring(0, index);
            String lastPart = theAddress.substring(index + 2);
            try {
                URL ur;
                this.url = ur = new URL(firstPart + lastPart);
                theAddress = ur.toString();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (theAddress.indexOf("..") != -1) {
            try {
                String tmp = u.getFile();
                String thePath = HttpURLConnection.simplifyPath(u.getFile());
                if (thePath != tmp) {
                    URL ur;
                    this.url = ur = new URL(u.getProtocol(), u.getHost(), u.getPort(), thePath);
                    theAddress = ur.toString();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        int pos = theAddress.lastIndexOf("http://");
        int cgipos = theAddress.indexOf("?");
        if (pos > 0 && cgipos == -1) {
            URL tmp;
            this.multipleURLS = true;
            if (this.fallbackURLs == null) {
                this.fallbackURLs = new Vector();
            }
            this.fallbackURLs.removeAllElements();
            int result = 0;
            int place = 0;
            while (result != -1) {
                result = theAddress.indexOf("http://", place + 1);
                if (result == -1) continue;
                try {
                    tmp = null;
                    if (place != result) {
                        tmp = new URL(theAddress.substring(place, result));
                        this.fallbackURLs.addElement(tmp);
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                place = result;
            }
            try {
                tmp = null;
                tmp = new URL(theAddress.substring(place, theAddress.length()));
                this.fallbackURLs.addElement(tmp);
                this.fallbackURLs.addElement(new URL(theAddress));
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.url = (URL)this.fallbackURLs.elementAt(this.fallbackURLs.size() - 1);
            this.fallbackURLs.removeElementAt(this.fallbackURLs.size() - 1);
        }
    }

    private static Object runAsTrustedForProxy(BoxedCode boxed) throws IOException {
        try {
            return SecurityKit.doPrivileged((BoxedCode)boxed);
        }
        catch (ProxyException ex) {
            throw (IOException)ex.getTarget();
        }
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        SecurityManager _securityManager = System.getSecurityManager();
        if (_securityManager != null) {
            _securityManager.checkConnect(this.url.getHost(), this.url.getPort());
        }
        this.connected = true;
        InetAddress _inetAddress = null;
        if (this.multipleURLS) {
            boolean _done = false;
            while (!_done) {
                try {
                    _inetAddress = this.getInstanceConnectionManager().getByName(this.host, this.httpUrlConnectionCallback == null ? true : this.httpUrlConnectionCallback.useIp());
                    _done = true;
                }
                catch (UnknownHostException exception) {
                    Debug.ex((Throwable)exception);
                    if (this.fallbackURLs != null && this.fallbackURLs.size() > 0) {
                        this.url = (URL)this.fallbackURLs.elementAt(0);
                        this.host = this.url.getHost();
                        this.fallbackURLs.removeElementAt(0);
                        continue;
                    }
                    throw exception;
                }
            }
        } else {
            _inetAddress = !this.usingProxy() ? this.getInstanceConnectionManager().getByName(this.host, this.httpUrlConnectionCallback == null ? true : this.httpUrlConnectionCallback.useIp()) : (InetAddress)HttpURLConnection.runAsTrustedForProxy(new BoxedCode(){

                public Object run() {
                    try {
                        return HttpURLConnection.this.getInstanceConnectionManager().getByName(HttpURLConnection.this.host, HttpURLConnection.this.httpUrlConnectionCallback == null ? true : HttpURLConnection.this.httpUrlConnectionCallback.useIp());
                    }
                    catch (IOException exception) {
                        throw new ProxyException((Exception)exception);
                    }
                }
            });
        }
        this.conn = this.getInstanceConnectionManager().getConnection(this, this.url, _inetAddress, this.port);
    }

    protected Socket createSocket(final InetAddress inetAddress, final int port) throws IOException {
        if (!this.usingProxy()) {
            return this.getInstanceConnectionManager().createSocket(inetAddress, port);
        }
        return (Socket)HttpURLConnection.runAsTrustedForProxy(new BoxedCode(){

            public Object run() {
                try {
                    return HttpURLConnection.this.getInstanceConnectionManager().createSocket(inetAddress, port);
                }
                catch (IOException exception) {
                    throw new ProxyException((Exception)exception);
                }
            }
        });
    }

    protected SimpleSocket createSimpleSocket(InetAddress inetAddress, int port) throws IOException {
        long _begin = System.currentTimeMillis();
        SimpleSocket _simpleSocket = this.httpUrlConnectionCallback == null ? new ClientSocket(this.createSocket(inetAddress, port)) : this.httpUrlConnectionCallback.createSimpleSocket(inetAddress, port);
        long _end = System.currentTimeMillis();
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
            Debug.trace((String)("Socket creation time: " + (_end - _begin) + " ms."));
        }
        return _simpleSocket;
    }

    protected int getDefaultPort() {
        if (this.url.getProtocol().equals("https")) {
            return 443;
        }
        return 80;
    }

    public void disconnect() {
        try {
            if (this.conn != null) {
                this.conn.disconnect();
            }
            if (this.httpResponse != null) {
                this.httpResponse.dispose();
            }
            this.connected = false;
        }
        catch (IOException ex) {
            Debug.ex((Throwable)ex);
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.pendingException != null) {
            throw this.pendingException;
        }
        if (this.httpResponse != null) {
            return this.httpResponse.getEntityBody().getInputStream();
        }
        Authentication _authentication = null;
        int numberOfRedirects = 0;
        int numberOfBadRequests = 0;
        boolean validConnection = false;
        boolean _keepCurrentConnection = false;
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        do {
            int _urlIndex;
            String _refreshFieldValue;
            int _semicolonIndex;
            int code;
            if (this.cookieManager != null) {
                try {
                    String _cookieString = this.cookieManager.getCookieStr(this.url);
                    if (_cookieString != null && _cookieString.length() != 0) {
                        this.requestHeaderMap.putHeader("Cookie", _cookieString);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.authenticationManager != null) {
                if (_authentication == null) {
                    _authentication = this.authenticationManager.applyAuthentication(this.url);
                }
                if (_authentication != null) {
                    this.requestHeaderMap.putHeader("Authorization", _authentication.getAuthString(), true);
                }
            }
            Authentication _proxyAuthentication = null;
            if (this.usingProxy() && (_proxyAuthentication = ((Proxy)this.connectionRoute).getAuthentication()) != null) {
                this.requestHeaderMap.putHeader("Proxy-Authorization", _proxyAuthentication.getAuthString(), true);
                this.pendingProxyAuth = true;
            }
            if (!"POST".equalsIgnoreCase(this.method)) {
                this.cacheProcessing();
                if (this.httpResponse != null) {
                    this.connected = true;
                    return this.httpResponse.getEntityBody().getInputStream();
                }
            }
            if (!_keepCurrentConnection) {
                boolean connectDone = false;
                while (!connectDone) {
                    try {
                        if (this.proxyResolver != null) {
                            this.connectionRoute = this.proxyResolver.findProxyForUrl(this.url);
                        }
                        if (this.connectionRoute instanceof Direct) {
                            URL _requestedUrl = this.connectionRoute.getRequestedUrl();
                            this.host = _requestedUrl.getHost();
                            this.port = _requestedUrl.getPort() < 0 ? this.getDefaultPort() : _requestedUrl.getPort();
                        } else if (this.connectionRoute instanceof Indirect) {
                            this.host = ((Indirect)this.connectionRoute).getHost();
                            this.port = ((Indirect)this.connectionRoute).getPort();
                        } else {
                            this.host = this.url.getHost();
                            int n = this.port = this.url.getPort() < 0 ? this.getDefaultPort() : this.url.getPort();
                        }
                        if (Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                            Debug.trace((String)("Trying connection route: " + (this.connectionRoute != null ? this.connectionRoute.toString() : "Direct")));
                        }
                        this.connect();
                        if (Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                            Debug.trace((String)("Using connection route: " + (this.connectionRoute != null ? this.connectionRoute.toString() : "Direct")));
                        }
                        connectDone = true;
                        if (this.connectionRoute == null) continue;
                        this.connectionRoute.setStatus(2);
                    }
                    catch (ConnectionRouteNotFoundException exception) {
                        this.connected = false;
                        throw new UnknownHostException(this.url.getHost());
                    }
                    catch (ConnectException exception) {
                        this.connected = false;
                        if (this.connectionRoute != null) {
                            this.connectionRoute.setStatus(3);
                        }
                        if (this.proxyResolver instanceof PacManager) continue;
                        if (this.usingProxy()) {
                            throw new UnknownHostException(this.url.getHost());
                        }
                        throw exception;
                    }
                    catch (NoRouteToHostException exception) {
                        this.connected = false;
                        if (this.connectionRoute != null) {
                            this.connectionRoute.setStatus(3);
                        }
                        if (this.proxyResolver instanceof PacManager) continue;
                        if (this.usingProxy()) {
                            throw new UnknownHostException(this.url.getHost());
                        }
                        throw exception;
                    }
                    catch (UnknownHostException exception) {
                        this.connected = false;
                        if (this.connectionRoute != null) {
                            this.connectionRoute.setStatus(3);
                        }
                        if (this.proxyResolver instanceof PacManager) continue;
                        if (this.usingProxy()) {
                            throw new UnknownHostException(this.url.getHost());
                        }
                        throw exception;
                    }
                    catch (IOException exception) {
                        this.connected = false;
                        if (this.connectionRoute != null) {
                            this.connectionRoute.setStatus(3);
                        }
                        if (this.proxyResolver instanceof PacManager) continue;
                        if (this.usingProxy()) {
                            throw new UnknownHostException(this.url.getHost());
                        }
                        throw exception;
                    }
                    catch (Throwable throwable) {
                        Debug.ex((Throwable)throwable);
                    }
                }
            } else {
                _keepCurrentConnection = false;
            }
            if (this.conn != null) {
                InputStream _inputStream = this.conn.getInputStream(this);
                if (_inputStream == null) {
                    throw new IOException("unable to get a response from the server");
                }
                this.httpResponse.setEntityBody(new HttpMessage.EntityBody(_inputStream));
                this.httpResponse.setResponseTime(System.currentTimeMillis());
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.responseMessage", (boolean)false)) {
                    Debug.trace((String)("HTTP response message:\r\n" + this.httpResponse.getMessage(true)));
                } else if (Defs.sysPropertyBoolean((String)"ice.net.debug.responseHeaders", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                    Debug.trace((String)("HTTP response to " + this.httpRequest + ":\r\n" + this.httpResponse.getMessage()));
                }
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                    Debug.trace((String)("Request-Response latency: " + (this.httpResponse.getResponseTime() - this.httpRequest.getRequestTime()) + " ms."));
                }
                this.connectionManager.fireHttpURLConnectionEvent(this, 3, this.httpRequest, this.httpResponse);
                if (this.responseCancelled) {
                    throw new IOException("response cancelled");
                }
            }
            if (this.httpResponse.getStatusCode() == 304) {
                this.postCacheProcessing();
                if (this.httpResponse != null) {
                    return this.httpResponse.getEntityBody().getInputStream();
                }
            } else {
                if (this.httpResponse.getStatusCode() == 403) {
                    throw new ForbiddenException("Server refuses to serve document");
                }
                if (!(this.httpResponse.getStatusCode() != 404 || this.httpResponse.containsHeader("Content-Type") && this.httpResponse.getFieldValues("Content-Type")[0].startsWith("text/html"))) {
                    throw new URLNotFoundException("Document not found on server");
                }
            }
            int category = this.httpResponse.getStatusCode() / 100;
            if (this.multipleURLS && this.httpResponse.getStatusCode() != 200 && category != 3 && this.httpResponse.getStatusCode() != 400 && this.fallbackURLs.size() > 0) {
                this.url = (URL)this.fallbackURLs.elementAt(0);
                this.fallbackURLs.removeElementAt(0);
                this.httpResponse.clearHeaders();
                if (this.proxyResolver != null) {
                    try {
                        this.connectionRoute = this.proxyResolver.findProxyForUrl(this.url);
                    }
                    catch (Exception e) {
                        Debug.trace((String)e.toString());
                    }
                }
                if (this.connectionRoute instanceof Direct) {
                    this.host = this.connectionRoute.getRequestedUrl().getHost();
                    this.port = this.connectionRoute.getRequestedUrl().getPort() < 0 ? this.getDefaultPort() : this.connectionRoute.getRequestedUrl().getPort();
                } else if (this.connectionRoute instanceof Indirect) {
                    this.host = ((Indirect)this.connectionRoute).getHost();
                    this.port = ((Indirect)this.connectionRoute).getPort();
                } else {
                    this.host = this.url.getHost();
                    this.port = this.url.getPort() < 0 ? this.getDefaultPort() : this.url.getPort();
                }
                this.disconnect();
            }
            if (_proxyAuthentication != null && this.httpResponse.getStatusCode() != 407) {
                if (!_proxyAuthentication.isConfirmed()) {
                    _proxyAuthentication.setConfirmed(true);
                }
                if (this.httpResponse.getStatusCode() != 401) {
                    if (this.conn instanceof PersistentConnection) {
                        ((PersistentConnection)this.conn).reuseable = false;
                    }
                    if (_proxyAuthentication.isVolatile()) {
                        ((Proxy)this.connectionRoute).setAuthentication(null);
                    }
                    this.pendingProxyAuth = false;
                }
            }
            if (_authentication != null && this.httpResponse.getStatusCode() != 401) {
                if (!_authentication.isConfirmed()) {
                    _authentication.setConfirmed(true);
                }
                if (this.conn instanceof PersistentConnection) {
                    ((PersistentConnection)this.conn).reuseable = false;
                }
            }
            if (this.cookieManager != null) {
                this.cookieManager.extractAllCookies(this.url, this);
            }
            if ((code = this.httpResponse.getStatusCode()) == 400 && numberOfBadRequests < 5 && this.getRetry()) {
                ++numberOfBadRequests;
                this.httpResponse.clearHeaders();
                this.disconnect();
            }
            if (this.connected && this.httpResponse.containsHeader("Refresh") && (_semicolonIndex = (_refreshFieldValue = this.httpResponse.getFieldValues("Refresh")[0]).indexOf(";")) != -1 && (_urlIndex = _refreshFieldValue.toLowerCase().indexOf("url=", _semicolonIndex)) != -1) {
                boolean _immediateRefresh;
                try {
                    _immediateRefresh = Integer.parseInt(_refreshFieldValue.substring(0, _semicolonIndex)) <= immediateRefreshThreshold;
                }
                catch (NumberFormatException exception) {
                    _immediateRefresh = true;
                }
                if (_immediateRefresh) {
                    code = 301;
                    this.httpResponse.putHeader("Location", _refreshFieldValue.substring(_urlIndex + 4));
                }
            }
            if (code >= 300 && code <= 305 && code != 304 && (this.httpSession == null ? this.redirectsEnabled : this.httpSession.followRedirects)) {
                String loc;
                String[] _fieldValues = this.httpResponse.getFieldValues("Location");
                String string = loc = _fieldValues.length > 0 ? _fieldValues[0] : null;
                if (loc != null && numberOfRedirects < 10) {
                    try {
                        try {
                            if (loc.indexOf(" ") != -1) {
                                loc = HttpURLConnection.encode(loc);
                            }
                            this.url = new URL(this.getURL(), loc);
                        }
                        catch (MalformedURLException e) {
                            try {
                                String origin = this.url.toString();
                                int index = origin.indexOf("?");
                                origin = origin.substring(0, index);
                                index = origin.lastIndexOf("/");
                                origin = origin.substring(0, index + 1);
                                String newURL = origin + loc;
                                this.url = new URL(newURL);
                            }
                            catch (Exception ex) {
                                throw e;
                            }
                        }
                        if (this.proxyResolver != null) {
                            try {
                                this.connectionRoute = this.proxyResolver.findProxyForUrl(this.url);
                            }
                            catch (Exception e) {
                                Debug.trace((String)e.toString());
                            }
                        }
                        if (this.connectionRoute instanceof Direct) {
                            this.host = this.connectionRoute.getRequestedUrl().getHost();
                            this.port = this.connectionRoute.getRequestedUrl().getPort() < 0 ? this.getDefaultPort() : this.connectionRoute.getRequestedUrl().getPort();
                        } else if (this.connectionRoute instanceof Indirect) {
                            this.host = ((Indirect)this.connectionRoute).getHost();
                            this.port = ((Indirect)this.connectionRoute).getPort();
                        } else {
                            this.host = this.url.getHost();
                            this.port = this.url.getPort() < 0 ? this.getDefaultPort() : this.url.getPort();
                        }
                        this.disconnect();
                        this.httpResponse = null;
                        this.responseCode = -1;
                        this.responseMessage = null;
                        if (code == 301 || code == 302 || code == 303) {
                            this.cachedOutput = null;
                            this.wasPosted = false;
                            this.method = "GET";
                            _authentication = null;
                            this.requestHeaderMap.removeHeaders("Authorization");
                            this.requestHeaderMap.removeHeaders("Content-Length");
                            this.requestHeaderMap.removeHeaders("Content-Type");
                            this.requestHeaderMap.removeHeaders("Host");
                            this.requestHeaderMap.removeHeaders("Connection");
                            this.requestHeaderMap.removeHeaders("Cookie");
                        }
                        ++numberOfRedirects;
                    }
                    catch (MalformedURLException mue) {
                        validConnection = true;
                    }
                } else {
                    validConnection = true;
                }
            } else {
                validConnection = true;
            }
            if (code == 401 || code == 407) {
                if (this.authenticationManager != null) {
                    Authentication _tempAuthentication = null;
                    switch (code) {
                        case 401: {
                            Authentication _badAuthentication = _authentication;
                            _authentication = _tempAuthentication = this.authenticationManager.extractAuthentication(this.url, this);
                            if (_badAuthentication == null || _badAuthentication.inProgress() || _badAuthentication.isConfirmed()) break;
                            this.authenticationManager.removeBadAuthentication(_badAuthentication);
                            break;
                        }
                        case 407: {
                            Proxy _proxy = (Proxy)this.connectionRoute;
                            Authentication _badProxyAuthentication = _proxy.getAuthentication();
                            try {
                                _proxyAuthentication = _tempAuthentication = this.authenticationManager.extractAuthentication(new URL(_proxy.getProtocol(), _proxy.getHost(), _proxy.getPort(), "/"), this);
                            }
                            catch (MalformedURLException exception) {
                                Debug.ex((Throwable)exception);
                            }
                            if (_proxyAuthentication != null) {
                                _proxy.setAuthentication(_proxyAuthentication);
                            }
                            if (_badProxyAuthentication == null || _badProxyAuthentication.isConfirmed() || _badProxyAuthentication.inProgress()) break;
                            this.authenticationManager.removeBadAuthentication(_badProxyAuthentication);
                            _proxy.setAuthentication(null);
                            break;
                        }
                    }
                    if (_tempAuthentication != null && !_tempAuthentication.giveUp()) {
                        this.httpResponse = null;
                        if (this.conn instanceof PersistentConnection) {
                            PersistentConnection _persistentConnection = (PersistentConnection)this.conn;
                            if (!_persistentConnection.hasTimedOut()) {
                                _persistentConnection.reInit();
                            } else {
                                this.disconnect();
                            }
                        }
                        if (this.connected && _tempAuthentication.inProgress()) {
                            _keepCurrentConnection = true;
                        }
                        validConnection = false;
                    } else {
                        if (_tempAuthentication != null) {
                            this.authenticationManager.removeAuthentication(_tempAuthentication);
                            if (_tempAuthentication.isProxyAuth()) {
                                ((Proxy)this.connectionRoute).setAuthentication(null);
                            }
                        }
                        validConnection = true;
                    }
                }
            } else if (_authentication != null) {
                this.authenticationManager.acknowledgeAuthentication(_authentication);
            }
            if (code != 200) continue;
            validConnection = true;
        } while (!validConnection);
        return this.httpResponse != null ? this.httpResponse.getEntityBody().getInputStream() : null;
    }

    private void cacheProcessing() {
        CacheManager _cacheManager = this.getInstanceCacheManager();
        if (_cacheManager != null) {
            this.cachedObject = _cacheManager.getCachedObject(this.url, this);
            if (this.cachedObject != null) {
                HttpResponse _httpResponse = this.cachedObject.getResponse();
                if (!this.cachedObject.isFresh()) {
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.cache", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                        Debug.trace((String)("Revalidate cached response for: " + this.cachedObject.getURL()));
                    }
                    if (_httpResponse.containsHeader("ETag")) {
                        this.requestHeaderMap.putHeader("If-None-Match", _httpResponse.getFieldValues("ETag")[0]);
                    }
                    if (_httpResponse.containsHeader("Last-Modified")) {
                        if (this.httpVersion.equalsIgnoreCase("HTTP/1.1") && _httpResponse.getHttpVersion().equalsIgnoreCase("HTTP/1.1")) {
                            this.requestHeaderMap.putHeader("If-Modified-Since", _httpResponse.getFieldValues("Last-Modified")[0]);
                        } else {
                            this.requestHeaderMap.putHeader("If-Unmodified-Since", _httpResponse.getFieldValues("Last-Modified")[0]);
                        }
                    }
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.responseHeaders", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                        Debug.trace((String)("Revalidate " + this.url));
                    }
                } else {
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.cache", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                        Debug.trace((String)("Retrieved from the cache: " + this.cachedObject.getURL()));
                    }
                    this.httpResponse = this.cachedObject.getResponse();
                    if (this.httpResponse.containsHeader("Set-Cookie")) {
                        this.httpResponse.removeHeaders("Set-Cookie");
                    }
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.responseHeaders", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                        Debug.trace((String)("(Cache) HTTP response:\r\n" + this.httpResponse.getMessage()));
                    }
                }
            }
        }
    }

    private void postCacheProcessing() {
        if (this.cachedObject != null) {
            String _fieldName;
            this.cachedObject.setRequestTime(this.httpRequest.getRequestTime());
            HttpResponse _cachedResponse = this.cachedObject.getResponse();
            _cachedResponse.setResponseTime(this.httpResponse.getResponseTime());
            while ((_fieldName = this.httpResponse.getFieldName(0)) != null) {
                String[] _fieldValues = this.httpResponse.getFieldValues(_fieldName);
                this.httpResponse.removeHeaders(_fieldName);
                if (_cachedResponse.containsHeader(_fieldName)) {
                    _cachedResponse.removeHeaders(_fieldName);
                }
                for (int i = 0; i < _fieldValues.length; ++i) {
                    _cachedResponse.putHeader(_fieldName, _fieldValues[i]);
                }
            }
            if (_cachedResponse.containsHeader("Set-Cookie")) {
                _cachedResponse.removeHeaders("Set-Cookie");
            }
            if (Defs.sysPropertyBoolean((String)"ice.net.debug.responseHeaders", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                Debug.trace((String)("(Cache) HTTP response:\r\n" + _cachedResponse.getMessage()));
            }
            this.httpResponse = _cachedResponse;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
        }
        this.method = "POST";
        if (this.httpResponse != null) {
            throw new ProtocolException("Cannot write output after reading input.");
        }
        if (!this.connected) {
            this.connect();
        }
        if (this.cachedOutput == null) {
            this.cachedOutput = new ByteArrayOutputStream();
        }
        this.wasPosted = true;
        return this.cachedOutput;
    }

    public InputStream getErrorStream() {
        if (!this.connected || !this.returnedError) {
            return null;
        }
        return this.httpResponse.getEntityBody().getInputStream();
    }

    public int getResponseCode() throws IOException {
        if (this.httpResponse == null) {
            this.getInputStream();
        }
        return this.httpResponse.getStatusCode();
    }

    public String getResponseMessage() throws IOException {
        if (this.httpResponse == null) {
            this.getInputStream();
        }
        return this.httpResponse.getReasonPhrase();
    }

    void prepareRequest() {
        String _file = this.url.getFile();
        String _requestUri = this.usingProxy() && !this.url.getProtocol().equals("https") && !((Proxy)this.connectionRoute).isTunneling() ? this.url.toExternalForm() : _file;
        if (_file.equals("")) {
            try {
                _requestUri = _requestUri + "/";
                this.url = new URL(this.url, _requestUri);
            }
            catch (MalformedURLException exception) {}
        } else {
            int _index;
            if (_file.startsWith("?")) {
                _index = _requestUri.indexOf("?");
                _requestUri = _requestUri.substring(0, _index) + "/" + _requestUri.substring(_index);
                try {
                    this.url = new URL(this.url, _requestUri);
                }
                catch (MalformedURLException exception) {
                    // empty catch block
                }
            }
            if ((_index = _requestUri.indexOf("#")) != -1) {
                _requestUri = _requestUri.substring(0, _index);
            }
        }
        if (_requestUri.indexOf(" ") != -1) {
            _requestUri = HttpURLConnection.encode(_requestUri);
            try {
                this.url = new URL(this.url, _requestUri);
            }
            catch (MalformedURLException exception) {
                // empty catch block
            }
        }
        if (this.url.getProtocol().equals("https")) {
            this.httpVersion = "HTTP/1.0";
        }
        if (this.url.getPort() == 80 || this.url.getPort() < 0) {
            this.requestHeaderMap.putHeader("Host", this.url.getHost(), true);
        } else {
            this.requestHeaderMap.putHeader("Host", this.url.getHost() + ":" + this.url.getPort(), true);
        }
        if (!this.httpVersion.equals("HTTP/1.0") && !this.connectionManager.arePersistentConnectionsEnabled()) {
            this.requestHeaderMap.putHeader("Connection", "close", true);
        }
        if (this.connectionManager.arePersistentConnectionsEnabled()) {
            if (this.usingProxy()) {
                this.requestHeaderMap.putHeader("Proxy-Connection", "keep-alive", true);
            } else {
                this.requestHeaderMap.putHeader("Connection", "keep-alive", true);
            }
        }
        this.httpRequest = new HttpRequest(this.method, _requestUri, this.httpVersion);
        int _size = this.requestHeaderMap.getSize();
        for (int i = 0; i < _size; ++i) {
            this.httpRequest.putHeader(this.requestHeaderMap.getFieldName(i), this.requestHeaderMap.getFieldValue(i));
        }
        if (this.cachedOutput != null) {
            this.httpRequest.setEntityBody(new HttpMessage.EntityBody(this.cachedOutput.toByteArray()));
        }
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.requestMessage", (boolean)false)) {
            Debug.trace((String)("HTTP request:\r\n" + this.httpRequest.getMessage(true)));
        } else if (Defs.sysPropertyBoolean((String)"ice.net.debug.requestHeaders", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
            Debug.trace((String)("HTTP request:\r\n" + this.httpRequest.getMessage()));
        }
        this.connectionManager.fireHttpURLConnectionEvent(this, 1, this.httpRequest);
    }

    void sendRequest() throws IOException {
        if (!this.requestCancelled) {
            this.httpRequest.setRequestTime(System.currentTimeMillis());
            this.conn.getOutputStream().write(this.httpRequest.getBytes(), 0, this.httpRequest.getLength());
            this.connectionManager.fireHttpURLConnectionEvent(this, 2, this.httpRequest);
        }
    }

    public boolean wasPosted() {
        return this.wasPosted;
    }

    public void addCookie(String documentUrl, String s) {
        CookieManager cm;
        if (Debug.trace) {
            Debug.trace((String)("url=" + documentUrl + " str=" + s));
        }
        if ((cm = this.getInstanceCookieManager()) != null) {
            URL urlObj;
            block8: {
                urlObj = null;
                try {
                    urlObj = new URL(documentUrl);
                }
                catch (MalformedURLException ex) {
                    if (!Debug.ex) break block8;
                    Debug.ex((Throwable)ex);
                }
            }
            if (urlObj != null) {
                Cookie c = Cookie.parseFromString(urlObj, s);
                if (c != null) {
                    cm.addCookie(c);
                } else if (Debug.trace) {
                    Debug.trace((String)("Error: bad cookie str=" + s));
                }
            }
        }
    }

    public String getCookieStr(String documentUrl) {
        CookieManager cm = this.getInstanceCookieManager();
        if (cm != null) {
            URL urlObj;
            block4: {
                urlObj = null;
                try {
                    urlObj = new URL(documentUrl);
                }
                catch (MalformedURLException ex) {
                    if (!Debug.ex) break block4;
                    Debug.ex((Throwable)ex);
                }
            }
            if (urlObj != null) {
                return cm.getCookieStr(urlObj);
            }
        }
        return null;
    }

    private static String encode(String requestUri) {
        if (requestUri.indexOf(" ") != -1 || requestUri.indexOf("\t") != -1) {
            int _length = requestUri.length();
            StringBuffer _requestUri = new StringBuffer(_length);
            for (int i = 0; i < _length; ++i) {
                char _char = requestUri.charAt(i);
                if (_char == '\t') {
                    _requestUri.append("%09");
                    continue;
                }
                if (_char == ' ') {
                    _requestUri.append("%20");
                    continue;
                }
                _requestUri.append(_char);
            }
            return _requestUri.toString();
        }
        return requestUri;
    }

    private static String simplifyPath(String theAddress) throws IOException {
        StringTokenizer st = new StringTokenizer(theAddress, "/", true);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if ("..".equals(s)) {
                if (v.size() < 3) {
                    throw new IOException("Error simplifying /../ .");
                }
                v.removeElementAt(v.size() - 1);
                v.removeElementAt(v.size() - 1);
                v.removeElementAt(v.size() - 1);
                continue;
            }
            v.addElement(s);
        }
        StringBuffer sb = new StringBuffer();
        for (int c = 0; c < v.size(); ++c) {
            sb.append((String)v.elementAt(c));
        }
        return sb.toString();
    }

    static {
        if (Debug.trace) {
            Debug.traceAsIs((String)"ICEhttp v1_6_4");
        } else if (Defs.sysPropertyBoolean((String)"ice.browser.verbose", (boolean)true)) {
            System.out.println("ICEhttp v1_6_4\r\n(c) ICEsoft Technologies, Inc.");
        }
        RFC_1123_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

