/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.CacheManager;
import ice.net.HttpResponse;
import ice.net.HttpSession;
import ice.net.HttpURLConnection;
import ice.util.Defs;
import ice.util.ParseDate;
import java.io.Serializable;
import java.util.Date;

public class CachedObject
implements Serializable {
    private transient CacheManager cacheManager;
    private HttpResponse httpResponse;
    private long lastAccessed;
    private long requestTime;
    private String url;
    private transient HttpSession httpSession;

    public CachedObject(HttpResponse httpResponse, CacheManager cacheManager) {
        this.httpResponse = httpResponse;
        this.cacheManager = cacheManager;
    }

    public CachedObject(CacheManager cacheManager) {
        this(null, cacheManager);
    }

    public CachedObject(HttpResponse httpResponse, HttpSession httpSession) {
        this.httpResponse = httpResponse;
        this.httpSession = httpSession;
    }

    public CachedObject(HttpSession httpSession) {
        this(null, httpSession);
    }

    public static long calculateCurrentAge(long ageValue, long dateValue, long requestTime, long responseTime) {
        long _now = System.currentTimeMillis();
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.cache", (boolean)false)) {
            Debug.trace((String)("Calculating current_age:\r\nage_value     = " + ageValue + "\r\n" + "date_value    = " + dateValue + " (" + new Date(dateValue) + ")\r\n" + "request_time  = " + requestTime + " (" + new Date(requestTime) + ")\r\n" + "response_time = " + responseTime + " (" + new Date(responseTime) + ")\r\n" + "now           = " + _now + " (" + new Date(_now) + ")\r\n\r\n"));
        }
        long _currentAge = Math.max(Math.max(responseTime - Math.max(dateValue, 0L), 0L), Math.max(ageValue, 0L)) + (responseTime - requestTime) + (_now - responseTime);
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.cache", (boolean)false)) {
            Debug.trace((String)("Calculating current_age:\r\ncurrent_age   = " + _currentAge + "\r\n\r\n"));
        }
        return _currentAge;
    }

    public static long calculateFreshnessLifetime(long maxAgeValue, long expiresValue, long dateValue, long lastModifiedValue, long responseTime, long cacheExpirationBuffer) {
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.cache", (boolean)false)) {
            Debug.trace((String)("Calculating freshness_lifetime:\r\ndate_value              = " + dateValue + " (" + new Date(dateValue) + ")\r\n" + "response_time           = " + responseTime + " (" + new Date(responseTime) + ")\r\n" + "max_age_value           = " + maxAgeValue + "\r\n" + "expires_value           = " + expiresValue + " (" + new Date(expiresValue) + ")\r\n" + "last_modified_value     = " + lastModifiedValue + " " + "(" + new Date(lastModifiedValue) + ")\r\n" + "cache_expiration_buffer = " + cacheExpirationBuffer + "\r\n\r\n"));
        }
        long _freshnessLifetime = maxAgeValue != -1L ? maxAgeValue + cacheExpirationBuffer : (expiresValue != -1L ? expiresValue - dateValue + cacheExpirationBuffer : (lastModifiedValue != -1L ? (long)((double)(responseTime - lastModifiedValue) * 0.1) + cacheExpirationBuffer : -1L));
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.cache", (boolean)false)) {
            Debug.trace((String)("Calculating freshness_lifetime:\r\nfreshness_lifetime  = " + _freshnessLifetime + "\r\n\r\n"));
        }
        return _freshnessLifetime;
    }

    public long getAge() {
        long _age;
        String[] _ageValues = this.httpResponse.getFieldValues("Age");
        if (_ageValues.length != 0) {
            try {
                _age = Long.parseLong(_ageValues[0]) * 1000L;
            }
            catch (NumberFormatException exception) {
                Debug.ex((Throwable)exception);
                _age = -1L;
            }
        } else {
            _age = -1L;
        }
        return _age;
    }

    public byte[] getdata() {
        return this.httpResponse.getEntityBody().getBytes();
    }

    public long getDate() {
        return this.getDateAsLong("Date");
    }

    public long getExpires() {
        return this.getDateAsLong("Expires");
    }

    public String[] getHeaderKeys() {
        String[] _fieldNames = new String[this.httpResponse.getHeaderCount()];
        for (int i = 0; i < _fieldNames.length; ++i) {
            _fieldNames[i] = this.httpResponse.getFieldName(i);
        }
        return _fieldNames;
    }

    public String[] getHeaders() {
        String[] _fieldValues = new String[this.httpResponse.getHeaderCount()];
        for (int i = 0; i < _fieldValues.length; ++i) {
            _fieldValues[i] = this.httpResponse.getFieldValue(i);
        }
        return _fieldValues;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public long getLastModified() {
        return this.getDateAsLong("Last-Modified");
    }

    public long getMaxAge() {
        long _maxAge;
        block7: {
            String[] _cacheControlValues = this.httpResponse.getFieldValues("Cache-Control");
            if (_cacheControlValues.length != 0) {
                int _beginIndex = _cacheControlValues[0].toLowerCase().indexOf("max-age");
                if (_beginIndex != -1) {
                    int _endIndex = _cacheControlValues[0].indexOf(",", _beginIndex += "max-age".length() + 1);
                    try {
                        if (_endIndex != -1) {
                            _maxAge = Long.parseLong(_cacheControlValues[0].substring(_beginIndex, _endIndex)) * 1000L;
                            break block7;
                        }
                        _maxAge = Long.parseLong(_cacheControlValues[0].substring(_beginIndex)) * 1000L;
                    }
                    catch (NumberFormatException exception) {
                        Debug.ex((Throwable)exception);
                        _maxAge = -1L;
                    }
                } else {
                    _maxAge = -1L;
                }
            } else {
                _maxAge = -1L;
            }
        }
        return _maxAge;
    }

    public long getRecivedAt() {
        return this.httpResponse.getResponseTime();
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public HttpResponse getResponse() {
        return this.httpResponse;
    }

    public String getURL() {
        return this.url;
    }

    public boolean isFresh() {
        if (this.httpSession == null ? this.cacheManager.shouldAlwaysRevalidate() : this.httpSession.alwaysRevalidate) {
            return false;
        }
        return CachedObject.isFresh(this.getAge(), this.getDate(), this.requestTime, this.httpResponse.getResponseTime(), this.getMaxAge(), this.getExpires(), this.getLastModified(), this.cacheManager.getCacheExpirationBuffer() * 1000);
    }

    public static boolean isFresh(long ageValue, long dateValue, long requestTime, long responseTime, long maxAgeValue, long expiresValue, long lastModifiedValue, long cacheExpirationBuffer) {
        if (maxAgeValue == -1L && expiresValue == -1L && lastModifiedValue == -1L) {
            return false;
        }
        return CachedObject.calculateFreshnessLifetime(maxAgeValue, expiresValue, dateValue, lastModifiedValue, responseTime, cacheExpirationBuffer) > CachedObject.calculateCurrentAge(ageValue, dateValue, requestTime, responseTime);
    }

    void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setExpires(long expiresValue) {
        if (this.httpResponse.containsHeader("Expires")) {
            this.httpResponse.removeHeaders("Expires");
        }
        this.httpResponse.putHeader("Expires", HttpURLConnection.RFC_1123_DATE_FORMAT.format(new Date(expiresValue)));
    }

    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public void setResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public void setURL(String url) {
        int _index = url.indexOf(35);
        this.url = _index == -1 ? url : url.substring(0, _index);
    }

    public int size() {
        return this.httpResponse.getBytes().length;
    }

    private long getDateAsLong(String fieldName) {
        Date _date;
        String[] _dateValues = this.httpResponse.getFieldValues(fieldName);
        if (_dateValues.length != 0 && (_date = ParseDate.parseDate((String)_dateValues[0])) != null) {
            return _date.getTime();
        }
        return -1L;
    }
}

