/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.CacheManager;
import ice.net.CachedInputStream;
import ice.net.ChunkDecoderInputStream;
import ice.net.Connection;
import ice.net.ConnectionManager;
import ice.net.HttpParser;
import ice.net.HttpResponse;
import ice.net.HttpSession;
import ice.net.HttpURLConnection;
import ice.net.SimpleSocket;
import ice.util.ICEException;
import ice.util.memory.MemoryManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.ProtocolException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

class BasicConnection
implements Connection {
    private InputStream in;
    private OutputStream out;
    private boolean opened;
    private byte[] buf = null;
    private int pos = 0;
    private int numRead = 0;
    private int startTokenPos = 0;
    private int mode = 0;
    private boolean skipCRLFs = false;
    private ChunkDecoderInputStream decoder = null;
    private Vector referenceVector = null;
    private HttpURLConnection curCon;
    private CachedInputStream curStream;
    private boolean chunked;
    private int startindex;
    private int lastreadindex;
    private byte[] brokenStatuslineBuffer = null;
    private byte[] brokenHeaderLineBuffer = null;
    private boolean continueMode = false;
    private int contentLength = 0;
    private int contentBytesServed = 0;
    private int posStore = -1;
    private int lastChunkLength = 0;
    private boolean zipMode;
    private CacheManager cacheManager;
    private ConnectionManager connectionManager;
    private SimpleSocket simpleSocket;
    private HttpSession httpSession;

    BasicConnection(SimpleSocket simpleSocket, CacheManager cacheManager, ConnectionManager connectionManager, MemoryManager memoryManager) throws IOException {
        this.simpleSocket = simpleSocket;
        this.in = this.simpleSocket.getInputStream();
        this.out = this.simpleSocket.getOutputStream();
        this.cacheManager = cacheManager;
        this.connectionManager = connectionManager;
        int _readBufferSize = this.connectionManager.getReadBufferSize();
        if (!(memoryManager != null ? memoryManager : MemoryManager.getInstance()).canAllocate(_readBufferSize)) {
            throw new ICEException(2, 2, 2);
        }
        this.buf = new byte[_readBufferSize];
        this.opened = true;
    }

    BasicConnection(CacheManager cacheManager, SimpleSocket simpleSocket, HttpSession httpSession) throws IOException {
        this(simpleSocket, cacheManager, httpSession.connectionMgr, httpSession.memoryManager);
        this.httpSession = httpSession;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void close() throws IOException {
        this.opened = false;
        this.simpleSocket.close();
    }

    public void disconnect() throws IOException {
        this.simpleSocket.close();
        this.opened = false;
    }

    public int read(byte[] readBuffer, int offset, int readLength) throws IOException {
        if (!this.chunked) {
            int byteCount;
            try {
                if (this.httpSession != null) {
                    this.httpSession.getClass();
                }
                if (this.contentBytesServed > 0 && this.contentBytesServed == this.contentLength) {
                    this.disconnect();
                    return -1;
                }
                byteCount = this.in.read(readBuffer, offset, readLength);
                this.contentBytesServed += byteCount;
            }
            catch (Exception e) {
                this.disconnect();
                return -1;
            }
            return byteCount;
        }
        int bytesread = this.decoder.read(readBuffer, offset, readLength);
        return bytesread;
    }

    public InputStream getInputStream(HttpURLConnection con) throws IOException {
        this.curCon = con;
        if (this.curStream != null) {
            return this.curStream;
        }
        con.prepareRequest();
        con.sendRequest();
        while (this.mode != 2) {
            if (this.pos == this.buf.length) {
                System.arraycopy(this.buf, this.startTokenPos, this.buf, 0, this.pos - this.startTokenPos);
                this.pos = this.buf.length - this.startTokenPos;
                this.startTokenPos = 0;
                this.numRead = this.pos;
            }
            int n = 0;
            try {
                if (this.opened) {
                    n = this.in.read(this.buf, this.numRead, this.buf.length - this.numRead);
                }
            }
            catch (IOException ex) {
                n = -1;
            }
            if (n <= 0) {
                return null;
            }
            this.numRead += n;
            while (this.pos < this.numRead && this.mode != 2) {
                if (this.skipCRLFs) {
                    if (this.buf[this.pos] == 13) {
                        ++this.pos;
                    }
                    if (this.pos < this.numRead && this.buf[this.pos] == 10) {
                        ++this.pos;
                    }
                    if (this.pos >= this.numRead) continue;
                    this.skipCRLFs = false;
                    continue;
                }
                if (this.mode == 0) {
                    try {
                        this.parseStatusLine();
                    }
                    catch (ProtocolException e) {}
                    continue;
                }
                if (this.mode != 1) continue;
                try {
                    this.parseHeaderLine();
                }
                catch (ProtocolException e) {
                    if (this.brokenStatuslineBuffer == null) continue;
                    HttpResponse _response = this.curCon.getResponse();
                    _response.putHeader("Cache-Control", "no-cache");
                    if (_response.containsHeader("Content-Type")) {
                        _response.removeHeaders("Content-Type");
                    }
                    _response.putHeader("Content-Type", "text/html");
                    this.curStream = HttpURLConnection.getGlobalConnectionManager().createInputStream(con, this.cacheManager, (Connection)this, this.buf, 0, this.numRead);
                    return this.curStream;
                }
            }
        }
        String _contentLength = con.getHeaderField("Content-Length");
        if (_contentLength != null) {
            if (this.httpSession != null) {
                this.httpSession.getClass();
            }
            try {
                this.contentLength = Integer.parseInt(_contentLength);
            }
            catch (NumberFormatException exception) {
                Debug.ex((Throwable)exception);
            }
        }
        this.chunked = "chunked".equalsIgnoreCase(con.getHeaderField("Transfer-Encoding"));
        this.zipMode = "gzip".equalsIgnoreCase(con.getHeaderField("Content-Encoding"));
        if (!this.chunked) {
            if (this.zipMode) {
                if (this.contentLength != 0 && this.numRead - this.pos >= this.contentLength) {
                    this.embedData(this.readZIPFully(new GZIPInputStream(new ByteArrayInputStream(this.buf, this.pos, this.numRead - this.pos))));
                } else {
                    InputStream _inputStream = this.contentLength != 0 ? new ByteArrayInputStream(this.readNBytes(this.in, this.contentLength - (this.numRead - this.pos))) : this.in;
                    if (this.numRead > this.pos) {
                        this.embedData(this.readZIPFully(new GZIPInputStream(new SequenceInputStream(new ByteArrayInputStream(this.buf, this.pos, this.numRead - this.pos), _inputStream))));
                    } else {
                        byte[] _header = new byte[2];
                        _inputStream.read(_header, 0, _header.length);
                        this.embedData(this.readZIPFully(new GZIPInputStream(new SequenceInputStream(new ByteArrayInputStream(_header), _inputStream))));
                    }
                }
                this.zipMode = false;
            }
            this.contentBytesServed = this.numRead - this.pos;
            this.curStream = HttpURLConnection.getGlobalConnectionManager().createInputStream(con, this.cacheManager, (Connection)this, this.buf, this.pos, this.numRead - this.pos);
        } else {
            this.startindex = this.pos;
            this.lastreadindex = this.numRead;
            if (this.referenceVector == null) {
                this.referenceVector = new Vector(1);
            } else {
                this.referenceVector.removeAllElements();
            }
            this.referenceVector.addElement(this.buf);
            this.decoder = new ChunkDecoderInputStream(this.referenceVector, this.startindex, this.lastreadindex - this.startindex, this.in);
            byte[] _buffer = new byte[1000];
            this.lastChunkLength = this.decoder.read(_buffer, 0, _buffer.length);
            if (this.zipMode) {
                byte[] _newBuffer;
                int _numberOfBytes;
                int _totalNumberOfBytes;
                int _readBufferSize = this.connectionManager.getReadBufferSize();
                if (this.lastChunkLength != -1) {
                    byte[] _newBuffer2 = new byte[this.lastChunkLength > _readBufferSize ? this.lastChunkLength : _readBufferSize];
                    System.arraycopy(_buffer, 0, _newBuffer2, 0, this.lastChunkLength);
                    _buffer = _newBuffer2;
                } else {
                    _buffer = new byte[_readBufferSize];
                }
                int n = _totalNumberOfBytes = this.lastChunkLength != -1 ? this.lastChunkLength : 0;
                while ((_numberOfBytes = this.decoder.read(_buffer, _totalNumberOfBytes, _buffer.length - _totalNumberOfBytes)) != -1) {
                    if (_numberOfBytes <= 0 || (_totalNumberOfBytes += _numberOfBytes) != _buffer.length) continue;
                    _newBuffer = new byte[_buffer.length * 2];
                    System.arraycopy(_buffer, 0, _newBuffer, 0, _buffer.length);
                    _buffer = _newBuffer;
                }
                if (_totalNumberOfBytes < _buffer.length) {
                    _newBuffer = new byte[_totalNumberOfBytes];
                    System.arraycopy(_buffer, 0, _newBuffer, 0, _totalNumberOfBytes);
                    _buffer = _newBuffer;
                }
                this.embedData(this.readZIPFully(new GZIPInputStream(new ByteArrayInputStream(_buffer))));
                this.zipMode = false;
                this.chunked = false;
                this.curStream = HttpURLConnection.getGlobalConnectionManager().createInputStream(con, this.cacheManager, (Connection)this, this.buf, this.pos, this.numRead - this.pos);
                return this.curStream;
            }
            this.curStream = HttpURLConnection.getGlobalConnectionManager().createInputStream(con, this.cacheManager, (Connection)this, _buffer, 0, this.lastChunkLength != -1 ? this.lastChunkLength : 0);
        }
        return this.curStream;
    }

    public boolean awaitingSocketCreation() {
        return false;
    }

    public void setSocket(SimpleSocket simpleSocket) throws IOException {
    }

    private void parseStatusLine() throws ProtocolException {
        while (this.pos < this.numRead && this.buf[this.pos] != 10 && this.buf[this.pos] != 13) {
            ++this.pos;
        }
        if (this.pos < this.numRead) {
            try {
                HttpResponse _httpResponse = HttpParser.parseStatusLine(new String(this.buf, this.startTokenPos, this.pos - this.startTokenPos));
                this.curCon.setResponse(_httpResponse);
                this.continueMode = _httpResponse.getStatusCode() == 100;
            }
            catch (ProtocolException exception) {
                this.brokenStatuslineBuffer = new byte[this.pos];
                System.arraycopy(this.buf, 0, this.brokenStatuslineBuffer, 0, this.pos);
                this.startTokenPos = this.pos;
                this.skipCRLFs = true;
                this.mode = 1;
                throw exception;
            }
            this.startTokenPos = this.pos;
            this.skipCRLFs = true;
            this.mode = 1;
        }
    }

    private void parseHeaderLine() throws ProtocolException {
        boolean lineEnded = false;
        if (this.continueMode) {
            this.posStore = this.pos;
        }
        while (this.pos < this.numRead) {
            byte c = this.buf[this.pos];
            if (lineEnded) {
                if (c == 32 || c == 9) {
                    lineEnded = false;
                } else {
                    if (c == 13) {
                        this.pos += 2;
                        this.mode = 2;
                        if (!this.continueMode) break;
                        this.mode = 0;
                        this.continueMode = false;
                        break;
                    }
                    if (c == 10) {
                        ++this.pos;
                        this.mode = 2;
                        if (!this.continueMode) break;
                        this.mode = 0;
                        this.continueMode = false;
                        break;
                    }
                    --this.pos;
                    break;
                }
            }
            if (c == 10) {
                lineEnded = true;
            }
            ++this.pos;
            if (this.pos != this.numRead) continue;
            if (this.pos == this.buf.length) {
                System.arraycopy(this.buf, this.startTokenPos, this.buf, 0, this.pos - this.startTokenPos);
                this.pos = this.buf.length - this.startTokenPos;
                this.startTokenPos = 0;
                this.numRead = this.pos;
            }
            int byteCount = -1;
            try {
                byteCount = this.in.read(this.buf, this.numRead, this.buf.length - this.numRead);
            }
            catch (IOException exception) {
                // empty catch block
            }
            if (byteCount <= 0) continue;
            this.numRead += byteCount;
        }
        if (this.continueMode && this.pos == this.posStore + 1) {
            ++this.pos;
            this.mode = 0;
            this.continueMode = false;
        }
        if (this.pos <= this.numRead) {
            boolean parsedOk = this.curCon.parseHeaderLine(new String(this.buf, this.startTokenPos, this.pos - this.startTokenPos));
            if (!parsedOk) {
                this.brokenHeaderLineBuffer = new byte[this.pos - this.startTokenPos];
                System.arraycopy(this.buf, this.startTokenPos, this.brokenHeaderLineBuffer, 0, this.pos - this.startTokenPos);
                this.startTokenPos = this.pos;
                this.skipCRLFs = this.mode != 2;
                throw new ProtocolException("Header line parse failed.");
            }
            this.startTokenPos = this.pos;
            this.skipCRLFs = this.mode != 2;
        }
    }

    private byte[] readZIPFully(GZIPInputStream gzipInputStream) {
        byte[] _newBuffer;
        byte[] _buffer = new byte[this.connectionManager.getReadBufferSize()];
        int _totalNumberOfBytes = 0;
        int _zeroCount = 0;
        try {
            int _numberOfBytes;
            while ((_numberOfBytes = gzipInputStream.read(_buffer, _totalNumberOfBytes, _buffer.length - _totalNumberOfBytes)) != -1 && _zeroCount != 2) {
                if (_numberOfBytes == 0) {
                    ++_zeroCount;
                    continue;
                }
                if ((_totalNumberOfBytes += _numberOfBytes) != _buffer.length) continue;
                _newBuffer = new byte[_buffer.length * 2];
                System.arraycopy(_buffer, 0, _newBuffer, 0, _buffer.length);
                _buffer = _newBuffer;
            }
        }
        catch (IOException exception) {
            // empty catch block
        }
        if (_totalNumberOfBytes < _buffer.length) {
            _newBuffer = new byte[_totalNumberOfBytes];
            System.arraycopy(_buffer, 0, _newBuffer, 0, _totalNumberOfBytes);
            _buffer = _newBuffer;
        }
        return _buffer;
    }

    private void embedData(byte[] data) {
        this.buf = data;
        this.contentLength = data.length;
        this.pos = 0;
        this.numRead = data.length;
    }

    private byte[] readNBytes(InputStream inStream, int bytesToRead) {
        byte[] readBuffer = new byte[bytesToRead];
        int bytesRead = 0;
        int totalRead = 0;
        int zeroCount = 0;
        while (bytesRead >= 0 && totalRead < bytesToRead && zeroCount < 2) {
            if (readBuffer.length - bytesRead == 0) {
                byte[] tmp = new byte[readBuffer.length * 2];
                System.arraycopy(readBuffer, 0, tmp, 0, readBuffer.length);
                readBuffer = tmp;
            }
            try {
                int bytesLeft = bytesToRead - totalRead;
                bytesRead = inStream.read(readBuffer, totalRead, bytesLeft);
            }
            catch (Throwable t) {
                Debug.trace((String)("ice.net.PersistentConnection: " + t));
            }
            if (bytesRead > 0) {
                totalRead += bytesRead;
                continue;
            }
            if (bytesRead != 0) continue;
            ++zeroCount;
        }
        byte[] tmp = new byte[totalRead];
        System.arraycopy(readBuffer, 0, tmp, 0, totalRead);
        return tmp;
    }
}

