/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.MyDigest;
import ice.util.encoding.Base64;
import java.io.Serializable;
import java.net.URL;

public class Authentication
implements Serializable {
    public static final int BASIC = 0;
    public static final int DIGEST = 1;
    public static final int NTLM = 2;
    private String nonce;
    private String method;
    private String password;
    private String realm;
    private String userName;
    private boolean confirmed;
    private transient boolean digestEnabled = true;
    private boolean giveUp;
    private boolean isProxyAuthentication;
    private URL requestUri;
    private int type = 0;

    public Authentication(URL requestUri) {
        this.requestUri = requestUri;
    }

    public String getAuthString() {
        switch (this.type) {
            case 0: {
                return "Basic " + Base64.encode((String)(this.userName + ":" + this.password));
            }
            case 1: {
                if (!this.digestEnabled) {
                    return "Digest disabled";
                }
                String _A1 = new String(this.userName + ":" + this.realm + ":" + this.password);
                String _A2 = new String(this.method + ":" + this.requestUri.getFile());
                MyDigest _d1 = null;
                MyDigest _d2 = null;
                MyDigest _d3 = null;
                try {
                    Class<?> _digestClass = Class.forName("ice.net.MyMessageDigest");
                    _d1 = ((MyDigest)_digestClass.newInstance()).getInstance("MD5");
                    _d2 = ((MyDigest)_digestClass.newInstance()).getInstance("MD5");
                    _d3 = ((MyDigest)_digestClass.newInstance()).getInstance("MD5");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                _d1.update(_A1.getBytes());
                _d1.digest();
                _A1 = this.extractDigestAsHex(((Object)_d1).toString());
                _d2.update(_A2.getBytes());
                _d2.digest();
                _A2 = this.extractDigestAsHex(((Object)_d2).toString());
                _d3.update(new String(_A1 + ":" + this.nonce + ":" + _A2).getBytes());
                _d3.digest();
                return new String("Digest realm=\"" + this.realm + "\"," + "username=\"" + this.userName + "\"," + "uri=\"" + this.requestUri.getFile() + "\"," + "nonce=\"" + this.nonce + "\"," + "response=\"" + this.extractDigestAsHex(((Object)_d3).toString()) + "\"");
            }
        }
        return null;
    }

    public String getLocation() {
        if (this.requestUri == null) {
            return null;
        }
        return this.requestUri.toString();
    }

    public String getMethod() {
        return this.method;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getType() {
        switch (this.type) {
            case 0: {
                return "Basic";
            }
            case 1: {
                return "Digest";
            }
            case 2: {
                return "NTLM";
            }
        }
        return "Basic";
    }

    public URL getUrl() {
        return this.requestUri;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean giveUp() {
        return this.giveUp;
    }

    public boolean inProgress() {
        return false;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public boolean isProxyAuth() {
        return this.isProxyAuthentication;
    }

    public boolean isVolatile() {
        return false;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public void setGiveUp(boolean giveUp) {
        this.giveUp = giveUp;
    }

    public void setIsProxyAuth(boolean isProxyAuthentication) {
        this.isProxyAuthentication = isProxyAuthentication;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setType(int type) {
        this.type = type >= 0 && type <= 2 ? type : 0;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String toString() {
        return "Authentication " + this.realm + " " + this.requestUri + " " + this.userName;
    }

    void setDigestEnabled(boolean digestEnabled) {
        this.digestEnabled = digestEnabled;
    }

    private String extractDigestAsHex(String digest) {
        return digest.substring(digest.indexOf(60) + 1, digest.indexOf(62));
    }
}

