/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xslf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFAutoShape;
import org.apache.poi.xslf.usermodel.XSLFDiagram;
import org.apache.poi.xslf.usermodel.XSLFGroupShape;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

public class SmartArtConversionDemo {
    private final XMLSlideShow inputPptx;
    private final XMLSlideShow outputPptx;

    SmartArtConversionDemo(XMLSlideShow inputPptx, XMLSlideShow outputPptx) {
        this.inputPptx = inputPptx;
        this.outputPptx = outputPptx;
    }

    public static void main(String[] args) throws IOException {
        File inputFile;
        if (args.length != 2) {
            System.out.println("Expected arguments: <inputPath> <outputPath>");
            System.exit(1);
        }
        if (!(inputFile = new File(args[0])).exists()) {
            System.out.printf(LocaleUtil.getUserLocale(), "Unable to find input file at path: %s", args[0]);
            System.exit(1);
        }
        try (FileInputStream inputPptxStream = new FileInputStream(inputFile);
             FileOutputStream outputPptxStream = new FileOutputStream(args[1]);){
            XMLSlideShow inputPptx = new XMLSlideShow(inputPptxStream);
            XMLSlideShow outputPptx = new XMLSlideShow();
            SmartArtConversionDemo demo = new SmartArtConversionDemo(inputPptx, outputPptx);
            demo.convertSmartArt();
            outputPptx.write(outputPptxStream);
        }
    }

    private static void copyAndUpdateImageRelations(XSLFDiagram diagram, XSLFSlide outputSlide) throws IOException {
        XSLFDiagram.XSLFDiagramGroupShape inputGroupShape = diagram.getGroupShape();
        for (XSLFShape shape : inputGroupShape.getShapes()) {
            CTShape ctShape = (CTShape)shape.getXmlObject();
            if (ctShape.getSpPr().getBlipFill() == null) continue;
            CTBlipFillProperties blipFillProps = ctShape.getSpPr().getBlipFill();
            CTBlip blip = blipFillProps.getBlip();
            POIXMLDocumentPart inputPicturePart = diagram.getDiagramDrawing().getRelationById(blip.getEmbed());
            if (inputPicturePart == null || inputPicturePart.getPackagePart() == null) continue;
            XSLFPictureData inputPictureData = new XSLFPictureData(inputPicturePart.getPackagePart());
            XMLSlideShow outputPptx = outputSlide.getSlideShow();
            XSLFPictureData outputPictureData = outputPptx.addPicture(inputPicturePart.getPackagePart().getInputStream(), inputPictureData.getType());
            POIXMLDocumentPart.RelationPart outputRelation = outputSlide.addRelation(null, XSLFRelation.IMAGES, outputPictureData);
            ctShape.getSpPr().getBlipFill().getBlip().setEmbed(outputRelation.getRelationship().getId());
        }
    }

    private static XSLFTheme extractTheme(XMLSlideShow slideShow) {
        if (!slideShow.getSlideMasters().isEmpty()) {
            return slideShow.getSlideMasters().get(0).getTheme();
        }
        return null;
    }

    private void convertSmartArt() throws IOException {
        this.outputPptx.setPageSize(this.inputPptx.getPageSize());
        XSLFTheme theme = SmartArtConversionDemo.extractTheme(this.inputPptx);
        if (theme != null) {
            this.outputPptx.getSlideMasters().get(0).getTheme().getXmlObject().set(theme.getXmlObject());
        }
        for (XSLFSlide inputSlide : this.inputPptx.getSlides()) {
            XSLFSlide outputSlide = this.outputPptx.createSlide();
            List<XSLFShape> inputShapes = inputSlide.getShapes();
            for (XSLFShape shape : inputShapes) {
                if (shape instanceof XSLFDiagram) {
                    this.copyDiagramToOutput((XSLFDiagram)shape, outputSlide);
                    continue;
                }
                XSLFAutoShape autoShape = outputSlide.createAutoShape();
                autoShape.getXmlObject().set(shape.getXmlObject());
            }
        }
    }

    private void copyDiagramToOutput(XSLFDiagram inputDiagram, XSLFSlide outputSlide) throws IOException {
        SmartArtConversionDemo.copyAndUpdateImageRelations(inputDiagram, outputSlide);
        XSLFDiagram.XSLFDiagramGroupShape inputGroupShape = inputDiagram.getGroupShape();
        XSLFGroupShape outputGroupShape = outputSlide.createGroup();
        outputGroupShape.getXmlObject().set(inputGroupShape.getXmlObject());
    }
}

