/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.ss;

import java.io.File;
import java.io.IOException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.xmlbeans.XmlException;

public final class LoadEmbedded {
    private LoadEmbedded() {
    }

    public static void main(String[] args) throws IOException, EncryptedDocumentException, OpenXML4JException, XmlException {
        Workbook wb = WorkbookFactory.create(new File(args[0]));
        LoadEmbedded.loadEmbedded(wb);
    }

    public static void loadEmbedded(Workbook wb) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        if (wb instanceof HSSFWorkbook) {
            LoadEmbedded.loadEmbedded((HSSFWorkbook)wb);
        } else if (wb instanceof XSSFWorkbook) {
            LoadEmbedded.loadEmbedded((XSSFWorkbook)wb);
        } else {
            throw new IllegalArgumentException(wb.getClass().getName());
        }
    }

    public static void loadEmbedded(HSSFWorkbook workbook) throws IOException {
        block10: for (HSSFObjectData obj : workbook.getAllEmbeddedObjects()) {
            DirectoryNode dn;
            String oleName;
            switch (oleName = obj.getOLE2ClassName()) {
                case "Worksheet": {
                    dn = (DirectoryNode)obj.getDirectory();
                    HSSFWorkbook embeddedWorkbook = new HSSFWorkbook(dn, false);
                    embeddedWorkbook.close();
                    continue block10;
                }
                case "Document": {
                    dn = (DirectoryNode)obj.getDirectory();
                    HWPFDocument embeddedWordDocument = new HWPFDocument(dn);
                    embeddedWordDocument.close();
                    continue block10;
                }
                case "Presentation": {
                    dn = (DirectoryNode)obj.getDirectory();
                    HSLFSlideShow embeddedSlieShow = new HSLFSlideShow(dn);
                    embeddedSlieShow.close();
                    continue block10;
                }
            }
            if (obj.hasDirectoryEntry()) {
                dn = (DirectoryNode)obj.getDirectory();
                for (Entry entry : dn) {
                }
                continue;
            }
            byte[] byArray = obj.getObjectData();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void loadEmbedded(XSSFWorkbook workbook) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        block66: for (PackagePart pPart : workbook.getAllEmbeddedParts()) {
            var4_4 = contentType = pPart.getContentType();
            var5_5 = -1;
            switch (var4_4.hashCode()) {
                case -366307023: {
                    if (!var4_4.equals("application/vnd.ms-excel")) break;
                    var5_5 = 0;
                    break;
                }
                case 1993842850: {
                    if (!var4_4.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) break;
                    var5_5 = 1;
                    break;
                }
                case 904647503: {
                    if (!var4_4.equals("application/msword")) break;
                    var5_5 = 2;
                    break;
                }
                case -1050893613: {
                    if (!var4_4.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) break;
                    var5_5 = 3;
                    break;
                }
                case -1071817359: {
                    if (!var4_4.equals("application/vnd.ms-powerpoint")) break;
                    var5_5 = 4;
                    break;
                }
                case -1073633483: {
                    if (!var4_4.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) break;
                    var5_5 = 5;
                }
            }
            switch (var5_5) {
                case 0: {
                    stream = pPart.getInputStream();
                    var7_7 = null;
                    embeddedWorkbook = new HSSFWorkbook(stream);
                    embeddedWorkbook.close();
                    if (stream == null) continue block66;
                    if (var7_7 == null) ** GOTO lbl43
                    try {
                        stream.close();
                    }
                    catch (Throwable embeddedWorkbook) {
                        var7_7.addSuppressed(embeddedWorkbook);
                    }
                    break;
lbl43:
                    // 1 sources

                    stream.close();
                    break;
                    catch (Throwable embeddedWorkbook) {
                        try {
                            var7_7 = embeddedWorkbook;
                            throw embeddedWorkbook;
                        }
                        catch (Throwable var9_22) {
                            if (stream != null) {
                                if (var7_7 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable var10_23) {
                                        var7_7.addSuppressed(var10_23);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw var9_22;
                        }
                    }
                }
                case 1: {
                    stream = pPart.getInputStream();
                    var7_7 = null;
                    embeddedWorkbook = new XSSFWorkbook(stream);
                    embeddedWorkbook.close();
                    if (stream == null) continue block66;
                    if (var7_7 == null) ** GOTO lbl74
                    try {
                        stream.close();
                    }
                    catch (Throwable embeddedWorkbook) {
                        var7_7.addSuppressed(embeddedWorkbook);
                    }
                    break;
lbl74:
                    // 1 sources

                    stream.close();
                    break;
                    catch (Throwable embeddedWorkbook) {
                        try {
                            var7_7 = embeddedWorkbook;
                            throw embeddedWorkbook;
                        }
                        catch (Throwable var11_24) {
                            if (stream != null) {
                                if (var7_7 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable var12_25) {
                                        var7_7.addSuppressed(var12_25);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw var11_24;
                        }
                    }
                }
                case 2: {
                    stream = pPart.getInputStream();
                    var7_7 = null;
                    document = new HWPFDocument(stream);
                    document.close();
                    if (stream == null) continue block66;
                    if (var7_7 == null) ** GOTO lbl105
                    try {
                        stream.close();
                    }
                    catch (Throwable document) {
                        var7_7.addSuppressed(document);
                    }
                    break;
lbl105:
                    // 1 sources

                    stream.close();
                    break;
                    catch (Throwable document) {
                        try {
                            var7_7 = document;
                            throw document;
                        }
                        catch (Throwable var13_26) {
                            if (stream != null) {
                                if (var7_7 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable var14_27) {
                                        var7_7.addSuppressed(var14_27);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw var13_26;
                        }
                    }
                }
                case 3: {
                    stream = pPart.getInputStream();
                    var7_7 = null;
                    document = new XWPFDocument(stream);
                    document.close();
                    if (stream == null) continue block66;
                    if (var7_7 == null) ** GOTO lbl136
                    try {
                        stream.close();
                    }
                    catch (Throwable document) {
                        var7_7.addSuppressed(document);
                    }
                    break;
lbl136:
                    // 1 sources

                    stream.close();
                    break;
                    catch (Throwable document) {
                        try {
                            var7_7 = document;
                            throw document;
                        }
                        catch (Throwable var15_28) {
                            if (stream != null) {
                                if (var7_7 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable var16_29) {
                                        var7_7.addSuppressed(var16_29);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw var15_28;
                        }
                    }
                }
                case 4: {
                    stream = pPart.getInputStream();
                    var7_7 = null;
                    slideShow = new HSLFSlideShow(stream);
                    slideShow.close();
                    if (stream == null) continue block66;
                    if (var7_7 == null) ** GOTO lbl167
                    try {
                        stream.close();
                    }
                    catch (Throwable slideShow) {
                        var7_7.addSuppressed(slideShow);
                    }
                    break;
lbl167:
                    // 1 sources

                    stream.close();
                    break;
                    catch (Throwable slideShow) {
                        try {
                            var7_7 = slideShow;
                            throw slideShow;
                        }
                        catch (Throwable var17_30) {
                            if (stream != null) {
                                if (var7_7 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable var18_31) {
                                        var7_7.addSuppressed(var18_31);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw var17_30;
                        }
                    }
                }
                case 5: {
                    stream = pPart.getInputStream();
                    var7_7 = null;
                    slideShow = new XMLSlideShow(stream);
                    slideShow.close();
                    if (stream == null) continue block66;
                    if (var7_7 == null) ** GOTO lbl198
                    try {
                        stream.close();
                    }
                    catch (Throwable var8_19) {
                        var7_7.addSuppressed(var8_19);
                    }
                    break;
lbl198:
                    // 1 sources

                    stream.close();
                    break;
                    catch (Throwable var8_20) {
                        try {
                            var7_7 = var8_20;
                            throw var8_20;
                        }
                        catch (Throwable var19_32) {
                            if (stream != null) {
                                if (var7_7 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable var20_33) {
                                        var7_7.addSuppressed(var20_33);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw var19_32;
                        }
                    }
                }
                default: {
                    System.out.println("Unknown Embedded Document: " + contentType);
                    inputStream = pPart.getInputStream();
                    var7_7 = null;
                    if (inputStream == null) continue block66;
                    if (var7_7 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable var8_21) {
                            var7_7.addSuppressed(var8_21);
                        }
                        break;
                    }
                    inputStream.close();
                }
            }
        }
    }
}

