/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hssf.usermodel;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.logging.PoiLogManager;

public class Outlines
implements Closeable {
    private final HSSFWorkbook wb = new HSSFWorkbook();
    private final HSSFSheet sheet1 = this.wb.createSheet("new sheet");

    public static void main(String[] args) throws IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Logger LOGGER = PoiLogManager.getLogger(Outlines.class);
        for (int i = 1; i <= 13; ++i) {
            try (Outlines o = new Outlines();){
                String log = (String)Outlines.class.getDeclaredMethod("test" + i, new Class[0]).invoke((Object)o, new Object[0]);
                String filename = "outline" + i + ".xls";
                o.writeOut(filename);
                LOGGER.atInfo().log("{} written. {}", (Object)filename, (Object)log);
                continue;
            }
        }
    }

    public void writeOut(String filename) throws IOException {
        try (FileOutputStream fileOut = new FileOutputStream(filename);){
            this.wb.write(fileOut);
        }
    }

    @Override
    public void close() throws IOException {
        this.wb.close();
    }

    public String test1() {
        this.sheet1.groupColumn(4, 7);
        for (int row = 0; row < 200; ++row) {
            HSSFRow r = this.sheet1.createRow(row);
            for (int column = 0; column < 200; ++column) {
                HSSFCell c = r.createCell(column);
                c.setCellValue(column);
            }
        }
        return "Two expanded groups.";
    }

    public String test2() {
        this.sheet1.groupColumn(2, 10);
        this.sheet1.groupColumn(4, 7);
        this.sheet1.setColumnGroupCollapsed(4, true);
        return "Two groups.  Inner group collapsed.";
    }

    public String test3() {
        this.sheet1.groupColumn(2, 10);
        this.sheet1.groupColumn(4, 7);
        this.sheet1.setColumnGroupCollapsed(4, true);
        this.sheet1.setColumnGroupCollapsed(2, true);
        return "Two groups.  Both collapsed.";
    }

    public String test4() {
        this.sheet1.groupColumn(2, 10);
        this.sheet1.groupColumn(4, 7);
        this.sheet1.setColumnGroupCollapsed(4, true);
        this.sheet1.setColumnGroupCollapsed(2, true);
        this.sheet1.setColumnGroupCollapsed(4, false);
        return "Two groups.  Collapsed then inner group expanded.";
    }

    public String test5() {
        this.sheet1.groupColumn(2, 10);
        this.sheet1.groupColumn(4, 7);
        this.sheet1.setColumnGroupCollapsed(4, true);
        this.sheet1.setColumnGroupCollapsed(2, true);
        this.sheet1.setColumnGroupCollapsed(4, false);
        this.sheet1.setColumnGroupCollapsed(3, false);
        return "Two groups.  Collapsed then reexpanded.";
    }

    public String test6() {
        this.sheet1.groupColumn(2, 10);
        this.sheet1.groupColumn(4, 10);
        this.sheet1.setColumnGroupCollapsed(4, true);
        this.sheet1.setColumnGroupCollapsed(2, true);
        this.sheet1.setColumnGroupCollapsed(3, false);
        return "Two groups with matching end points.  Second group collapsed.";
    }

    public String test7() {
        this.sheet1.groupRow(5, 14);
        this.sheet1.groupRow(7, 10);
        return "Row outlines.";
    }

    public String test8() {
        this.sheet1.groupRow(5, 14);
        this.sheet1.groupRow(7, 10);
        this.sheet1.setRowGroupCollapsed(7, true);
        return "Row outlines.  Inner group collapsed.";
    }

    public String test9() {
        this.sheet1.groupRow(5, 14);
        this.sheet1.groupRow(7, 10);
        this.sheet1.setRowGroupCollapsed(7, true);
        this.sheet1.setRowGroupCollapsed(5, true);
        return "Row outlines.  Both collapsed.";
    }

    public String test10() {
        this.sheet1.groupRow(5, 14);
        this.sheet1.groupRow(7, 10);
        this.sheet1.setRowGroupCollapsed(7, true);
        this.sheet1.setRowGroupCollapsed(5, true);
        this.sheet1.setRowGroupCollapsed(8, false);
        return "Row outlines.  Collapsed then inner group expanded.";
    }

    public String test11() {
        this.sheet1.groupRow(5, 14);
        this.sheet1.groupRow(7, 10);
        this.sheet1.setRowGroupCollapsed(7, true);
        this.sheet1.setRowGroupCollapsed(5, true);
        this.sheet1.setRowGroupCollapsed(8, false);
        this.sheet1.setRowGroupCollapsed(14, false);
        return "Row outlines.  Collapsed then expanded.";
    }

    public String test12() {
        this.sheet1.groupRow(5, 14);
        this.sheet1.groupRow(7, 14);
        this.sheet1.setRowGroupCollapsed(7, true);
        this.sheet1.setRowGroupCollapsed(5, true);
        this.sheet1.setRowGroupCollapsed(6, false);
        return "Row outlines.  Two row groups with matching end points.  Second group collapsed.";
    }

    public String test13() {
        this.sheet1.groupRow(5, 14);
        this.sheet1.groupRow(7, 14);
        this.sheet1.groupRow(16, 19);
        this.sheet1.groupColumn(4, 7);
        this.sheet1.groupColumn(9, 12);
        this.sheet1.groupColumn(10, 11);
        return "Mixed bag.";
    }
}

