/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.querycaching;

import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.aws.dynamodb.CFDynamoDbServiceConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CFDynamoQueryDetails
implements Serializable {
    private Map queryMap;
    private Map queryOptions;
    private AWSCredential credential;
    private CFDynamoDbServiceConfig serviceConfig;
    private String awsServiceName;
    private String cacheID;

    public CFDynamoQueryDetails(Map queryMap, Map queryOptions, AWSCredential credential, CFDynamoDbServiceConfig serviceConfig, String awsServiceName, String cacheID) {
        this.queryMap = queryMap;
        this.queryOptions = this.extractOptions(queryOptions);
        this.credential = credential;
        this.serviceConfig = serviceConfig;
        this.awsServiceName = awsServiceName;
        this.cacheID = cacheID;
    }

    private Map extractOptions(Map queryOptions) {
        HashMap options = new HashMap();
        options.put("hasType", queryOptions.get("hasType"));
        options.put("customResponse", queryOptions.get("customResponse"));
        options.put("binaryFormat", queryOptions.get("binaryFormat"));
        options.put("caseSensitiveReturn", queryOptions.get("caseSensitiveReturn"));
        return options;
    }

    public Map getQueryMap() {
        return this.queryMap;
    }

    public Map getQueryOptions() {
        return this.queryOptions;
    }

    public AWSCredential getCredential() {
        return this.credential;
    }

    public CFDynamoDbServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public String getAwsServiceName() {
        return this.awsServiceName;
    }

    public String getCacheID() {
        return this.cacheID;
    }

    public String toString() {
        return String.format("{ queryMap : " + this.queryMap + " , queryOptions : " + this.queryOptions + " , credentialAlias : " + this.credential.getAlias() + " , vendorName : " + this.credential.getVendorName() + " , accessKey : " + this.credential.getAccessKeyId() + " , secretKey : " + this.credential.getSecretAccessKey() + " , region : " + this.credential.getRegion() + " , awsServiceName : " + this.awsServiceName + " , cacheID : " + this.cacheID + " , serviceName : " + this.serviceConfig.getServiceName() + " , configAlias : " + this.serviceConfig.getConfigAlias() + " , clientOverride : " + this.serviceConfig.getClientOverrideConfiguration() + " , httpClientBuilder : " + this.serviceConfig.getHttpClientBuilder() + " }", new Object[0]);
    }

    public int hashCode() {
        int prime = 31;
        int uniqueCode = 1;
        uniqueCode = this.cacheID != null ? 31 * uniqueCode + this.cacheID.hashCode() : 31 * uniqueCode;
        uniqueCode = this.awsServiceName != null ? 31 * uniqueCode + this.awsServiceName.hashCode() : 31 * uniqueCode;
        uniqueCode = this.queryMap != null ? 31 * uniqueCode + this.queryMap.hashCode() : 31 * uniqueCode;
        uniqueCode = this.queryOptions != null ? 31 * uniqueCode + this.queryOptions.hashCode() : 31 * uniqueCode;
        if (this.serviceConfig != null) {
            if (this.serviceConfig.getServiceName() != null) {
                uniqueCode = 31 * uniqueCode + this.serviceConfig.getServiceName().hashCode();
            }
            if (this.serviceConfig.getConfigAlias() != null) {
                uniqueCode = 31 * uniqueCode + this.serviceConfig.getConfigAlias().hashCode();
            }
            if (this.serviceConfig.getClientOverrideConfiguration() != null) {
                uniqueCode = 31 * uniqueCode + this.serviceConfig.getClientOverrideConfiguration().hashCode();
            }
            if (this.serviceConfig.getHttpClientBuilder() != null) {
                uniqueCode = 31 * uniqueCode + this.serviceConfig.getHttpClientBuilder().hashCode();
            }
        } else {
            uniqueCode = 31 * uniqueCode;
        }
        uniqueCode = this.credential != null ? 31 * uniqueCode + this.credential.hashCode() : 31 * uniqueCode;
        return uniqueCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass() || !(obj instanceof CFDynamoQueryDetails)) {
            return false;
        }
        CFDynamoQueryDetails compObj = (CFDynamoQueryDetails)obj;
        if (this.queryMap == null && compObj.getQueryMap() != null || this.queryMap != null && compObj.getQueryMap() == null) {
            return false;
        }
        if (this.queryMap != null && !this.queryMap.equals(compObj.getQueryMap())) {
            return false;
        }
        if (this.queryOptions == null && compObj.getQueryOptions() != null || this.queryOptions != null && compObj.getQueryOptions() == null) {
            return false;
        }
        if (this.queryOptions != null && !this.queryOptions.equals(compObj.getQueryOptions())) {
            return false;
        }
        if (this.credential == null && compObj.getCredential() != null || this.credential != null && compObj.getCredential() == null) {
            return false;
        }
        if (this.credential != null && !this.credential.equals((Object)compObj.getCredential())) {
            return false;
        }
        if (this.serviceConfig == null && compObj.getServiceConfig() != null || this.serviceConfig != null && compObj.getServiceConfig() == null) {
            return false;
        }
        if (this.serviceConfig != null && compObj.getServiceConfig() != null) {
            if (this.serviceConfig.getServiceName() != null && !this.serviceConfig.getServiceName().equals(compObj.getServiceConfig().getServiceName())) {
                return false;
            }
            if (this.serviceConfig.getConfigAlias() != null && !this.serviceConfig.getConfigAlias().equals(compObj.getServiceConfig().getConfigAlias())) {
                return false;
            }
            if (this.serviceConfig.getClientOverrideConfiguration() != null && !this.serviceConfig.getClientOverrideConfiguration().equals(compObj.getServiceConfig().getClientOverrideConfiguration())) {
                return false;
            }
            if (this.serviceConfig.getHttpClientBuilder() != null && !this.serviceConfig.getHttpClientBuilder().equals(compObj.getServiceConfig().getHttpClientBuilder())) {
                return false;
            }
        }
        if (this.awsServiceName == null && compObj.getAwsServiceName() != null || this.awsServiceName != null && compObj.getAwsServiceName() == null) {
            return false;
        }
        if (this.awsServiceName != null && !this.awsServiceName.equals(compObj.getAwsServiceName())) {
            return false;
        }
        if (this.cacheID == null && compObj.getCacheID() != null || this.cacheID != null && compObj.getCacheID() == null) {
            return false;
        }
        return this.cacheID == null || this.cacheID.equals(compObj.getCacheID());
    }
}

