/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.exceptions;

import coldfusion.cloud.aws.dynamodb.casesensitive.CFHandleCaseSensitiveReturn;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbException;
import coldfusion.cloud.aws.dynamodb.utils.CFDynamoDbCustomizeResponse;
import coldfusion.util.RB;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.CancellationReason;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;

public class CFDynamoDbTransactionCanceledException
extends CFDynamoDbException {
    private List<String> cancelMessages;
    private List<Map> unprocessedItems;
    private static final String detailedMessage = RB.getString(CFDynamoDbTransactionCanceledException.class, (String)"Exception.TransactionCanceledException");

    public CFDynamoDbTransactionCanceledException(DynamoDbException dynamoDbException, String apiName) {
        super(dynamoDbException, apiName, detailedMessage);
        this.exceptionDetails.put("DetailedExceptionMessage", detailedMessage);
    }

    public CFDynamoDbTransactionCanceledException(DynamoDbException dynamoDbException, List<CancellationReason> cancellationReasons, String apiName, Map options) {
        super(dynamoDbException, apiName);
        this.buildCancellationReasons(cancellationReasons);
        this.buildUnprocessedItems(cancellationReasons, options);
        this.exceptionDetails.put("UnprocessedItems", this.unprocessedItems);
        this.exceptionDetails.put("DetailedExceptionMessage", detailedMessage);
        this.exceptionDetails.put("CancellationReasons", this.cancelMessages);
    }

    private void buildUnprocessedItems(List<CancellationReason> cancellationReasons, Map options) {
        this.unprocessedItems = new ArrayList<Map>();
        for (CancellationReason cancellationReason : cancellationReasons) {
            if (cancellationReason.code().equals("None")) continue;
            Map unprocessedItem = CFHandleCaseSensitiveReturn.contructReturn(cancellationReason);
            if (CFDynamoDbCustomizeResponse.returnCustomResponse(options)) {
                CFDynamoDbCustomizeResponse.customizeUnprocessedItems(cancellationReason.item(), unprocessedItem, options);
            }
            this.unprocessedItems.add(unprocessedItem);
        }
    }

    private void buildCancellationReasons(List<CancellationReason> cancellationReasons) {
        this.cancelMessages = new ArrayList<String>();
        for (CancellationReason cancellationReason : cancellationReasons) {
            if (cancellationReason.message() == null) continue;
            this.cancelMessages.add(cancellationReason.message());
        }
    }
}

