/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.report.Report;
import coldfusion.server.ServiceFactory;
import coldfusion.util.FastHashtable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRDesignSubreportReturnValue;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreportReturnValue;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import net.sf.jasperreports.engine.fill.JRSubreportRunnerFactory;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import net.sf.jasperreports.engine.fill.JRTemplateRectangle;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillSubreport
extends JRFillElement
implements JRSubreport {
    private static final JRSingletonCache runnerFactoryCache = new JRSingletonCache(JRSubreportRunnerFactory.class);
    private FastHashtable parameterValues = null;
    private JRSubreportParameter[] parameters = null;
    private JRDataSource dataSource = null;
    private JasperReport jasperReport = null;
    private Map loadedEvaluators = null;
    private Report report = null;
    private FusionContext context = null;
    private JRFillSubreportReturnValue[] returnValues = null;
    private JRBaseFiller subreportFiller = null;
    private JRPrintPage printPage = null;
    private JRReportFont[] subreportFonts = null;
    private JRStyle[] subreportStyles = null;
    private JRSubreportRunner runner;
    private Set checkedReports;

    protected JRFillSubreport(JRBaseFiller filler, JRSubreport subreport, JRFillObjectFactory factory) {
        super(filler, subreport, factory);
        this.parameters = subreport.getParameters();
        JRSubreportReturnValue[] subrepReturnValues = subreport.getReturnValues();
        if (subrepReturnValues != null) {
            ArrayList returnValuesList = new ArrayList(subrepReturnValues.length * 2);
            this.returnValues = new JRFillSubreportReturnValue[subrepReturnValues.length];
            for (int i = 0; i < subrepReturnValues.length; ++i) {
                this.addReturnValue(subrepReturnValues[i], returnValuesList, factory);
            }
            this.returnValues = new JRFillSubreportReturnValue[returnValuesList.size()];
            returnValuesList.toArray(this.returnValues);
        }
        this.loadedEvaluators = new HashMap();
        this.checkedReports = new HashSet();
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public boolean isUsingCache() {
        return ((JRSubreport)this.parent).isUsingCache();
    }

    @Override
    public void setUsingCache(boolean isUsingCache) {
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return ((JRSubreport)this.parent).getParametersMapExpression();
    }

    @Override
    public JRSubreportParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getConnectionExpression() {
        return ((JRSubreport)this.parent).getConnectionExpression();
    }

    @Override
    public JRExpression getDataSourceExpression() {
        return ((JRSubreport)this.parent).getDataSourceExpression();
    }

    @Override
    public JRExpression getExpression() {
        return ((JRSubreport)this.parent).getExpression();
    }

    protected JRTemplateRectangle getJRTemplateRectangle() {
        JRStyle style = this.getStyle();
        JRTemplateRectangle template = (JRTemplateRectangle)this.getTemplate(style);
        if (template == null) {
            template = new JRTemplateRectangle(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.registerTemplate(style, template);
        }
        return template;
    }

    protected JRReportFont[] getFonts() {
        return this.subreportFonts;
    }

    protected JRStyle[] getStyles() {
        return this.subreportStyles;
    }

    protected Collection getPrintElements() {
        List printElements = null;
        if (this.printPage != null) {
            printElements = this.printPage.getElements();
        }
        return printElements;
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        JRExpression expression;
        Object source;
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && (source = this.evaluateExpression(expression = this.getExpression(), evaluation)) != null) {
            JREvaluator evaluator = null;
            if (this.isUsingCache() && this.filler.loadedSubreports.containsKey(source)) {
                LoadedSubreportEntry entry = (LoadedSubreportEntry)this.filler.loadedSubreports.get(source);
                this.jasperReport = entry.jasperReport;
                this.report = entry.cfReport;
                this.context = entry.cfContext;
                evaluator = (JREvaluator)this.loadedEvaluators.get(this.jasperReport);
                if (evaluator == null) {
                    evaluator = JRDefaultCompiler.getInstance().loadEvaluator(this.jasperReport);
                    this.loadedEvaluators.put(this.jasperReport, evaluator);
                }
            } else {
                Class expressionClass = expression.getValueClass();
                if (expressionClass.equals(JasperReport.class)) {
                    this.jasperReport = (JasperReport)source;
                } else if (expressionClass.equals(InputStream.class)) {
                    this.jasperReport = (JasperReport)JRLoader.loadObject((InputStream)source);
                } else if (expressionClass.equals(URL.class)) {
                    this.jasperReport = (JasperReport)JRLoader.loadObject((URL)source);
                } else if (expressionClass.equals(File.class)) {
                    this.jasperReport = (JasperReport)JRLoader.loadObject((File)source);
                } else if (expressionClass.equals(String.class)) {
                    this.context = FusionContext.getCurrent();
                    NeoPageContext pageContext = this.context.pageContext;
                    String subReportLocation = this.resolveSubReportPath((String)source, pageContext);
                    String style = this.getSubreportStyles() != null ? (String)this.getSubreportStyles().get(this.getKey()) : null;
                    this.report = new Report(subReportLocation, pageContext, style);
                    this.report.setSubreportQueries(this.getSubreportQueries());
                    this.report.setSubreportStyles(this.getSubreportStyles());
                    this.jasperReport = this.report.compileReport(this.getQuery());
                    this.report.setupSubreportData(this.jasperReport);
                }
                if (this.jasperReport != null) {
                    evaluator = JRDefaultCompiler.getInstance().loadEvaluator(this.jasperReport);
                }
                if (this.isUsingCache()) {
                    LoadedSubreportEntry entry = new LoadedSubreportEntry(this.jasperReport, this.report, this.context);
                    this.filler.loadedSubreports.put(source, entry);
                    this.loadedEvaluators.put(this.jasperReport, evaluator);
                }
            }
            if (this.jasperReport != null) {
                boolean hasResourceBundle = this.jasperReport.getResourceBundle() != null;
                this.parameterValues = JRFillSubreport.getParameterValues(this.filler, this.getParametersMapExpression(), this.getParameters(), evaluation, false, hasResourceBundle);
                if (this.subreportFiller != null) {
                    this.filler.unregisterSubfiller(this.subreportFiller);
                }
                this.initSubreportFiller(evaluator);
                this.checkReturnValues();
            }
        }
    }

    protected void initSubreportFiller(JREvaluator evaluator) throws JRException {
        switch (this.jasperReport.getPrintOrder()) {
            case 2: {
                this.subreportFiller = new JRHorizontalFiller(this.jasperReport, evaluator, this.filler);
                break;
            }
            case 1: {
                this.subreportFiller = new JRVerticalFiller(this.jasperReport, evaluator, this.filler);
                break;
            }
            default: {
                throw new JRRuntimeException("Unkown print order " + this.jasperReport.getPrintOrder() + ".");
            }
        }
        this.runner = JRFillSubreport.getRunnerFactory().createSubreportRunner(this, this.subreportFiller);
        this.subreportFiller.setSubreportRunner(this.runner);
    }

    public static FastHashtable getParameterValues(JRBaseFiller filler, JRExpression parametersMapExpression, JRDatasetParameter[] subreportParameters, byte evaluation, boolean ignoreNullExpressions, boolean removeResourceBundle) throws JRException {
        FastHashtable parameterValues = null;
        if (parametersMapExpression != null) {
            parameterValues = (FastHashtable)filler.evaluateExpression(parametersMapExpression, evaluation);
        }
        if (parameterValues != null) {
            if (removeResourceBundle) {
                parameterValues.remove((Object)"REPORT_RESOURCE_BUNDLE");
            }
            parameterValues.remove((Object)"REPORT_CONNECTION");
            parameterValues.remove((Object)"REPORT_MAX_COUNT");
            parameterValues.remove((Object)"REPORT_DATA_SOURCE");
            parameterValues.remove((Object)"REPORT_SCRIPTLET");
            parameterValues.remove((Object)"REPORT_VIRTUALIZER");
            parameterValues.remove((Object)"IS_IGNORE_PAGINATION");
            parameterValues.remove((Object)"REPORT_PARAMETERS_MAP");
        }
        if (parameterValues == null) {
            parameterValues = new FastHashtable();
        }
        if (subreportParameters != null && subreportParameters.length > 0) {
            for (int i = 0; i < subreportParameters.length; ++i) {
                JRExpression expression = subreportParameters[i].getExpression();
                if (expression == null && ignoreNullExpressions) continue;
                Object parameterValue = filler.evaluateExpression(expression, evaluation);
                if (parameterValue == null) {
                    parameterValues.remove((Object)subreportParameters[i].getName());
                    continue;
                }
                parameterValues.put((Object)subreportParameters[i].getName(), parameterValue);
            }
        }
        if (!parameterValues.containsKey((Object)"REPORT_LOCALE")) {
            parameterValues.put((Object)"REPORT_LOCALE", (Object)filler.getLocale());
        }
        if (!parameterValues.containsKey((Object)"REPORT_TIME_ZONE")) {
            parameterValues.put((Object)"REPORT_TIME_ZONE", (Object)filler.getTimeZone());
        }
        if (!parameterValues.containsKey((Object)"REPORT_CLASS_LOADER") && filler.reportClassLoader != null) {
            parameterValues.put((Object)"REPORT_CLASS_LOADER", (Object)filler.reportClassLoader);
        }
        if (!parameterValues.containsKey((Object)"REPORT_URL_HANDLER_FACTORY") && filler.urlHandlerFactory != null) {
            parameterValues.put((Object)"REPORT_URL_HANDLER_FACTORY", (Object)filler.urlHandlerFactory);
        }
        return parameterValues;
    }

    protected void fillSubreport(JRDataSource ds) throws JRException {
        this.dataSource = ds;
        this.subreportFiller.fill((Map)this.parameterValues, this.dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        boolean reprinted;
        boolean willOverflow = false;
        super.prepare(availableStretchHeight, isOverflow);
        if (this.subreportFiller == null) {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        if (availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
            this.setToPrint(false);
            return true;
        }
        boolean filling = this.runner.isFilling();
        boolean toPrint = !isOverflow || this.isPrintWhenDetailOverflows() || !this.isAlreadyPrinted();
        boolean bl = reprinted = isOverflow && this.isPrintWhenDetailOverflows();
        if (!filling && toPrint && reprinted) {
            this.rewind();
        }
        int availableHeight = availableStretchHeight - this.getRelativeY() + this.getBand().getContainerHeight() - this.getBandBottomY();
        this.subreportFiller.setPageHeight(availableHeight);
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            JRSubreportRunResult result;
            if (filling) {
                result = this.runner.resume();
            } else if (toPrint) {
                this.setReprinted(reprinted);
                result = this.runner.start();
            } else {
                this.printPage = null;
                this.subreportFonts = null;
                this.subreportStyles = null;
                this.setStretchHeight(this.getHeight());
                this.setToPrint(false);
                return willOverflow;
            }
            if (result.getException() != null) {
                Throwable error = result.getException();
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new JRRuntimeException(error);
            }
            if (result.hasFinished()) {
                this.copyValues();
            }
            this.printPage = this.subreportFiller.getCurrentPage();
            this.subreportFonts = this.subreportFiller.getFonts();
            this.subreportStyles = this.subreportFiller.getPrintStyles();
            this.setStretchHeight(result.hasFinished() ? this.subreportFiller.getCurrentPageStretchHeight() : availableHeight);
            boolean bl2 = willOverflow = !result.hasFinished();
            if (!willOverflow) {
                this.runner.reset();
            }
        }
        Collection printElements = this.getPrintElements();
        if ((printElements == null || printElements.size() == 0) && this.isRemoveLineWhenBlank()) {
            this.setToPrint(false);
        }
        return willOverflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rewind() throws JRException {
        if (this.subreportFiller == null) {
            return;
        }
        this.subreportFiller.setInterrupted(true);
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.runner.cancel();
            this.runner.reset();
        }
        this.filler.unregisterSubfiller(this.subreportFiller);
        this.initSubreportFiller(null);
        if (this.getConnectionExpression() == null && this.dataSource != null) {
            if (this.dataSource instanceof JRRewindableDataSource) {
                ((JRRewindableDataSource)this.dataSource).moveFirst();
            } else if (this.subreportFiller.isDebugEnabled()) {
                System.err.println("The subreport is placed on a non-splitting band, but it does not have a rewindable data source.");
            }
        }
    }

    @Override
    protected JRPrintElement fill() {
        JRTemplatePrintRectangle printRectangle = new JRTemplatePrintRectangle(this.getJRTemplateRectangle());
        printRectangle.setX(this.getX());
        printRectangle.setY(this.getRelativeY());
        printRectangle.setWidth(this.getWidth());
        printRectangle.setHeight(this.getStretchHeight());
        return printRectangle;
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getSubreport(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        xmlWriter.writeSubreport(this);
    }

    private JRFillSubreportReturnValue addReturnValue(JRSubreportReturnValue parentReturnValue, List returnValueList, JRFillObjectFactory factory) {
        JRFillSubreportReturnValue returnValue = factory.getSubreportReturnValue(parentReturnValue);
        byte calculation = returnValue.getCalculation();
        switch (calculation) {
            case 3: 
            case 7: {
                JRSubreportReturnValue countVal = this.createHelperReturnValue(parentReturnValue, "_COUNT", (byte)1);
                this.addReturnValue(countVal, returnValueList, factory);
                JRSubreportReturnValue sumVal = this.createHelperReturnValue(parentReturnValue, "_SUM", (byte)2);
                this.addReturnValue(sumVal, returnValueList, factory);
                this.filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
            case 6: {
                JRSubreportReturnValue varianceVal = this.createHelperReturnValue(parentReturnValue, "_VARIANCE", (byte)7);
                this.addReturnValue(varianceVal, returnValueList, factory);
                this.filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
            case 10: {
                JRSubreportReturnValue countVal = this.createDistinctCountHelperReturnValue(parentReturnValue);
                this.addReturnValue(countVal, returnValueList, factory);
                this.filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
        }
        returnValueList.add(returnValue);
        return returnValue;
    }

    protected JRSubreportReturnValue createHelperReturnValue(JRSubreportReturnValue returnValue, String nameSuffix, byte calculation) {
        JRDesignSubreportReturnValue helper = new JRDesignSubreportReturnValue();
        helper.setToVariable(returnValue.getToVariable() + nameSuffix);
        helper.setSubreportVariable(returnValue.getSubreportVariable());
        helper.setCalculation(calculation);
        helper.setIncrementerFactoryClassName(helper.getIncrementerFactoryClassName());
        return helper;
    }

    protected JRSubreportReturnValue createDistinctCountHelperReturnValue(JRSubreportReturnValue returnValue) {
        JRDesignSubreportReturnValue helper = new JRDesignSubreportReturnValue();
        helper.setToVariable(returnValue.getToVariable() + "_DISTINCT_COUNT");
        helper.setSubreportVariable(returnValue.getSubreportVariable());
        helper.setCalculation((byte)0);
        helper.setIncrementerFactoryClassName(helper.getIncrementerFactoryClassName());
        return helper;
    }

    @Override
    public JRSubreportReturnValue[] getReturnValues() {
        return this.returnValues;
    }

    private void copyValues() {
        if (this.returnValues != null && this.returnValues.length > 0) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                try {
                    JRFillVariable variable = this.filler.getVariable(this.returnValues[i].getToVariable());
                    Object value = this.subreportFiller.getVariableValue(this.returnValues[i].getSubreportVariable());
                    Object newValue = this.returnValues[i].getIncrementer().increment(variable, value, AbstractValueProvider.getCurrentValueProvider());
                    variable.setOldValue(newValue);
                    variable.setValue(newValue);
                    continue;
                }
                catch (JRException e) {
                    throw new JRRuntimeException(e);
                }
            }
        }
    }

    private void checkReturnValues() throws JRException {
        if (this.returnValues != null && this.returnValues.length > 0 && !this.checkedReports.contains(this.jasperReport)) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                JRFillSubreportReturnValue returnValue = this.returnValues[i];
                String subreportVariableName = returnValue.getSubreportVariable();
                JRFillVariable subrepVariable = this.subreportFiller.getVariable(subreportVariableName);
                if (subrepVariable == null) {
                    throw new JRException("Subreport variable " + subreportVariableName + " not found.");
                }
                JRFillVariable variable = this.filler.getVariable(returnValue.getToVariable());
                if (returnValue.getCalculation() == 1 || returnValue.getCalculation() == 10) {
                    if (Number.class.isAssignableFrom(variable.getValueClass())) continue;
                    throw new JRException("Variable " + returnValue.getToVariable() + " must have a numeric type.");
                }
                if (variable.getValueClass().isAssignableFrom(subrepVariable.getValueClass()) || Number.class.isAssignableFrom(variable.getValueClass()) && Number.class.isAssignableFrom(subrepVariable.getValueClass())) continue;
                throw new JRException("Variable " + returnValue.getToVariable() + " is not assignable from subreport variable " + subreportVariableName);
            }
            if (this.isUsingCache()) {
                this.checkedReports.add(this.jasperReport);
            }
        }
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    @Override
    public Boolean isOwnUsingCache() {
        return ((JRSubreport)this.parent).isOwnUsingCache();
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
    }

    @Override
    public JRCloneable createClone(JRFillCloneFactory factory) {
        return null;
    }

    protected static JRSubreportRunnerFactory getRunnerFactory() throws JRException {
        String factoryClassName = JRProperties.getProperty("net.sf.jasperreports.subreport.runner.factory");
        if (factoryClassName == null) {
            throw new JRException("Property \"net.sf.jasperreports.subreport.runner.factory\" must be set");
        }
        return (JRSubreportRunnerFactory)runnerFactoryCache.getCachedInstance(factoryClassName);
    }

    private String resolveSubReportPath(String location, NeoPageContext pageContext) {
        String filepath;
        String CFR_PARENT_PATH = (String)pageContext.findAttribute("CFR_PATH");
        boolean _absolute_path = false;
        if (location.length() > 1 && location.charAt(1) == ':') {
            filepath = location;
            _absolute_path = true;
        } else {
            filepath = CFR_PARENT_PATH + File.separatorChar + location;
        }
        File file = new File(filepath);
        if (!(file.exists() && file.isFile() || _absolute_path)) {
            try {
                file = ServiceFactory.getRuntimeService().resolveTemplatePath(location);
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (file != null && file.exists() && file.isFile()) {
            filepath = file.getAbsolutePath();
        }
        return filepath;
    }

    protected FastHashtable getCaseInsensitiveParameterValues() {
        return this.parameterValues;
    }

    protected Report getCFReport() {
        return this.report;
    }

    protected FusionContext getCFFusionContext() {
        return this.context;
    }

    @Override
    public boolean isPrintWhenDetailOverflows() {
        return false;
    }

    @Override
    public ResultSet getQuery() {
        return ((JRSubreport)this.parent).getQuery();
    }

    @Override
    public void setSubreportQueries(Map srQueries) {
        ((JRSubreport)this.parent).setSubreportQueries(srQueries);
    }

    @Override
    public Map getSubreportQueries() {
        return ((JRSubreport)this.parent).getSubreportQueries();
    }

    @Override
    public void setSubreportStyles(Map srStyles) {
        ((JRSubreport)this.parent).setSubreportStyles(srStyles);
    }

    @Override
    public Map getSubreportStyles() {
        return ((JRSubreport)this.parent).getSubreportStyles();
    }

    private class LoadedSubreportEntry {
        JasperReport jasperReport;
        Report cfReport;
        FusionContext cfContext;

        LoadedSubreportEntry(JasperReport jasperReport, Report cfReport, FusionContext cfContext) {
            this.jasperReport = jasperReport;
            this.cfReport = cfReport;
            this.cfContext = cfContext;
        }
    }
}

