/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.ant;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.RegexpPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class JRAntCompileTask
extends MatchingTask {
    private Path src = null;
    private File destdir = null;
    private File tempdir = null;
    private boolean keepjava = false;
    private String compiler = null;
    private Path classpath = null;
    private boolean xmlvalidation = true;
    private Map reportFilesMap = null;

    public void setSrcdir(Path srcdir) {
        if (this.src == null) {
            this.src = srcdir;
        } else {
            this.src.append(srcdir);
        }
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setTempdir(File tempdir) {
        this.tempdir = tempdir;
    }

    public void setKeepjava(boolean keepjava) {
        this.keepjava = keepjava;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setXmlvalidation(boolean xmlvalidation) {
        this.xmlvalidation = xmlvalidation;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.reportFilesMap = new HashMap();
        JRProperties.backupProperties();
        try {
            if (this.tempdir != null) {
                JRProperties.setProperty("net.sf.jasperreports.compiler.temp.dir", String.valueOf(this.tempdir));
            }
            JRProperties.setProperty("net.sf.jasperreports.compiler.keep.java.file", this.keepjava);
            if (this.compiler != null) {
                JRProperties.setProperty("net.sf.jasperreports.compiler.class", this.compiler);
            }
            if (this.classpath != null) {
                JRProperties.setProperty("net.sf.jasperreports.compiler.classpath", String.valueOf(this.classpath));
            }
            JRProperties.setProperty("net.sf.jasperreports.compiler.xml.validation", this.xmlvalidation);
            this.scanSrc();
            this.compile();
        }
        finally {
            JRProperties.restoreProperties();
        }
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null || this.src.size() == 0) {
            throw new BuildException("The srcdir attribute must be set.", this.location);
        }
        if (this.destdir != null && !this.destdir.isDirectory()) {
            throw new BuildException("The destination directory \"" + this.destdir + "\" does not exist or is not a directory.", this.location);
        }
        if (this.tempdir != null && !this.tempdir.isDirectory()) {
            throw new BuildException("The temporary directory \"" + this.tempdir + "\" does not exist or is not a directory.", this.location);
        }
    }

    protected void scanSrc() throws BuildException {
        String[] list = this.src.list();
        for (int i = 0; i < list.length; ++i) {
            File srcdir = this.project.resolveFile(list[i]);
            if (!srcdir.exists()) {
                throw new BuildException("The srcdir \"" + srcdir.getPath() + "\" does not exist.", this.location);
            }
            if (srcdir.isDirectory()) {
                DirectoryScanner ds = this.getDirectoryScanner(srcdir);
                String[] files = ds.getIncludedFiles();
                this.scanDir(srcdir, this.destdir != null ? this.destdir : srcdir, files);
                continue;
            }
            String[] files = new String[]{srcdir.getName()};
            this.scanDir(srcdir.getParentFile(), this.destdir != null ? this.destdir : srcdir.getParentFile(), files);
        }
    }

    protected void scanDir(File srcdir, File destdir, String[] files) {
        RegexpPatternMapper mapper = new RegexpPatternMapper();
        mapper.setFrom("^(.*)\\.(.*)$");
        mapper.setTo("\\1.jasper");
        SourceFileScanner scanner = new SourceFileScanner((Task)this);
        String[] newFiles = scanner.restrict(files, srcdir, destdir, (FileNameMapper)mapper);
        if (newFiles != null && newFiles.length > 0) {
            for (int i = 0; i < newFiles.length; ++i) {
                this.reportFilesMap.put(new File(srcdir, newFiles[i]).getAbsolutePath(), new File(destdir, mapper.mapFileName(newFiles[i])[0]).getAbsolutePath());
            }
        }
    }

    protected void compile() throws BuildException {
        Set files = this.reportFilesMap.keySet();
        if (files != null && files.size() > 0) {
            boolean isError = false;
            System.out.println("Compiling " + files.size() + " report design files.");
            String srcFileName2 = null;
            String destFileName = null;
            File destFileParent = null;
            for (String srcFileName2 : files) {
                destFileName = (String)this.reportFilesMap.get(srcFileName2);
                destFileParent = new File(destFileName).getParentFile();
                if (!destFileParent.exists()) {
                    destFileParent.mkdirs();
                }
                try {
                    System.out.print("File : " + srcFileName2 + " ... ");
                    JasperCompileManager.compileReportToFile(srcFileName2, destFileName);
                    System.out.println("OK.");
                }
                catch (JRException e) {
                    System.out.println("FAILED.");
                    System.out.println("Error compiling report design : " + srcFileName2);
                    e.printStackTrace(System.out);
                    isError = true;
                }
            }
            if (isError) {
                throw new BuildException("Errors were encountered when compiling report designs.");
            }
        }
    }
}

