/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.bson.types;

import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.util.CFDumpable;
import java.io.Serializable;
import java.util.Date;
import org.bson.types.ObjectId;

public class CFMongoObjectID
implements CFDumpable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ObjectId objectId;

    public CFMongoObjectID(ObjectId objectId) {
        this.objectId = objectId;
    }

    public CFMongoObjectID() {
        this.objectId = new ObjectId();
    }

    public CFMongoObjectID(Object objId) {
        this.objectId = MongoUtils.getObjectId(objId);
    }

    public String toHex() {
        return this.objectId.toHexString();
    }

    public byte[] toBinary() {
        return this.objectId.toByteArray();
    }

    public Date toDate() {
        long seconds = this.objectId.getTimestamp();
        return new Date(seconds * 1000L);
    }

    public ObjectId getId() {
        return this.objectId;
    }

    public Object getMetadata() {
        return this.toHex();
    }

    public String getLabel() {
        return "MongoDBObjectId";
    }
}

