/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.search.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.search.ComparisonMode;
import microsoft.exchange.webservices.data.core.enumeration.search.ContainmentMode;
import microsoft.exchange.webservices.data.core.enumeration.search.LogicalOperator;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SearchFilter
extends ComplexProperty {
    private static final Log LOG = LogFactory.getLog(SearchFilter.class);

    protected SearchFilter() {
    }

    public static SearchFilter loadFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.ensureCurrentNodeIsStartElement();
        SearchFilter searchFilter = null;
        searchFilter = reader.getLocalName().equalsIgnoreCase("Exists") ? new Exists() : (reader.getLocalName().equalsIgnoreCase("Contains") ? new ContainsSubstring() : (reader.getLocalName().equalsIgnoreCase("Excludes") ? new ExcludesBitmask() : (reader.getLocalName().equalsIgnoreCase("Not") ? new Not() : (reader.getLocalName().equalsIgnoreCase("And") ? new SearchFilterCollection(LogicalOperator.And) : (reader.getLocalName().equalsIgnoreCase("Or") ? new SearchFilterCollection(LogicalOperator.Or) : (reader.getLocalName().equalsIgnoreCase("IsEqualTo") ? new IsEqualTo() : (reader.getLocalName().equalsIgnoreCase("IsNotEqualTo") ? new IsNotEqualTo() : (reader.getLocalName().equalsIgnoreCase("IsGreaterThan") ? new IsGreaterThan() : (reader.getLocalName().equalsIgnoreCase("IsGreaterThanOrEqualTo") ? new IsGreaterThanOrEqualTo() : (reader.getLocalName().equalsIgnoreCase("IsLessThan") ? new IsLessThan() : (reader.getLocalName().equalsIgnoreCase("IsLessThanOrEqualTo") ? new IsLessThanOrEqualTo() : null)))))))))));
        if (searchFilter != null) {
            searchFilter.loadFromXml(reader, reader.getLocalName());
        }
        return searchFilter;
    }

    protected abstract String getXmlElementName();

    public void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeToXml(writer, this.getXmlElementName());
    }

    public static class SearchFilterCollection
    extends SearchFilter
    implements Iterable<SearchFilter>,
    IComplexPropertyChangedDelegate {
        private LogicalOperator logicalOperator = LogicalOperator.And;
        private ArrayList<SearchFilter> searchFilters = new ArrayList();

        public SearchFilterCollection() {
        }

        public SearchFilterCollection(LogicalOperator logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        public SearchFilterCollection(LogicalOperator logicalOperator, SearchFilter ... searchFilters) {
            this(logicalOperator);
            for (SearchFilter search : searchFilters) {
                List<SearchFilter> searchFil = Arrays.asList(search);
                this.addRange(searchFil);
            }
        }

        public SearchFilterCollection(LogicalOperator logicalOperator, Iterable<SearchFilter> searchFilters) {
            this(logicalOperator);
            this.addRange(searchFilters);
        }

        @Override
        protected void internalValidate() throws Exception {
            for (int i = 0; i < this.getCount(); ++i) {
                try {
                    this.searchFilters.get(i).internalValidate();
                    continue;
                }
                catch (ServiceValidationException e) {
                    throw new ServiceValidationException(String.format("The search filter at index %d is invalid.", i), e);
                }
            }
        }

        private void searchFilterChanged(ComplexProperty complexProperty) {
            this.changed();
        }

        @Override
        protected String getXmlElementName() {
            return this.logicalOperator.toString();
        }

        @Override
        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            this.add(SearchFilter.loadFromXml(reader));
            return true;
        }

        @Override
        public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
            for (SearchFilter searchFilter : this.searchFilters) {
                searchFilter.writeToXml(writer);
            }
        }

        @Override
        public void writeToXml(EwsServiceXmlWriter writer) throws Exception {
            if (this.getCount() == 1) {
                this.searchFilters.get(0).writeToXml(writer);
            } else {
                super.writeToXml(writer);
            }
        }

        public void add(SearchFilter searchFilter) {
            if (searchFilter == null) {
                throw new IllegalArgumentException("searchFilter");
            }
            searchFilter.addOnChangeEvent(this);
            this.searchFilters.add(searchFilter);
            this.changed();
        }

        public void addRange(Iterable<SearchFilter> searchFilters) {
            if (searchFilters == null) {
                throw new IllegalArgumentException("searchFilters");
            }
            for (SearchFilter searchFilter : searchFilters) {
                searchFilter.addOnChangeEvent(this);
                this.searchFilters.add(searchFilter);
            }
            this.changed();
        }

        public void clear() {
            if (this.getCount() > 0) {
                for (SearchFilter searchFilter : this.searchFilters) {
                    searchFilter.removeChangeEvent(this);
                }
                this.searchFilters.clear();
                this.changed();
            }
        }

        public boolean contains(SearchFilter searchFilter) {
            return this.searchFilters.contains(searchFilter);
        }

        public void remove(SearchFilter searchFilter) {
            if (searchFilter == null) {
                throw new IllegalArgumentException("searchFilter");
            }
            if (this.contains(searchFilter)) {
                searchFilter.removeChangeEvent(this);
                this.searchFilters.remove(searchFilter);
                this.changed();
            }
        }

        public void removeAt(int index) {
            if (index < 0 || index >= this.getCount()) {
                throw new IllegalArgumentException(String.format("index %d is out of range [0..%d[.", index, this.getCount()));
            }
            this.searchFilters.get(index).removeChangeEvent(this);
            this.searchFilters.remove(index);
            this.changed();
        }

        public int getCount() {
            return this.searchFilters.size();
        }

        public SearchFilter getSearchFilter(int index) {
            if (index < 0 || index >= this.getCount()) {
                throw new IllegalArgumentException(String.format("index %d is out of range [0..%d[.", index, this.getCount()));
            }
            return this.searchFilters.get(index);
        }

        public void setSearchFilter(int index, SearchFilter searchFilter) {
            if (index < 0 || index >= this.getCount()) {
                throw new IllegalArgumentException(String.format("index %d is out of range [0..%d[.", index, this.getCount()));
            }
            this.searchFilters.add(index, searchFilter);
        }

        public LogicalOperator getLogicalOperator() {
            return this.logicalOperator;
        }

        public void setLogicalOperator(LogicalOperator logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        public void complexPropertyChanged(ComplexProperty complexProperty) {
            this.searchFilterChanged(complexProperty);
        }

        @Override
        public Iterator<SearchFilter> iterator() {
            return this.searchFilters.iterator();
        }
    }

    @EditorBrowsable(state=EditorBrowsableState.Never)
    public static abstract class RelationalFilter
    extends PropertyBasedFilter {
        private PropertyDefinitionBase otherPropertyDefinition;
        private Object value;

        RelationalFilter() {
        }

        RelationalFilter(PropertyDefinitionBase propertyDefinition, PropertyDefinitionBase otherPropertyDefinition) {
            super(propertyDefinition);
            this.otherPropertyDefinition = otherPropertyDefinition;
        }

        RelationalFilter(PropertyDefinitionBase propertyDefinition, Object value) {
            super(propertyDefinition);
            this.value = value;
        }

        @Override
        protected void internalValidate() throws ServiceValidationException {
            super.internalValidate();
            if (this.otherPropertyDefinition == null && this.value == null) {
                throw new ServiceValidationException("Either the OtherPropertyDefinition or the Value property must be set.");
            }
        }

        @Override
        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            boolean result = super.tryReadElementFromXml(reader);
            if (!result && reader.getLocalName().equals("FieldURIOrConstant")) {
                try {
                    reader.read();
                    reader.ensureCurrentNodeIsStartElement();
                }
                catch (ServiceXmlDeserializationException e) {
                    LOG.error((Object)e);
                }
                catch (XMLStreamException e) {
                    LOG.error((Object)e);
                }
                if (reader.isStartElement(XmlNamespace.Types, "Constant")) {
                    this.value = reader.readAttributeValue("Value");
                    result = true;
                } else {
                    OutParam<PropertyDefinitionBase> outParam = new OutParam<PropertyDefinitionBase>();
                    outParam.setParam((Object)this.otherPropertyDefinition);
                    result = PropertyDefinitionBase.tryLoadFromXml(reader, outParam);
                }
            }
            return result;
        }

        @Override
        public void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
            super.writeElementsToXml(writer);
            writer.writeStartElement(XmlNamespace.Types, "FieldURIOrConstant");
            if (this.value != null) {
                writer.writeStartElement(XmlNamespace.Types, "Constant");
                writer.writeAttributeValue("Value", true, this.value);
                writer.writeEndElement();
            } else {
                this.otherPropertyDefinition.writeToXml(writer);
            }
            writer.writeEndElement();
        }

        public PropertyDefinitionBase getOtherPropertyDefinition() {
            return this.otherPropertyDefinition;
        }

        public void setOtherPropertyDefinition(PropertyDefinitionBase OtherPropertyDefinition) {
            this.otherPropertyDefinition = OtherPropertyDefinition;
            this.value = null;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
            this.otherPropertyDefinition = null;
        }

        @Override
        protected String getXmlElementName() {
            return null;
        }
    }

    @EditorBrowsable(state=EditorBrowsableState.Never)
    public static abstract class PropertyBasedFilter
    extends SearchFilter {
        private PropertyDefinitionBase propertyDefinition;

        PropertyBasedFilter() {
        }

        PropertyBasedFilter(PropertyDefinitionBase propertyDefinition) {
            this.propertyDefinition = propertyDefinition;
        }

        @Override
        protected void internalValidate() throws ServiceValidationException {
            if (this.propertyDefinition == null) {
                throw new ServiceValidationException("The PropertyDefinition property must be set.");
            }
        }

        @Override
        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            OutParam<PropertyDefinitionBase> outParam = new OutParam<PropertyDefinitionBase>();
            outParam.setParam((Object)this.propertyDefinition);
            return PropertyDefinitionBase.tryLoadFromXml(reader, outParam);
        }

        @Override
        public void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
            this.propertyDefinition.writeToXml(writer);
        }

        public PropertyDefinitionBase getPropertyDefinition() {
            return this.propertyDefinition;
        }

        public void setPropertyDefinition(PropertyDefinitionBase propertyDefinition) {
            this.propertyDefinition = propertyDefinition;
        }
    }

    public static class Not
    extends SearchFilter
    implements IComplexPropertyChangedDelegate {
        private SearchFilter searchFilter;

        public Not() {
        }

        public Not(SearchFilter searchFilter) {
            this.searchFilter = searchFilter;
        }

        private void searchFilterChanged(ComplexProperty complexProperty) {
            this.changed();
        }

        @Override
        protected void internalValidate() throws ServiceValidationException {
            if (this.searchFilter == null) {
                throw new ServiceValidationException("The SearchFilter property must be set.");
            }
        }

        @Override
        protected String getXmlElementName() {
            return "Not";
        }

        @Override
        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            this.searchFilter = SearchFilter.loadFromXml(reader);
            return true;
        }

        @Override
        public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
            this.searchFilter.writeToXml(writer);
        }

        public SearchFilter getSearchFilter() {
            return this.searchFilter;
        }

        public void setSearchFilter(SearchFilter searchFilter) {
            if (this.searchFilter != null) {
                this.searchFilter.removeChangeEvent(this);
            }
            if (this.canSetFieldValue(this.searchFilter, searchFilter)) {
                this.searchFilter = searchFilter;
                this.changed();
            }
            if (this.searchFilter != null) {
                this.searchFilter.addOnChangeEvent(this);
            }
        }

        public void complexPropertyChanged(ComplexProperty complexProperty) {
            this.searchFilterChanged(complexProperty);
        }
    }

    public static class IsNotEqualTo
    extends RelationalFilter {
        public IsNotEqualTo() {
        }

        public IsNotEqualTo(PropertyDefinitionBase propertyDefinition, PropertyDefinitionBase otherPropertyDefinition) {
            super(propertyDefinition, otherPropertyDefinition);
        }

        public IsNotEqualTo(PropertyDefinitionBase propertyDefinition, Object value) {
            super(propertyDefinition, value);
        }

        @Override
        protected String getXmlElementName() {
            return "IsNotEqualTo";
        }
    }

    public static class IsLessThanOrEqualTo
    extends RelationalFilter {
        public IsLessThanOrEqualTo() {
        }

        public IsLessThanOrEqualTo(PropertyDefinitionBase propertyDefinition, PropertyDefinitionBase otherPropertyDefinition) {
            super(propertyDefinition, otherPropertyDefinition);
        }

        public IsLessThanOrEqualTo(PropertyDefinitionBase propertyDefinition, Object value) {
            super(propertyDefinition, value);
        }

        @Override
        protected String getXmlElementName() {
            return "IsLessThanOrEqualTo";
        }
    }

    public static class IsLessThan
    extends RelationalFilter {
        public IsLessThan() {
        }

        public IsLessThan(PropertyDefinitionBase propertyDefinition, PropertyDefinitionBase otherPropertyDefinition) {
            super(propertyDefinition, otherPropertyDefinition);
        }

        public IsLessThan(PropertyDefinitionBase propertyDefinition, Object value) {
            super(propertyDefinition, value);
        }

        @Override
        protected String getXmlElementName() {
            return "IsLessThan";
        }
    }

    public static class IsGreaterThanOrEqualTo
    extends RelationalFilter {
        public IsGreaterThanOrEqualTo() {
        }

        public IsGreaterThanOrEqualTo(PropertyDefinitionBase propertyDefinition, PropertyDefinitionBase otherPropertyDefinition) {
            super(propertyDefinition, otherPropertyDefinition);
        }

        public IsGreaterThanOrEqualTo(PropertyDefinitionBase propertyDefinition, Object value) {
            super(propertyDefinition, value);
        }

        @Override
        protected String getXmlElementName() {
            return "IsGreaterThanOrEqualTo";
        }
    }

    public static class IsGreaterThan
    extends RelationalFilter {
        public IsGreaterThan() {
        }

        public IsGreaterThan(PropertyDefinitionBase propertyDefinition, PropertyDefinitionBase otherPropertyDefinition) {
            super(propertyDefinition, otherPropertyDefinition);
        }

        public IsGreaterThan(PropertyDefinitionBase propertyDefinition, Object value) {
            super(propertyDefinition, value);
        }

        @Override
        protected String getXmlElementName() {
            return "IsGreaterThan";
        }
    }

    public static class IsEqualTo
    extends RelationalFilter {
        public IsEqualTo() {
        }

        public IsEqualTo(PropertyDefinitionBase propertyDefinition, PropertyDefinitionBase otherPropertyDefinition) {
            super(propertyDefinition, otherPropertyDefinition);
        }

        public IsEqualTo(PropertyDefinitionBase propertyDefinition, Object value) {
            super(propertyDefinition, value);
        }

        @Override
        protected String getXmlElementName() {
            return "IsEqualTo";
        }
    }

    public static final class Exists
    extends PropertyBasedFilter {
        public Exists() {
        }

        public Exists(PropertyDefinitionBase propertyDefinition) {
            super(propertyDefinition);
        }

        @Override
        protected String getXmlElementName() {
            return "Exists";
        }
    }

    public static class ExcludesBitmask
    extends PropertyBasedFilter {
        private int bitmask;

        public ExcludesBitmask() {
        }

        public ExcludesBitmask(PropertyDefinitionBase propertyDefinition, int bitmask) {
            super(propertyDefinition);
            this.bitmask = bitmask;
        }

        @Override
        public String getXmlElementName() {
            return "Excludes";
        }

        @Override
        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            boolean result = super.tryReadElementFromXml(reader);
            if (!result && reader.getLocalName().equals("Bitmask")) {
                this.bitmask = Integer.parseInt(reader.readAttributeValue("Value"));
            }
            return result;
        }

        @Override
        public void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
            super.writeElementsToXml(writer);
            writer.writeStartElement(XmlNamespace.Types, "Bitmask");
            writer.writeAttributeValue("Value", this.bitmask);
            writer.writeEndElement();
        }

        public int getBitmask() {
            return this.bitmask;
        }

        public void setBitmask(int bitmask) {
            this.bitmask = bitmask;
        }
    }

    public static final class ContainsSubstring
    extends PropertyBasedFilter {
        private ContainmentMode containmentMode = ContainmentMode.Substring;
        private ComparisonMode comparisonMode = ComparisonMode.IgnoreCase;
        private String value;

        public ContainsSubstring() {
        }

        public ContainsSubstring(PropertyDefinitionBase propertyDefinition, String value) {
            super(propertyDefinition);
            this.value = value;
        }

        public ContainsSubstring(PropertyDefinitionBase propertyDefinition, String value, ContainmentMode containmentMode, ComparisonMode comparisonMode) {
            this(propertyDefinition, value);
            this.containmentMode = containmentMode;
            this.comparisonMode = comparisonMode;
        }

        @Override
        protected void internalValidate() throws ServiceValidationException {
            super.internalValidate();
            if (this.value == null || this.value.isEmpty()) {
                throw new ServiceValidationException("The Value property must be set.");
            }
        }

        @Override
        protected String getXmlElementName() {
            return "Contains";
        }

        @Override
        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            boolean result = super.tryReadElementFromXml(reader);
            if (!result && reader.getLocalName().equals("Constant")) {
                this.value = reader.readAttributeValue("Value");
                result = true;
            }
            return result;
        }

        @Override
        public void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
            super.readAttributesFromXml(reader);
            this.containmentMode = reader.readAttributeValue(ContainmentMode.class, "ContainmentMode");
            try {
                this.comparisonMode = reader.readAttributeValue(ComparisonMode.class, "ContainmentComparison");
            }
            catch (IllegalArgumentException ile) {
                this.comparisonMode = ComparisonMode.IgnoreCaseAndNonSpacingCharacters;
            }
        }

        @Override
        public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
            super.writeAttributesToXml(writer);
            writer.writeAttributeValue("ContainmentMode", (Object)this.containmentMode);
            writer.writeAttributeValue("ContainmentComparison", (Object)this.comparisonMode);
        }

        @Override
        public void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
            super.writeElementsToXml(writer);
            writer.writeStartElement(XmlNamespace.Types, "Constant");
            writer.writeAttributeValue("Value", this.value);
            writer.writeEndElement();
        }

        public ContainmentMode getContainmentMode() {
            return this.containmentMode;
        }

        public void setContainmentMode(ContainmentMode containmentMode) {
            this.containmentMode = containmentMode;
        }

        public ComparisonMode getComparisonMode() {
            return this.comparisonMode;
        }

        public void setComparisonMode(ComparisonMode comparisonMode) {
            this.comparisonMode = comparisonMode;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

