/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.time;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.misc.TimeSpan;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;
import microsoft.exchange.webservices.data.property.complex.time.TimeZonePeriod;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneTransition;

abstract class AbsoluteMonthTransition
extends TimeZoneTransition {
    private TimeSpan timeOffset;
    private int month;

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (super.tryReadElementFromXml(reader)) {
            return true;
        }
        if (reader.getLocalName().equals("TimeOffset")) {
            this.timeOffset = EwsUtilities.getXSDurationToTimeSpan(reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equals("Month")) {
            this.month = reader.readElementValue(Integer.class);
            EwsUtilities.ewsAssert(this.month > 0 && this.month <= 12, "AbsoluteMonthTransition.TryReadElementFromXml", "month is not in the valid 1 - 12 range.");
            return true;
        }
        return false;
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "TimeOffset", EwsUtilities.getTimeSpanToXSDuration(this.timeOffset));
        writer.writeElementValue(XmlNamespace.Types, "Month", this.month);
    }

    protected AbsoluteMonthTransition(TimeZoneDefinition timeZoneDefinition) {
        super(timeZoneDefinition);
    }

    protected AbsoluteMonthTransition(TimeZoneDefinition timeZoneDefinition, TimeZonePeriod targetPeriod) {
        super(timeZoneDefinition, targetPeriod);
    }

    protected TimeSpan getTimeOffset() {
        return this.timeOffset;
    }

    protected int getMonth() {
        return this.month;
    }
}

