/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.recurrence.range;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.recurrence.pattern.Recurrence;

public abstract class RecurrenceRange
extends ComplexProperty {
    private Date startDate;
    private Recurrence recurrence;

    protected RecurrenceRange() {
    }

    protected RecurrenceRange(Date startDate) {
        this();
        this.startDate = startDate;
    }

    @Override
    public void changed() {
        if (this.recurrence != null) {
            this.recurrence.changed();
        }
    }

    public void setupRecurrence(Recurrence recurrence) throws Exception {
        recurrence.setStartDate(this.getStartDate());
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        Date d = this.startDate;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String formattedString = df.format(d);
        writer.writeElementValue(XmlNamespace.Types, "StartDate", formattedString);
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("StartDate")) {
            Date startDate = reader.readElementValueAsUnspecifiedDate();
            if (startDate != null) {
                this.startDate = startDate;
                return true;
            }
            return false;
        }
        return false;
    }

    public abstract String getXmlElementName();

    protected Recurrence getRecurrence() {
        return this.recurrence;
    }

    protected void setRecurrence(Recurrence value) {
        this.recurrence = value;
    }

    protected Date getStartDate() {
        return this.startDate;
    }

    protected void setStartDate(Date value) {
        this.canSetFieldValue(this.startDate, value);
    }
}

