/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.util.Calendar;
import java.util.Date;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;

public final class Time {
    private int hours;
    private int minutes;
    private int seconds;

    protected Time() {
    }

    protected Time(int minutes) throws ArgumentException {
        this();
        if (minutes < 0 || minutes >= 1440) {
            throw new ArgumentException(String.format("%s,%s", "minutes must be between 0 and 1439, inclusive.", "minutes"));
        }
        this.hours = minutes / 60;
        this.minutes = minutes % 60;
        this.seconds = 0;
    }

    public Time(Date dateTime) throws ArgumentException {
        if (dateTime != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateTime);
            this.setHours(cal.get(10));
            this.setMinutes(cal.get(12));
            this.setSeconds(cal.get(13));
        }
    }

    protected Time(int hours, int minutes, int seconds) {
        this();
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public String toXSTime() {
        return String.format("%s,%s,%s,%s", "{0:00}:{1:00}:{2:00}", this.getHours(), this.getMinutes(), this.getSeconds());
    }

    protected int convertToMinutes() {
        return this.getMinutes() + this.getHours() * 60;
    }

    protected int getHours() {
        return this.hours;
    }

    protected void setHours(int value) throws ArgumentException {
        if (value < 0 || value >= 24) {
            throw new ArgumentException("Hour must be between 0 and 23.");
        }
        this.hours = value;
    }

    protected int getMinutes() {
        return this.minutes;
    }

    protected void setMinutes(int value) throws ArgumentException {
        if (value < 0 || value >= 60) {
            throw new ArgumentException("Minute must be between 0 and 59.");
        }
        this.minutes = value;
    }

    protected int getSeconds() {
        return this.seconds;
    }

    protected void setSeconds(int value) throws ArgumentException {
        if (value < 0 || value >= 60) {
            throw new ArgumentException("Second must be between 0 and 59.");
        }
        this.seconds = value;
    }
}

