/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ILazyMember;
import microsoft.exchange.webservices.data.core.LazyMember;
import microsoft.exchange.webservices.data.core.enumeration.property.MapiPropertyType;
import microsoft.exchange.webservices.data.core.exception.misc.FormatException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.misc.IFunction;
import microsoft.exchange.webservices.data.misc.IFunctions;
import microsoft.exchange.webservices.data.misc.MapiTypeConverterMap;
import microsoft.exchange.webservices.data.misc.MapiTypeConverterMapEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapiTypeConverter {
    private static final Log LOG = LogFactory.getLog(MapiTypeConverter.class);
    private static final IFunction<String, Object> DATE_TIME_PARSER = new IFunction<String, Object>(){

        @Override
        public Object func(String s) {
            return MapiTypeConverter.parseDateTime(s);
        }
    };
    private static final IFunction<String, Object> MAPI_VALUE_PARSER = new IFunction<String, Object>(){

        @Override
        public Object func(String s) {
            return MapiTypeConverter.parseMapiIntegerValue(s);
        }
    };
    private static final LazyMember<MapiTypeConverterMap> MAPI_TYPE_CONVERTER_MAP = new LazyMember<MapiTypeConverterMap>(new ILazyMember<MapiTypeConverterMap>(){

        @Override
        public MapiTypeConverterMap createInstance() {
            MapiTypeConverterMap map = new MapiTypeConverterMap();
            map.put(MapiPropertyType.ApplicationTime, new MapiTypeConverterMapEntry(Double.class));
            MapiTypeConverterMapEntry mapitype = new MapiTypeConverterMapEntry(Double.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.ApplicationTimeArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Byte[].class);
            mapitype.setParse(IFunctions.Base64Decoder.INSTANCE);
            mapitype.setConvertToString(IFunctions.Base64Encoder.INSTANCE);
            map.put(MapiPropertyType.Binary, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Byte[].class);
            mapitype.setParse(IFunctions.Base64Decoder.INSTANCE);
            mapitype.setConvertToString(IFunctions.Base64Encoder.INSTANCE);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.BinaryArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Boolean.class);
            mapitype.setParse(IFunctions.ToBoolean.INSTANCE);
            mapitype.setConvertToString(IFunctions.ToLowerCase.INSTANCE);
            map.put(MapiPropertyType.Boolean, mapitype);
            mapitype = new MapiTypeConverterMapEntry(UUID.class);
            mapitype.setParse(IFunctions.ToUUID.INSTANCE);
            mapitype.setConvertToString(IFunctions.ToString.INSTANCE);
            map.put(MapiPropertyType.CLSID, mapitype);
            mapitype = new MapiTypeConverterMapEntry(UUID.class);
            mapitype.setParse(IFunctions.ToUUID.INSTANCE);
            mapitype.setConvertToString(IFunctions.ToString.INSTANCE);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.CLSIDArray, mapitype);
            map.put(MapiPropertyType.Currency, new MapiTypeConverterMapEntry(Long.class));
            mapitype = new MapiTypeConverterMapEntry(Long.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.CurrencyArray, mapitype);
            map.put(MapiPropertyType.Double, new MapiTypeConverterMapEntry(Double.class));
            mapitype = new MapiTypeConverterMapEntry(Double.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.DoubleArray, mapitype);
            map.put(MapiPropertyType.Error, new MapiTypeConverterMapEntry(Integer.class));
            map.put(MapiPropertyType.Float, new MapiTypeConverterMapEntry(Float.class));
            mapitype = new MapiTypeConverterMapEntry(Float.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.FloatArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Integer.class);
            mapitype.setParse(MAPI_VALUE_PARSER);
            map.put(MapiPropertyType.Integer, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Integer.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.IntegerArray, mapitype);
            map.put(MapiPropertyType.Long, new MapiTypeConverterMapEntry(Long.class));
            mapitype = new MapiTypeConverterMapEntry(Long.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.LongArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(String.class);
            mapitype.setParse(IFunctions.StringToObject.INSTANCE);
            map.put(MapiPropertyType.Object, mapitype);
            mapitype = new MapiTypeConverterMapEntry(String.class);
            mapitype.setParse(IFunctions.StringToObject.INSTANCE);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.ObjectArray, mapitype);
            map.put(MapiPropertyType.Short, new MapiTypeConverterMapEntry(Short.class));
            mapitype = new MapiTypeConverterMapEntry(Short.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.ShortArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(String.class);
            mapitype.setParse(IFunctions.StringToObject.INSTANCE);
            map.put(MapiPropertyType.String, mapitype);
            mapitype = new MapiTypeConverterMapEntry(String.class);
            mapitype.setParse(IFunctions.StringToObject.INSTANCE);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.StringArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Date.class);
            mapitype.setParse(DATE_TIME_PARSER);
            mapitype.setConvertToString(IFunctions.DateTimeToXSDateTime.INSTANCE);
            map.put(MapiPropertyType.SystemTime, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Date.class);
            mapitype.setParse(DATE_TIME_PARSER);
            mapitype.setConvertToString(IFunctions.DateTimeToXSDateTime.INSTANCE);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.SystemTimeArray, mapitype);
            return map;
        }
    });

    public static List<Object> convertToValue(MapiPropertyType mapiPropType, Iterator<String> strings) throws Exception {
        EwsUtilities.validateParam(strings, "strings");
        MapiTypeConverterMapEntry typeConverter = MapiTypeConverter.getMapiTypeConverterMap().get((Object)mapiPropType);
        ArrayList<Object> array = new ArrayList<Object>();
        int index = 0;
        while (strings.hasNext()) {
            Object value = typeConverter.convertToValueOrDefault(strings.next());
            array.add(index, value);
        }
        return array;
    }

    public static Object convertToValue(MapiPropertyType mapiPropType, String stringValue) throws ServiceXmlDeserializationException, FormatException {
        return MapiTypeConverter.getMapiTypeConverterMap().get((Object)mapiPropType).convertToValue(stringValue);
    }

    public static String convertToString(MapiPropertyType mapiPropType, Object value) {
        return value == null ? "" : MapiTypeConverter.getMapiTypeConverterMap().get((Object)mapiPropType).getConvertToString().func(value);
    }

    public static Object changeType(MapiPropertyType mapiType, Object value) throws Exception {
        EwsUtilities.validateParam(value, "value");
        return MapiTypeConverter.getMapiTypeConverterMap().get((Object)mapiType).changeType(value);
    }

    protected static Object parseMapiIntegerValue(String s) {
        try {
            int intValue = Integer.parseInt(s.trim());
            return intValue;
        }
        catch (NumberFormatException e) {
            return s;
        }
    }

    public static boolean isArrayType(MapiPropertyType mapiType) {
        return MapiTypeConverter.getMapiTypeConverterMap().get((Object)mapiType).getIsArray();
    }

    public static Map<MapiPropertyType, MapiTypeConverterMapEntry> getMapiTypeConverterMap() {
        return MAPI_TYPE_CONVERTER_MAP.getMember();
    }

    private static Object parseDateTime(String s) {
        Date dt;
        String utcPattern = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        String errMsg = String.format("Date String %s not in valid UTC/local format", s);
        SimpleDateFormat utcFormatter = new SimpleDateFormat(utcPattern);
        if (s.endsWith("Z")) {
            try {
                dt = utcFormatter.parse(s);
            }
            catch (ParseException e) {
                s = s.substring(0, 10) + "T12:00:00Z";
                try {
                    dt = utcFormatter.parse(s);
                }
                catch (ParseException e1) {
                    LOG.error((Object)e);
                    throw new IllegalArgumentException(errMsg, e);
                }
            }
        } else {
            if (s.endsWith("z")) {
                utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'z'");
                try {
                    dt = utcFormatter.parse(s);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            try {
                dt = utcFormatter.parse(s);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return dt;
    }
}

