/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceObjectType;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.SyncFolderHierarchyResponse;
import microsoft.exchange.webservices.data.property.complex.FolderId;

public class SyncFolderHierarchyRequest
extends MultiResponseServiceRequest<SyncFolderHierarchyResponse> {
    private PropertySet propertySet;
    private FolderId syncFolderId;
    private String syncState;

    public SyncFolderHierarchyRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected SyncFolderHierarchyResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new SyncFolderHierarchyResponse(this.getPropertySet());
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    public String getXmlElementName() {
        return "SyncFolderHierarchy";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "SyncFolderHierarchyResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "SyncFolderHierarchyResponseMessage";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getPropertySet(), "PropertySet");
        if (this.getSyncFolderId() != null) {
            this.getSyncFolderId().validate(this.getService().getRequestedServerVersion());
        }
        this.getPropertySet().validateForRequest(this, false);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getPropertySet().writeToXml(writer, ServiceObjectType.Folder);
        if (this.getSyncFolderId() != null) {
            writer.writeStartElement(XmlNamespace.Messages, "SyncFolderId");
            this.getSyncFolderId().writeToXml(writer);
            writer.writeEndElement();
        }
        writer.writeElementValue(XmlNamespace.Messages, "SyncState", this.getSyncState());
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public void setPropertySet(PropertySet value) {
        this.propertySet = value;
    }

    public FolderId getSyncFolderId() {
        return this.syncFolderId;
    }

    public void setSyncFolderId(FolderId value) {
        this.syncFolderId = value;
    }

    public String getSyncState() {
        return this.syncState;
    }

    public void setSyncState(String value) {
        this.syncState = value;
    }
}

