/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.request.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.property.complex.availability.OofSettings;

public final class SetUserOofSettingsRequest
extends SimpleServiceRequestBase<ServiceResponse> {
    private String smtpAddress;
    private OofSettings oofSettings;

    @Override
    public String getXmlElementName() {
        return "SetUserOofSettingsRequest";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getSmtpAddress(), "SmtpAddress");
        EwsUtilities.validateParam(this.getOofSettings(), "OofSettings");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, "Mailbox");
        writer.writeElementValue(XmlNamespace.Types, "Address", this.getSmtpAddress());
        writer.writeEndElement();
        this.getOofSettings().writeToXml(writer, "UserOofSettings");
    }

    @Override
    protected String getResponseXmlElementName() {
        return "SetUserOofSettingsResponse";
    }

    @Override
    protected ServiceResponse parseResponse(EwsServiceXmlReader reader) throws Exception {
        ServiceResponse serviceResponse = new ServiceResponse();
        serviceResponse.loadFromXml(reader, "ResponseMessage");
        return serviceResponse;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public SetUserOofSettingsRequest(ExchangeService service) throws Exception {
        super(service);
    }

    public ServiceResponse execute() throws Exception {
        ServiceResponse serviceResponse = (ServiceResponse)this.internalExecute();
        serviceResponse.throwIfNecessary();
        return serviceResponse;
    }

    public String getSmtpAddress() {
        return this.smtpAddress;
    }

    public void setSmtpAddress(String smtpAddress) {
        this.smtpAddress = smtpAddress;
    }

    public OofSettings getOofSettings() {
        return this.oofSettings;
    }

    public void setOofSettings(OofSettings oofSettings) {
        this.oofSettings = oofSettings;
    }
}

