/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class DeleteRequest<TResponse extends ServiceResponse>
extends MultiResponseServiceRequest<TResponse> {
    private static final Log LOG = LogFactory.getLog(DeleteRequest.class);
    private DeleteMode deleteMode = DeleteMode.SoftDelete;

    protected DeleteRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        try {
            writer.writeAttributeValue("DeleteType", (Object)this.getDeleteMode());
        }
        catch (ServiceXmlSerializationException e) {
            LOG.error((Object)e);
        }
    }

    public DeleteMode getDeleteMode() {
        return this.deleteMode;
    }

    public void setDeleteMode(DeleteMode deleteMode) {
        this.deleteMode = deleteMode;
    }
}

