/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.security;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.util.CloudDeserializationUtil;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.gcp.storage.consumer.CreateHmacKeyConsumer;
import coldfusion.gcp.storage.consumer.DeleteHmacKeyOptionConsumer;
import coldfusion.gcp.storage.consumer.GetHmacKeyOptionConsumer;
import coldfusion.gcp.storage.consumer.ListHmacKeysOptionConsumer;
import coldfusion.gcp.storage.consumer.UpdateHmacKeyOptionConsumer;
import coldfusion.gcp.storage.exception.CFStorageException;
import coldfusion.gcp.storage.pmt.util.GCPStorageApis;
import coldfusion.gcp.storage.pmt.util.PMTUtilForGCPStorage;
import coldfusion.gcp.storage.request.CreateHmacKeyBuilder;
import coldfusion.gcp.storage.request.DeleteHmacKeyOptionBuilder;
import coldfusion.gcp.storage.request.GetHmacKeyOptionBuilder;
import coldfusion.gcp.storage.request.ListHmacKeysOptionBuilder;
import coldfusion.gcp.storage.request.UpdateHmacKeyOptionBuilder;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.Struct;
import com.google.api.gax.paging.Page;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import java.util.Map;

public class StorageHmacKey {
    private static FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.STORAGE.name());

    public static Struct getHmacKey(Storage storageClient, Map getHmacKeyOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.getHmacKey, tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            HmacKey.HmacKeyMetadata metadata;
            GetHmacKeyOptionBuilder builder = new GetHmacKeyOptionBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)builder, getHmacKeyOption, (ConsumerMap)GetHmacKeyOptionConsumer.getInstance());
            int size = builder.getHmacKeyOption().size();
            if (size > 0) {
                Storage.GetHmacKeyOption[] arr = new Storage.GetHmacKeyOption[size];
                metadata = storageClient.getHmacKey(builder.getAccessId(), builder.getHmacKeyOption().toArray(arr));
            } else {
                metadata = storageClient.getHmacKey(builder.getAccessId(), new Storage.GetHmacKeyOption[0]);
            }
            response.put((Object)"hmacKeys", (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)metadata));
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.getHmacKey, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return response;
    }

    public static Struct updateHmacKeyState(Storage storageClient, Map updateHmacKeyOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.updateHmacKeyState, tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            HmacKey.HmacKeyMetadata newMetadata;
            UpdateHmacKeyOptionBuilder builder = new UpdateHmacKeyOptionBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)builder, updateHmacKeyOption, (ConsumerMap)UpdateHmacKeyOptionConsumer.getInstance());
            HmacKey.HmacKeyMetadata hmacKeyMetadata = storageClient.getHmacKey(builder.getAccessId(), new Storage.GetHmacKeyOption[0]);
            int size = builder.updateHmacKeyOption().size();
            if (size > 0) {
                Storage.UpdateHmacKeyOption[] arr = new Storage.UpdateHmacKeyOption[size];
                newMetadata = storageClient.updateHmacKeyState(hmacKeyMetadata, builder.getHmacKeyState(), builder.updateHmacKeyOption().toArray(arr));
            } else {
                newMetadata = storageClient.updateHmacKeyState(hmacKeyMetadata, builder.getHmacKeyState(), new Storage.UpdateHmacKeyOption[0]);
            }
            response.put((Object)"hmacKeys", (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)newMetadata));
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.updateHmacKeyState, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("put", status));
        }
        return response;
    }

    public static Struct createHmacKey(Storage storageClient, Map createHmacKeyOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.createHmacKey, tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            HmacKey hmacKey;
            CreateHmacKeyBuilder builder = new CreateHmacKeyBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)builder, createHmacKeyOption, (ConsumerMap)CreateHmacKeyConsumer.getInstance());
            ServiceAccount serviceAccountEmail = ServiceAccount.of((String)builder.getServiceAccountEmail());
            int size = builder.getOption().size();
            if (size > 0) {
                Storage.CreateHmacKeyOption[] arr = new Storage.CreateHmacKeyOption[size];
                hmacKey = storageClient.createHmacKey(serviceAccountEmail, builder.getOption().toArray(arr));
            } else {
                hmacKey = storageClient.createHmacKey(serviceAccountEmail, new Storage.CreateHmacKeyOption[0]);
            }
            response = CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)hmacKey);
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.createHmacKey, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("post", status));
        }
        return response;
    }

    public static Struct deleteHmacKey(Storage storageClient, Map deleteHmacKeyOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.deleteHmacKey, tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            int size;
            DeleteHmacKeyOptionBuilder builder = new DeleteHmacKeyOptionBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)builder, deleteHmacKeyOption, (ConsumerMap)DeleteHmacKeyOptionConsumer.getInstance());
            HmacKey.HmacKeyMetadata hmacKeyMetadata = storageClient.getHmacKey(builder.getAccessId(), new Storage.GetHmacKeyOption[0]);
            if (hmacKeyMetadata.getState() != HmacKey.HmacKeyState.INACTIVE) {
                storageClient.updateHmacKeyState(hmacKeyMetadata, HmacKey.HmacKeyState.INACTIVE, new Storage.UpdateHmacKeyOption[0]);
            }
            if ((size = builder.deleteHmacKeyOption().size()) > 0) {
                Storage.DeleteHmacKeyOption[] arr = new Storage.DeleteHmacKeyOption[size];
                storageClient.deleteHmacKey(hmacKeyMetadata, builder.deleteHmacKeyOption().toArray(arr));
            } else {
                storageClient.deleteHmacKey(hmacKeyMetadata, new Storage.DeleteHmacKeyOption[0]);
            }
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.deleteHmacKey, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("delete", status));
        }
        return response;
    }

    public static Struct listHmacKeys(Storage storageClient, Map listHmacKeysOption) {
        TagAttributeList tempAttributeList = PMTUtilForGCPStorage.startGCPStorageMonitoring(GCPStorageApis.listHmacKeys, tagAttributeList);
        String status = "Success";
        Struct response = new Struct();
        try {
            ListHmacKeysOptionBuilder builder = new ListHmacKeysOptionBuilder();
            ValidatorFiller.INSTANCE.fillObject((Object)builder, listHmacKeysOption, (ConsumerMap)ListHmacKeysOptionConsumer.getInstance());
            Storage.ListHmacKeysOption[] arr = new Storage.ListHmacKeysOption[builder.getListHmacKeysOptions().size()];
            Page page = storageClient.listHmacKeys(builder.getListHmacKeysOptions().toArray(arr));
            int hmacKeyCount = 0;
            Struct hmacKeys = new Struct();
            for (HmacKey.HmacKeyMetadata metadata : page.iterateAll()) {
                hmacKeys.put((Object)(++hmacKeyCount), (Object)CloudDeserializationUtil.INSTANCE.beanToStructUsingGson((Object)metadata));
            }
            response.put((Object)"hmacKeys", (Object)hmacKeys);
            response.put((Object)"status", (Object)"Success");
        }
        catch (StorageException e) {
            status = "Failure";
            throw new CFStorageException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPStorage.endGCPStorageMonitoring(GCPStorageApis.listHmacKeys, tempAttributeList, PMTUtilForGCPStorage.getMonitoringResponseMap("get", status));
        }
        return response;
    }
}

