/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.gcp.storage.pmt.util;

import coldfusion.gcp.storage.pmt.util.GCPStorageApis;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.util.RB;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PMTUtilForGCPStorage {
    private static Logger logger = CFLogs.SERVER_LOG;

    public static TagAttributeList startGCPStorageMonitoring(GCPStorageApis name, TagAttributeList tagAttributeList) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            RequestMonitorEventProcessor.onFunctionStart((String)name.name(), null, (boolean)true);
            TagAttributeList temp = TagAttributeList.getInstance((TagAttributeList)tagAttributeList);
            return temp;
        }
        return null;
    }

    public static void endGCPStorageMonitoring(GCPStorageApis name, TagAttributeList tempAttributeList, Map<String, String> responseMap) {
        if (tempAttributeList == null) {
            return;
        }
        if (responseMap != null) {
            PMTUtilForGCPStorage.updateTagAttributeList(name, tempAttributeList, responseMap);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)name.name(), null, (List)TagAttributeList.getInstance((TagAttributeList)tempAttributeList).getTagAttributes(), (boolean)true);
    }

    private static void updateTagAttributeList(GCPStorageApis name, TagAttributeList tempAttributeList, Map<String, String> responseMap) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isCloudServiceMetrics()) {
                return;
            }
            if (responseMap.get("action") != null) {
                tempAttributeList.addTagAttribute("action", (Object)responseMap.get("action"));
            }
            if (responseMap.get("status_code") != null) {
                tempAttributeList.addTagAttribute("status_code", (Object)responseMap.get("status_code"));
            }
            if (responseMap.get("bucket") != null) {
                tempAttributeList.addTagAttribute("bucket", (Object)responseMap.get("bucket"));
            }
            if (responseMap.get("object") != null) {
                tempAttributeList.addTagAttribute("object", (Object)responseMap.get("object"));
            }
        }
        catch (Exception e) {
            logger.info((Object)RB.getString(PMTUtilForGCPStorage.class, (String)"Util.PmtMonitoringError"));
        }
    }

    public static Map<String, String> getMonitoringResponseMap(String action, String statusCode, String object) {
        Map<String, String> responseMap = PMTUtilForGCPStorage.getMonitoringResponseMap(action, statusCode);
        if (object != null) {
            responseMap.put("object", object);
        }
        return responseMap;
    }

    public static Map<String, String> getMonitoringResponseMap(String action, String statusCode) {
        HashMap<String, String> responseMap = new HashMap<String, String>();
        if (action != null) {
            responseMap.put("action", action);
        }
        if (statusCode != null) {
            responseMap.put("status_code", statusCode);
        }
        return responseMap;
    }
}

