/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Category;
import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Generator;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.feed.atom.Person;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.impl.BaseWireFeedParser;
import com.sun.syndication.io.impl.DateParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.output.XMLOutputter;

public class Atom10Parser
extends BaseWireFeedParser {
    private static final String ATOM_10_URI = "http://www.w3.org/2005/Atom";
    Namespace ns = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");
    static Pattern absoluteURIPattern = Pattern.compile("^[a-z0-9]*:.*$");

    public Atom10Parser() {
        this("atom_1.0");
    }

    protected Atom10Parser(String type) {
        super(type);
    }

    protected Namespace getAtomNamespace() {
        return this.ns;
    }

    public boolean isMyType(Document document) {
        Element rssRoot = document.getRootElement();
        Namespace defaultNS = rssRoot.getNamespace();
        return defaultNS != null && defaultNS.equals((Object)this.getAtomNamespace());
    }

    public WireFeed parse(Document document, boolean validate) throws IllegalArgumentException, FeedException {
        if (validate) {
            this.validateFeed(document);
        }
        Element rssRoot = document.getRootElement();
        return this.parseFeed(rssRoot);
    }

    protected void validateFeed(Document document) throws FeedException {
    }

    protected WireFeed parseFeed(Element eFeed) {
        List foreignMarkup;
        Element e;
        Feed feed = new Feed(this.getType());
        URL baseURI = this.findBaseURI(eFeed);
        String xmlBase = eFeed.getAttributeValue("base", Namespace.XML_NAMESPACE);
        if (xmlBase != null) {
            feed.setXmlBase(xmlBase);
        }
        if ((e = eFeed.getChild("title", this.getAtomNamespace())) != null) {
            Content title = new Content();
            title.setType(e.getAttributeValue("type"));
            title.setValue(this.parseTextConstructToString(e));
            feed.setTitle(title);
        }
        List eList = eFeed.getChildren("link", this.getAtomNamespace());
        feed.setAlternateLinks(this.parseAlternateLinks(feed, null, baseURI, eList));
        feed.setOtherLinks(this.parseOtherLinks(feed, null, baseURI, eList));
        List cList = eFeed.getChildren("category", this.getAtomNamespace());
        feed.setCategories(this.parseCategories(baseURI, cList));
        eList = eFeed.getChildren("author", this.getAtomNamespace());
        if (eList.size() > 0) {
            feed.setAuthors(this.parsePersons(baseURI, eList));
        }
        if ((eList = eFeed.getChildren("contributor", this.getAtomNamespace())).size() > 0) {
            feed.setContributors(this.parsePersons(baseURI, eList));
        }
        if ((e = eFeed.getChild("subtitle", this.getAtomNamespace())) != null) {
            Content subtitle = new Content();
            subtitle.setType(e.getAttributeValue("type"));
            subtitle.setValue(this.parseTextConstructToString(e));
            feed.setSubtitle(subtitle);
        }
        if ((e = eFeed.getChild("id", this.getAtomNamespace())) != null) {
            feed.setId(e.getText());
        }
        if ((e = eFeed.getChild("generator", this.getAtomNamespace())) != null) {
            Generator gen = new Generator();
            gen.setValue(e.getText());
            String att = e.getAttributeValue("uri");
            if (att != null) {
                gen.setUrl(att);
            }
            if ((att = e.getAttributeValue("version")) != null) {
                gen.setVersion(att);
            }
            feed.setGenerator(gen);
        }
        if ((e = eFeed.getChild("rights", this.getAtomNamespace())) != null) {
            feed.setRights(this.parseTextConstructToString(e));
        }
        if ((e = eFeed.getChild("icon", this.getAtomNamespace())) != null) {
            feed.setIcon(e.getText());
        }
        if ((e = eFeed.getChild("logo", this.getAtomNamespace())) != null) {
            feed.setLogo(e.getText());
        }
        if ((e = eFeed.getChild("updated", this.getAtomNamespace())) != null) {
            feed.setUpdated(DateParser.parseDate(e.getText()));
        }
        feed.setModules(this.parseFeedModules(eFeed));
        eList = eFeed.getChildren("entry", this.getAtomNamespace());
        if (eList.size() > 0) {
            feed.setEntries(this.parseEntries(feed, baseURI, eList));
        }
        if ((foreignMarkup = this.extractForeignMarkup(eFeed, feed, this.getAtomNamespace())).size() > 0) {
            feed.setForeignMarkup(foreignMarkup);
        }
        return feed;
    }

    private Link parseLink(Feed feed, Entry entry, URL baseURI, Element eLink) {
        Link link = new Link();
        String att = eLink.getAttributeValue("rel");
        if (att != null) {
            link.setRel(att);
        }
        if ((att = eLink.getAttributeValue("type")) != null) {
            link.setType(att);
        }
        if ((att = eLink.getAttributeValue("href")) != null) {
            if (this.isRelativeURI(att)) {
                link.setHref(this.resolveURI(baseURI, (Parent)eLink, att));
            } else {
                link.setHref(att);
            }
        }
        if ((att = eLink.getAttributeValue("title")) != null) {
            link.setTitle(att);
        }
        if ((att = eLink.getAttributeValue("hreflang")) != null) {
            link.setHreflang(att);
        }
        if ((att = eLink.getAttributeValue("length")) != null) {
            link.setLength(new Long(Long.parseLong(att)));
        }
        return link;
    }

    private List parseAlternateLinks(Feed feed, Entry entry, URL baseURI, List eLinks) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (int i = 0; i < eLinks.size(); ++i) {
            Element eLink = (Element)eLinks.get(i);
            Link link = this.parseLink(feed, entry, baseURI, eLink);
            if (link.getRel() != null && !"".equals(link.getRel().trim()) && !"alternate".equals(link.getRel())) continue;
            links.add(link);
        }
        return links.size() > 0 ? links : null;
    }

    private List parseOtherLinks(Feed feed, Entry entry, URL baseURI, List eLinks) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (int i = 0; i < eLinks.size(); ++i) {
            Element eLink = (Element)eLinks.get(i);
            Link link = this.parseLink(feed, entry, baseURI, eLink);
            String rel = link.getRel();
            if (rel == null || "alternate".equals(rel)) continue;
            links.add(link);
        }
        return links.size() > 0 ? links : null;
    }

    private Person parsePerson(URL baseURI, Element ePerson) {
        Person person = new Person();
        Element e = ePerson.getChild("name", this.getAtomNamespace());
        if (e != null) {
            person.setName(e.getText());
        }
        if ((e = ePerson.getChild("uri", this.getAtomNamespace())) != null) {
            person.setUri(this.resolveURI(baseURI, (Parent)ePerson, e.getText()));
        }
        if ((e = ePerson.getChild("email", this.getAtomNamespace())) != null) {
            person.setEmail(e.getText());
        }
        return person;
    }

    private List parsePersons(URL baseURI, List ePersons) {
        ArrayList<Person> persons = new ArrayList<Person>();
        for (int i = 0; i < ePersons.size(); ++i) {
            persons.add(this.parsePerson(baseURI, (Element)ePersons.get(i)));
        }
        return persons.size() > 0 ? persons : null;
    }

    private Content parseContent(Element e) {
        String value = this.parseTextConstructToString(e);
        String src = e.getAttributeValue("src");
        String type = e.getAttributeValue("type");
        Content content = new Content();
        content.setSrc(src);
        content.setType(type);
        content.setValue(value);
        return content;
    }

    private String parseTextConstructToString(Element e) {
        String value = null;
        String type = e.getAttributeValue("type");
        String string = type = type != null ? type : "text";
        if (type.equals("xhtml")) {
            XMLOutputter outputter = new XMLOutputter();
            List eContent = e.getContent();
            for (org.jdom.Content c : eContent) {
                Element eC;
                if (!(c instanceof Element) || !(eC = (Element)c).getNamespace().equals((Object)this.getAtomNamespace())) continue;
                ((Element)c).setNamespace(Namespace.NO_NAMESPACE);
            }
            value = outputter.outputString(eContent);
        } else {
            value = e.getText();
        }
        return value;
    }

    protected List parseEntries(Feed feed, URL baseURI, List eEntries) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = 0; i < eEntries.size(); ++i) {
            entries.add(this.parseEntry(feed, (Element)eEntries.get(i), baseURI));
        }
        return entries.size() > 0 ? entries : null;
    }

    protected Entry parseEntry(Feed feed, Element eEntry, URL baseURI) {
        Element e;
        Entry entry = new Entry();
        String xmlBase = eEntry.getAttributeValue("base", Namespace.XML_NAMESPACE);
        if (xmlBase != null) {
            entry.setXmlBase(xmlBase);
        }
        if ((e = eEntry.getChild("title", this.getAtomNamespace())) != null) {
            Content title = new Content();
            title.setType(e.getAttributeValue("type"));
            title.setValue(this.parseTextConstructToString(e));
            entry.setTitle(title);
        }
        List eList = eEntry.getChildren("link", this.getAtomNamespace());
        entry.setAlternateLinks(this.parseAlternateLinks(feed, entry, baseURI, eList));
        entry.setOtherLinks(this.parseOtherLinks(feed, entry, baseURI, eList));
        eList = eEntry.getChildren("author", this.getAtomNamespace());
        if (eList.size() > 0) {
            entry.setAuthors(this.parsePersons(baseURI, eList));
        }
        if ((eList = eEntry.getChildren("contributor", this.getAtomNamespace())).size() > 0) {
            entry.setContributors(this.parsePersons(baseURI, eList));
        }
        if ((e = eEntry.getChild("id", this.getAtomNamespace())) != null) {
            entry.setId(e.getText());
        }
        if ((e = eEntry.getChild("updated", this.getAtomNamespace())) != null) {
            entry.setUpdated(DateParser.parseDate(e.getText()));
        }
        if ((e = eEntry.getChild("published", this.getAtomNamespace())) != null) {
            entry.setPublished(DateParser.parseDate(e.getText()));
        }
        if ((e = eEntry.getChild("summary", this.getAtomNamespace())) != null) {
            entry.setSummary(this.parseContent(e));
        }
        if ((e = eEntry.getChild("content", this.getAtomNamespace())) != null) {
            ArrayList<Content> contents = new ArrayList<Content>();
            contents.add(this.parseContent(e));
            entry.setContents(contents);
        }
        if ((e = eEntry.getChild("rights", this.getAtomNamespace())) != null) {
            entry.setRights(e.getText());
        }
        List cList = eEntry.getChildren("category", this.getAtomNamespace());
        entry.setCategories(this.parseCategories(baseURI, cList));
        entry.setModules(this.parseItemModules(eEntry));
        List foreignMarkup = this.extractForeignMarkup(eEntry, entry, this.getAtomNamespace());
        if (foreignMarkup.size() > 0) {
            entry.setForeignMarkup(foreignMarkup);
        }
        return entry;
    }

    private List parseCategories(URL baseURI, List eCategories) {
        ArrayList<Category> cats = new ArrayList<Category>();
        for (int i = 0; i < eCategories.size(); ++i) {
            Element eCategory = (Element)eCategories.get(i);
            cats.add(this.parseCategory(baseURI, eCategory));
        }
        return cats.size() > 0 ? cats : null;
    }

    private Category parseCategory(URL baseURI, Element eCategory) {
        Category category = new Category();
        String att = eCategory.getAttributeValue("term");
        if (att != null) {
            category.setTerm(att);
        }
        if ((att = eCategory.getAttributeValue("scheme")) != null) {
            category.setScheme(this.resolveURI(baseURI, (Parent)eCategory, att));
        }
        if ((att = eCategory.getAttributeValue("label")) != null) {
            category.setLabel(att);
        }
        return category;
    }

    private String resolveURI(URL baseURI, Parent parent, String url) {
        String string = url = url.equals(".") || url.equals("./") ? "" : url;
        if (this.isRelativeURI(url) && parent != null && parent instanceof Element) {
            String xmlBase;
            Attribute baseAtt = ((Element)parent).getAttribute("base", Namespace.XML_NAMESPACE);
            String string2 = xmlBase = baseAtt == null ? "" : baseAtt.getValue();
            if (this.isAbsoluteURI(xmlBase) && baseURI != null) {
                String hostURI = baseURI.getProtocol() + "://" + baseURI.getHost();
                if (url.startsWith("/")) {
                    String newUrl = hostURI + url;
                    return newUrl;
                }
            }
            if (this.isAbsoluteURI(xmlBase) && !xmlBase.endsWith("/")) {
                xmlBase = xmlBase.substring(0, xmlBase.lastIndexOf("/") + 1);
            }
            if (this.isAbsoluteURI(xmlBase) && url.startsWith("..")) {
                xmlBase = xmlBase.substring(0, xmlBase.lastIndexOf("/"));
                xmlBase = xmlBase.substring(0, xmlBase.lastIndexOf("/"));
                url = url.substring(2);
                return this.resolveURI(baseURI, parent.getParent(), xmlBase + url);
            }
            return this.resolveURI(baseURI, parent.getParent(), xmlBase + url);
        }
        if (this.isRelativeURI(url) && parent == null) {
            return baseURI + url;
        }
        if (baseURI != null && url.startsWith("/")) {
            String hostURI = baseURI.getProtocol() + "://" + baseURI.getHost();
            if (baseURI.getPort() != baseURI.getDefaultPort()) {
                hostURI = hostURI + ":" + baseURI.getPort();
            }
            return hostURI + url;
        }
        return url;
    }

    private boolean isAbsoluteURI(String uri) {
        return absoluteURIPattern.matcher(uri).find();
    }

    private boolean isRelativeURI(String uri) {
        return !this.isAbsoluteURI(uri);
    }

    private URL findBaseURI(Element root) {
        URL baseURI = null;
        List linksList = root.getChildren("link", this.ns);
        if (linksList != null) {
            Element link;
            Iterator links = linksList.iterator();
            while (links.hasNext() && root.equals((Object)(link = (Element)links.next()).getParent())) {
                String href = link.getAttribute("href").getValue();
                if (link.getAttribute("rel", this.ns) != null && !link.getAttribute("rel", this.ns).getValue().equals("alternate")) continue;
                href = this.resolveURI(null, (Parent)link, href);
                try {
                    baseURI = new URL(href);
                    break;
                }
                catch (MalformedURLException e) {
                    System.err.println("Base URI is malformed: " + href);
                }
            }
        }
        return baseURI;
    }
}

