/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.TargetResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageContextBuilder {
    protected static final Log log = LogFactory.getLog(MessageContextBuilder.class);

    private static MessageContext createResponseMessageContext(MessageContext inMessageContext) throws AxisFault {
        MessageContext newmsgCtx = inMessageContext.getConfigurationContext().createMessageContext();
        newmsgCtx.setSessionContext(inMessageContext.getSessionContext());
        newmsgCtx.setTransportIn(inMessageContext.getTransportIn());
        newmsgCtx.setTransportOut(inMessageContext.getTransportOut());
        newmsgCtx.setServerSide(inMessageContext.isServerSide());
        newmsgCtx.setProperty("axis2.inMsgContext", inMessageContext);
        newmsgCtx.addRelatesTo(new RelatesTo(inMessageContext.getOptions().getMessageId()));
        newmsgCtx.setProperty("WSAddressingVersion", inMessageContext.getProperty("WSAddressingVersion"));
        newmsgCtx.setProperty("disableAddressingForOutMessages", inMessageContext.getProperty("disableAddressingForOutMessages"));
        newmsgCtx.setProperty("endpoint", inMessageContext.getProperty("endpoint"));
        newmsgCtx.setProperty("AxisBindingOperation", inMessageContext.getProperty("AxisBindingOperation"));
        newmsgCtx.setProperty("CHARACTER_SET_ENCODING", inMessageContext.getProperty("CHARACTER_SET_ENCODING"));
        newmsgCtx.setProperty("messageType", inMessageContext.getProperty("messageType"));
        newmsgCtx.setDoingREST(inMessageContext.isDoingREST());
        newmsgCtx.setOperationContext(inMessageContext.getOperationContext());
        newmsgCtx.setProperty("TRANSPORT_OUT", inMessageContext.getProperty("TRANSPORT_OUT"));
        newmsgCtx.setProperty("OutTransportInfo", inMessageContext.getProperty("OutTransportInfo"));
        MessageContextBuilder.handleCorrelationID(inMessageContext, newmsgCtx);
        return newmsgCtx;
    }

    public static MessageContext createOutMessageContext(MessageContext inMessageContext) throws AxisFault {
        AxisBindingMessage inboundAxisBindingMessage;
        AxisService axisService;
        TargetResolver targetResolver;
        MessageContext newmsgCtx = MessageContextBuilder.createResponseMessageContext(inMessageContext);
        newmsgCtx.setTo(inMessageContext.getReplyTo());
        if (newmsgCtx.getTo() == null) {
            newmsgCtx.setTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
        }
        if ((targetResolver = newmsgCtx.getConfigurationContext().getAxisConfiguration().getTargetResolverChain()) != null) {
            targetResolver.resolveTarget(newmsgCtx);
        }
        if ((axisService = inMessageContext.getAxisService()) != null && "soapsession".equals(axisService.getScope())) {
            Object version = inMessageContext.getProperty("WSAddressingVersion");
            if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(version)) {
                newmsgCtx.setReplyTo(new EndpointReference("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous"));
            } else {
                newmsgCtx.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/none"));
            }
            newmsgCtx.setMessageID(UIDGenerator.generateURNString());
            String serviceGroupContextId = inMessageContext.getServiceGroupContextId();
            if (serviceGroupContextId != null && !"".equals(serviceGroupContextId)) {
                EndpointReference replyToEPR = newmsgCtx.getReplyTo();
                replyToEPR.addReferenceParameter(new QName("http://ws.apache.org/namespaces/axis2", "ServiceGroupId", "axis2"), serviceGroupContextId);
            }
        } else {
            EndpointReference outboundToEPR = newmsgCtx.getTo();
            Object version = newmsgCtx.getProperty("WSAddressingVersion");
            if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(version) || outboundToEPR != null && !outboundToEPR.hasAnonymousAddress()) {
                newmsgCtx.setMessageID(UIDGenerator.generateURNString());
                newmsgCtx.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/none"));
            }
        }
        AxisOperation ao = inMessageContext.getAxisOperation();
        if (ao != null && ao.getOutputAction() != null) {
            newmsgCtx.setWSAAction(ao.getOutputAction());
        } else {
            newmsgCtx.setWSAAction(inMessageContext.getWSAAction());
        }
        if (ao != null) {
            newmsgCtx.setAxisMessage(ao.getMessage("Out"));
        }
        if ((inboundAxisBindingMessage = (AxisBindingMessage)inMessageContext.getProperty("AxisBindingMessage")) != null) {
            AxisBindingOperation axisBindingOperation = inboundAxisBindingMessage.getAxisBindingOperation();
            newmsgCtx.setProperty("AxisBindingMessage", axisBindingOperation.getChild("Out"));
        }
        newmsgCtx.setDoingMTOM(inMessageContext.isDoingMTOM());
        newmsgCtx.setDoingSwA(inMessageContext.isDoingSwA());
        newmsgCtx.setServiceGroupContextId(inMessageContext.getServiceGroupContextId());
        MessageContextBuilder.setupCorrectTransportOut(newmsgCtx);
        return newmsgCtx;
    }

    private static void handleCorrelationID(MessageContext inMessageContext, MessageContext outMessageContext) {
        if (inMessageContext.getIncomingTransportName() != null && inMessageContext.getIncomingTransportName().equals("jms")) {
            log.debug((Object)"Incoming Transport is JMS, lets check for JMS correlation id");
            String correlationId = (String)inMessageContext.getProperty("JMS_COORELATION_ID");
            log.debug((Object)("Correlation id is " + correlationId));
            if (correlationId != null && correlationId.length() > 0) {
                outMessageContext.setProperty("JMS_COORELATION_ID", correlationId);
            }
        }
    }

    public static MessageContext createFaultMessageContext(MessageContext processingContext, Throwable e) throws AxisFault {
        TargetResolver targetResolver;
        String faultAction;
        MessageContext faultMessageContext;
        if (processingContext.isProcessingFault()) {
            throw new AxisFault(Messages.getMessage("errorwhileProcessingFault"));
        }
        if (e instanceof AxisFault && (faultMessageContext = ((AxisFault)e).getFaultMessageContext()) != null) {
            faultMessageContext.setProperty("TRANSPORT_OUT", processingContext.getProperty("TRANSPORT_OUT"));
            faultMessageContext.setProperty("OutTransportInfo", processingContext.getProperty("OutTransportInfo"));
            faultMessageContext.setProperty("axis2.inMsgContext", processingContext);
            faultMessageContext.setProcessingFault(true);
            return faultMessageContext;
        }
        MessageContext faultContext = MessageContextBuilder.createResponseMessageContext(processingContext);
        OperationContext operationContext = processingContext.getOperationContext();
        if (operationContext != null) {
            processingContext.getAxisOperation().addFaultMessageContext(faultContext, operationContext);
        }
        faultContext.setProcessingFault(true);
        String string = faultAction = e instanceof AxisFault ? ((AxisFault)e).getFaultAction() : null;
        if (faultAction == null) {
            AxisOperation op = processingContext.getAxisOperation();
            faultAction = op != null && op.getFaultAction() != null ? op.getFaultAction() : "http://www.w3.org/2005/08/addressing/soap/fault";
        }
        faultContext.setWSAAction(faultAction);
        Object faultInfoForHeaders = processingContext.getLocalProperty("FaultHeaders");
        if (faultInfoForHeaders != null) {
            faultContext.setProperty("FaultHeaders", faultInfoForHeaders);
            faultContext.setWSAAction("http://www.w3.org/2005/08/addressing/fault");
        }
        boolean shouldSendFaultToFaultTo = AddressingHelper.shouldSendFaultToFaultTo(processingContext);
        EndpointReference faultTo = processingContext.getFaultTo();
        if (faultTo != null && shouldSendFaultToFaultTo) {
            faultContext.setTo(faultTo);
        } else {
            faultContext.setTo(processingContext.getReplyTo());
        }
        if (faultContext.getTo() == null) {
            faultContext.setTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
        }
        EndpointReference outboundToEPR = faultContext.getTo();
        Object version = faultContext.getProperty("WSAddressingVersion");
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(version) || outboundToEPR != null && !outboundToEPR.hasAnonymousAddress()) {
            faultContext.setMessageID(UIDGenerator.generateURNString());
            faultContext.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/none"));
        }
        if ((targetResolver = faultContext.getConfigurationContext().getAxisConfiguration().getTargetResolverChain()) != null) {
            targetResolver.resolveTarget(faultContext);
        }
        MessageContextBuilder.setupCorrectTransportOut(faultContext);
        SOAPEnvelope envelope = MessageContextBuilder.createFaultEnvelope(processingContext, e);
        faultContext.setEnvelope(envelope);
        List soapHeadersList = (List)processingContext.getProperty("Header");
        if (soapHeadersList != null) {
            SOAPHeader soapHeaderElement = envelope.getHeader();
            for (Object aSoapHeadersList : soapHeadersList) {
                OMElement soapHeaderBlock = (OMElement)aSoapHeadersList;
                soapHeaderElement.addChild((OMNode)soapHeaderBlock);
            }
        }
        faultContext.setProperty("HTTP_HEADERS", processingContext.getProperty("HTTP_HEADERS"));
        AxisBindingMessage inboundAxisBindingMessage = (AxisBindingMessage)processingContext.getProperty("AxisBindingMessage");
        if (inboundAxisBindingMessage != null) {
            AxisBindingOperation axisBindingOperation = inboundAxisBindingMessage.getAxisBindingOperation();
            faultContext.setProperty("AxisBindingMessage", axisBindingOperation.getChild("Out"));
        }
        return faultContext;
    }

    private static void setupCorrectTransportOut(MessageContext context) throws AxisFault {
        TransportOutDescription transportOut = context.getTransportOut();
        try {
            EndpointReference responseEPR = context.getTo();
            if (context.isServerSide() && responseEPR != null && !responseEPR.hasAnonymousAddress() && !responseEPR.hasNoneAddress()) {
                URI uri = new URI(responseEPR.getAddress());
                String scheme = uri.getScheme();
                if (transportOut == null || !transportOut.getName().equals(scheme)) {
                    ConfigurationContext configurationContext = context.getConfigurationContext();
                    transportOut = configurationContext.getAxisConfiguration().getTransportOut(scheme);
                    if (transportOut == null) {
                        throw new AxisFault("Can not find the transport sender : " + scheme);
                    }
                    context.setTransportOut(transportOut);
                }
                if (context.getOperationContext() != null) {
                    context.getOperationContext().setProperty("DIFFERENT_EPR", "true");
                }
            }
        }
        catch (URISyntaxException urise) {
            throw AxisFault.makeFault(urise);
        }
    }

    private static SOAPEnvelope createFaultEnvelope(MessageContext context, Throwable e) {
        SOAPFaultReason faultReason;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start createFaultEnvelope()");
        }
        SOAPEnvelope envelope = context.isSOAP11() ? OMAbstractFactory.getSOAP11Factory().getDefaultFaultEnvelope() : OMAbstractFactory.getSOAP12Factory().getDefaultFaultEnvelope();
        SOAPFault fault = envelope.getBody().getFault();
        SOAPProcessingException soapException = null;
        AxisFault axisFault = null;
        if (e == null) {
            return envelope;
        }
        if (e instanceof AxisFault) {
            axisFault = (AxisFault)e;
        } else if (e.getCause() instanceof AxisFault) {
            axisFault = (AxisFault)e.getCause();
        }
        if (axisFault != null) {
            ListIterator<SOAPHeaderBlock> iter = axisFault.headerIterator();
            while (iter.hasNext()) {
                SOAPHeaderBlock header = (SOAPHeaderBlock)iter.next();
                envelope.getHeader().addChild((OMNode)header);
            }
        }
        if (e instanceof SOAPProcessingException) {
            soapException = (SOAPProcessingException)e;
        } else if (axisFault != null && axisFault.getCause() instanceof SOAPProcessingException) {
            soapException = (SOAPProcessingException)axisFault.getCause();
        }
        Object faultCode = context.getProperty("Code");
        String soapFaultCode = "";
        if (faultCode != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"faultCode != null");
            }
            fault.setCode((SOAPFaultCode)faultCode);
            soapFaultCode = ((SOAPFaultCode)faultCode).getText();
        } else if (soapException != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"soapException != null");
            }
            soapFaultCode = soapException.getFaultCode();
            OMNamespace namespace = null;
            if (envelope != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"envelope!=null");
                }
                namespace = envelope.getNamespace();
            }
            if (namespace != null) {
                String sfcLocalPart = soapFaultCode.substring(soapFaultCode.lastIndexOf(":") + 1);
                if (sfcLocalPart.equals("VersionMismatch") || sfcLocalPart.equals("MustUnderstand") || sfcLocalPart.equals("DataEncodingUnknown") || sfcLocalPart.equals("") || sfcLocalPart.equals("")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("SoapFaultCode local part= " + sfcLocalPart));
                    }
                    String prefix = namespace.getPrefix() + ":";
                    soapFaultCode = !soapFaultCode.contains(":") ? prefix + soapFaultCode : prefix + soapFaultCode.substring(soapFaultCode.indexOf(":") + 1);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("SoapFaultCode reset to " + soapFaultCode));
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Namespace is null, cannot attach prefix to SOAPFaultCode");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("SoapFaultCode =" + soapFaultCode));
            }
        } else if (axisFault != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"axisFault != null");
            }
            if (axisFault.getFaultCodeElement() != null) {
                fault.setCode(axisFault.getFaultCodeElement());
                soapFaultCode = axisFault.getFaultCodeElement().getText();
            } else {
                QName faultCodeQName = axisFault.getFaultCode();
                if (faultCodeQName != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("prefix =" + faultCodeQName.getPrefix()));
                        log.debug((Object)("Fault Code namespace =" + faultCodeQName.getNamespaceURI()));
                        log.debug((Object)("Fault Code =" + faultCodeQName.getLocalPart()));
                    }
                    if (faultCodeQName.getLocalPart().indexOf(":") == -1) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"faultCodeQName.getLocalPart().indexOf(\":\") == -1");
                        }
                        String prefix = faultCodeQName.getPrefix();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("prefix = " + prefix));
                        }
                        String uri = faultCodeQName.getNamespaceURI();
                        prefix = prefix == null ? "" : prefix;
                        uri = uri == null || "".equals(uri) ? fault.getNamespace().getNamespaceURI() : uri;
                        prefix = fault.declareNamespace(uri, prefix).getPrefix();
                        soapFaultCode = prefix + ":" + faultCodeQName.getLocalPart();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Altered soapFaultCode =" + soapFaultCode));
                        }
                    } else {
                        soapFaultCode = faultCodeQName.getLocalPart();
                    }
                }
            }
        }
        if (faultCode == null && context.getEnvelope() != null) {
            String string = soapFaultCode = "".equals(soapFaultCode) || soapFaultCode == null ? "soapenv:" + context.getEnvelope().getVersion().getReceiverFaultCode().getLocalPart() : soapFaultCode;
        }
        if (faultCode == null) {
            QName name;
            SOAPFaultValue value;
            SOAPFaultCode code;
            if (log.isDebugEnabled()) {
                log.debug((Object)"faultCode == null");
            }
            if (context.isSOAP11()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"context.isSOAP11() = true");
                    code = fault != null ? fault.getCode() : null;
                    SOAPFaultValue sOAPFaultValue = value = code != null ? code.getValue() : null;
                    if (value != null) {
                        name = value.getQName();
                        log.debug((Object)("prefix =" + name.getPrefix()));
                        log.debug((Object)("Fault Code namespace =" + name.getNamespaceURI()));
                        log.debug((Object)("Fault Code =" + name.getLocalPart()));
                    }
                }
                fault.getCode().setText(soapFaultCode);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"context.isSOAP11() = false");
                    code = fault != null ? fault.getCode() : null;
                    SOAPFaultValue sOAPFaultValue = value = code != null ? code.getValue() : null;
                    if (value != null) {
                        name = value.getQName();
                        log.debug((Object)("prefix =" + name.getPrefix()));
                        log.debug((Object)("Fault Code namespace =" + name.getNamespaceURI()));
                        log.debug((Object)("Fault Code =" + name.getLocalPart()));
                    }
                }
                SOAPFaultValue value2 = fault.getCode().getValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("soapFaultCode originally was set to : " + soapFaultCode));
                }
                OMNamespace namespace = value2.getNamespace();
                soapFaultCode = MessageContextBuilder.switchNamespacePrefix(soapFaultCode, namespace);
                value2.setText(soapFaultCode);
            }
        }
        if (axisFault != null && !context.isSOAP11() && axisFault.getFaultSubCodes() != null) {
            List<QName> faultSubCodes = axisFault.getFaultSubCodes();
            Iterator<QName> i$ = faultSubCodes.iterator();
            while (i$.hasNext()) {
                QName faultSubCode;
                QName faultSubCodeQName = faultSubCode = i$.next();
                SOAPFactory sf = (SOAPFactory)envelope.getOMFactory();
                SOAPFaultSubCode soapFaultSubCode = sf.createSOAPFaultSubCode(fault.getCode());
                SOAPFaultValue saopFaultValue = sf.createSOAPFaultValue(fault.getCode());
                saopFaultValue.setText(faultSubCodeQName);
                soapFaultSubCode.setValue(saopFaultValue);
                fault.getCode().setSubCode(soapFaultSubCode);
            }
        }
        if ((faultReason = (SOAPFaultReason)context.getProperty("Reason")) == null && axisFault != null) {
            faultReason = axisFault.getFaultReasonElement();
        }
        if (faultReason != null) {
            fault.setReason(faultReason);
        } else {
            String message = "";
            if (soapException != null) {
                message = soapException.getMessage();
            } else if (axisFault != null) {
                message = axisFault.getReason();
            }
            if (message == null || "".equals(message)) {
                message = MessageContextBuilder.getFaultReasonFromException(e, context);
            }
            if (message == null || "".equals(message)) {
                message = "unknown";
            }
            if (context.isSOAP11()) {
                fault.getReason().setText(message);
            } else {
                fault.getReason().getFirstSOAPText().setLang("en-US");
                fault.getReason().getFirstSOAPText().setText(message);
            }
        }
        Object faultRole = context.getProperty("Role");
        if (faultRole != null) {
            fault.getRole().setText((String)faultRole);
        } else if (axisFault != null && axisFault.getFaultRoleElement() != null) {
            fault.setRole(axisFault.getFaultRoleElement());
        }
        Object faultNode = context.getProperty("Node");
        if (faultNode != null) {
            SOAPFaultNode soapFaultNode = fault.getNode();
            if (soapFaultNode != null) {
                soapFaultNode.setText((String)faultNode);
            }
        } else if (axisFault != null && axisFault.getFaultNodeElement() != null) {
            fault.setNode(axisFault.getFaultNodeElement());
        }
        boolean sendStacktraceDetailsWithFaults = false;
        OperationContext oc = context.getOperationContext();
        Object flagFromContext = null;
        if (oc != null) {
            flagFromContext = context.getOperationContext().getProperty("sendStacktraceDetailsWithFaults");
        }
        if (flagFromContext != null) {
            sendStacktraceDetailsWithFaults = JavaUtils.isTrue(flagFromContext);
        } else {
            Parameter param = context.getParameter("sendStacktraceDetailsWithFaults");
            if (param != null) {
                sendStacktraceDetailsWithFaults = JavaUtils.isTrue(param.getValue());
            }
        }
        Object faultDetail = context.getProperty("Detail");
        if (faultDetail != null) {
            fault.setDetail((SOAPFaultDetail)faultDetail);
        } else if (axisFault != null) {
            if (axisFault.getFaultDetailElement() != null) {
                fault.setDetail(axisFault.getFaultDetailElement());
            } else {
                OMElement detail = axisFault.getDetail();
                if (detail != null) {
                    fault.getDetail().addDetailEntry(detail);
                } else if (sendStacktraceDetailsWithFaults) {
                    fault.setException((Exception)axisFault);
                }
            }
        } else if (fault.getException() == null && sendStacktraceDetailsWithFaults) {
            if (e instanceof Exception) {
                fault.setException((Exception)e);
            } else {
                fault.setException(new Exception(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End createFaultEnvelope()");
        }
        return envelope;
    }

    public static String switchNamespacePrefix(String soapFaultCode, OMNamespace namespace) {
        if (soapFaultCode != null && soapFaultCode.endsWith(":VersionMismatch")) {
            String prefix = namespace.getPrefix();
            if (log.isDebugEnabled()) {
                log.debug((Object)("prefix being used in the outgoing soap envelope is : " + prefix));
            }
            if (!soapFaultCode.startsWith(prefix + ":")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("stripping old prefix and adding the new one - " + prefix));
                }
                int index = soapFaultCode.indexOf(58) + 1;
                soapFaultCode = soapFaultCode.substring(index);
                soapFaultCode = prefix + ":" + soapFaultCode;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("soapFaultCode is being set to : " + soapFaultCode));
        }
        return soapFaultCode;
    }

    private static String getFaultReasonFromException(Throwable e, MessageContext context) {
        boolean drillDownToRootCauseForFaultReason;
        Throwable throwable = e;
        Parameter param = context.getParameter("drillDownToRootCauseForFaultReason");
        boolean bl = drillDownToRootCauseForFaultReason = param != null && ((String)param.getValue()).equalsIgnoreCase("true");
        if (drillDownToRootCauseForFaultReason) {
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
        }
        return throwable.getMessage();
    }
}

