/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.Endpoint;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse;

public class ListEndpointsByPlatformApplicationIterable
implements SdkIterable<ListEndpointsByPlatformApplicationResponse> {
    private final SnsClient client;
    private final ListEndpointsByPlatformApplicationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEndpointsByPlatformApplicationIterable(SnsClient client, ListEndpointsByPlatformApplicationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEndpointsByPlatformApplicationResponseFetcher();
    }

    public Iterator<ListEndpointsByPlatformApplicationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Endpoint> endpoints() {
        Function<ListEndpointsByPlatformApplicationResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEndpointsByPlatformApplicationResponseFetcher
    implements SyncPageFetcher<ListEndpointsByPlatformApplicationResponse> {
        private ListEndpointsByPlatformApplicationResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointsByPlatformApplicationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEndpointsByPlatformApplicationResponse nextPage(ListEndpointsByPlatformApplicationResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointsByPlatformApplicationIterable.this.client.listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationIterable.this.firstRequest);
            }
            return ListEndpointsByPlatformApplicationIterable.this.client.listEndpointsByPlatformApplication((ListEndpointsByPlatformApplicationRequest)((Object)ListEndpointsByPlatformApplicationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

