/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.search;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.cyberneko.html.filters.ElementRemover;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HTMLParser {
    private String title = "";
    private String text = "";

    public HTMLParser(String filename) {
        try {
            DOMFragmentParser parser = new DOMFragmentParser();
            parser.setFeature("http://cyberneko.org/html/features/scanner/script/strip-comment-delims", true);
            parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
            XMLDocumentFilter[] filters = new XMLDocumentFilter[]{this.getRemover()};
            parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
            InputSource inSource = null;
            FileInputStream fin = new FileInputStream(new File(filename));
            inSource = new InputSource(fin);
            CoreDocumentImpl codeDoc = new CoreDocumentImpl();
            DocumentFragment doc = codeDoc.createDocumentFragment();
            parser.parse(inSource, doc);
            DOMParser domparser = new DOMParser();
            domparser.parse(new File(filename).toURI().toString());
            Document d = domparser.getDocument();
            if (!this.getTitle(d)) {
                this.title = "";
            }
            this.scan(doc);
        }
        catch (Exception e) {
            this.title = "";
            this.text = "";
        }
    }

    public HTMLParser(StringBuilder content) {
        try {
            DOMFragmentParser parser = new DOMFragmentParser();
            parser.setFeature("http://cyberneko.org/html/features/scanner/script/strip-comment-delims", true);
            parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
            XMLDocumentFilter[] filters = new XMLDocumentFilter[]{this.getRemover()};
            parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
            ByteArrayInputStream fin = new ByteArrayInputStream(content.toString().getBytes(StandardCharsets.UTF_8));
            InputSource inSource = null;
            inSource = new InputSource(fin);
            CoreDocumentImpl codeDoc = new CoreDocumentImpl();
            DocumentFragment doc = codeDoc.createDocumentFragment();
            parser.parse(inSource, doc);
            this.scan(doc);
        }
        catch (Exception e) {
            this.title = "";
            this.text = "";
        }
    }

    private boolean getTitle(Node node) {
        Node child;
        String name = node.getNodeName();
        if (name.equalsIgnoreCase("title") && (child = node.getFirstChild()) != null) {
            this.title = child.getNodeValue();
            return true;
        }
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                if (!this.getTitle(children.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    private ElementRemover getRemover() {
        ElementRemover remover = new ElementRemover();
        remover.acceptElement("a", new String[]{"href"});
        remover.acceptElement("link", new String[]{"href"});
        remover.acceptElement("img", new String[]{"src"});
        remover.removeElement("script");
        remover.removeElement("style");
        return remover;
    }

    private void scan(Node node) {
        Node child;
        boolean getnext = true;
        String name = node.getNodeName();
        if (name.equalsIgnoreCase("#title")) {
            child = node.getFirstChild();
            if (child != null) {
                this.title = child.getNodeValue();
            }
            getnext = false;
        } else if (name.equalsIgnoreCase("#text")) {
            this.text = this.text + " " + node.getNodeValue().trim();
        }
        child = null;
        if (getnext) {
            child = node.getFirstChild();
        }
        while (child != null) {
            this.scan(child);
            child = child.getNextSibling();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public String getSummary() {
        int summarylength = Math.min(this.text.length(), 300);
        return this.text.substring(0, summarylength);
    }
}

