/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.presentation;

import coldfusion.document.link.G2DLink;
import coldfusion.log.CFLogs;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.apache.poi.hslf.usermodel.HSLFFill;
import org.apache.poi.hslf.usermodel.HSLFFreeformShape;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSimpleShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextBox;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.StrokeStyle;
import org.apache.poi.sl.usermodel.VerticalAlignment;

public class PPGraphics2D
extends Graphics2D
implements G2DLink {
    private final HSLFGroupShape group;
    private final HSLFSlide slide;
    private final HSLFSlideShow ppt;
    private boolean underline;
    private Color foreground;
    private Color background;
    private Font font;
    private Stroke stroke;
    private Composite composite;
    private Paint paint;
    private AffineTransform transform;
    private Area clip;
    private RenderingHints hints = new RenderingHints(null);

    public PPGraphics2D(HSLFGroupShape group, HSLFSlide slide, HSLFSlideShow ppt) {
        this.group = group;
        this.slide = slide;
        this.ppt = ppt;
        this.transform = new AffineTransform();
        this.stroke = new BasicStroke();
        this.paint = Color.black;
        this.font = new Font("Arial", 0, 12);
        this.background = Color.black;
        this.foreground = Color.white;
        this.hints = new RenderingHints(null);
    }

    public HSLFGroupShape getShapeGroup() {
        return this.group;
    }

    @Override
    public void draw(Shape shape) {
        Path2D.Double path = new Path2D.Double(this.transform.createTransformedShape(shape));
        HSLFFreeformShape p = new HSLFFreeformShape((ShapeContainer)this.group);
        p.setPath((Path2D)path);
        p.getFill().setForegroundColor(null);
        this.applyStroke((HSLFSimpleShape)p);
        if (this.paint instanceof Color) {
            p.setLineColor((Color)this.paint);
        }
        this.group.addShape((HSLFShape)p);
    }

    @Override
    public void fill(Shape shape) {
        Path2D.Double path = new Path2D.Double(this.transform.createTransformedShape(shape));
        HSLFFreeformShape p = new HSLFFreeformShape((ShapeContainer)this.group);
        p.setPath((Path2D)path);
        if (this.paint instanceof Color) {
            p.setFillColor((Color)this.paint);
        }
        p.setLineColor(null);
        this.group.addShape((HSLFShape)p);
    }

    @Override
    public void setColor(Color c) {
        this.setPaint(c);
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        boolean isAntiAliased = RenderingHints.VALUE_TEXT_ANTIALIAS_ON.equals(this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
        boolean usesFractionalMetrics = RenderingHints.VALUE_FRACTIONALMETRICS_ON.equals(this.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
        return new FontRenderContext(new AffineTransform(), isAntiAliased, usesFractionalMetrics);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.hints = new RenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.hints.add(new RenderingHints(hints));
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    @Override
    public void translate(int x, int y) {
        this.transform.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.transform.concatenate(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.transform = new AffineTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void clip(Shape s) {
        if (s == null) {
            this.setClip(null);
            return;
        }
        s = this.transform.createTransformedShape(s);
        if (this.clip == null) {
            this.clip = new Area(s);
        } else {
            this.clip.intersect(new Area(s));
        }
        Path2D.Double path = new Path2D.Double(this.transform.createTransformedShape(this.clip));
        HSLFFreeformShape p = new HSLFFreeformShape((ShapeContainer)this.group);
        p.setPath((Path2D)path);
        p.getFill().setForegroundColor(null);
        p.setLineColor(null);
        this.applyStroke((HSLFSimpleShape)p);
        this.group.addShape((HSLFShape)p);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        Shape c = this.getClip();
        if (c == null) {
            return null;
        }
        return c.getBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public Shape getClip() {
        try {
            return this.transform.createInverse().createTransformedShape(this.clip);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    public void setClip(Shape s) {
        if (s != null) {
            s = this.transform.createTransformedShape(s);
        }
        if (s == null) {
            this.clip = null;
        } else {
            this.clip = new Area(s);
            Path2D.Double path = new Path2D.Double(this.transform.createTransformedShape(this.clip));
            HSLFFreeformShape p = new HSLFFreeformShape((ShapeContainer)this.group);
            p.setPath((Path2D)path);
            p.getFill().setForegroundColor(null);
            p.setLineColor(null);
            this.applyStroke((HSLFSimpleShape)p);
            this.group.addShape((HSLFShape)p);
        }
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        CFLogs.SERVER_LOG.info((Object)"copyArea() is not supported in PowerPoint presentation generation");
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Float line = new Line2D.Float(x1, y1, x2, y2);
        this.draw(line);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        this.fill(rect);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Paint paint = this.getPaint();
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(paint);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight);
        this.draw(rect);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight);
        this.fill(rect);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        Ellipse2D.Float oval = new Ellipse2D.Float(x, y, width, height);
        this.draw(oval);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        Ellipse2D.Float oval = new Ellipse2D.Float(x, y, width, height);
        this.fill(oval);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float arc = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0);
        this.draw(arc);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float arc = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2);
        this.fill(arc);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            GeneralPath path = new GeneralPath();
            path.moveTo(xPoints[0], yPoints[0]);
            for (int i = 1; i < nPoints; ++i) {
                path.lineTo(xPoints[i], yPoints[i]);
            }
            this.draw(path);
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon polygon = new Polygon(xPoints, yPoints, nPoints);
        this.draw(polygon);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon polygon = new Polygon(xPoints, yPoints, nPoints);
        this.fill(polygon);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        HSLFTextBox txt = new HSLFTextBox((ShapeContainer)this.group);
        txt.setSheet(this.group.getSheet());
        txt.setText(str);
        AffineTransform at = this.getTransform();
        AffineTransform at2 = this.getTransform();
        at2.translate(x, y);
        at2.concatenate(this.font.getTransform());
        this.setTransform(at2);
        x = (float)at2.getTranslateX();
        y = (float)at2.getTranslateY();
        HSLFTextRun rt = (HSLFTextRun)((HSLFTextParagraph)txt.getTextParagraphs().get(0)).getTextRuns().get(0);
        rt.setFontSize(Double.valueOf(this.font.getSize()));
        rt.setFontFamily(this.font.getFamily());
        if (this.getColor() != null) {
            rt.setFontColor((PaintStyle)DrawPaint.createSolidPaint((Color)this.getColor()));
        }
        if (this.font.isBold()) {
            rt.setBold(true);
        }
        if (this.font.isItalic()) {
            rt.setItalic(true);
        }
        txt.setBottomInset(0.0);
        txt.setTopInset(0.0);
        txt.setLeftInset(0.0);
        txt.setRightInset(0.0);
        txt.setWordWrap(false);
        txt.setHorizontalCentered(Boolean.valueOf(false));
        txt.setVerticalAlignment(VerticalAlignment.MIDDLE);
        TextLayout layout = new TextLayout(str, this.font, this.getFontRenderContext());
        float ascent = layout.getAscent();
        double width = 0.0;
        if (this.font.getSize() > 0) {
            float scale = 1000.0f / (float)this.font.getSize();
            Font derivedFont = this.font.deriveFont(AffineTransform.getScaleInstance(scale, scale));
            width = derivedFont.getStringBounds(str, this.getFontRenderContext()).getWidth();
            if (derivedFont.isTransformed()) {
                width /= (double)scale;
            }
        }
        float height = ascent * 2.0f;
        txt.setAnchor((Rectangle2D)new Rectangle((int)x, (int)(y -= height / 2.0f + ascent / 2.0f), (int)width, (int)height));
        this.group.addShape((HSLFShape)txt);
        this.setTransform(at);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        StringBuilder sb = new StringBuilder(iterator.getEndIndex());
        char c = iterator.first();
        while (c != '\uffff') {
            if (iterator.getIndex() == iterator.getRunStart()) {
                if (sb.length() > 0) {
                    this.drawString(sb.toString(), x, y);
                    FontMetrics fm = this.getFontMetrics();
                    x = (float)((double)x + fm.getStringBounds(sb.toString(), this).getWidth());
                    sb.delete(0, sb.length());
                }
                this.doAttributes(iterator);
            }
            sb.append(c);
            c = iterator.next();
        }
        this.drawString(sb.toString(), x, y);
        this.underline = false;
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape glyphOutline = g.getOutline(x, y);
        this.fill(glyphOutline);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        double scalex = (double)width / (double)img.getWidth(observer);
        double scaley = (double)height / (double)img.getHeight(observer);
        AffineTransform tx = AffineTransform.getTranslateInstance(x, y);
        tx.scale(scalex, scaley);
        return this.drawImage(img, null, tx, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        double dwidth = dx2 - dx1;
        double dheight = dy2 - dy1;
        double swidth = sx2 - sx1;
        double sheight = sy2 - sy1;
        if (dwidth == 0.0 || dheight == 0.0 || swidth == 0.0 || sheight == 0.0) {
            return true;
        }
        double scalex = dwidth / swidth;
        double scaley = dheight / sheight;
        double transx = (double)sx1 * scalex;
        double transy = (double)sy1 * scaley;
        AffineTransform tx = AffineTransform.getTranslateInstance((double)dx1 - transx, (double)dy1 - transy);
        tx.scale(scalex, scaley);
        BufferedImage mask = new BufferedImage(img.getWidth(observer), img.getHeight(observer), 12);
        Graphics g = mask.getGraphics();
        g.fillRect(sx1, sy1, (int)swidth, (int)sheight);
        boolean result = this.drawImage(img, mask, tx, null, observer);
        g.dispose();
        return result;
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.drawImage(img, null, xform, null, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage result = img;
        if (op != null) {
            result = op.createCompatibleDestImage(img, img.getColorModel());
            result = op.filter(img, result);
        }
        this.drawImage((Image)result, x, y, null);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        CFLogs.SERVER_LOG.info((Object)"drawRenderedImage() is not supported in PowerPoint presentation generation");
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        CFLogs.SERVER_LOG.info((Object)"drawRenderableImage() is not supported in PowerPoint presentation generation");
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return this.clip != null && this.clip.intersects(x, y, width, height);
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        Shape c = this.getClip();
        if (c == null) {
            return null;
        }
        Rectangle bounds = c.getBounds();
        r.setBounds(bounds);
        return r;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            s = this.getStroke().createStrokedShape(s);
        }
        s = this.getTransform().createTransformedShape(s);
        return s.intersects(rect);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.paint = paint;
        if (paint instanceof Color) {
            this.foreground = (Color)paint;
        }
    }

    @Override
    public void setPaintMode() {
        CFLogs.SERVER_LOG.info((Object)"setPaintMode() is not supported in PowerPoint presentation generation");
    }

    @Override
    public void setXORMode(Color c1) {
        CFLogs.SERVER_LOG.info((Object)"setXORMode() is not supported in PowerPoint presentation generation");
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public Color getColor() {
        return this.foreground;
    }

    @Override
    public Graphics create() {
        PPGraphics2D copy = new PPGraphics2D(this.group, this.slide, this.ppt);
        copy.setColor(this.getColor());
        copy.setFont(this.getFont());
        copy.setStroke(this.getStroke());
        copy.setComposite(this.getComposite());
        copy.setPaint(this.getPaint());
        copy.setTransform(this.getTransform());
        copy.setClip(this.getClip());
        copy.setRenderingHints(this.getRenderingHints());
        copy.setBackground(this.getBackground());
        copy.foreground = this.foreground;
        return copy;
    }

    protected void applyStroke(HSLFSimpleShape shape) {
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            shape.setLineWidth((double)bs.getLineWidth());
            float[] dash = bs.getDashArray();
            if (dash != null) {
                shape.setLineDash(StrokeStyle.LineDash.DASH);
            }
        }
    }

    protected void applyPaint(HSLFSimpleShape shape) {
        if (this.paint instanceof Color) {
            shape.getFill().setForegroundColor((Color)this.paint);
        }
    }

    protected void doAttributes(AttributedCharacterIterator iter) {
        this.underline = false;
        Set<AttributedCharacterIterator.Attribute> set = iter.getAttributes().keySet();
        for (AttributedCharacterIterator.Attribute attribute : set) {
            Font font;
            if (!(attribute instanceof TextAttribute)) continue;
            TextAttribute textattribute = (TextAttribute)attribute;
            if (textattribute.equals(TextAttribute.FONT)) {
                font = (Font)iter.getAttributes().get(textattribute);
                this.setFont(font);
                continue;
            }
            if (textattribute.equals(TextAttribute.UNDERLINE)) {
                if (iter.getAttributes().get(textattribute) != TextAttribute.UNDERLINE_ON) continue;
                this.underline = true;
                continue;
            }
            if (textattribute.equals(TextAttribute.SIZE)) {
                Object obj = iter.getAttributes().get(textattribute);
                if (obj instanceof Integer) {
                    int i = (Integer)obj;
                    this.setFont(this.getFont().deriveFont(this.getFont().getStyle(), i));
                    continue;
                }
                if (!(obj instanceof Float)) continue;
                float f = ((Float)obj).floatValue();
                this.setFont(this.getFont().deriveFont(this.getFont().getStyle(), f));
                continue;
            }
            if (textattribute.equals(TextAttribute.FOREGROUND)) {
                this.setColor((Color)iter.getAttributes().get(textattribute));
                continue;
            }
            if (textattribute.equals(TextAttribute.FAMILY)) {
                font = this.getFont();
                Map<TextAttribute, ?> fontAttributes = font.getAttributes();
                fontAttributes.put(TextAttribute.FAMILY, iter.getAttributes().get(textattribute));
                this.setFont(font.deriveFont(fontAttributes));
                continue;
            }
            if (textattribute.equals(TextAttribute.POSTURE)) {
                font = this.getFont();
                Map<TextAttribute, ?> fontAttributes = font.getAttributes();
                fontAttributes.put(TextAttribute.POSTURE, iter.getAttributes().get(textattribute));
                this.setFont(font.deriveFont(fontAttributes));
                continue;
            }
            if (!textattribute.equals(TextAttribute.WEIGHT)) continue;
            font = this.getFont();
            Map<TextAttribute, ?> fontAttributes = font.getAttributes();
            fontAttributes.put(TextAttribute.WEIGHT, iter.getAttributes().get(textattribute));
            this.setFont(font.deriveFont(fontAttributes));
        }
    }

    public void addLink(String resource, int linkType, AffineTransform trans, Shape s) {
    }

    public void addAltText(Shape shape, String altText) {
    }

    public void addAltText(Image image, String altText) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drawImage(Image img, Image mask, AffineTransform xform, Color bgColor, ImageObserver obs) {
        float jpegQuality = 0.95f;
        if (img != null) {
            boolean imageForBackground = this.isImageForBackground(img);
            xform = xform == null ? new AffineTransform() : new AffineTransform(xform);
            double scalex = xform.getScaleX();
            double scaley = xform.getScaleY();
            xform.translate(0.0, img.getHeight(obs));
            xform.scale(img.getWidth(obs), img.getHeight(obs));
            AffineTransform inverse = this.normalizeMatrix();
            AffineTransform flipper = AffineTransform.getScaleInstance(1.0, -1.0);
            AffineTransform at2 = this.getTransform();
            inverse.concatenate(xform);
            inverse.concatenate(flipper);
            double x = this.transform.getTranslateX();
            double y = this.transform.getTranslateY();
            x -= scalex;
            y -= scaley;
            double[] mx = new double[6];
            inverse.getMatrix(mx);
            boolean hasAlpha = this.imageHasAlpha(img);
            int colorspace = 1;
            if (hasAlpha) {
                colorspace = 2;
            }
            BufferedImage scaled = new BufferedImage(img.getWidth(null), img.getHeight(null), colorspace);
            Graphics2D g3 = scaled.createGraphics();
            g3.drawImage(img, 0, 0, img.getWidth(null), img.getHeight(null), null);
            g3.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PictureData.PictureType imagetype = PictureData.PictureType.JPEG;
            if (hasAlpha) {
                try {
                    ImageIO.write((RenderedImage)scaled, "png", baos);
                    imagetype = PictureData.PictureType.PNG;
                }
                catch (IOException iOException) {}
            } else {
                JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
                iwparam.setCompressionMode(2);
                iwparam.setCompressionQuality(jpegQuality);
                ImageWriter iw = ImageIO.getImageWritersByFormatName("jpg").next();
                ImageOutputStream ios = null;
                try {
                    ios = ImageIO.createImageOutputStream(baos);
                    iw.setOutput(ios);
                    iw.write(null, new IIOImage(scaled, null, null), iwparam);
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        iw.dispose();
                        if (ios != null) {
                            ios.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            scaled.flush();
            scaled = null;
            try {
                byte[] b = baos.toByteArray();
                HSLFPictureData pictureData = this.ppt.addPicture(b, imagetype);
                HSLFPictureShape pict = new HSLFPictureShape(pictureData);
                pict.setAnchor((Rectangle2D)new Rectangle2D.Double(x, y, mx[0], mx[3]));
                if (imageForBackground) {
                    HSLFFill fill = this.slide.getBackground().getFill();
                    fill.setFillType(3);
                    fill.setPictureData(pictureData);
                } else {
                    this.slide.addShape((HSLFShape)pict);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean imageHasAlpha(Image image) {
        boolean hasAlpha = false;
        PixelGrabber pg = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), false);
        try {
            pg.grabPixels();
            ColorModel cm = pg.getColorModel();
            hasAlpha = cm.hasAlpha();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return hasAlpha;
    }

    private strictfp boolean isImageForBackground(Image image) {
        boolean isbackground = false;
        float accelerationPriority = image.getAccelerationPriority();
        if (accelerationPriority == 0.99f) {
            image.setAccelerationPriority(0.5f);
            isbackground = true;
        }
        return isbackground;
    }

    private AffineTransform normalizeMatrix() {
        double[] mx = new double[6];
        AffineTransform result = AffineTransform.getTranslateInstance(0.0, 0.0);
        result.getMatrix(mx);
        mx[3] = -1.0;
        mx[5] = this.getShapeGroup().getAnchor().getHeight();
        result = new AffineTransform(mx);
        result.concatenate(this.transform);
        return result;
    }
}

