/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.BrowserDialog_swing;
import ice.browser.BrowserFrame_swing;
import ice.browser.CallbackImplBase;
import ice.browser.ListDialog;
import ice.browser.Main;
import ice.browser.MultiLabel;
import ice.browser.Tooltip;
import ice.ri.common.print.awt.PrintPreviewDialog;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import ice.storm.print.StormPageFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MyCallback_swing
extends CallbackImplBase
implements ActionListener,
WindowListener {
    public String okText = "Ok";
    public String cancelText = "Cancel";
    private Hashtable windows = new Hashtable();
    private JFrame frame = new JFrame("ICEbrowser (Swing)");
    private JDesktopPane desktop;
    private JButton gc;
    private JButton info;
    private JButton viewDOM;
    private JButton printBut;
    private JLabel stats;
    private StormPageFormat stormPageFormat;
    boolean reportScriptExceptions;
    static final int ACTION_CLOSE = 1;
    static final int ACTION_SET_TRUE = 2;

    public MyCallback_swing() {
        this.frame.addWindowListener(this);
        this.desktop = new JDesktopPane();
        this.info = new JButton("Info");
        this.info.addActionListener(this);
        this.viewDOM = new JButton("View DOM");
        this.viewDOM.addActionListener(this);
        this.gc = new JButton("GC");
        this.gc.addActionListener(this);
        this.printBut = new JButton("print");
        this.printBut.addActionListener(this);
        this.stats = new JLabel("press gc to update", 4);
        this.stormPageFormat = new StormPageFormat();
        JPanel p = new JPanel();
        p.add(this.info);
        p.add(this.viewDOM);
        p.add(this.printBut);
        p.add(this.gc);
        p.add(this.stats);
        Container c = this.frame.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.desktop, "Center");
        c.add((Component)p, "South");
        this.frame.setSize(Main.reqWidth, Main.reqHeight);
        this.frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.gc) {
            System.gc();
            System.gc();
            this.updateStats();
        } else if (src == this.info) {
            ListDialog d = new ListDialog((Frame)this.frame, this.base);
            d.setVisible(true);
        } else if (src == this.viewDOM) {
            this.base.renderContent("dom:icemain0", null, "dom");
        } else if (src == this.printBut) {
            Viewport view = this.base.findViewportByName("icemain0");
            PrintPreviewDialog d = new PrintPreviewDialog((Frame)this.frame, view, this.stormPageFormat);
            this.stormPageFormat = d.showDialog();
        }
    }

    private void updateStats() {
        int t1 = (int)(Runtime.getRuntime().freeMemory() >> 10);
        int t2 = (int)(Runtime.getRuntime().totalMemory() >> 10);
        int t3 = Thread.activeCount();
        String s = " mem: " + (t2 - t1) + "k/" + t2 + "k, threads: " + t3 + "  ";
        this.stats.setText(s);
    }

    public void windowClosing(WindowEvent e) {
        this.frame.setVisible(false);
        this.frame.dispose();
        Main.exit(this.base);
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }

    public Container createTopLevelContainer(Viewport viewport) {
        boolean dialogType = false;
        ViewportGuiParams params = viewport.getGuiParams();
        if (params != null) {
            dialogType = params.dialog;
        }
        if (dialogType) {
            BrowserDialog_swing f = new BrowserDialog_swing(this.base, viewport);
            this.windows.put(viewport.getId(), f);
            return f.getPanel();
        }
        BrowserFrame_swing f = new BrowserFrame_swing(this, viewport);
        f.setTooltip(new Tooltip(this.frame, this.base));
        this.desktop.add(f);
        this.desktop.moveToFront(f);
        f.setLocation(0, 0);
        f.setSize(640, 480);
        try {
            f.setMaximum(true);
        }
        catch (PropertyVetoException exception) {
            // empty catch block
        }
        f.setVisible(true);
        this.windows.put(viewport.getId(), f);
        return f.getPanel();
    }

    public void disposeTopLevelContainer(Viewport viewport) {
        Object o = this.windows.get(viewport.getId());
        if (o instanceof BrowserFrame_swing) {
            BrowserFrame_swing w = (BrowserFrame_swing)o;
            this.windows.remove(viewport.getId());
            w.setVisible(false);
            w.dispose();
        } else if (o instanceof BrowserDialog_swing) {
            BrowserDialog_swing w = (BrowserDialog_swing)o;
            this.windows.remove(viewport.getId());
            w.setVisible(false);
            w.dispose();
        }
    }

    private Frame findFrame(Viewport vp) {
        Container x = vp.getTopLevelContainer();
        if (x instanceof Frame) {
            return (Frame)x;
        }
        Viewport vp_top = null;
        Viewport vp_parent = vp.getParent();
        while (vp_parent != null) {
            vp_top = vp_parent;
            vp_parent = vp_top.getParent();
        }
        x = vp_top.getTopLevelContainer();
        if (x instanceof Frame) {
            return (Frame)x;
        }
        return null;
    }

    private JDialog createDialog(Frame top, String title) {
        JDialog dlg = new JDialog(top, title, true);
        return dlg;
    }

    private void packAndShow(JDialog d, Frame f) {
        d.pack();
        if (f != null) {
            int y;
            Point p = f.getLocation();
            Dimension fd = f.getSize();
            Dimension dd = d.getSize();
            int x = p.x + (fd.width - dd.width) / 2;
            if (x < 0) {
                x = 0;
            }
            if ((y = p.y + (fd.height - dd.height) / 2) < 0) {
                y = 0;
            }
            d.setLocation(x, y);
        }
        d.show();
        d.dispose();
    }

    void showMessage(Viewport vp, String title, String message) {
        Frame f = this.findFrame(vp);
        JDialog dlg = this.createDialog(f, title);
        JPanel body = new JPanel();
        body.add(new MultiLabel(message, 100));
        JButton btn_ok = new JButton(this.okText);
        btn_ok.addActionListener(new Action(dlg, 1, null));
        Container content = dlg.getContentPane();
        content.add((Component)body, "North");
        content.add((Component)btn_ok, "South");
        this.packAndShow(dlg, f);
    }

    boolean showConfirmation(Viewport vp, String title, String message) {
        boolean[] result = new boolean[]{false};
        Frame f = this.findFrame(vp);
        JDialog dlg = this.createDialog(f, title);
        JPanel body = new JPanel();
        body.add(new MultiLabel(message, 100));
        JButton btn_ok = new JButton(this.okText);
        btn_ok.addActionListener(new Action(dlg, 2, result));
        JButton btn_cancel = new JButton(this.cancelText);
        btn_cancel.addActionListener(new Action(dlg, 1, null));
        JPanel buttons = new JPanel();
        buttons.add(btn_ok);
        buttons.add(btn_cancel);
        Container content = dlg.getContentPane();
        content.add((Component)body, "North");
        content.add((Component)buttons, "South");
        this.packAndShow(dlg, f);
        return result[0];
    }

    String showPrompt(Viewport vp, String title, String message, String defaultValue) {
        boolean[] result = new boolean[]{false};
        Frame f = this.findFrame(vp);
        JDialog dlg = this.createDialog(f, title);
        JPanel body = new JPanel();
        body.setLayout(new GridLayout(2, 1));
        body.add(new MultiLabel(message, 100));
        JTextField text = new JTextField(defaultValue, 30);
        text.addActionListener(new Action(dlg, 2, result));
        body.add(text);
        JButton btn_ok = new JButton(this.okText);
        btn_ok.addActionListener(new Action(dlg, 2, result));
        JButton btn_cancel = new JButton(this.cancelText);
        btn_cancel.addActionListener(new Action(dlg, 1, null));
        JPanel buttons = new JPanel();
        buttons.add(btn_ok);
        buttons.add(btn_cancel);
        Container content = dlg.getContentPane();
        content.add((Component)body, "North");
        content.add((Component)buttons, "South");
        this.packAndShow(dlg, f);
        return result[0] ? text.getText() : null;
    }

    private static final class Action
    implements ActionListener {
        private JDialog dialog;
        private int actionId;
        private Object result;

        Action(JDialog dialog, int actionId, Object result) {
            this.dialog = dialog;
            this.actionId = actionId;
            this.result = result;
        }

        public void actionPerformed(ActionEvent e) {
            switch (this.actionId) {
                case 1: {
                    this.dialog.setVisible(false);
                    break;
                }
                case 2: {
                    ((boolean[])this.result)[0] = true;
                    this.dialog.setVisible(false);
                }
            }
        }
    }
}

