/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.Main;
import ice.storm.ContentLoader;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import ice.util.Defs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

class BrowserDialog
extends Dialog
implements WindowListener,
PropertyChangeListener {
    private StormBase base;
    private String viewportId;
    private Panel panel;
    private Label status;

    public BrowserDialog(StormBase b, Viewport viewport) {
        super(new Frame(), "Dialog - " + viewport.getName());
        this.base = b;
        this.viewportId = viewport.getId();
        this.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.base.addPropertyChangeListener((PropertyChangeListener)this, this.viewportId);
        Font bf = new Font("SansSerif", 0, 11);
        this.status = new Label("", 0);
        this.status.setFont(bf);
        this.status.setForeground(Color.white);
        this.status.setBackground(Color.black);
        boolean pjavaMode = Defs.sysPropertyBoolean((String)"ice.browser.pjava");
        int w = Main.reqWidth;
        int h = Main.reqHeight;
        int left = -1;
        int top = -1;
        boolean canResize = true;
        boolean showModal = false;
        boolean showStatus = true;
        ViewportGuiParams params = viewport.getGuiParams();
        if (params != null) {
            if (params.width >= 0) {
                w = params.width + 4;
            }
            if (params.height >= 0) {
                h = params.height + 28;
            }
            left = params.left;
            top = params.top;
            canResize = params.resizable;
            showModal = params.modal;
            showStatus = params.status;
        }
        if (showStatus) {
            this.add((Component)this.status, "South");
        }
        this.panel = new Panel();
        this.panel.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.panel, "Center");
        if (!pjavaMode) {
            // empty if block
        }
        this.setSize(w, h);
        if (left >= 0 && top >= 0) {
            this.setLocation(left, top);
        }
        if (!canResize) {
            this.setResizable(false);
        }
        if (showModal) {
            this.setModal(true);
        }
    }

    Panel getPanel() {
        return this.panel;
    }

    private void updateProgress(String name, int value, int total) {
        if (total > 0) {
            this.status.setText("loading " + name + " (" + value * 100 / total + "%)");
        } else {
            this.status.setText("loading " + name + " (" + value + " bytes)");
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        Viewport v = (Viewport)e.getSource();
        boolean isMyView = v.getId().equals(this.viewportId);
        String name = e.getPropertyName();
        String val = e.getNewValue().toString();
        if (isMyView && name.equals("title")) {
            this.setTitle("Dialog - " + v.getName() + " - " + val);
        } else if (name.equals("statusLine")) {
            this.status.setText(val);
        } else if (name.equals("contentLoadingProgress")) {
            try {
                int idx1 = val.indexOf(32);
                int idx2 = val.indexOf(32, idx1 + 1);
                int l = Integer.parseInt(val.substring(idx1 + 1, idx2));
                int t = Integer.parseInt(val.substring(idx2 + 1));
                this.updateProgress(val.substring(0, idx1), l, t);
            }
            catch (Exception ex) {}
        } else if (name.equals("outstandingImages")) {
            if (val.equals("0")) {
                this.status.setText("loading images: done");
            } else {
                this.status.setText("loading images: " + val + " left");
            }
        } else if (name.equals("contentLoading") && val.equals("error")) {
            ContentLoader cl = (ContentLoader)e.getOldValue();
            if (cl != null) {
                this.status.setText(v.getName() + ": " + cl.getException());
            } else {
                this.status.setText(v.getName() + ": loading error");
            }
        } else if (!name.equals("contentRendering")) {
            this.status.setText(v.getName() + ": " + name + " " + val);
        }
        if (name.equals("viewport") && !this.isShowing()) {
            this.setVisible(true);
        }
    }

    public void windowClosing(WindowEvent e) {
        this.base.closeViewport(this.viewportId);
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }
}

