/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import macromedia.jdbc.extensions.ExtDatabaseMetaData;
import macromedia.jdbc.slbase.BaseClassUtility;
import macromedia.jdbc.slbase.BaseColumn;
import macromedia.jdbc.slbase.BaseColumns;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseDriver;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplDatabaseMetaData;
import macromedia.jdbc.slbase.BaseImplResultSet;
import macromedia.jdbc.slbase.BaseResultSetFilterDescriptor;
import macromedia.jdbc.slbase.BaseResultSetSortDescriptor;
import macromedia.jdbc.slbase.BaseStatement;
import macromedia.jdbc.slbase.BaseTableTypes;
import macromedia.jdbc.slbase.BaseTypeInfos;
import macromedia.slutil.UtilResource;

public final class BaseDatabaseMetaData
implements DatabaseMetaData,
ExtDatabaseMetaData {
    protected BaseConnection connection;
    protected BaseImplDatabaseMetaData implDatabaseMetaData;
    protected BaseExceptions exceptions;

    public BaseDatabaseMetaData(BaseConnection baseConnection, BaseImplDatabaseMetaData baseImplDatabaseMetaData) throws SQLException {
        this.exceptions = baseConnection.exceptions;
        this.connection = baseConnection;
        this.implDatabaseMetaData = baseImplDatabaseMetaData;
    }

    private void validateClosedState() throws SQLException {
        if (this.connection != null && this.connection.implConnection == null) {
            this.connection = null;
        }
        if (this.connection == null) {
            throw this.exceptions.getException(6009);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allProceduresAreCallable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.allProceduresAreCallable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.ALLPROCEDURESARECALLABLE);
            }
            return this.implDatabaseMetaData.allProceduresAreCallable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allTablesAreSelectable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.allTablesAreSelectable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.ALLTABLESARESELECTABLE);
            }
            return this.implDatabaseMetaData.allTablesAreSelectable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            String string = "jdbc:datadirect:" + this.connection.driverName.toLowerCase() + ":";
            String string2 = this.connection.connectProps.get("serverName");
            if (string2 != null && string2.length() > 0) {
                string = string + "//" + string2 + ":" + this.connection.connectProps.get("portNumber");
            }
            Enumeration enumeration = this.connection.connectProps.propertyNames();
            String string3 = null;
            String string4 = null;
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                if (string3.equals("USER") || string3.equals("PASSWORD") || string3.equals("SERVERNAME") || string3.equals("PORTNUMBER")) continue;
                string4 = this.connection.connectProps.get(string3);
                if (string3.equals("XPYATTRIBUTES")) {
                    string3 = "SPYATTRIBUTES";
                }
                string = string + ";" + string3 + "=" + string4;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            return this.implDatabaseMetaData.getUserName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.isReadOnly == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.ISREADONLY);
            }
            return this.implDatabaseMetaData.isReadOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nullsAreSortedHigh() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedHigh == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.NULLSARESORTEDHIGH);
            }
            return this.implDatabaseMetaData.nullsAreSortedHigh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nullsAreSortedLow() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedLow == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.NULLSARESORTEDLOW);
            }
            return this.implDatabaseMetaData.nullsAreSortedLow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nullsAreSortedAtStart() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedAtStart == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.NULLSARESORTEDATSTART);
            }
            return this.implDatabaseMetaData.nullsAreSortedAtStart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nullsAreSortedAtEnd() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedAtEnd == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.NULLSARESORTEDATEND);
            }
            return this.implDatabaseMetaData.nullsAreSortedAtEnd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseProductName() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.databaseProductName == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.DATABASEPRODUCTNAME);
            }
            return this.implDatabaseMetaData.databaseProductName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseProductVersion() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.databaseProductVersion == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.DATABASEPRODUCTVERSION);
            }
            return this.implDatabaseMetaData.databaseProductVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDriverName() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            return this.connection.driverName;
        }
    }

    public String getDriverVersion() throws SQLException {
        String string;
        String string2 = string = "??";
        try {
            string2 = new UtilResource(this.connection.getClass(), BaseClassUtility.getRootName(this.connection).toLowerCase() + ".properties").getAsProperties().getProperty("buildid", string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.toString(this.getDriverMajorVersion()) + "." + Integer.toString(this.getDriverMinorVersion()) + "." + string2;
    }

    public int getDriverMajorVersion() {
        return BaseDatabaseMetaData.getVersionInternal("driverMajorVersion", this.connection);
    }

    public int getDriverMinorVersion() {
        return BaseDatabaseMetaData.getVersionInternal("driverMinorVersion", this.connection);
    }

    static int getVersionInternal(String string, Object object) {
        try {
            String string2 = object instanceof BaseDriver ? BaseClassUtility.getRootName((BaseDriver)object).toLowerCase() : BaseClassUtility.getRootName((BaseConnection)object).toLowerCase();
            String string3 = new UtilResource(object.getClass(), string2 + ".properties").getAsProperties().getProperty(string, "");
            if (string3.length() == 0) {
                string3 = new UtilResource(Class.forName("macromedia.jdbc.slbase.BaseDatabaseMetaData"), "base.properties").getAsProperties().getProperty(string, "");
            }
            return Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean usesLocalFiles() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.usesLocalFiles == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.USESLOCALFILES);
            }
            return this.implDatabaseMetaData.usesLocalFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean usesLocalFilePerTable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.usesLocalFilePerTable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.USESLOCALFILEPERTABLE);
            }
            return this.implDatabaseMetaData.usesLocalFilePerTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMixedCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSMIXEDCASEIDENTIFIERS);
            }
            return this.implDatabaseMetaData.supportsMixedCaseIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesUpperCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.STORESUPPERCASEIDENTIFIERS);
            }
            return this.implDatabaseMetaData.storesUpperCaseIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesLowerCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.STORESLOWERCASEIDENTIFIERS);
            }
            return this.implDatabaseMetaData.storesLowerCaseIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesMixedCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.STORESMIXEDCASEIDENTIFIERS);
            }
            return this.implDatabaseMetaData.storesMixedCaseIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMixedCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSMIXEDCASEQUOTEDIDENTIFIERS);
            }
            return this.implDatabaseMetaData.supportsMixedCaseQuotedIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesUpperCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.STORESUPPERCASEQUOTEDIDENTIFIERS);
            }
            return this.implDatabaseMetaData.storesUpperCaseQuotedIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesLowerCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.STORESLOWERCASEQUOTEDIDENTIFIERS);
            }
            return this.implDatabaseMetaData.storesLowerCaseQuotedIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesMixedCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.STORESMIXEDCASEQUOTEDIDENTIFIERS);
            }
            return this.implDatabaseMetaData.storesMixedCaseQuotedIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdentifierQuoteString() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.identifierQuoteString == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.IDENTIFIERQUOTESTRING);
            }
            return this.implDatabaseMetaData.identifierQuoteString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSQLKeywords() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.SQLKeywords == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SQLKEYWORDS);
            }
            return this.implDatabaseMetaData.SQLKeywords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNumericFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.numericFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.NUMERICFUNCTIONS);
            }
            return this.implDatabaseMetaData.numericFunctions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.stringFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.STRINGFUNCTIONS);
            }
            return this.implDatabaseMetaData.stringFunctions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSystemFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.systemFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SYSTEMFUNCTIONS);
            }
            return this.implDatabaseMetaData.systemFunctions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTimeDateFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.timeDateFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.TIMEDATEFUNCTIONS);
            }
            return this.implDatabaseMetaData.timeDateFunctions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSearchStringEscape() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.searchStringEscape == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SEARCHSTRINGESCAPE);
            }
            return this.implDatabaseMetaData.searchStringEscape;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExtraNameCharacters() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.extraNameCharacters == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.EXTRANAMECHARACTERS);
            }
            return this.implDatabaseMetaData.extraNameCharacters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsAlterTableWithAddColumn == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSALTERTABLEWITHADDCOLUMN);
            }
            return this.implDatabaseMetaData.supportsAlterTableWithAddColumn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsAlterTableWithDropColumn == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSALTERTABLEWITHDROPCOLUMN);
            }
            return this.implDatabaseMetaData.supportsAlterTableWithDropColumn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsColumnAliasing() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsColumnAliasing == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSCOLUMNALIASING);
            }
            return this.implDatabaseMetaData.supportsColumnAliasing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nullPlusNonNullIsNull() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullPlusNonNullIsNull == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.NULLPLUSNONNULLISNULL);
            }
            return this.implDatabaseMetaData.nullPlusNonNullIsNull;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsConvert() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsConvert == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSCONVERT);
            }
            return this.implDatabaseMetaData.supportsConvert;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsConvert(int n, int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            return this.implDatabaseMetaData.supportsConvert(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsTableCorrelationNames() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsTableCorrelationNames == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSTABLECORRELATIONNAMES);
            }
            return this.implDatabaseMetaData.supportsTableCorrelationNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsDifferentTableCorrelationNames == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSDIFFERENTTABLECORRELATIONNAMES);
            }
            return this.implDatabaseMetaData.supportsDifferentTableCorrelationNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsExpressionsInOrderBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSEXPRESSIONSINORDERBY);
            }
            return this.implDatabaseMetaData.supportsExpressionsInOrderBy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsOrderByUnrelated() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOrderByUnrelated == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSORDERBYUNRELATED);
            }
            return this.implDatabaseMetaData.supportsOrderByUnrelated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsGroupBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsGroupBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSGROUPBY);
            }
            return this.implDatabaseMetaData.supportsGroupBy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsGroupByUnrelated() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsGroupByUnrelated == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSGROUPBYUNRELATED);
            }
            return this.implDatabaseMetaData.supportsGroupByUnrelated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsGroupByBeyondSelect == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSGROUPBYBEYONDSELECT);
            }
            return this.implDatabaseMetaData.supportsGroupByBeyondSelect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsLikeEscapeClause() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsLikeEscapeClause == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSLIKEESCAPECLAUSE);
            }
            return this.implDatabaseMetaData.supportsLikeEscapeClause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsMultipleResultSets() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMultipleResultSets == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSMULTIPLERESULTSETS);
            }
            return this.implDatabaseMetaData.supportsMultipleResultSets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsMultipleTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMultipleTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSMULTIPLETRANSACTIONS);
            }
            return this.implDatabaseMetaData.supportsMultipleTransactions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsNonNullableColumns() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsNonNullableColumns == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSNONNULLABLECOLUMNS);
            }
            return this.implDatabaseMetaData.supportsNonNullableColumns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMinimumSQLGrammar == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSMINIMUMSQLGRAMMAR);
            }
            return this.implDatabaseMetaData.supportsMinimumSQLGrammar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsCoreSQLGrammar() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCoreSQLGrammar == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSCORESQLGRAMMAR);
            }
            return this.implDatabaseMetaData.supportsCoreSQLGrammar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsExtendedSQLGrammar == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSEXTENDEDSQLGRAMMAR);
            }
            return this.implDatabaseMetaData.supportsExtendedSQLGrammar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsANSI92EntryLevelSQL == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSANSI92ENTRYLEVELSQL);
            }
            return this.implDatabaseMetaData.supportsANSI92EntryLevelSQL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsANSI92IntermediateSQL == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSANSI92INTERMEDIATESQL);
            }
            return this.implDatabaseMetaData.supportsANSI92IntermediateSQL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsANSI92FullSQL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsANSI92FullSQL == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSANSI92FULLSQL);
            }
            return this.implDatabaseMetaData.supportsANSI92FullSQL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsIntegrityEnhancementFacility == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSINTEGRITYENHANCEMENTFACILITY);
            }
            return this.implDatabaseMetaData.supportsIntegrityEnhancementFacility;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsOuterJoins() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOuterJoins == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSOUTERJOINS);
            }
            return this.implDatabaseMetaData.supportsOuterJoins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsFullOuterJoins() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsFullOuterJoins == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSFULLOUTERJOINS);
            }
            return this.implDatabaseMetaData.supportsFullOuterJoins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsLimitedOuterJoins() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsLimitedOuterJoins == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSLIMITEDOUTERJOINS);
            }
            return this.implDatabaseMetaData.supportsLimitedOuterJoins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchemaTerm() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.schemaTerm == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SCHEMATERM);
            }
            return this.implDatabaseMetaData.schemaTerm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProcedureTerm() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.procedureTerm == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.PROCEDURETERM);
            }
            return this.implDatabaseMetaData.procedureTerm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCatalogTerm() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.catalogTerm == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.CATALOGTERM);
            }
            return this.implDatabaseMetaData.catalogTerm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCatalogAtStart() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.isCatalogAtStart == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.ISCATALOGATSTART);
            }
            return this.implDatabaseMetaData.isCatalogAtStart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCatalogSeparator() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.catalogSeparator == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.CATALOGSEPARATOR);
            }
            return this.implDatabaseMetaData.catalogSeparator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInDataManipulation == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSCHEMASINDATAMANIPULATION);
            }
            return this.implDatabaseMetaData.supportsSchemasInDataManipulation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInProcedureCalls == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSCHEMASINPROCEDURECALLS);
            }
            return this.implDatabaseMetaData.supportsSchemasInProcedureCalls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInTableDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSCHEMASINTABLEDEFINITIONS);
            }
            return this.implDatabaseMetaData.supportsSchemasInTableDefinitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInIndexDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSCHEMASININDEXDEFINITIONS);
            }
            return this.implDatabaseMetaData.supportsSchemasInIndexDefinitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInPrivilegeDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSCHEMASINPRIVILEGEDEFINITIONS);
            }
            return this.implDatabaseMetaData.supportsSchemasInPrivilegeDefinitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInDataManipulation == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSCATALOGSINDATAMANIPULATION);
            }
            return this.implDatabaseMetaData.supportsCatalogsInDataManipulation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInProcedureCalls == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSCATALOGSINPROCEDURECALLS);
            }
            return this.implDatabaseMetaData.supportsCatalogsInProcedureCalls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInTableDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSCATALOGSINTABLEDEFINITIONS);
            }
            return this.implDatabaseMetaData.supportsCatalogsInTableDefinitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInIndexDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSCATALOGSININDEXDEFINITIONS);
            }
            return this.implDatabaseMetaData.supportsCatalogsInIndexDefinitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInPrivilegeDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSCATALOGSINPRIVILEGEDEFINITIONS);
            }
            return this.implDatabaseMetaData.supportsCatalogsInPrivilegeDefinitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsPositionedDelete() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsPositionedDelete == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSPOSITIONEDDELETE);
            }
            return this.implDatabaseMetaData.supportsPositionedDelete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsPositionedUpdate() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsPositionedUpdate == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSPOSITIONEDUPDATE);
            }
            return this.implDatabaseMetaData.supportsPositionedUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSelectForUpdate() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSelectForUpdate == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSELECTFORUPDATE);
            }
            return this.implDatabaseMetaData.supportsSelectForUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsStoredProcedures() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsStoredProcedures == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSTOREDPROCEDURES);
            }
            return this.implDatabaseMetaData.supportsStoredProcedures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInComparisons == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSUBQUERIESINCOMPARISONS);
            }
            return this.implDatabaseMetaData.supportsSubqueriesInComparisons;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSubqueriesInExists() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInExists == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSUBQUERIESINEXISTS);
            }
            return this.implDatabaseMetaData.supportsSubqueriesInExists;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSubqueriesInIns() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInIns == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSUBQUERIESININS);
            }
            return this.implDatabaseMetaData.supportsSubqueriesInIns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInQuantifieds == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSUBQUERIESINQUANTIFIEDS);
            }
            return this.implDatabaseMetaData.supportsSubqueriesInQuantifieds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCorrelatedSubqueries == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSCORRELATEDSUBQUERIES);
            }
            return this.implDatabaseMetaData.supportsCorrelatedSubqueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsUnion() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsUnion == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSUNION);
            }
            return this.implDatabaseMetaData.supportsUnion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsUnionAll() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsUnionAll == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSUNIONALL);
            }
            return this.implDatabaseMetaData.supportsUnionAll;
        }
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.getResultSetHoldability() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenCursorsAcrossRollback == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSOPENCURSORSACROSSROLLBACK);
            }
            return this.implDatabaseMetaData.supportsOpenCursorsAcrossRollback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenStatementsAcrossCommit == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSOPENSTATEMENTSACROSSCOMMIT);
            }
            return this.implDatabaseMetaData.supportsOpenStatementsAcrossCommit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenStatementsAcrossRollback == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSOPENSTATEMENTSACROSSROLLBACK);
            }
            return this.implDatabaseMetaData.supportsOpenStatementsAcrossRollback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxBinaryLiteralLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxBinaryLiteralLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXBINARYLITERALLENGTH);
            }
            return this.implDatabaseMetaData.maxBinaryLiteralLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxCharLiteralLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxCharLiteralLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCHARLITERALLENGTH);
            }
            return this.implDatabaseMetaData.maxCharLiteralLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxColumnNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCOLUMNNAMELENGTH);
            }
            return this.implDatabaseMetaData.maxColumnNameLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxColumnsInGroupBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInGroupBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCOLUMNSINGROUPBY);
            }
            return this.implDatabaseMetaData.maxColumnsInGroupBy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxColumnsInIndex() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInIndex == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCOLUMNSININDEX);
            }
            return this.implDatabaseMetaData.maxColumnsInIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxColumnsInOrderBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInOrderBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCOLUMNSINORDERBY);
            }
            return this.implDatabaseMetaData.maxColumnsInOrderBy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxColumnsInSelect() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInSelect == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCOLUMNSINSELECT);
            }
            return this.implDatabaseMetaData.maxColumnsInSelect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxColumnsInTable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInTable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCOLUMNSINTABLE);
            }
            return this.implDatabaseMetaData.maxColumnsInTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxConnections() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxConnections == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCONNECTIONS);
            }
            return this.implDatabaseMetaData.maxConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxCursorNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxCursorNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCURSORNAMELENGTH);
            }
            return this.implDatabaseMetaData.maxCursorNameLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxIndexLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxIndexLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXINDEXLENGTH);
            }
            return this.implDatabaseMetaData.maxIndexLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSchemaNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxSchemaNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXSCHEMANAMELENGTH);
            }
            return this.implDatabaseMetaData.maxSchemaNameLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxProcedureNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxProcedureNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXPROCEDURENAMELENGTH);
            }
            return this.implDatabaseMetaData.maxProcedureNameLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxCatalogNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxCatalogNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCATALOGNAMELENGTH);
            }
            return this.implDatabaseMetaData.maxCatalogNameLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRowSize() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxRowSize == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXROWSIZE);
            }
            return this.implDatabaseMetaData.maxRowSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.doesMaxRowSizeIncludeBlobs == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.DOESMAXROWSIZEINCLUDEBLOBS);
            }
            return this.implDatabaseMetaData.doesMaxRowSizeIncludeBlobs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxStatementLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxStatementLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXSTATEMENTLENGTH);
            }
            return this.implDatabaseMetaData.maxStatementLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxStatements() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int n;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxStatements == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXSTATEMENTS);
            }
            if ((n = this.implDatabaseMetaData.maxStatements.intValue()) == 1) {
                n = 0;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxTableNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxTableNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXTABLENAMELENGTH);
            }
            return this.implDatabaseMetaData.maxTableNameLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxTablesInSelect() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxTablesInSelect == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXTABLESINSELECT);
            }
            return this.implDatabaseMetaData.maxTablesInSelect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxUserNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxUserNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXUSERNAMELENGTH);
            }
            return this.implDatabaseMetaData.maxUserNameLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDefaultTransactionIsolation() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.defaultTransactionIsolation == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.DEFAULTTRANSACTIONISOLATION);
            }
            return this.implDatabaseMetaData.defaultTransactionIsolation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSTRANSACTIONS);
            }
            return this.implDatabaseMetaData.supportsTransactions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            switch (n) {
                case 0: {
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelNone == null) {
                        this.implDatabaseMetaData.getClass();
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(154);
                        if (this.implDatabaseMetaData.supportsTransactionIsolationLevelNone == null) {
                            this.implDatabaseMetaData.supportsTransactionIsolationLevelNone = Boolean.FALSE;
                        }
                    }
                    return this.implDatabaseMetaData.supportsTransactionIsolationLevelNone;
                }
                case 2: {
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelReadCommited == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSTRANSACTIONISOLATIONLEVELREADCOMMITED);
                    }
                    return this.implDatabaseMetaData.supportsTransactionIsolationLevelReadCommited;
                }
                case 1: {
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelReadUncommited == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSTRANSACTIONISOLATIONLEVELREADUNCOMMITED);
                    }
                    return this.implDatabaseMetaData.supportsTransactionIsolationLevelReadUncommited;
                }
                case 4: {
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelRepeatableRead == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSTRANSACTIONISOLATIONLEVELREPEATABLEREAD);
                    }
                    return this.implDatabaseMetaData.supportsTransactionIsolationLevelRepeatableRead;
                }
                case 8: {
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelSerializable == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSTRANSACTIONISOLATIONLEVELSERIALIZABLE);
                    }
                    return this.implDatabaseMetaData.supportsTransactionIsolationLevelSerializable;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSDATADEFINITIONANDDATAMANIPULATIONTRANSACTIONS);
            }
            return this.implDatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsDataManipulationTransactionsOnly == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSDATAMANIPULATIONTRANSACTIONSONLY);
            }
            return this.implDatabaseMetaData.supportsDataManipulationTransactionsOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.dataDefinitionCausesTransactionCommit == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.DATADEFINITIONCAUSESTRANSACTIONCOMMIT);
            }
            return this.implDatabaseMetaData.dataDefinitionCausesTransactionCommit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.dataDefinitionIgnoredInTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.DATADEFINITIONIGNOREDINTRANSACTIONS);
            }
            return this.implDatabaseMetaData.dataDefinitionIgnoredInTransactions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1, 2, 3};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[]{false, true, true};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{2, 3};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(5, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_CAT";
            baseColumn.name = "PROCEDURE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_SCHEM";
            baseColumn.name = "PROCEDURE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_NAME";
            baseColumn.name = "PROCEDURE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "RESERVED_1";
            baseColumn.name = "RESERVED_1";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "RESERVED_2";
            baseColumn.name = "RESERVED_2";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "RESERVED_3";
            baseColumn.name = "RESERVED_3";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REMARKS";
            baseColumn.name = "REMARKS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "PROCEDURE_TYPE";
            baseColumn.name = "PROCEDURE_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string4, baseColumns, 5, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1, 2, 3, 4};
            Object[] objectArray = new Object[]{string, string2, string3, string4};
            boolean[] blArray = new boolean[]{false, true, true, true};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{2, 3};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string5 = this.implDatabaseMetaData.getResultSetSQL(6, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_CAT";
            baseColumn.name = "PROCEDURE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_SCHEM";
            baseColumn.name = "PROCEDURE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PROCEDURE_NAME";
            baseColumn.name = "PROCEDURE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "COLUMN_TYPE";
            baseColumn.name = "COLUMN_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "PRECISION";
            baseColumn.name = "PRECISION";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "LENGTH";
            baseColumn.name = "LENGTH";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "SCALE";
            baseColumn.name = "SCALE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "RADIX";
            baseColumn.name = "RADIX";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "NULLABLE";
            baseColumn.name = "NULLABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REMARKS";
            baseColumn.name = "REMARKS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string5, baseColumns, 6, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1, 2, 3, 4};
            Object[] objectArray = new Object[]{string, string2, string3, stringArray};
            boolean[] blArray = new boolean[]{false, true, true, false};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{4, 2, 3};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(1, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_TYPE";
            baseColumn.name = "TABLE_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REMARKS";
            baseColumn.name = "REMARKS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_CAT";
            baseColumn.name = "TYPE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_SCHEM";
            baseColumn.name = "TYPE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "SELF_REFERENCING_COL_NAME";
            baseColumn.name = "SELF_REFERENCING_COL_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REF_GENERATION";
            baseColumn.name = "REF_GENERATION";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string4, baseColumns, 1, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getSchemas() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray);
            String string = this.implDatabaseMetaData.getResultSetSQL(15, null, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CATALOG";
            baseColumn.name = "TABLE_CATALOG";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string, baseColumns, 15, null, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCatalogs() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray);
            String string = this.implDatabaseMetaData.getResultSetSQL(8, null, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string, baseColumns, 8, null, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTableTypes() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "TABLE_TYPE";
            baseColumn.name = "TABLE_TYPE";
            baseColumn.displaySize = 32;
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            BaseTableTypes baseTableTypes = this.implDatabaseMetaData.getTableTypes();
            String string = baseTableTypes != null ? null : this.implDatabaseMetaData.getResultSetSQL(4, null, null);
            return baseStatement.executeDatabaseMetaDataQuery(string, baseColumns, 4, null, null, baseTableTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1, 2, 3, 4};
            Object[] objectArray = new Object[]{string, string2, string3, string4};
            boolean[] blArray = new boolean[]{false, true, true, true};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{2, 3, 17};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "COLUMN_SIZE";
            baseColumn.name = "COLUMN_SIZE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "BUFFER_LENGTH";
            baseColumn.name = "BUFFER_LENGTH";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "DECIMAL_DIGITS";
            baseColumn.name = "DECIMAL_DIGITS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "NUM_PREC_RADIX";
            baseColumn.name = "NUM_PREC_RADIX";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "NULLABLE";
            baseColumn.name = "NULLABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REMARKS";
            baseColumn.name = "REMARKS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_DEF";
            baseColumn.name = "COLUMN_DEF";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "SQL_DATA_TYPE";
            baseColumn.name = "SQL_DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "SQL_DATETIME_SUB";
            baseColumn.name = "SQL_DATETIME_SUB";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "CHAR_OCTET_LENGTH";
            baseColumn.name = "CHAR_OCTET_LENGTH";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "ORDINAL_POSITION";
            baseColumn.name = "ORDINAL_POSITION";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "IS_NULLABLE";
            baseColumn.name = "IS_NULLABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "SCOPE_CATLOG";
            baseColumn.name = "SCOPE_CATLOG";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "SCOPE_SCHEMA";
            baseColumn.name = "SCOPE_SCHEMA";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "SCOPE_TABLE";
            baseColumn.name = "SCOPE_TABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "SOURCE_DATA_TYPE";
            baseColumn.name = "SOURCE_DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            BaseImplResultSet baseImplResultSet = this.implDatabaseMetaData.getImplResultSet(2, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            String string5 = baseImplResultSet != null ? null : this.implDatabaseMetaData.getResultSetSQL(2, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            return baseStatement.executeDatabaseMetaDataQuery(string5, baseColumns, 2, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, baseImplResultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string == null && string3 == null && string2 == null && string4 == null) {
                String[] stringArray = new String[]{"getColumnPrivileges"};
                throw this.exceptions.getException(6002, stringArray);
            }
            int[] nArray = new int[]{1, 2, 3, 4};
            Object[] objectArray = new Object[]{string, string2, string3, string4};
            boolean[] blArray = new boolean[]{false, false, false, true};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{4, 7};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string5 = this.implDatabaseMetaData.getResultSetSQL(9, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "GRANTOR";
            baseColumn.name = "GRANTOR";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "GRANTEE";
            baseColumn.name = "GRANTEE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PRIVILEGE";
            baseColumn.name = "PRIVILEGE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "IS_GRANTABLE";
            baseColumn.name = "IS_GRANTABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string5, baseColumns, 9, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{1, 2, 3};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[]{false, true, true};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{2, 3, 6};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(16, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "GRANTOR";
            baseColumn.name = "GRANTOR";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "GRANTEE";
            baseColumn.name = "GRANTEE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PRIVILEGE";
            baseColumn.name = "PRIVILEGE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "IS_GRANTABLE";
            baseColumn.name = "IS_GRANTABLE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string4, baseColumns, 16, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (n != 0 && n != 1 && n != 2 || string3 == null) {
                String[] stringArray = new String[]{"getBestRowIdentifier"};
                throw this.exceptions.getException(6002, stringArray);
            }
            int[] nArray = new int[]{9, 10, 11, 1, 12};
            Object[] objectArray = new Object[]{string, string2, string3, new Integer(n), new Boolean(bl)};
            boolean[] blArray = new boolean[]{false, false, false, false, false};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{1};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(7, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(5);
            baseColumn.label = "SCOPE";
            baseColumn.name = "SCOPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "COLUMN_SIZE";
            baseColumn.name = "COLUMN_SIZE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "BUFFER_LENGTH";
            baseColumn.name = "BUFFER_LENGTH";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DECIMAL_DIGITS";
            baseColumn.name = "DECIMAL_DIGITS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "PSEUDO_COLUMN";
            baseColumn.name = "PSEUDO_COLUMN";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            if (!baseResultSetFilterDescriptor.allRestrictionsSatified()) {
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_CAT";
                baseColumn.name = "TABLE_CAT";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_SCHEM";
                baseColumn.name = "TABLE_SCHEM";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_NAME";
                baseColumn.name = "TABLE_NAME";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
                baseColumn = new BaseColumn(-7);
                baseColumn.label = "NULLABLE";
                baseColumn.name = "NULLABLE";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
            }
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string4, baseColumns, 7, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int[] nArray = new int[]{9, 10, 11};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[]{false, false, false};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(18, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(5);
            baseColumn.label = "SCOPE";
            baseColumn.name = "SCOPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "COLUMN_SIZE";
            baseColumn.name = "COLUMN_SIZE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "BUFFER_LENGTH";
            baseColumn.name = "BUFFER_LENGTH";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DECIMAL_DIGITS";
            baseColumn.name = "DECIMAL_DIGITS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "PSEUDO_COLUMN";
            baseColumn.name = "PSEUDO_COLUMN";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            if (!baseResultSetFilterDescriptor.allRestrictionsSatified()) {
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_CAT";
                baseColumn.name = "TABLE_CAT";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_SCHEM";
                baseColumn.name = "TABLE_SCHEM";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
                baseColumn = new BaseColumn(12);
                baseColumn.label = "TABLE_NAME";
                baseColumn.name = "TABLE_NAME";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
            }
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string4, baseColumns, 18, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string == null && string3 == null && string2 == null) {
                String[] stringArray = new String[]{"getPrimaryKeys"};
                throw this.exceptions.getException(6002, stringArray);
            }
            int[] nArray = new int[]{1, 2, 3};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[]{false, false, false};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{4};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(14, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "KEY_SEQ";
            baseColumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PK_NAME";
            baseColumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string4, baseColumns, 14, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string3 == null) {
                String[] stringArray = new String[]{"getImportedKeys"};
                throw this.exceptions.getException(6002, stringArray);
            }
            int[] nArray = new int[]{5, 6, 7};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[]{false, false, false};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{1, 2, 3, 9};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(12, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_CAT";
            baseColumn.name = "PKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_SCHEM";
            baseColumn.name = "PKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_NAME";
            baseColumn.name = "PKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKCOLUMN_NAME";
            baseColumn.name = "PKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_CAT";
            baseColumn.name = "FKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_SCHEM";
            baseColumn.name = "FKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_NAME";
            baseColumn.name = "FKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKCOLUMN_NAME";
            baseColumn.name = "FKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "KEY_SEQ";
            baseColumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "UPDATE_RULE";
            baseColumn.name = "UPDATE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DELETE_RULE";
            baseColumn.name = "DELETE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FK_NAME";
            baseColumn.name = "FK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PK_NAME";
            baseColumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DEFERRABILITY";
            baseColumn.name = "DEFERRABILITY";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string4, baseColumns, 12, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string == null && string3 == null && string2 == null) {
                String[] stringArray = new String[]{"getExportedKeys"};
                throw this.exceptions.getException(6002, stringArray);
            }
            int[] nArray = new int[]{1, 2, 3};
            Object[] objectArray = new Object[]{string, string2, string3};
            boolean[] blArray = new boolean[]{false, false, false};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{5, 6, 7, 9};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(11, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_CAT";
            baseColumn.name = "PKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_SCHEM";
            baseColumn.name = "PKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_NAME";
            baseColumn.name = "PKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKCOLUMN_NAME";
            baseColumn.name = "PKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_CAT";
            baseColumn.name = "FKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_SCHEM";
            baseColumn.name = "FKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_NAME";
            baseColumn.name = "FKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKCOLUMN_NAME";
            baseColumn.name = "FKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "KEY_SEQ";
            baseColumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "UPDATE_RULE";
            baseColumn.name = "UPDATE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DELETE_RULE";
            baseColumn.name = "DELETE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FK_NAME";
            baseColumn.name = "FK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PK_NAME";
            baseColumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DEFERRABILITY";
            baseColumn.name = "DEFERRABILITY";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string4, baseColumns, 11, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string3 == null || string6 == null) {
                String[] stringArray = new String[]{"getCrossReference"};
                throw this.exceptions.getException(6002, stringArray);
            }
            int[] nArray = new int[]{1, 2, 3, 5, 6, 7};
            Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6};
            boolean[] blArray = new boolean[]{false, false, false, false, false, false};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{5, 6, 7, 9};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string7 = this.implDatabaseMetaData.getResultSetSQL(10, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_CAT";
            baseColumn.name = "PKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_SCHEM";
            baseColumn.name = "PKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKTABLE_NAME";
            baseColumn.name = "PKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PKCOLUMN_NAME";
            baseColumn.name = "PKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_CAT";
            baseColumn.name = "FKTABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_SCHEM";
            baseColumn.name = "FKTABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKTABLE_NAME";
            baseColumn.name = "FKTABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FKCOLUMN_NAME";
            baseColumn.name = "FKCOLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "KEY_SEQ";
            baseColumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "UPDATE_RULE";
            baseColumn.name = "UPDATE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DELETE_RULE";
            baseColumn.name = "DELETE_RULE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FK_NAME";
            baseColumn.name = "FK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "PK_NAME";
            baseColumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DEFERRABILITY";
            baseColumn.name = "DEFERRABILITY";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string7, baseColumns, 10, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getTypeInfo() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "PRECISION";
            baseColumn.name = "PRECISION";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "LITERAL_PREFIX";
            baseColumn.name = "LITERAL_PREFIX";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "LITERAL_SUFFIX";
            baseColumn.name = "LITERAL_SUFFIX";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "CREATE_PARAMS";
            baseColumn.name = "CREATE_PARAMS";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "NULLABLE";
            baseColumn.name = "NULLABLE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "CASE_SENSITIVE";
            baseColumn.name = "CASE_SENSITIVE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "SEARCHABLE";
            baseColumn.name = "SEARCHABLE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "UNSIGNED_ATTRIBUTE";
            baseColumn.name = "UNSIGNED_ATTRIBUTE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "FIXED_PREC_SCALE";
            baseColumn.name = "FIXED_PREC_SCALE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "AUTO_INCREMENT";
            baseColumn.name = "AUTO_INCREMENT";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "LOCAL_TYPE_NAME";
            baseColumn.name = "LOCAL_TYPE_NAME";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "MINIMUM_SCALE";
            baseColumn.name = "MINIMUM_SCALE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "MAXIMUM_SCALE";
            baseColumn.name = "MAXIMUM_SCALE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "SQL_DATA_TYPE";
            baseColumn.name = "SQL_DATA_TYPE";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "SQL_DATETIME_SUB";
            baseColumn.name = "SQL_DATETIME_SUB";
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(baseColumn);
            baseColumn.label = "NUM_PREC_RADIX";
            baseColumn.name = "NUM_PREC_RADIX";
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            BaseTypeInfos baseTypeInfos = this.implDatabaseMetaData.getTypeInfo();
            String string = baseTypeInfos != null ? null : this.implDatabaseMetaData.getResultSetSQL(3, null, null);
            return baseStatement.executeDatabaseMetaDataQuery(string, baseColumns, 3, null, null, baseTypeInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (string3 == null) {
                throw this.exceptions.getException(6045);
            }
            int[] nArray = new int[]{1, 2, 3, 4, 14};
            Object[] objectArray = new Object[]{string, string2, string3, new Boolean(bl), new Boolean(bl2)};
            boolean[] blArray = new boolean[]{false, false, false, false, false};
            BaseResultSetFilterDescriptor baseResultSetFilterDescriptor = new BaseResultSetFilterDescriptor(nArray, objectArray, blArray, this.implDatabaseMetaData.stripDoubleQuotesFromValues());
            int[] nArray2 = new int[]{4, 7, 6, 8};
            BaseResultSetSortDescriptor baseResultSetSortDescriptor = new BaseResultSetSortDescriptor(nArray2);
            String string4 = this.implDatabaseMetaData.getResultSetSQL(13, baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_CAT";
            baseColumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_SCHEM";
            baseColumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TABLE_NAME";
            baseColumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(-7);
            baseColumn.label = "NON_UNIQUE";
            baseColumn.name = "NON_UNIQUE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "INDEX_QUALIFIER";
            baseColumn.name = "INDEX_QUALIFIER";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "INDEX_NAME";
            baseColumn.name = "INDEX_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "TYPE";
            baseColumn.name = "TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "ORDINAL_POSITION";
            baseColumn.name = "ORDINAL_POSITION";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "COLUMN_NAME";
            baseColumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "ASC_OR_DESC";
            baseColumn.name = "ASC_OR_DESC";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "CARDINALITY";
            baseColumn.name = "CARDINALITY";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(4);
            baseColumn.label = "PAGES";
            baseColumn.name = "PAGES";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "FILTER_CONDITION";
            baseColumn.name = "FILTER_CONDITION";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            if (!baseResultSetFilterDescriptor.allRestrictionsSatified()) {
                baseColumn = new BaseColumn(-7);
                baseColumn.label = "APPROXIMATE";
                baseColumn.name = "APPROXIMATE";
                this.setCommonResultSetMetaData(baseColumn);
                baseColumns.add(baseColumn);
            }
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(string4, baseColumns, 13, baseResultSetFilterDescriptor, baseResultSetSortDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsResultSetType(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    bl = true;
                    break;
                }
                case 1004: {
                    bl = true;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLSENSITIVE);
                    }
                    if ((bl = this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive.booleanValue()) || !this.connection.implConnection.supportsRowId()) break;
                    bl = true;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"supportsResultSetType"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: 
                case 1004: 
                case 1005: {
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"supportsResultSetConcurrency"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            switch (n2) {
                case 1007: 
                case 1008: {
                    bl = this.supportsResultSetType(n);
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"supportsResultSetConcurrency"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: 
                case 1004: {
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLSENSITIVE);
                    }
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive.booleanValue()) {
                        if (this.implDatabaseMetaData.ownUpdatesAreVisibleScrollSensitive == null) {
                            this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OWNUPDATESAREVISIBLESCROLLSENSITIVE);
                        }
                        bl = this.implDatabaseMetaData.ownUpdatesAreVisibleScrollSensitive;
                        break;
                    }
                    if (!this.connection.implConnection.supportsRowId()) break;
                    bl = true;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"ownUpdatesAreVisible"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: 
                case 1004: {
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLSENSITIVE);
                    }
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive.booleanValue()) {
                        if (this.implDatabaseMetaData.ownDeletesAreVisibleScrollSensitive == null) {
                            this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OWNDELETESAREVISIBLESCROLLSENSITIVE);
                        }
                        bl = this.implDatabaseMetaData.ownDeletesAreVisibleScrollSensitive;
                        break;
                    }
                    if (!this.connection.implConnection.supportsRowId()) break;
                    bl = true;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"ownDeletesAreVisible"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: 
                case 1004: {
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLSENSITIVE);
                    }
                    if (!this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive.booleanValue()) break;
                    if (this.implDatabaseMetaData.ownInsertsAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OWNINSERTSAREVISIBLESCROLLSENSITIVE);
                    }
                    bl = this.implDatabaseMetaData.ownInsertsAreVisibleScrollSensitive;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"ownInsertsAreVisible"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.othersUpdatesAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OTHERSUPDATESAREVISIBLEFORWARDONLY);
                    }
                    bl = this.implDatabaseMetaData.othersUpdatesAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLINSENSITIVE);
                    }
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollInsensitive.booleanValue()) {
                        if (this.implDatabaseMetaData.othersUpdatesAreVisibleScrollInsensitive == null) {
                            this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OTHERSUPDATESAREVISIBLESCROLLINSENSITIVE);
                        }
                        bl = this.implDatabaseMetaData.othersUpdatesAreVisibleScrollInsensitive;
                        break;
                    }
                    bl = this.othersUpdatesAreVisible(1003);
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLSENSITIVE);
                    }
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive.booleanValue()) {
                        if (this.implDatabaseMetaData.othersUpdatesAreVisibleScrollInsensitive == null) {
                            this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OTHERSUPDATESAREVISIBLESCROLLSENSITIVE);
                        }
                        bl = this.implDatabaseMetaData.othersUpdatesAreVisibleScrollSensitive;
                        break;
                    }
                    if (!this.connection.implConnection.supportsRowId()) break;
                    bl = true;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"othersUpdatesAreVisible"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.othersDeletesAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OTHERSDELETESAREVISIBLEFORWARDONLY);
                    }
                    bl = this.implDatabaseMetaData.othersDeletesAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLINSENSITIVE);
                    }
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollInsensitive.booleanValue()) {
                        if (this.implDatabaseMetaData.othersDeletesAreVisibleScrollInsensitive == null) {
                            this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OTHERSDELETESAREVISIBLESCROLLINSENSITIVE);
                        }
                        bl = this.implDatabaseMetaData.othersDeletesAreVisibleScrollInsensitive;
                        break;
                    }
                    bl = this.othersDeletesAreVisible(1003);
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLSENSITIVE);
                    }
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive.booleanValue()) {
                        if (this.implDatabaseMetaData.othersDeletesAreVisibleScrollInsensitive == null) {
                            this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OTHERSDELETESAREVISIBLESCROLLSENSITIVE);
                        }
                        bl = this.implDatabaseMetaData.othersDeletesAreVisibleScrollSensitive;
                        break;
                    }
                    if (!this.connection.implConnection.supportsRowId()) break;
                    bl = true;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"othersDeletesAreVisible"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: {
                    if (this.implDatabaseMetaData.othersInsertsAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OTHERSINSERTSAREVISIBLEFORWARDONLY);
                    }
                    bl = this.implDatabaseMetaData.othersInsertsAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLINSENSITIVE);
                    }
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollInsensitive.booleanValue()) {
                        if (this.implDatabaseMetaData.othersInsertsAreVisibleScrollInsensitive == null) {
                            this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OTHERSINSERTSAREVISIBLESCROLLINSENSITIVE);
                        }
                        bl = this.implDatabaseMetaData.othersInsertsAreVisibleScrollInsensitive;
                        break;
                    }
                    bl = this.othersInsertsAreVisible(1003);
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLSENSITIVE);
                    }
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive.booleanValue()) {
                        if (this.implDatabaseMetaData.othersInsertsAreVisibleScrollInsensitive == null) {
                            this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.OTHERSINSERTSAREVISIBLESCROLLSENSITIVE);
                        }
                        bl = this.implDatabaseMetaData.othersInsertsAreVisibleScrollSensitive;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"othersInsertsAreVisible"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatesAreDetected(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: 
                case 1004: 
                case 1005: {
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"updatesAreDetected"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deletesAreDetected(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: 
                case 1004: {
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSRESULTSETTYPESCROLLSENSITIVE);
                    }
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive.booleanValue()) {
                        if (this.implDatabaseMetaData.deletesAreDetectedScrollSensitive == null) {
                            this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.DELETESAREDETECTEDSCROLLSENSITIVE);
                        }
                        bl = this.implDatabaseMetaData.deletesAreDetectedScrollSensitive;
                        break;
                    }
                    if (!this.connection.implConnection.supportsRowId()) break;
                    bl = true;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"deletesAreDetected"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertsAreDetected(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = false;
            switch (n) {
                case 1003: 
                case 1004: 
                case 1005: {
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"insertsAreDetected"};
                    throw this.exceptions.getException(6002, stringArray);
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsBatchUpdates() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseColumns baseColumns = new BaseColumns();
            BaseColumn baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_CAT";
            baseColumn.name = "TYPE_CAT";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_SCHEM";
            baseColumn.name = "TYPE_SCHEM";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "TYPE_NAME";
            baseColumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "CLASS_NAME";
            baseColumn.name = "CLASS_NAME";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(5);
            baseColumn.label = "DATA_TYPE";
            baseColumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            baseColumn = new BaseColumn(12);
            baseColumn.label = "REMARKS";
            baseColumn.name = "REMARKS";
            this.setCommonResultSetMetaData(baseColumn);
            baseColumns.add(baseColumn);
            BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
            return baseStatement.executeDatabaseMetaDataQuery(null, baseColumns, 17, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            return this.connection;
        }
    }

    private void setCommonResultSetMetaData(BaseColumn baseColumn) {
        if (baseColumn.type == 12) {
            baseColumn.displaySize = 254;
        }
        baseColumn.isSigned = false;
        baseColumn.isWritable = false;
        baseColumn.isDefinitelyWritable = false;
        baseColumn.isReadOnly = true;
        baseColumn.isSearchable = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean locatorsUpdateCopy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.locatorsUpdateCopy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.LOCATORSUPDATECOPY);
                if (this.implDatabaseMetaData.locatorsUpdateCopy == null) {
                    return true;
                }
            }
            return this.implDatabaseMetaData.locatorsUpdateCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSavepoints() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSavepoints == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSSAVEPOINTS);
                if (this.implDatabaseMetaData.supportsSavepoints == null) {
                    return false;
                }
            }
            return this.implDatabaseMetaData.supportsSavepoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsNamedParameters() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsNamedParameters == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSNAMEDPARAMETERS);
                if (this.implDatabaseMetaData.supportsNamedParameters == null) {
                    return false;
                }
            }
            return this.implDatabaseMetaData.supportsNamedParameters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsMultipleOpenResults() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMultipleOpenResults == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSMULTIPLEOPENRESULTS);
                if (this.implDatabaseMetaData.supportsMultipleOpenResults == null) {
                    return false;
                }
            }
            return this.implDatabaseMetaData.supportsMultipleOpenResults;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsGetGeneratedKeys() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsGetGeneratedKeys == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.SUPPORTSGETGENERATEDKEYS);
                if (this.implDatabaseMetaData.supportsGetGeneratedKeys == null) {
                    return false;
                }
            }
            return this.implDatabaseMetaData.supportsGetGeneratedKeys;
        }
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        this.validateClosedState();
        BaseColumns baseColumns = new BaseColumns();
        BaseColumn baseColumn = new BaseColumn(12);
        baseColumn.label = "TYPE_CAT";
        baseColumn.name = "TYPE_CAT";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "TYPE_SCHEM";
        baseColumn.name = "TYPE_SCHEM";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "TYPE_NAME";
        baseColumn.name = "TYPE_NAME";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "SUPERTYPE_CAT";
        baseColumn.name = "SUPERTYPE_CAT";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "SUPERTYPE_SCHEM";
        baseColumn.name = "SUPERTYPE_SCHEM";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "SUPERTYPE_NAME";
        baseColumn.name = "SUPERTYPE_NAME";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
        return baseStatement.executeDatabaseMetaDataQuery(null, baseColumns, 19, null, null, null);
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        this.validateClosedState();
        BaseColumns baseColumns = new BaseColumns();
        BaseColumn baseColumn = new BaseColumn(12);
        baseColumn.label = "TABLE_CAT";
        baseColumn.name = "TABLE_CAT";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "TABLE_SCHEM";
        baseColumn.name = "TABLE_SCHEM";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "TABLE_NAME";
        baseColumn.name = "TABLE_NAME";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "SUPERTABLE_NAME ";
        baseColumn.name = "SUPERTABLE_NAME ";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
        return baseStatement.executeDatabaseMetaDataQuery(null, baseColumns, 20, null, null, null);
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        BaseColumns baseColumns = new BaseColumns();
        BaseColumn baseColumn = new BaseColumn(12);
        baseColumn.label = "TYPE_CAT";
        baseColumn.name = "TYPE_CAT";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "TYPE_SCHEM";
        baseColumn.name = "TYPE_SCHEM";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "TYPE_NAME";
        baseColumn.name = "TYPE_NAME";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "ATTR_NAME";
        baseColumn.name = "ATTR_NAME";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "DATA_TYPE";
        baseColumn.name = "DATA_TYPE";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "ATTR_TYPE_NAME";
        baseColumn.name = "ATTR_TYPE_NAME";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "ATTR_SIZE";
        baseColumn.name = "ATTR_SIZE";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "DECIMAL_DIGITS";
        baseColumn.name = "DECIMAL_DIGITS";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "NUM_PREC_RADIX";
        baseColumn.name = "NUM_PREC_RADIX";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "NULLABLE";
        baseColumn.name = "NULLABLE";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "REMARKS";
        baseColumn.name = "REMARKS";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "ATTR_DEF";
        baseColumn.name = "ATTR_DEF";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "SQL_DATA_TYPE";
        baseColumn.name = "SQL_DATA_TYPE";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "SQL_DATETIME_SUB";
        baseColumn.name = "SQL_DATETIME_SUB";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "CHAR_OCTET_LENGTH";
        baseColumn.name = "CHAR_OCTET_LENGTH";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "ORDINAL_POSITION";
        baseColumn.name = "ORDINAL_POSITION";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "IS_NULLABLE";
        baseColumn.name = "IS_NULLABLE";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "SCOPE_CATALOG";
        baseColumn.name = "SCOPE_CATALOG";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "SCOPE_SCHEMA";
        baseColumn.name = "SCOPE_SCHEMA";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "SCOPE_TABLE";
        baseColumn.name = "SCOPE_TABLE";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        baseColumn = new BaseColumn(12);
        baseColumn.label = "SOURCE_DATA_TYPE";
        baseColumn.name = "SOURCE_DATA_TYPE";
        this.setCommonResultSetMetaData(baseColumn);
        baseColumns.add(baseColumn);
        BaseStatement baseStatement = (BaseStatement)this.connection.createStatement();
        return baseStatement.executeDatabaseMetaDataQuery(null, baseColumns, 21, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            return this.getResultSetHoldability() == n;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetHoldability() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.resultSetHoldability == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.RESULTSETHOLDABILITY);
            }
            return this.implDatabaseMetaData.resultSetHoldability;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatabaseMajorVersion() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.databaseMajorVersion == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.DATABASEMAJORVERSION);
            }
            return this.implDatabaseMetaData.databaseMajorVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatabaseMinorVersion() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.databaseMinorVersion == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.DATABASEMINORVERSION);
            }
            return this.implDatabaseMetaData.databaseMinorVersion;
        }
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSQLStateType() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.sqlStateType == null) {
                this.implDatabaseMetaData.getClass();
                this.implDatabaseMetaData.initializeNonResultSetMetaData(154);
            }
            return 1;
        }
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientApplicationNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxClientAppName == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCLIENTAPPNAME);
            }
            if (this.implDatabaseMetaData.maxClientAppName == null) {
                return 0;
            }
            return this.implDatabaseMetaData.maxClientAppName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientHostNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxClientHostName == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCLIENTHOSTNAME);
            }
            if (this.implDatabaseMetaData.maxClientHostName == null) {
                return 0;
            }
            return this.implDatabaseMetaData.maxClientHostName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientUserLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxClientUser == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCLIENTUSER);
            }
            if (this.implDatabaseMetaData.maxClientUser == null) {
                return 0;
            }
            return this.implDatabaseMetaData.maxClientUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientAccountingInfoLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxClientAcctInfo == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(this.implDatabaseMetaData.MAXCLIENTACCTINFO);
            }
            if (this.implDatabaseMetaData.maxClientAcctInfo == null) {
                return 0;
            }
            return this.implDatabaseMetaData.maxClientAcctInfo;
        }
    }
}

