/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import macromedia.jdbc.sequelink.SequeLinkConnection;
import macromedia.jdbc.sequelink.SequeLinkImplDatabaseMetaData;
import macromedia.jdbc.sequelink.SequeLinkImplStatement;
import macromedia.jdbc.slbase.BaseImplConnection;
import macromedia.jdbc.slbase.BaseImplStatement;
import macromedia.sequelink.ctxt.PidList;
import macromedia.sequelink.ctxt.conn.ConnectionContext;
import macromedia.sequelink.jdbc.ConnectAttributes;
import macromedia.sequelink.jdbc.Utils;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SlXid;
import macromedia.sequelink.ssp.SspLob;
import macromedia.sequelink.util.SlXaException;
import macromedia.sequelink.util.UnSyncVector;

public final class SequeLinkImplConnection
extends BaseImplConnection {
    ConnectionContext conCtxt;
    SequeLinkConnection con;
    private DiagnosticList diagnosticList;
    private boolean _rowidRetrieved;
    private String _rowidValue;
    private String[] _aggregateFunctions;
    private Boolean _supportsRowId;
    private Boolean _supportsLobsNatively;

    SequeLinkImplConnection(SequeLinkConnection sequeLinkConnection) {
        this.con = sequeLinkConnection;
        this.diagnosticList = new DiagnosticList();
    }

    private void addWarnings() {
        SQLWarning sQLWarning = this.diagnosticList.getSQLWarning();
        if (sQLWarning != null) {
            String[] stringArray = new String[]{sQLWarning.getMessage()};
            do {
                this.warnings.add(6001, stringArray, sQLWarning.getSQLState(), sQLWarning.getErrorCode());
            } while ((sQLWarning = sQLWarning.getNextWarning()) != null);
            this.diagnosticList.clear();
        }
    }

    public SequeLinkConnection getConnection() {
        return this.con;
    }

    public void open() throws SQLException {
        ConnectAttributes connectAttributes = this.getConnectAttributes();
        DriverPropertyInfo[] driverPropertyInfoArray = this.getDpis();
        for (int i = 0; i < driverPropertyInfoArray.length; ++i) {
            String string = driverPropertyInfoArray[i].name;
            String string2 = this.connectProps.get(string);
            if (string2 == null) continue;
            connectAttributes.setAttribute(string, string2);
        }
        this.conCtxt = new ConnectionContext(connectAttributes, null);
        this.conCtxt.connect(this.isXAConnection, this.diagnosticList);
        this.addWarnings();
        if (this.con.implDmd == null) {
            this.con.implDmd = new SequeLinkImplDatabaseMetaData(this);
        }
    }

    void doUnlock() throws SQLException {
        this.conCtxt.doUnlock(this.diagnosticList);
    }

    public void reset() throws SQLException {
        this.conCtxt.testAlive(this.diagnosticList);
    }

    protected void commitTransaction() throws SQLException {
        this.conCtxt.commit(this.diagnosticList);
        this.addWarnings();
    }

    protected void rollbackTransaction() throws SQLException {
        this.conCtxt.rollback(this.diagnosticList);
        this.addWarnings();
    }

    protected BaseImplStatement createImplStatement(int n, int n2) throws SQLException {
        return new SequeLinkImplStatement(this);
    }

    public void close() throws SQLException {
        this.conCtxt.deactivate(this.diagnosticList);
        this.addWarnings();
        this.con.implDmd = null;
        this.con.implCon = null;
        this.con.ca = null;
        this.con.dpis = null;
    }

    protected void startManualTransactionMode() throws SQLException {
        this.conCtxt.setAutoCommit(false, this.diagnosticList);
        this.addWarnings();
    }

    protected void stopManualTransactionMode() throws SQLException {
        this.conCtxt.setAutoCommit(true, this.diagnosticList);
        this.addWarnings();
    }

    protected String getCatalog() throws SQLException {
        return this.conCtxt.getCatalog(this.diagnosticList);
    }

    protected void setCatalog(String string) throws SQLException {
        this.conCtxt.setCatalog(string, this.diagnosticList);
    }

    protected int getTransactionIsolation() throws SQLException {
        int n = this.conCtxt.getTransactionIsolation(this.diagnosticList);
        return Utils.NativeToJdbcTxnIsolation(n);
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        int n2 = Utils.JdbcToNativeTxnIsolation(n);
        int n3 = n;
        if (n3 == 1 && !this.conCtxt.supportsTransactionIsolation(n2, this.diagnosticList)) {
            n3 = 2;
            n2 = Utils.JdbcToNativeTxnIsolation(2);
        }
        if (n3 == 2 && !this.conCtxt.supportsTransactionIsolation(n2, this.diagnosticList)) {
            n3 = 4;
            n2 = Utils.JdbcToNativeTxnIsolation(4);
        }
        if (n3 == 4 && !this.conCtxt.supportsTransactionIsolation(n2, this.diagnosticList)) {
            n3 = 8;
            n2 = Utils.JdbcToNativeTxnIsolation(8);
        }
        if (n3 == 8 && !this.conCtxt.supportsTransactionIsolation(n2, this.diagnosticList)) {
            throw Message.Gen.getSqlException(7391, "Connection.setTransactionIsolation(" + n + ")");
        }
        this.conCtxt.setTransactionIsolation(n2, this.diagnosticList);
    }

    SequeLinkImplDatabaseMetaData createImplDatabaseMetaData() throws SQLException {
        return new SequeLinkImplDatabaseMetaData(this);
    }

    PidList getPidList() {
        return this.conCtxt.getPidList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRowIdColumnName(DiagnosticList diagnosticList) {
        if (this._rowidRetrieved) {
            return this._rowidValue;
        }
        String string = null;
        try {
            string = this.getPidList().getPidString(11027, diagnosticList);
            if (string == null) {
                String string2 = null;
                return string2;
            }
            int n = string.length();
            if (n == 0) {
                String string3 = null;
                return string3;
            }
            char c = string.charAt(n - 1);
            while (c == '\u0000') {
                string = string.substring(0, n - 1);
                n = string.length();
                c = string.charAt(n - 1);
            }
            String string4 = string;
            return string4;
        }
        catch (SQLException sQLException) {
            String string5 = null;
            return string5;
        }
        finally {
            this._rowidRetrieved = true;
            this._rowidValue = string;
        }
    }

    protected String[] getAggregateFunctions() {
        if (!this.supportsRowId()) {
            return null;
        }
        if (this._aggregateFunctions != null) {
            return this._aggregateFunctions;
        }
        try {
            int n = this.getPidList().getPidInt(11251, this.diagnosticList);
            int n2 = 0;
            if ((n & 1) != 0) {
                ++n2;
            }
            if ((n & 2) != 0) {
                ++n2;
            }
            if ((n & 4) != 0) {
                ++n2;
            }
            if ((n & 8) != 0) {
                ++n2;
            }
            if ((n & 0x10) != 0) {
                ++n2;
            }
            if ((n & 0x20) != 0) {
                ++n2;
            }
            this._aggregateFunctions = new String[n2];
            n2 = 0;
            if ((n & 1) != 0) {
                this._aggregateFunctions[n2++] = "AVG";
            }
            if ((n & 2) != 0) {
                this._aggregateFunctions[n2++] = "COUNT";
            }
            if ((n & 4) != 0) {
                this._aggregateFunctions[n2++] = "MAX";
            }
            if ((n & 8) != 0) {
                this._aggregateFunctions[n2++] = "MIN";
            }
            if ((n & 0x10) != 0) {
                this._aggregateFunctions[n2++] = "SUM";
            }
            if ((n & 0x20) != 0) {
                this._aggregateFunctions[n2++] = "DISTINCT";
            }
            return this._aggregateFunctions;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public int getEmptyRowInsertSyntax() {
        try {
            return this.getPidList().getPidInt(11401, DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int[] executeBatch(UnSyncVector unSyncVector, DiagnosticList diagnosticList) throws SQLException {
        return this.conCtxt.executeBatch(unSyncVector, diagnosticList);
    }

    public void getLobLength(SspLob sspLob) throws SQLException {
        this.conCtxt.getLobLength(sspLob, this.diagnosticList);
    }

    public int getLobData(SspLob sspLob, byte[] byArray, int n, long l, int n2) throws SQLException {
        return this.conCtxt.getLobData(sspLob, byArray, n, l, n2, this.diagnosticList);
    }

    public int setLobData(SspLob sspLob, byte[] byArray, int n, long l, int n2) throws SQLException {
        return this.conCtxt.setLobData(sspLob, byArray, n, l, n2, this.diagnosticList);
    }

    public long getLobPosition(SspLob sspLob, byte[] byArray, long l) throws SQLException {
        return this.conCtxt.getLobPosition(sspLob, byArray, l, this.diagnosticList);
    }

    public void lobTruncate(SspLob sspLob, long l) throws SQLException {
        this.conCtxt.lobTruncate(sspLob, l, this.diagnosticList);
    }

    public void xa_open() throws SQLException {
        this.conCtxt.xa_open(this.diagnosticList);
    }

    public void xa_close() throws SQLException {
        this.conCtxt.xa_close(this.diagnosticList);
    }

    public void xa_start(SlXid slXid, int n) throws SlXaException {
        this.conCtxt.xa_start(slXid, n);
    }

    public void xa_end(SlXid slXid, int n) throws SlXaException {
        this.conCtxt.xa_end(slXid, n);
    }

    public int xa_prepare(SlXid slXid) throws SlXaException {
        return this.conCtxt.xa_prepare(slXid);
    }

    public void xa_commit(SlXid slXid, boolean bl) throws SlXaException {
        this.conCtxt.xa_commit(slXid, bl);
    }

    public void xa_rollback(SlXid slXid) throws SlXaException {
        this.conCtxt.xa_rollback(slXid);
    }

    public SlXid[] xa_recover(int n) throws SlXaException {
        return this.conCtxt.xa_recover(n);
    }

    public void xa_forget(SlXid slXid) throws SlXaException {
        this.conCtxt.xa_forget(slXid);
    }

    public int getXaTransactionTimeout() throws SlXaException {
        return this.conCtxt.getXaTransactionTimeout(this.diagnosticList);
    }

    public boolean setXATransactionTimeout(int n) throws SlXaException {
        return false;
    }

    public String getRmIdentification() throws SlXaException {
        return this.getAttributeValue("SERVERNAME") + "-" + this.getAttributeValue("PORTNUMBER") + "-" + this.getAttributeValue("DATABASENAME") + "-" + this.getAttributeValue("SERVERDATASOURCE");
    }

    private String getAttributeValue(String string) {
        String string2 = this.getConnectAttributes().getAttribute(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private ConnectAttributes getConnectAttributes() {
        return this.con.ca;
    }

    private DriverPropertyInfo[] getDpis() {
        return this.con.dpis;
    }

    public boolean supportsCancel() {
        return this.conCtxt.supportsCancel();
    }

    public boolean supportsQueryTimeout() {
        try {
            boolean bl = this.conCtxt.supportsQueryTimeout(DiagnosticList.GetADummyList());
            return bl;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean supportsSelectStarCommaColumn() {
        try {
            int n = this.conCtxt.getRowIdOptions(DiagnosticList.GetADummyList());
            return (n & 1) == 0;
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    protected boolean shouldExposeGetSetUnicodeStream() {
        return true;
    }

    protected int getMaxLongDataFieldCacheSize() {
        return this.conCtxt.getSLKStaticCursorLongColBuffLen();
    }

    protected boolean exposeEmptyDBMDResultSetOnExecutionError() {
        return false;
    }

    protected boolean supportsRowId() {
        if (this._supportsRowId == null) {
            String string = this.getRowIdColumnName(DiagnosticList.GetADummyList());
            this._supportsRowId = string == null || string.length() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return this._supportsRowId;
    }

    public boolean supportsLobsNatively() {
        if (this._supportsLobsNatively == null) {
            try {
                int n = this.conCtxt.supportsLobs(DiagnosticList.GetADummyList());
                this._supportsLobsNatively = new Boolean(n != 0);
            }
            catch (SQLException sQLException) {
                this._supportsLobsNatively = new Boolean(false);
            }
        }
        return this._supportsLobsNatively;
    }

    public boolean supportsLobs() {
        return true;
    }

    protected boolean enableXlobOnLongVarX() {
        return !this.supportsLobsNatively();
    }

    protected void setSavepoint(String string) throws SQLException {
        this.conCtxt.setSavepoint(string, this.diagnosticList);
    }

    protected void releaseSavepoint(String string) throws SQLException {
        this.conCtxt.releaseSavepoint(string, this.diagnosticList);
    }

    protected void rollbackTransaction(String string) throws SQLException {
        this.conCtxt.rollbackToSavepoint(string, this.diagnosticList);
    }

    public void setOemId(String string) throws SQLException {
        this.conCtxt.setOemId(string, this.diagnosticList);
    }

    public void setApplicationId(String string) throws SQLException {
        this.conCtxt.setApplicationId(string, this.diagnosticList);
    }

    public boolean requiresUserId() {
        return false;
    }
}

